/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools.impl;

import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.io.IOException;
import java.util.Iterator;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.QueryCondition;

public class DocScanner {
    DocumentStream s;
    Iterator<Document> iter;
    DBDocumentImpl lastDocument;
    MapRDBTableImpl table;
    boolean preserveTimestamp = true;
    boolean decodeTimestamp = true;
    boolean getDeletes = true;

    public DocScanner(String tablePath, QueryCondition c, String[] fields, boolean excludedEmbeddedFamily, boolean getDeletes) throws IOException {
        this.table = (MapRDBTableImpl)MapRDBImpl.getTable((String)tablePath);
        this.table.setPrivateOption(BaseJsonTable.TablePrivateOption.PRESERVE_TIMESTAMP, this.preserveTimestamp);
        this.table.setPrivateOption(BaseJsonTable.TablePrivateOption.GET_DELETES, getDeletes);
        this.table.setPrivateOption(BaseJsonTable.TablePrivateOption.DECODE_TIMESTAMP, this.decodeTimestamp);
        this.table.setPrivateOption(BaseJsonTable.TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, excludedEmbeddedFamily);
        this.s = fields != null ? this.table.find(c, fields) : this.table.find(c);
        this.iter = this.s.iterator();
    }

    public DBDocumentImpl getNext() {
        if (this.lastDocument != null) {
            DBDocumentImpl d = this.lastDocument;
            this.lastDocument = null;
            return d;
        }
        if (this.iter.hasNext()) {
            return (DBDocumentImpl)this.iter.next();
        }
        return null;
    }

    public DBDocumentImpl peekNext() {
        if (this.lastDocument != null) {
            return this.lastDocument;
        }
        if (this.iter.hasNext()) {
            this.lastDocument = (DBDocumentImpl)this.iter.next();
        }
        return this.lastDocument;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public void consume() {
        this.lastDocument = null;
    }

    public void close() throws IOException {
        this.table.close();
    }
}

