/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tools;

import com.mapr.db.mapreduce.tools.CopyTable;
import com.mapr.fs.MapRFileSystem;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyStream
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CopyStream.class);
    private static final String NAME = "CopyStream";

    private void Usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: CopyStream\n  -src <source stream path>\n  -dst <destination stream path>\n  [-mapreduce <true|false> (default: false)]\n  [-numthreads <number of threads> (default: 16)\n");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        Path dst;
        MapRFileSystem mfs;
        String[] cmdArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        String srcPath = null;
        String dstPath = null;
        boolean mapreduceOptionPresent = false;
        for (int i = 0; i < cmdArgs.length; ++i) {
            int mapReduce;
            if (cmdArgs[i].equalsIgnoreCase("-src")) {
                srcPath = cmdArgs[++i];
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-dst")) {
                dstPath = cmdArgs[++i];
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-mapreduce")) {
                mapReduce = Boolean.valueOf(cmdArgs[++i]).booleanValue();
                mapreduceOptionPresent = true;
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-numthreads")) {
                mapReduce = Integer.parseInt(cmdArgs[++i]);
                continue;
            }
            this.Usage("Unknown option " + cmdArgs[i]);
        }
        if (srcPath == null || dstPath == null) {
            this.Usage("missing -src or -dst stream");
        }
        if (!(mfs = (MapRFileSystem)FileSystem.get((Configuration)new Configuration())).isStream(new Path(srcPath))) {
            this.Usage("src " + srcPath + " is not a stream");
        }
        if (mfs.exists(dst = new Path(dstPath)) && !mfs.isStream(dst)) {
            this.Usage("dst " + dstPath + " is not a stream");
        }
        int numCopyTableArgs = args.length + (mapreduceOptionPresent ? 0 : 2) + 2;
        String[] copyTableArgs = Arrays.copyOf(args, numCopyTableArgs);
        int argsIdx = args.length;
        if (!mapreduceOptionPresent) {
            copyTableArgs[argsIdx++] = "-mapreduce";
            copyTableArgs[argsIdx++] = "false";
        }
        copyTableArgs[argsIdx++] = "-bulkload";
        copyTableArgs[argsIdx++] = "false";
        return ToolRunner.run((Configuration)this.getConf(), (Tool)new CopyTable(), (String[])copyTableArgs);
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyStream(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

