/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tools;

import com.mapr.db.mapreduce.tools.Export;
import com.mapr.fs.MapRFileSystem;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportStream
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ExportStream.class);
    private static final String NAME = "ExportStream";

    private void Usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: ExportStream\n  -src <Input stream path>]\n  -dst <dest directory>\n  [-mapreduce <true|false> (default: false)]\n");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        MapRFileSystem mfs;
        String[] cmdArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        String srcPath = null;
        String dstPath = null;
        boolean mapreduceOptionPresent = false;
        for (int i = 0; i < cmdArgs.length; ++i) {
            if (cmdArgs[i].equalsIgnoreCase("-src")) {
                srcPath = cmdArgs[++i];
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-dst")) {
                dstPath = cmdArgs[++i];
                continue;
            }
            if (cmdArgs[i].equalsIgnoreCase("-mapreduce")) {
                boolean mapReduce = Boolean.valueOf(cmdArgs[++i]);
                mapreduceOptionPresent = true;
                continue;
            }
            this.Usage("Unknown option " + cmdArgs[i]);
        }
        if (srcPath == null) {
            this.Usage("missing -src streamPath");
        }
        if (dstPath == null) {
            this.Usage("missing -dst directory");
        }
        if (!(mfs = (MapRFileSystem)FileSystem.get((Configuration)new Configuration())).isStream(new Path(srcPath))) {
            this.Usage("src " + srcPath + " is not a stream");
        }
        int numExportArgs = args.length + (mapreduceOptionPresent ? 0 : 2);
        String[] exportTableArgs = Arrays.copyOf(args, numExportArgs);
        int argsIdx = args.length;
        if (!mapreduceOptionPresent) {
            exportTableArgs[argsIdx++] = "-mapreduce";
            exportTableArgs[argsIdx++] = "false";
        }
        return ToolRunner.run((Configuration)this.getConf(), (Tool)new Export(), (String[])exportTableArgs);
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new ExportStream(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

