/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.listener;

import com.mapr.streams.listener.ListenerPerformance;
import com.mapr.streams.producer.ProducerPerformance;
import java.io.IOException;

public class ListenerTest {
    public static String streamName;
    public static int numTopics;
    public static int numPartitions;
    public static int numMsgsPerPartition;
    public static int numBatches;
    public static long batchSleepMs;
    public static boolean verifyKeys;
    public static boolean keysInOrder;
    public static boolean allowDuplicateKeys;
    public static boolean isTracingEnabled;
    public static boolean printProgress;

    public static void usage() {
        System.err.println("ListenerTest -path <stream-full-name> [-ntopics <#topics>");
        System.err.println(" -npart <#partitions/topic> -nmsgs <#msgs/topicfeed> -keysinorder <True/False>");
        System.err.println(" -verifykesy <True/False> -debug <True/False>] -progress <True/False>");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-path")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                streamName = args[i];
                continue;
            }
            if (args[i].equals("-ntopics")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                numTopics = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-npart")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                numPartitions = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-nmsgs")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                numMsgsPerPartition = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-verifykeys")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                verifyKeys = Boolean.parseBoolean(args[i]);
                continue;
            }
            if (args[i].equals("-keysinorder")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                keysInOrder = Boolean.parseBoolean(args[i]);
                continue;
            }
            if (args[i].equals("-debug")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                isTracingEnabled = Boolean.parseBoolean(args[i]);
                continue;
            }
            if (args[i].equals("-nbatches")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                numBatches = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-progress")) {
                if (++i >= args.length) {
                    ListenerTest.usage();
                }
                printProgress = Boolean.parseBoolean(args[i]);
                continue;
            }
            ListenerTest.usage();
        }
        ListenerTest.runTest();
    }

    public static boolean runStressTest(String stream, int nmsgs, int ntopics, int npartitions, int nbatches, long batchsleepms, boolean keysOrdered) throws IOException {
        streamName = stream;
        numMsgsPerPartition = nmsgs;
        numTopics = ntopics;
        numPartitions = npartitions;
        keysInOrder = keysOrdered;
        numBatches = nbatches;
        batchSleepMs = batchsleepms;
        return ListenerTest.runTest();
    }

    public static boolean runTest() throws IOException {
        try {
            ListenerPerformance lp = new ListenerPerformance(streamName, numTopics, numPartitions, numMsgsPerPartition, numBatches, verifyKeys, keysInOrder, allowDuplicateKeys, isTracingEnabled, printProgress, null, "ListenerTest", false);
            Thread lt = new Thread(lp);
            lt.start();
            ProducerPerformanceThread pp = new ProducerPerformanceThread(streamName, numTopics, numPartitions, numMsgsPerPartition, numBatches, batchSleepMs, verifyKeys, keysInOrder, printProgress);
            Thread pt = new Thread(pp);
            pt.start();
            pt.join();
            lt.join();
            if (!lp.status || !pp.status) {
                System.out.println("ListenerPerformance test failed.");
                return false;
            }
        }
        catch (InterruptedException e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    static {
        numTopics = 2;
        numPartitions = 4;
        numMsgsPerPartition = 1000000;
        numBatches = 1;
        batchSleepMs = 10000L;
        verifyKeys = true;
        keysInOrder = false;
        allowDuplicateKeys = false;
        isTracingEnabled = false;
        printProgress = false;
    }

    private static class ProducerPerformanceThread
    implements Runnable {
        public String stream;
        public int nmsgs;
        public int ntopics;
        public int npartitions;
        public int nbatches;
        public long batchsleepms;
        public boolean status;
        public boolean mflushers;
        public boolean verifyKeys;
        public boolean printProgress;

        public ProducerPerformanceThread(String stream, int ntopics, int npartitions, int nmsgs, int nbatches, long batchSleepMs, boolean verifyKeys, boolean ordered, boolean printProgress) {
            this.stream = stream;
            this.nmsgs = nmsgs;
            this.ntopics = ntopics;
            this.npartitions = npartitions;
            this.nbatches = nbatches;
            this.batchsleepms = batchSleepMs;
            this.status = false;
            this.verifyKeys = verifyKeys;
            this.mflushers = !ordered;
            this.printProgress = printProgress;
        }

        @Override
        public void run() {
            try {
                this.status = ProducerPerformance.runStressTest(this.stream, this.nmsgs, this.ntopics, this.npartitions, this.nbatches, this.batchsleepms, this.verifyKeys, this.mflushers, this.printProgress, false, false);
            }
            catch (Exception e) {
                System.out.println(e);
                this.status = false;
            }
        }
    }
}

