/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.demo.drill;

import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditCard {
    private static final Logger _logger = LoggerFactory.getLogger(CreditCard.class);
    private String cc_num;
    private int cc_limit;
    private boolean fraudulent;
    private boolean lowSpending;
    private int numUsed;
    private Random rand;

    public CreditCard(String num, int limit, boolean isFraud, boolean isLowExp) {
        this.cc_num = num;
        this.cc_limit = limit;
        this.fraudulent = isFraud;
        this.lowSpending = isLowExp;
        this.numUsed = 0;
        this.rand = new Random();
    }

    public String number() {
        return this.cc_num;
    }

    public String getKey() {
        return "{\"cc_num\": \"" + this.cc_num + "\"}";
    }

    public float use() {
        ++this.numUsed;
        if (this.numUsed == 3 && this.lowSpending) {
            _logger.info("Generating 0.49 transaction");
            return 0.49f;
        }
        if (this.lowSpending) {
            float amt = this.rand.nextInt(10) + 1;
            amt = (float)((double)amt + (double)this.rand.nextInt(100) / 100.0);
            return amt;
        }
        if (this.numUsed == 5 && this.fraudulent) {
            _logger.info("Generating fraudulent transaction");
            return 0.99f;
        }
        float amt = this.rand.nextInt(100) + 10;
        amt = (float)((double)amt + (double)this.rand.nextInt(100) / 100.0);
        return amt;
    }

    public boolean isLowSpending() {
        return this.lowSpending;
    }

    public int getLimit() {
        return this.cc_limit;
    }

    public boolean isFraudulent() {
        if (this.fraudulent && this.numUsed > 50) {
            this.fraudulent = false;
            return true;
        }
        return false;
    }
}

