/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.listener;

import com.mapr.fs.proto.Marlinserver;
import com.mapr.streams.impl.listener.ListenerRecord;
import com.mapr.streams.impl.listener.MarlinConsumerCoordinator;
import com.mapr.streams.impl.listener.MarlinListener;
import com.mapr.streams.impl.listener.MarlinListenerImplV10;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinListenerV10<K, V>
extends MarlinListener<K, V> {
    private static final Logger log = LoggerFactory.getLogger(MarlinListenerV10.class);

    public MarlinListenerV10(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, ConsumerInterceptors<?, ?> interceptors) {
        super(config, keyDeserializer, valueDeserializer, new MarlinListenerImplV10(config, interceptors, MarlinListenerV10.DeserializerToCDCOpenFormatType(valueDeserializer)));
        Marlinserver.MarlinConfigDefaults mConfDef = Marlinserver.MarlinConfigDefaults.getDefaultInstance();
        List assignors = config.getConfiguredInstances(mConfDef.getPartitionAssignmentStrategy(), PartitionAssignor.class);
        if (assignors.size() > 1) {
            throw new KafkaException("Multiple partition assignors is not supported!!");
        }
        if (config.getBoolean(mConfDef.getClientSidePartitionAssignment()).booleanValue() && !config.getString(mConfDef.getGroupID()).isEmpty()) {
            if (assignors.size() == 0) {
                throw new KafkaException("Client-side partition assignment requires config partition.assignment.strategy to be set.");
            }
            if (config.getString(mConfDef.getClientSidePartitionAssignmentInternalStream()).isEmpty()) {
                throw new KafkaException("Client-side partition assignment requires config streams.clientside.partition.assignment.internal.stream to be set.");
            }
            this._clientSidePartitioningEnabled = true;
            this._coordinator = new MarlinConsumerCoordinator(this, this._listener, config.getString(mConfDef.getGroupID()), assignors, config.getString(mConfDef.getClientSidePartitionAssignmentInternalStream()));
        }
        log.debug("MarlinListenerV10 constructor");
    }

    @Override
    protected <K, V> ConsumerRecord<K, V> generateConsumerRecord(String topic, ListenerRecord rec, K kkey, V kvalue, int serializedKeySize, int serializedValueSize) {
        MarlinListenerImplV10 impl = (MarlinListenerImplV10)this._listener;
        TimestampType timestampType = impl.convertMarlinTimestampTypeToKafka(rec.timestampType());
        return new ConsumerRecord(topic, rec.feedId(), rec.offset(), rec.timestamp(), timestampType, Long.valueOf(0L), serializedKeySize, serializedValueSize, kkey, kvalue, rec.headers(), rec.producer());
    }
}

