/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.db.tests.utils.DBTests;
import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.tests.producer.ProducerMultiTest;
import com.mapr.streams.tests.producer.SendMessagesToProducer;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerIdempotenceMfsRestartWithTabletSplit
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerIdempotenceMfsRestartWithTabletSplit.class);
    private static final String PREFIX = "/jtest-" + ProducerIdempotenceMfsRestartWithTabletSplit.class.getSimpleName() + "-";
    private static final String TED_FILE = "build_fileserver/fs/common/ted/ted";
    private static Path repoRootPath = null;
    private static Path tedCmdPath = null;
    private static Admin madmin;
    private static final int numParts = 2;
    private static final String SET_TED_CMD = " enable IdempotentRequestDrop";
    private static final String RESET_TED_CMD = " disable IdempotentRequestDrop";

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        String sname = PREFIX + "idempotentproducertabletsplit";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        madmin.createStream(sname, sdesc);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        String cmd = tedCmdPath.toString() + RESET_TED_CMD;
        int setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        String sname = PREFIX + "idempotentproducertabletsplit";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void produceMsgsWithErrorInjection(String topicName, KafkaProducer<byte[], byte[]> kafkaproducer, int numMsgs, int numPartitions, int msgSize, boolean shouldClose) throws Exception {
        ProducerMultiTest.CountCallback cb = new ProducerMultiTest.CountCallback(numMsgs * 1);
        String cmd = null;
        int setStatus = 0;
        int numTries = 0;
        SendMessagesToProducer producer = new SendMessagesToProducer(kafkaproducer, cb, topicName, numPartitions, numMsgs, msgSize, shouldClose);
        cmd = tedCmdPath.toString() + SET_TED_CMD;
        setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        Thread producerThread = new Thread(producer);
        producerThread.start();
        while (numTries < 10) {
            ++numTries;
            cmd = tedCmdPath.toString() + SET_TED_CMD;
            setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
            if (setStatus != 0) {
                throw new IOException(cmd + " failed with exitStatus: " + setStatus);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                System.out.println("Sleep interrupted " + e);
            }
            cmd = tedCmdPath.toString() + RESET_TED_CMD;
            setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
            if (setStatus != 0) {
                throw new IOException(cmd + " failed with exitStatus: " + setStatus);
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println("Sleep interrupted " + e);
            }
        }
        producerThread.join();
    }

    private void produceMsgsWithMfsRestart(String topicName, KafkaProducer<byte[], byte[]> kafkaproducer, int numMsgs, int numPartitions, int msgSize, boolean shouldClose) throws Exception {
        ProducerMultiTest.CountCallback cb = new ProducerMultiTest.CountCallback(numMsgs * 1);
        String cmd = null;
        int setStatus = 0;
        SendMessagesToProducer producer = new SendMessagesToProducer(kafkaproducer, cb, topicName, numPartitions, numMsgs, msgSize, shouldClose);
        cmd = tedCmdPath.toString() + SET_TED_CMD;
        setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        Thread producerThread = new Thread(producer);
        producerThread.start();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        ProcessBuilder proc = new ProcessBuilder("sudo", "service", "mapr-warden", "restart");
        Process process = proc.start();
        process.waitFor();
        producerThread.join();
    }

    private void consumeMsgs(String topicName, KafkaConsumer<byte[], byte[]> kafkaconsumer, int numMsgs, int numPartitions) throws Exception {
        int count;
        ConsumerRecords recs;
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topicName);
        kafkaconsumer.subscribe(topics);
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        for (count = 0; count < numMsgs * numPartitions; count += recs.count()) {
            recs = kafkaconsumer.poll(0L);
        }
        Assert.assertEquals((long)(numMsgs * numPartitions), (long)count);
    }

    @Test
    public void testMfsRestartWithTabletSplit() throws Exception {
        int numParts = 1;
        if (tedCmdPath == null) {
            throw new IOException("Could not find ted command file.");
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setCompressionAlgo("off");
        String sname = PREFIX + "idempotentproducertabletsplit";
        ProcessBuilder proc = new ProcessBuilder("maprcli", "table", "edit", "-path", sname, "-regionsizemb", "256");
        Process process = proc.start();
        int errorCode = process.waitFor();
        String topicName = ":t";
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("enable.idempotence", (Object)true);
        KafkaProducer kafkaproducer = new KafkaProducer(props);
        Properties listenerProps = new Properties();
        listenerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("fetch.min.bytes", "1");
        listenerProps.put("auto.offset.reset", "earliest");
        listenerProps.put("max.partition.fetch.bytes", (Object)0xA00000);
        KafkaConsumer kafkaconsumer = new KafkaConsumer(listenerProps);
        madmin.createTopic(sname, "t", numParts);
        int numMsgs = 600;
        int msgSize = 0x200000;
        this.produceMsgsWithErrorInjection(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, numMsgs, numParts, msgSize, false);
        this.produceMsgsWithMfsRestart(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, numMsgs, numParts, msgSize, false);
        this.consumeMsgs(sname + topicName, (KafkaConsumer<byte[], byte[]>)kafkaconsumer, numMsgs * 2, numParts);
        kafkaconsumer.unsubscribe();
        kafkaconsumer.close();
        kafkaproducer.close();
    }

    static {
        repoRootPath = BaseTest.getSourceRoot();
        if (repoRootPath != null && !Files.exists(tedCmdPath = repoRootPath.resolve(TED_FILE), new LinkOption[0])) {
            tedCmdPath = null;
        }
    }
}

