/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.ojai;

import com.mapr.db.JsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.demo.drill.Producer;
import com.mapr.streams.impl.StreamsDocument;
import com.mapr.streams.impl.StreamsDocumentTranslator;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestStreamScanWithCondition
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestStreamScanWithCondition.class);
    private static final int NUM_PARTITION = 10;
    private static final String TMP_TEST_SCAN_WITH_CONDITION_STREAM = "/tmp/TestScanWithCondition_stream";
    private static Admin admin;

    @BeforeClass
    public static void setupTests_ScanWithCondition() throws IOException {
        admin = Streams.newAdmin((Configuration)new Configuration());
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setDefaultPartitions(10);
        try {
            admin.deleteStream(TMP_TEST_SCAN_WITH_CONDITION_STREAM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        admin.createStream(TMP_TEST_SCAN_WITH_CONDITION_STREAM, sdesc);
        Producer p = new Producer(TMP_TEST_SCAN_WITH_CONDITION_STREAM, 10, 50000);
        p.run();
    }

    @AfterClass
    public static void cleanupTests_ScanWithCondition() {
        try {
            if (admin != null) {
                admin.deleteStream(TMP_TEST_SCAN_WITH_CONDITION_STREAM);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testScanWithCondition() throws Exception {
        try (JsonTable t = MapRDBImpl.getTable((String)TMP_TEST_SCAN_WITH_CONDITION_STREAM);){
            ConditionImpl splitCond = MapRDBImpl.newCondition().or().and().is("_id", QueryCondition.Op.GREATER_OR_EQUAL, "p001").is("_id", QueryCondition.Op.LESS, "p002").close().and().is("_id", QueryCondition.Op.GREATER_OR_EQUAL, "p003").is("_id", QueryCondition.Op.LESS, "p004").close().close().build();
            ConditionImpl c = MapRDBImpl.newCondition().and().is("_id", QueryCondition.Op.GREATER_OR_EQUAL, "p001tUS_SOUTH:000000010000000000000000").is("_id", QueryCondition.Op.LESS, "p001tUS_SOUTH:000000017fffffffffffffff").close().build();
            ConditionImpl prodCond = MapRDBImpl.newCondition().is("p", QueryCondition.Op.EQUAL, "root").build();
            ConditionImpl fullCond = MapRDBImpl.newCondition().and().condition((QueryCondition)splitCond).condition((QueryCondition)c).condition((QueryCondition)prodCond).close().build();
            _logger.info("Full Condition: {}", (Object)fullCond);
            DocumentStream rs = t.find((QueryCondition)fullCond);
            for (Document rec : rs) {
                StreamsDocumentTranslator translator = new StreamsDocumentTranslator(rec, null);
                while (translator.hasNext()) {
                    StreamsDocument r = (StreamsDocument)translator.next();
                    _logger.info("{}", (Object)r);
                    Assert.assertEquals((long)1L, (long)r.getInt("partition"));
                    Assert.assertEquals((Object)"US_SOUTH", (Object)r.getString("topic"));
                    Assert.assertEquals((Object)"root", (Object)r.getString("producer"));
                }
            }
        }
    }
}

