/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class TestProducerInterceptor
implements ProducerInterceptor<byte[], byte[]> {
    private static AtomicInteger onSendCount = new AtomicInteger(0);
    private static AtomicInteger onAckCount = new AtomicInteger(0);

    public void resetCounters() {
        onSendCount.set(0);
        onAckCount.set(0);
    }

    public int getOnSendCount() {
        return onSendCount.get();
    }

    public int getOnAckCount() {
        return onAckCount.get();
    }

    public void configure(Map<String, ?> configs) {
    }

    public ProducerRecord<byte[], byte[]> onSend(ProducerRecord<byte[], byte[]> record) {
        onSendCount.getAndIncrement();
        return record;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
        onAckCount.getAndIncrement();
    }

    public void close() {
    }
}

