/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.producer.ProducerPerformance;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerStressTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerStressTest.class);
    private static final String STREAM = "/jtest-" + ProducerStressTest.class.getSimpleName();
    private static Admin madmin;
    private static final int numParts = 4;
    private static int counter;

    @BeforeClass
    public static void setupTestClass() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        try {
            for (int c = 1; c <= 4; ++c) {
                madmin.deleteStream(STREAM + c);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Before
    public void setupTest() throws Exception {
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setDefaultPartitions(4);
        madmin.createStream(STREAM + counter, sdesc);
    }

    @After
    public void cleanupTest() throws Exception {
        madmin.deleteStream(STREAM + counter);
        ++counter;
    }

    @Test
    public void testProducerPerformancePartition() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(STREAM + counter, 100000, 2, 4, 1, 10000L, true, true, true, false, false));
    }

    @Test
    public void testProducerPerformanceRoundRobin() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(STREAM + counter, 100000, 2, 4, 1, 10000L, false, true, true, true, false));
    }

    @Test
    public void testProducerPerformanceHashKey() throws IOException {
        Assert.assertTrue((boolean)ProducerPerformance.runStressTest(STREAM + counter, 100000, 2, 4, 1, 10000L, false, true, true, false, true));
    }

    static {
        counter = 1;
    }
}

