/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.admin;

import com.mapr.streams.impl.MarlinRowKeyDecoder;
import com.mapr.streams.tests.admin.TopicTest;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class RowDecoderTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TopicTest.class);

    @BeforeClass
    public static void setupTest() throws Exception {
    }

    @Test
    public void testDecodeAssignKey() throws IOException {
        String key = "attopic1:00000001GLTopicTest";
        Document doc = MarlinRowKeyDecoder.decodeAssignKey((String)key);
        _logger.info(doc.toString());
        Assert.assertTrue((boolean)doc.getString(MarlinRowKeyDecoder.TOPIC).equals("topic1"));
        Assert.assertTrue((doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)doc.getString(MarlinRowKeyDecoder.CONSUMER_GROUP).equals("LTopicTest"));
    }

    @Test
    public void testDecodeMsgKey() throws IOException {
        String key = "p00attopic0:000000020000000000000066";
        Document doc = MarlinRowKeyDecoder.decodeMsgKey((String)key);
        _logger.info(doc.toString());
        Assert.assertTrue((boolean)doc.getString(MarlinRowKeyDecoder.TOPIC).equals("topic0"));
        Assert.assertTrue((doc.getInt(MarlinRowKeyDecoder.PARTITION) == 10 ? 1 : 0) != 0);
        Assert.assertTrue((doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((doc.getLong(MarlinRowKeyDecoder.OFFSET) == 102L ? 1 : 0) != 0);
        key = "p000t0:00000001";
        doc = MarlinRowKeyDecoder.decodeTopicFeedKey((String)key);
        Assert.assertTrue((boolean)doc.getString(MarlinRowKeyDecoder.TOPIC).equals("0"));
        Assert.assertTrue((doc.getInt(MarlinRowKeyDecoder.PARTITION) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDecodeCursorKey() throws IOException {
        String key = "ctxyz:0000000bp0ffGmygroup";
        Document doc = MarlinRowKeyDecoder.decodeCursorKey((String)key);
        _logger.info(doc.toString());
        Assert.assertTrue((boolean)doc.getString(MarlinRowKeyDecoder.TOPIC).equals("xyz"));
        Assert.assertTrue((doc.getInt(MarlinRowKeyDecoder.TOPIC_UNIQ) == 11 ? 1 : 0) != 0);
        Assert.assertTrue((doc.getInt(MarlinRowKeyDecoder.PARTITION) == 255 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)doc.getString(MarlinRowKeyDecoder.CONSUMER_GROUP).equals("mygroup"));
    }
}

