/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.db.tests.utils.DBTests;
import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.tests.producer.ProducerMultiTest;
import com.mapr.streams.tests.producer.SendMessagesToProducer;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerIdempotenceSnapshotCleanupFailureTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerIdempotenceSnapshotCleanupFailureTest.class);
    private static final String PREFIX = "/jtest-" + ProducerIdempotenceSnapshotCleanupFailureTest.class.getSimpleName() + "-";
    private static final String TED_FILE = "build_fileserver/fs/common/ted/ted";
    private static Path repoRootPath = null;
    private static Path tedCmdPath = null;
    private static Admin madmin;
    private static final int numParts = 1;
    private static final String SET_TED_CMD = " enable IdempotentRequestDrop";
    private static final String RESET_TED_CMD = " disable IdempotentRequestDrop";
    private static final String SET_DURABLE_TED_CMD = " enable PutAlwaysDurable";
    private static final String RESET_DURABLE_TED_CMD = " disable PutAlwaysDurable";

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        String sname = PREFIX + "idempotentproducercleanupfailure";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        madmin.createStream(sname, sdesc);
        String cmd = tedCmdPath.toString() + RESET_TED_CMD;
        int setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        String sname = PREFIX + "idempotentproducercleanupfailure";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String cmd = tedCmdPath.toString() + RESET_TED_CMD;
        int setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        cmd = tedCmdPath.toString() + RESET_DURABLE_TED_CMD;
        setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
    }

    private void produceMsgs(String topicName, KafkaProducer<byte[], byte[]> kafkaproducer, int numMsgs, int numPartitions, int msgSize, boolean shouldClose, String failureTedCmd) throws Exception {
        ProducerMultiTest.CountCallback cb = new ProducerMultiTest.CountCallback(numMsgs * 1);
        String cmd = null;
        String failureCmd = null;
        int setStatus = 0;
        int numTries = 0;
        SendMessagesToProducer producer = new SendMessagesToProducer(kafkaproducer, cb, topicName, numPartitions, numMsgs, msgSize, shouldClose);
        cmd = tedCmdPath.toString() + SET_DURABLE_TED_CMD;
        setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        if (failureTedCmd != null && (setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)(failureCmd = tedCmdPath.toString() + " enableOnce " + failureTedCmd))) != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        Thread producerThread = new Thread(producer);
        producerThread.start();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        if (failureTedCmd != null && (setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)(failureCmd = tedCmdPath.toString() + " disable " + failureTedCmd))) != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        while (numTries < 10 && failureTedCmd == null) {
            ++numTries;
            cmd = tedCmdPath.toString() + SET_TED_CMD;
            setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
            if (setStatus != 0) {
                throw new IOException(cmd + " failed with exitStatus: " + setStatus);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                System.out.println("Sleep interrupted " + e);
            }
            cmd = tedCmdPath.toString() + RESET_TED_CMD;
            setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
            if (setStatus != 0) {
                throw new IOException(cmd + " failed with exitStatus: " + setStatus);
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println("Sleep interrupted " + e);
            }
        }
        producerThread.join();
    }

    private void consumeMsgs(String topicName, KafkaConsumer<byte[], byte[]> kafkaconsumer, int numMsgs, int numPartitions) throws Exception {
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topicName);
        kafkaconsumer.subscribe(topics);
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        int count = 0;
        while (count < numMsgs * numPartitions) {
            ConsumerRecords recs = kafkaconsumer.poll(0L);
            System.err.println("messages fetched count " + (count += recs.count()));
        }
        Assert.assertEquals((long)(numMsgs * numPartitions), (long)count);
    }

    @Test
    public void testProducerIdempotenceSnapshotCleanupFailure() throws Exception {
        if (tedCmdPath == null) {
            throw new IOException("Could not find ted command file.");
        }
        String sname = PREFIX + "idempotentproducercleanupfailure";
        String topicName = ":t";
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("enable.idempotence", (Object)true);
        KafkaProducer kafkaproducer = new KafkaProducer(props);
        Properties listenerProps = new Properties();
        listenerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("fetch.min.bytes", "1");
        listenerProps.put("auto.offset.reset", "earliest");
        listenerProps.put("enable.auto.commit", (Object)false);
        KafkaConsumer kafkaconsumer = new KafkaConsumer(listenerProps);
        madmin.createTopic(sname, "t", 1);
        int msgSize = 0x200000;
        int numMsgs = 500;
        this.produceMsgs(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, numMsgs, 1, msgSize, false, null);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        this.produceMsgs(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, numMsgs, 1, msgSize, false, "IdempotentSnapshotCleanupCrash ");
        this.consumeMsgs(sname + topicName, (KafkaConsumer<byte[], byte[]>)kafkaconsumer, numMsgs * 2, 1);
        kafkaconsumer.unsubscribe();
        kafkaconsumer.close();
        kafkaproducer.close();
    }

    static {
        repoRootPath = BaseTest.getSourceRoot();
        if (repoRootPath != null && !Files.exists(tedCmdPath = repoRootPath.resolve(TED_FILE), new LinkOption[0])) {
            tedCmdPath = null;
        }
    }
}

