/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.tests.producer.ProducerMultiTest;
import com.mapr.streams.tests.producer.SendMessagesToProducer;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerIdExpiryMfsRestartTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerIdExpiryMfsRestartTest.class);
    private static final String PREFIX = "/jtest-" + ProducerIdExpiryMfsRestartTest.class.getSimpleName() + "-";
    private static Admin madmin;
    private static final int numParts = 4;

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        String sname = PREFIX + "idempotentproducer";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setProducerIdExpirySecs(3L);
        madmin.createStream(sname, sdesc);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        String sname = PREFIX + "idempotentproducer";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void produceMsgs(String topicName, KafkaProducer<byte[], byte[]> kafkaproducer, int numMsgs, int numPartitions, int msgSize, boolean shouldClose) throws Exception {
        ProducerMultiTest.CountCallback cb = new ProducerMultiTest.CountCallback(numMsgs * 1);
        SendMessagesToProducer producer = new SendMessagesToProducer(kafkaproducer, cb, topicName, numPartitions, numMsgs, msgSize, shouldClose);
        Thread producerThread = new Thread(producer);
        producerThread.start();
        producerThread.join();
    }

    private void consumeMsgs(String topicName, KafkaConsumer<byte[], byte[]> kafkaconsumer, int numMsgs, int numPartitions) throws Exception {
        int count;
        ConsumerRecords recs;
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topicName);
        kafkaconsumer.subscribe(topics);
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        for (count = 0; count < numMsgs * numPartitions; count += recs.count()) {
            recs = kafkaconsumer.poll(0L);
        }
        Assert.assertEquals((long)(numMsgs * numPartitions), (long)count);
    }

    @Test
    public void testProducerIdExpiryMfsRestart() throws Exception {
        String sname = PREFIX + "idempotentproducer";
        String topicName = ":t";
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("enable.idempotence", (Object)true);
        KafkaProducer kafkaproducer = new KafkaProducer(props);
        Properties listenerProps = new Properties();
        listenerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("fetch.min.bytes", "1");
        listenerProps.put("auto.offset.reset", "earliest");
        listenerProps.put("enable.auto.commit", (Object)false);
        KafkaConsumer kafkaconsumer = new KafkaConsumer(listenerProps);
        madmin.createTopic(sname, "t", 4);
        int msgSize = 20;
        int numMsgs = 10000;
        this.produceMsgs(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, numMsgs, 4, msgSize, false);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        ProcessBuilder proc = new ProcessBuilder("sudo", "service", "mapr-warden", "restart");
        Process process = proc.start();
        process.waitFor();
        this.produceMsgs(sname + topicName, (KafkaProducer<byte[], byte[]>)kafkaproducer, numMsgs, 4, msgSize, false);
        this.consumeMsgs(sname + topicName, (KafkaConsumer<byte[], byte[]>)kafkaconsumer, numMsgs * 2, 4);
        kafkaconsumer.unsubscribe();
        kafkaconsumer.close();
        kafkaproducer.close();
    }
}

