/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.UnixUserGroupHelper;
import com.mapr.web.security.SecurityUtils;
import com.mapr.web.security.WebSecurityConfig;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class ImpersonationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(ImpersonationFilter.class);
    private static final String IMPERSONATED_USER_HEADER = "X-MAPR-IMPERSONATED-USER";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String user;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Authentication header = SecurityContextHolder.getContext().getAuthentication();
        if (header != null && header.isAuthenticated() && StringUtils.isNotBlank((CharSequence)(user = request.getHeader(IMPERSONATED_USER_HEADER)))) {
            if (ImpersonationFilter.isAllowedToImpersonate(SecurityUtils.getCurrentUserName())) {
                log.debug("Impersonating user: {}", (Object)user);
            } else {
                String encodedUser = URLEncoder.encode(user, StandardCharsets.UTF_8.displayName());
                response.sendError(403, "Unable to impersonate user: " + encodedUser);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static boolean isAllowedToImpersonate(String sessionUser) {
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (JNISecurity.IsSecurityEnabled((String)clusterName)) {
            MutableInt err = new MutableInt();
            Security.TicketAndKey ticket = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (MutableInt)err);
            int maprUserUid = ticket.getUserCreds().getUid();
            return maprUserUid == new UnixUserGroupHelper().getUserId(sessionUser);
        }
        String proxyDir = WebSecurityConfig.CONFIG.getMaprConfDir() + "/proxy/";
        return new File(proxyDir + sessionUser).exists();
    }
}

