/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.web.security.MapRTicketToken;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MapRTicketAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(MapRTicketAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) {
        try {
            MapRTicketToken token = (MapRTicketToken)authentication;
            byte[] t = Base64.decodeBase64((byte[])token.getToken());
            log.debug("MapRTicket authentication started");
            Security.AuthenticationReqFull authReq = Security.AuthenticationReqFull.parseFrom((byte[])t);
            if (authReq != null && authReq.getEncryptedTicket() != null) {
                MutableInt err;
                byte[] encryptedTicket = authReq.getEncryptedTicket().toByteArray();
                Security.Ticket decryptedTicket = Security.DecryptTicket((byte[])encryptedTicket, (MutableInt)(err = new MutableInt()));
                if (decryptedTicket != null && err.GetValue() == 0) {
                    Security.CredentialsMsg creds = decryptedTicket.getUserCreds();
                    boolean canImpersonate = decryptedTicket.getCanUserImpersonate();
                    Security.Key userKey = decryptedTicket.getUserKey();
                    String userName = creds.getUserName();
                    if (!canImpersonate && token.isImpersonateUser()) {
                        String msg = "User " + userName + " doesn't have permissions to impersonate other users";
                        log.error(msg);
                        throw new AuthenticationServiceException(msg);
                    }
                    byte[] secretNum = authReq.getEncryptedRandomSecret().toByteArray();
                    byte[] secretNumDecrypted = Security.Decrypt((Security.Key)userKey, (byte[])secretNum, (MutableInt)err);
                    if (secretNumDecrypted.length == 8) {
                        long returnLong = ((long)secretNumDecrypted[0] << 56) + ((long)(secretNumDecrypted[1] & 0xFF) << 48) + ((long)(secretNumDecrypted[2] & 0xFF) << 40) + ((long)(secretNumDecrypted[3] & 0xFF) << 32) + ((long)(secretNumDecrypted[4] & 0xFF) << 24) + (long)((secretNumDecrypted[5] & 0xFF) << 16) + (long)((secretNumDecrypted[6] & 0xFF) << 8) + (long)((secretNumDecrypted[7] & 0xFF) << 0);
                        log.debug("Received secret number: {}", (Object)returnLong);
                        Security.AuthenticationResp.Builder authResp = Security.AuthenticationResp.newBuilder();
                        authResp.setChallengeResponse(++returnLong);
                        authResp.setStatus(0);
                        byte[] resp = authResp.build().toByteArray();
                        byte[] respEncrypted = Security.Encrypt((Security.Key)userKey, (byte[])resp, (MutableInt)err);
                        Base64 base64 = new Base64(0);
                        String authenticate = base64.encodeToString(respEncrypted);
                        ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
                        log.debug("MaprRTicket Authentication is completed on server side");
                        grantedAuths.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
                        MapRTicketToken mapRTicketToken = new MapRTicketToken(userName, grantedAuths, null, authenticate, canImpersonate);
                        SecurityContextHolder.getContext().setAuthentication((Authentication)mapRTicketToken);
                        return mapRTicketToken;
                    }
                    String msg = "Bad random secret";
                    log.error(msg);
                    throw new AuthenticationServiceException(msg);
                }
                String userCreds = "Error while decrypting ticket and key " + err.GetValue();
                log.error(userCreds);
                throw new AuthenticationServiceException(userCreds);
            }
            String clientRequestError = "Malformed client request";
            log.error(clientRequestError);
            throw new AuthenticationServiceException(clientRequestError);
        }
        catch (AuthenticationException ex) {
            String serverKeyError = "Bad server key";
            log.error(serverKeyError, (Throwable)ex);
            throw new AuthenticationServiceException(serverKeyError);
        }
    }

    public boolean supports(Class<?> authentication) {
        return MapRTicketToken.class.isAssignableFrom(authentication);
    }
}

