/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mapr.db.Admin;
import com.mapr.db.MetaTable;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ClonedCondition;
import com.mapr.db.impl.CommitContextHelper;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.CorrelationTracker;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.ojai.DBDocumentBuilder;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.scan.ScanStats;
import com.mapr.db.util.ConditionParser;
import com.mapr.fs.proto.Dbserver;
import com.mapr.ojai.store.impl.AbstractDocumentStream;
import com.mapr.ojai.store.impl.CommitWaitStream;
import com.mapr.ojai.store.impl.DocumentFlattener;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.DrillPostludeFilter;
import com.mapr.ojai.store.impl.DrillPreludeFilter;
import com.mapr.ojai.store.impl.ElementGroups;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.IdIndexDesc;
import com.mapr.ojai.store.impl.LimitStream;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OffsetStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDocumentStore;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.QueryEquivalence;
import com.mapr.ojai.store.impl.SharedDrillSession;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import com.mapr.ojai.store.impl.SortKey;
import com.mapr.ojai.store.impl.TimeoutDocumentFilter;
import com.mapr.ojai.store.impl.TopKStream;
import com.mapr.ojai.store.impl.UnaryOperator;
import com.mapr.utils.CommaSeparated;
import com.mapr.utils.SeparatorWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentConstants;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.SortOrder;
import org.ojai.util.Documents;
import org.ojai.util.FieldProjector;
import org.ojai.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OjaiQuery
implements Query {
    private static final Logger _logger = LoggerFactory.getLogger(OjaiQuery.class);
    private static final String ROW_CPU_IO_RATIO_NAME = "ojai.mapr.query.row-time-to-io-ratio";
    private static final String ROW_CPU_IO_RATIO_DEFAULT = "1.0";
    private static final double ROW_CPU_IO_RATIO = Double.parseDouble(System.getProperty("ojai.mapr.query.row-time-to-io-ratio", "1.0"));
    private Document options;
    private boolean possiblyNeedProjection = false;
    private boolean hasProjectionWithArrayIndex = false;
    private boolean isStarQuery = false;
    private final HashSet<FieldPath> projectedFieldSet = new HashSet();
    private boolean includeId = false;
    private ConditionImpl condition = MapRDBImpl.newCondition();
    public static final long LIMIT_NONE = -1L;
    private long limit = -1L;
    private static final String MAX_CLIENT_SORT_LIMIT_NAME = "ojai.mapr.query.max-client-sort-limit";
    private static final String MAX_CLIENT_SORT_LIMIT_DEFAULT = "5000";
    @VisibleForTesting
    public static final int MAX_CLIENT_SORT_LIMIT = Integer.parseInt(System.getProperty("ojai.mapr.query.max-client-sort-limit", "5000"));
    public static final long OFFSET_NONE = 0L;
    private long offset = 0L;
    private Dbserver.CommitContext commitContext;
    private static final FieldPath[] EMPTY_FIELD_PATH_ARRAY = new FieldPath[0];
    private List<SortKey> sortKeys;
    static final ImmutableMap<QueryCondition.Op, String> OP_TO_NAME;
    private QueryAnalyzer queryAnalyzer;
    public static final Equivalence<OjaiQuery> EQUIVALENCE;
    private static final int HASH_ROTATION = 5;
    private static final long INTEGER_MASK = 0xFFFFFFFFL;
    private static final int HASH_SEED = -256961641;
    private static final String DRILL_FORCE_SORT_NONCOVERING = "planner.index.force_sort_noncovering";
    private static final String DRILL_OPTIONS_PREFIX;
    private double rowCpuIoRatio;
    public static final long TIMEOUT_NONE = -1L;
    private long timeout = -1L;
    private boolean built;
    private boolean isSortLimit;
    private ElementGroups elementGroups;
    private static final String EMPTY_COND = "<EMPTY>";
    private static final String COMMA_SPACE = ", ";

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public Dbserver.CommitContext getCommitContext() {
        return this.commitContext;
    }

    public void setCommitContext(Dbserver.CommitContext val) {
        this.commitContext = val;
    }

    public boolean hasCondition() {
        return !this.condition.isEmpty();
    }

    boolean hasRowKeyCondition() {
        return this.condition.hasRowKeyCondition();
    }

    public ConditionImpl getCondition() {
        return this.condition;
    }

    public FieldPath[] getSelectListAsArray() {
        if (this.projectedFieldSet.size() == 0 || this.isStarQuery) {
            return null;
        }
        return this.projectedFieldSet.toArray(EMPTY_FIELD_PATH_ARRAY);
    }

    public OjaiQuery setOption(String optionName, Object value) throws IllegalArgumentException {
        this.checkNotBuilt();
        if (this.options == null) {
            this.options = MapRDBImpl.newDocument();
        }
        this.options.set(optionName, (Value)DBValueBuilderImpl.KeyValueBuilder.initFromObject(value));
        return this;
    }

    public Object getOption(String optionName) {
        return this.options == null ? null : this.options.getValue(optionName).getObject();
    }

    public OjaiQuery setOptions(Document options) throws IllegalArgumentException {
        this.checkNotBuilt();
        this.options = options;
        return this;
    }

    public Document getOptions() {
        return this.options;
    }

    public OjaiQuery select(String ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        this.select(Fields.toFieldPathArray((String[])fieldPaths));
        return this;
    }

    public OjaiQuery select(FieldPath ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        for (FieldPath fieldPath : fieldPaths) {
            if ("*".equals(fieldPath.getRootSegment().getNameSegment().getName())) {
                this.isStarQuery = true;
            } else if (!this.hasProjectionWithArrayIndex) {
                FieldSegment seg = fieldPath.getRootSegment();
                while ((seg = seg.getChild()) != null) {
                    if (!seg.isIndexed()) continue;
                    this.possiblyNeedProjection = true;
                    this.hasProjectionWithArrayIndex = true;
                    break;
                }
            }
            this.projectedFieldSet.add(fieldPath);
        }
        return this;
    }

    public OjaiQuery where(String conditionJson) throws OjaiException, IllegalArgumentException {
        this.checkNotBuilt();
        ConditionParser conditionParser = new ConditionParser();
        return conditionJson != null ? this.where(conditionParser.parseCondition(conditionJson)) : this.where(conditionJson);
    }

    public OjaiQuery where(QueryCondition queryCond) throws OjaiException, IllegalArgumentException {
        this.checkNotBuilt();
        if (queryCond != null && !queryCond.isEmpty()) {
            this.possiblyNeedProjection = true;
            if (this.condition.isEmpty()) {
                this.condition.condition(queryCond);
            } else {
                ConditionImpl previousCondition = this.condition;
                if (!previousCondition.isBuilt()) {
                    previousCondition.build();
                }
                this.condition = MapRDBImpl.newCondition().and().condition((QueryCondition)previousCondition).condition(queryCond).close();
            }
        }
        return this;
    }

    public OjaiQuery orderBy(String ... stringPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((stringPaths != null && stringPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        this.orderBy(Fields.toFieldPathArray((String[])stringPaths));
        return this;
    }

    public OjaiQuery orderBy(FieldPath ... fieldPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPaths != null && fieldPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        for (FieldPath fieldPath : fieldPaths) {
            this.orderBy(fieldPath, SortOrder.ASC);
        }
        return this;
    }

    public OjaiQuery orderBy(String field, String order) throws IllegalArgumentException {
        return this.orderBy(FieldPath.parseFrom((String)field), SortOrder.valueOf((String)order));
    }

    public OjaiQuery orderBy(String field, SortOrder order) throws IllegalArgumentException {
        return this.orderBy(FieldPath.parseFrom((String)field), order);
    }

    boolean needsSort() {
        return this.sortKeys != null && this.sortKeys.size() > 0;
    }

    public OjaiQuery orderBy(FieldPath fieldPath, SortOrder sortOrder) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPath != null ? 1 : 0) != 0, (Object)"fieldPath must be non-null");
        Preconditions.checkArgument((sortOrder != null ? 1 : 0) != 0, (Object)"sortOrder must be non-null");
        Preconditions.checkArgument((!OjaiQuery.isOpenArrayPath(fieldPath) ? 1 : 0) != 0, (Object)"cannot sort by an open array expression");
        if (this.sortKeys == null) {
            this.sortKeys = new LinkedList<SortKey>();
        }
        this.possiblyNeedProjection = true;
        this.sortKeys.add(new SortKey(fieldPath, sortOrder));
        return this;
    }

    public OjaiQuery offset(long offset) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be non-negative");
        this.offset = offset;
        return this;
    }

    public OjaiQuery limit(long limit) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be non-negative");
        this.limit = limit;
        return this;
    }

    QueryAnalyzer getQueryAnalyzer() {
        if (this.queryAnalyzer == null) {
            Preconditions.checkState((!this.built ? 1 : 0) != 0);
            this.queryAnalyzer = new QueryAnalyzer();
            this.condition.visit((ConditionVisitor)this.queryAnalyzer);
        }
        return this.queryAnalyzer;
    }

    public String buildSqlString(String engineName, String tableName) {
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        return queryAnalyzer.buildSql(this, engineName, tableName, this.sortKeys, this.offset, this.limit);
    }

    public boolean isIdIn() {
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        if (!queryAnalyzer.isUnion()) {
            return false;
        }
        Set<Expression> otherPredicates = queryAnalyzer.getOtherPredicates();
        if (otherPredicates.size() > 0) {
            return false;
        }
        Map<FieldPath, List<NaryOperator>> topRelations = queryAnalyzer.getTopRelations();
        if (topRelations.size() != 1) {
            return false;
        }
        List<NaryOperator> relOps = topRelations.get(DocumentConstants.ID_FIELD);
        if (relOps == null) {
            return false;
        }
        int notEquality = 0;
        for (NaryOperator relOp : relOps) {
            String opName = relOp.opName;
            if (opName.equals("=") || opName.equals("in")) continue;
            ++notEquality;
        }
        return notEquality <= 0;
    }

    public boolean structuralEquals(OjaiQuery otherQuery) {
        if (this.limit == -1L != (otherQuery.limit == -1L)) {
            return false;
        }
        if (this.offset == 0L != (otherQuery.offset == 0L)) {
            return false;
        }
        if (this.projectedFieldSet.size() != otherQuery.projectedFieldSet.size()) {
            return false;
        }
        Iterator<FieldPath> otherIter = otherQuery.projectedFieldSet.iterator();
        for (FieldPath fieldPath : this.projectedFieldSet) {
            FieldPath otherFieldPath;
            if (fieldPath.equals((Object)(otherFieldPath = otherIter.next()))) continue;
            return false;
        }
        if (this.options == null) {
            if (otherQuery.options != null) {
                return false;
            }
        } else {
            if (otherQuery.options == null) {
                return false;
            }
            if (!this.options.equals(otherQuery.options)) {
                return false;
            }
        }
        if (!this.getQueryAnalyzer().structuralEquals(otherQuery.getQueryAnalyzer())) {
            return false;
        }
        if (this.sortKeys == null && otherQuery.sortKeys != null && otherQuery.sortKeys.size() != 0) {
            return false;
        }
        if (this.sortKeys != null) {
            if (otherQuery.sortKeys == null || otherQuery.sortKeys.size() == 0) {
                return false;
            }
            if (this.sortKeys.size() != otherQuery.sortKeys.size()) {
                return false;
            }
            Iterator<SortKey> otherSortIter = otherQuery.sortKeys.iterator();
            for (SortKey sortKey : this.sortKeys) {
                SortKey otherKey = otherSortIter.next();
                if (!sortKey.fieldPath.equals((Object)otherKey.fieldPath)) {
                    return false;
                }
                if (sortKey.sortOrder == otherKey.sortOrder) continue;
                return false;
            }
        }
        return true;
    }

    private static int blendHash(int hash, int toBlend) {
        int rotatedHash = hash << 5 | hash >> 27;
        return rotatedHash ^ toBlend;
    }

    private static int blendHash(int hash, long toBlend) {
        int highBits = (int)(toBlend >> 32);
        hash = OjaiQuery.blendHash(hash, highBits);
        int lowBits = (int)(toBlend & 0xFFFFFFFFL);
        hash = OjaiQuery.blendHash(hash, lowBits);
        return hash;
    }

    public int structuralHashCode() {
        int hash = -256961641;
        hash = OjaiQuery.blendHash(hash, this.limit != -1L ? 7L : -1L);
        hash = OjaiQuery.blendHash(hash, this.offset != 0L ? 11L : 0L);
        for (FieldPath fieldPath : this.projectedFieldSet) {
            hash = OjaiQuery.blendHash(hash, fieldPath.hashCode());
        }
        if (this.options != null) {
            hash = OjaiQuery.blendHash(hash, this.options.hashCode());
        }
        hash = OjaiQuery.blendHash(hash, this.getQueryAnalyzer().structuralHashCode());
        if (this.sortKeys != null) {
            for (SortKey sortKey : this.sortKeys) {
                hash = OjaiQuery.blendHash(hash, sortKey.fieldPath.hashCode());
                hash = OjaiQuery.blendHash(hash, sortKey.sortOrder.hashCode());
            }
        }
        return hash;
    }

    @VisibleForTesting
    public static boolean includesCoveringArray(Map<String, ?> coveredMap, String fieldPathStr) {
        int rBracketPos;
        while (fieldPathStr.length() > 2 && (rBracketPos = fieldPathStr.lastIndexOf(93, fieldPathStr.length() - 2)) >= 0) {
            if (!coveredMap.containsKey(fieldPathStr = fieldPathStr.substring(0, rBracketPos + 1))) continue;
            return true;
        }
        return false;
    }

    private boolean isCoveringIndex(QueryAnalyzer queryAnalyzer, IndexDesc indexDesc, int scanFields) {
        if (this.projectedFieldSet == null || this.projectedFieldSet.size() == 0) {
            return false;
        }
        List indexedFields = indexDesc.getIndexedFields();
        Collection coveredFields = indexDesc.getIncludedFields();
        final HashSet<String> coveredSetForCondition = new HashSet<String>(indexedFields.size() + coveredFields.size());
        HashMap<String, Object> coveredMapForSortSelect = new HashMap<String, Object>(indexedFields.size() + coveredFields.size());
        coveredSetForCondition.add("_id");
        coveredMapForSortSelect.put("_id", IdIndexDesc.ID_INDEX_FIELD_DESC);
        int usableFields = 0;
        for (Object ifd : indexedFields) {
            FieldPath fieldPath = ifd.getFieldPath();
            if (usableFields++ < scanFields) {
                coveredSetForCondition.add(fieldPath.toString());
            }
            if (OjaiQuery.isOpenArrayPath(fieldPath)) continue;
            coveredMapForSortSelect.put(fieldPath.toString(), ifd);
        }
        boolean hasIncludedArrays = false;
        for (IndexFieldDesc ifd : coveredFields) {
            FieldPath fieldPath = ifd.getFieldPath();
            String fieldPathStr = fieldPath.toString();
            coveredSetForCondition.add(fieldPathStr);
            coveredMapForSortSelect.put(fieldPathStr, ifd);
            if (!OjaiQuery.isOpenArrayPath(fieldPath)) continue;
            hasIncludedArrays = true;
        }
        for (FieldPath fieldPath : this.projectedFieldSet) {
            String fieldPathString = fieldPath.asPathString();
            if (coveredMapForSortSelect.containsKey(fieldPathString) || hasIncludedArrays && OjaiQuery.includesCoveringArray(coveredMapForSortSelect, fieldPathString)) continue;
            return false;
        }
        if (this.sortKeys != null && this.sortKeys.size() > 0) {
            for (SortKey sortKey : this.sortKeys) {
                if (coveredMapForSortSelect.containsKey(sortKey.fieldString)) continue;
                return false;
            }
        }
        final MutableBoolean isCovering = new MutableBoolean(true);
        this.condition.visit((ConditionVisitor)new QueryAnalyzer(){

            @Override
            public void field(FieldPath leafPath, FieldPath fullPath, boolean isBlock) {
                if (isBlock) {
                    super.field(leafPath, fullPath, isBlock);
                    return;
                }
                String fieldPathStr = fullPath.asPathString();
                if (!coveredSetForCondition.contains(fieldPathStr)) {
                    isCovering.value = false;
                }
                super.field(leafPath, fullPath, isBlock);
            }
        });
        return isCovering.value;
    }

    public boolean isSortOnId() {
        if (this.sortKeys == null) {
            return false;
        }
        int sortKeySize = this.sortKeys.size();
        if (sortKeySize != 1) {
            return false;
        }
        SortKey sortKey = this.sortKeys.get(0);
        if (sortKey.order != IndexFieldDesc.Order.Asc) {
            return false;
        }
        return sortKey.fieldPath.equals((Object)DocumentConstants.ID_FIELD);
    }

    private boolean isSortKeyIndexEqualitySuffix(List<IndexFieldDesc> fieldDescriptors, Map<FieldPath, List<NaryOperator>> topFieldRelations) {
        IndexFieldDesc fieldDesc;
        Iterator<SortKey> sortKeyIter = this.sortKeys.iterator();
        SortKey sortKey = sortKeyIter.next();
        int equalityKeys = 0;
        Iterator<IndexFieldDesc> fieldDescIter = fieldDescriptors.iterator();
        while (fieldDescIter.hasNext()) {
            fieldDesc = fieldDescIter.next();
            FieldPath fieldPath = fieldDesc.getFieldPath();
            if (sortKey.fieldPath.equals((Object)fieldPath) && !fieldDesc.isFunctional()) {
                if (sortKey.order == fieldDesc.getSortOrder()) break;
                return false;
            }
            List<NaryOperator> relOps = topFieldRelations.get(fieldPath);
            if (relOps == null) {
                return false;
            }
            for (NaryOperator relOp : relOps) {
                if (relOp.opName.equals("=")) continue;
                return false;
            }
            ++equalityKeys;
        }
        if (this.sortKeys.size() > fieldDescriptors.size() - equalityKeys) {
            return false;
        }
        while (sortKeyIter.hasNext()) {
            sortKey = sortKeyIter.next();
            fieldDesc = fieldDescIter.next();
            if (sortKey.order == fieldDesc.getSortOrder() && sortKey.fieldPath.equals((Object)fieldDesc.getFieldPath())) continue;
            return false;
        }
        return true;
    }

    private static boolean cantUseIndex(List<NaryOperator> relOps, int fieldPos, Dbserver.SIndexInfo.Version ver) {
        if (ver == Dbserver.SIndexInfo.Version.v6dot1) {
            return false;
        }
        for (NaryOperator nOp : relOps) {
            String opName;
            LiteralExpression litExpr = (LiteralExpression)nOp.arg[1];
            Value.Type litType = litExpr.getType();
            if (nOp.arg[0] instanceof FieldExpression && (litType == Value.Type.MAP || litType == Value.Type.ARRAY)) {
                return true;
            }
            switch (opName = nOp.opName) {
                case "notMatches": 
                case "ojai_condition": {
                    return true;
                }
                case "=": {
                    if (litType != Value.Type.NULL) break;
                    return true;
                }
                case "<>": {
                    if (fieldPos == 0) {
                        return true;
                    }
                    if (!(nOp.arg[0] instanceof UnaryOperator)) break;
                    UnaryOperator unOp = (UnaryOperator)nOp.arg[0];
                    switch (unOp.opName) {
                        case "sizeOf": {
                            return true;
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }

    private static boolean isOpenArrayPath(FieldPath fieldPath) {
        for (FieldSegment fieldSegment : fieldPath) {
            FieldSegment.IndexSegment indexSegment;
            if (!fieldSegment.isIndexed() || (indexSegment = fieldSegment.getIndexSegment()).getIndex() >= 0) continue;
            return true;
        }
        return false;
    }

    public List<FieldPath> getSortLimitExtras() {
        boolean needsSort = this.sortKeys != null && this.sortKeys.size() > 0;
        ImmutableList sortLimitExtras = null;
        if (needsSort && this.isSortLimit && !this.isStarQuery()) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (SortKey sortKey : this.sortKeys) {
                if (this.projectedFieldSet.contains(sortKey.fieldPath)) continue;
                listBuilder.add((Object)sortKey.fieldPath);
            }
            sortLimitExtras = listBuilder.build();
        }
        return sortLimitExtras;
    }

    public boolean canUseIndexForQuery(Admin admin, Path tablePath, SharedTable sharedPrimaryTable, OjaiConnection ojaiConnection) throws IOException {
        Preconditions.checkState((boolean)this.built);
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        return queryAnalyzer.canUseOneIndex();
    }

    public List<EligibleIndex> getEligibleIndexes(Admin admin, Path tablePath, SharedTable sharedPrimaryTable, OjaiConnection ojaiConnection) throws IOException {
        Preconditions.checkState((boolean)this.built);
        _logger.trace("getEligibleIndexes ojaiQuery:{}", (Object)this.toString());
        Collection indexes = admin.getTableIndexes(tablePath);
        BaseJsonTable table = (BaseJsonTable)sharedPrimaryTable.get();
        IdIndexDesc idIndexDesc = new IdIndexDesc(table);
        indexes.add(idIndexDesc);
        ScanStats tableStats = null;
        LinkedList<EligibleIndex> eligibleIndexes = new LinkedList<EligibleIndex>();
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        Map<FieldPath, List<NaryOperator>> topFieldRelations = queryAnalyzer.getTopRelations();
        HashSet<String> arrayFields = new HashSet<String>();
        block5: for (IndexDesc indexDesc : indexes) {
            int tcCount;
            Set conditionSets;
            boolean isCovering;
            if (indexDesc.isDisabled()) continue;
            List fieldDescriptors = indexDesc.getIndexedFields();
            boolean canUseIndexForSort = false;
            if (this.sortKeys != null && this.sortKeys.size() > 0) {
                if (!indexDesc.isHashed() && this.sortKeys.size() <= fieldDescriptors.size() && this.isSortKeyIndexEqualitySuffix(fieldDescriptors, topFieldRelations)) {
                    canUseIndexForSort = true;
                }
                if (!canUseIndexForSort && !this.isSortLimit) continue;
            }
            boolean isArrayIndex = false;
            int scanFields = 0;
            arrayFields.clear();
            if (topFieldRelations.size() > 0) {
                int fieldPos = 0;
                for (IndexFieldDesc fieldDesc : fieldDescriptors) {
                    FieldPath fieldPath = fieldDesc.getFieldPath();
                    boolean isOpenArrayPath = OjaiQuery.isOpenArrayPath(fieldPath);
                    List<NaryOperator> relOps = topFieldRelations.get(fieldPath);
                    if (isOpenArrayPath) {
                        isArrayIndex = true;
                    }
                    if (!(fieldDesc.isFunctional() || relOps == null || OjaiQuery.cantUseIndex(relOps, fieldPos, indexDesc.getIndexVersion()) || isOpenArrayPath && arrayFields.size() != 0 && !this.elementGroups.mustCorrelate(fieldPath, arrayFields))) {
                        ++scanFields;
                        if (isOpenArrayPath) {
                            arrayFields.add(fieldPath.toString());
                        }
                    }
                    if (fieldPos == 0 && scanFields == 0 && indexDesc != idIndexDesc) continue block5;
                    if (scanFields <= fieldPos) break;
                    ++fieldPos;
                }
            }
            boolean bl = isCovering = indexDesc == idIndexDesc || this.isCoveringIndex(queryAnalyzer, indexDesc, scanFields);
            if (scanFields <= 0 && !isCovering && !canUseIndexForSort) continue;
            if (tableStats == null) {
                try (MetaTable metaTable = table.getMetaTable();){
                    tableStats = metaTable.getScanStats();
                }
            }
            if (!isArrayIndex && scanFields < fieldDescriptors.size()) {
                int nDesc = fieldDescriptors.size();
                for (int i = scanFields; i < nDesc; ++i) {
                    IndexFieldDesc fieldDesc = (IndexFieldDesc)fieldDescriptors.get(i);
                    FieldPath fieldPath = fieldDesc.getFieldPath();
                    if (!OjaiQuery.isOpenArrayPath(fieldPath)) continue;
                    isArrayIndex = true;
                    break;
                }
            }
            boolean needsSort = this.needsSort();
            List<FieldPath> sortLimitExtras = this.getSortLimitExtras();
            CorrelationTracker correlationTracker = this.condition.getCorrelationTracker();
            if (arrayFields.size() == 0) {
                conditionSets = null;
                tcCount = 0;
            } else {
                String arrayField = (String)arrayFields.iterator().next();
                conditionSets = correlationTracker.getClonedConditions(arrayField);
                tcCount = correlationTracker.getTrackedConditionCount(arrayField);
            }
            if (conditionSets == null || conditionSets.isEmpty()) {
                EligibleIndex ei = new EligibleIndex(indexDesc, scanFields, isCovering, isArrayIndex, needsSort, canUseIndexForSort, sortLimitExtras, ojaiConnection, this, null, tableStats, sharedPrimaryTable);
                eligibleIndexes.add(ei);
                continue;
            }
            for (ClonedCondition clonedCondition : conditionSets) {
                EligibleIndex ei = new EligibleIndex(indexDesc, scanFields, tcCount == 1 ? isCovering : false, isArrayIndex, needsSort, canUseIndexForSort, sortLimitExtras, ojaiConnection, this, clonedCondition, tableStats, sharedPrimaryTable);
                eligibleIndexes.add(ei);
            }
        }
        return eligibleIndexes;
    }

    public QueryCondition getScanCondition(OjaiDriver ojaiDriver, EligibleIndex eligibleIndex) {
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        Map<FieldPath, List<NaryOperator>> topRelations = queryAnalyzer.getTopRelations();
        IndexDesc indexDesc = eligibleIndex.indexDesc;
        List fieldDescs = indexDesc.getIndexedFields();
        QueryCondition queryCondition = null;
        int fieldIdx = 0;
        for (IndexFieldDesc fieldDesc : fieldDescs) {
            if (fieldIdx >= eligibleIndex.scanFields) break;
            List<NaryOperator> relOps = topRelations.get(fieldDesc.getFieldPath());
            for (NaryOperator relOp : relOps) {
                QueryCondition newCond = ExpressionToCondition.convert(relOp, ojaiDriver);
                if (queryCondition == null) {
                    queryCondition = newCond;
                    continue;
                }
                queryCondition = ojaiDriver.newCondition().and().condition(queryCondition).condition(newCond).close().build();
            }
            ++fieldIdx;
        }
        return queryCondition;
    }

    public Set<FieldPath> getProjectedFieldSet() {
        return this.projectedFieldSet;
    }

    public boolean isStarQuery() {
        return this.isStarQuery || this.projectedFieldSet.isEmpty();
    }

    public boolean isPossiblyNeedProjection() {
        return this.possiblyNeedProjection;
    }

    public OjaiQuery waitForTrackedWrites(String writesContext) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)writesContext);
        this.checkNotBuilt();
        try {
            this.commitContext = CommitContextHelper.DecodeCommitContext((String)writesContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return this;
    }

    public QueryResult decorateStream(QueryResult docStream, OjaiConnection ojaiConnection, boolean isIndexSorted, List<FieldPath> sortLimitExtras, SharedResource<BaseJsonTable> sharedTable) {
        QueryResult resultStream = docStream;
        boolean useLimitStream = false;
        boolean useTopKStream = false;
        if (this.limit != -1L) {
            if (this.sortKeys == null || isIndexSorted && !this.getForceNonCoveringSort()) {
                useLimitStream = true;
            } else {
                if (this.limit > Integer.MAX_VALUE) {
                    throw new OjaiException("Limit (" + this.limit + ") is too large for client-side execution");
                }
                useTopKStream = true;
            }
        }
        if (!useTopKStream && this.offset > 0L) {
            resultStream = new OffsetStream((DocumentStream)resultStream, this.offset);
        }
        if (useLimitStream) {
            resultStream = new LimitStream((DocumentStream)resultStream, this.limit);
        }
        if (useTopKStream) {
            resultStream = new TopKStream((DocumentStream)resultStream, (int)(this.limit + this.offset), this.sortKeys, sortLimitExtras);
            if (this.offset > 0L) {
                resultStream = new OffsetStream((DocumentStream)resultStream, this.offset);
            }
        }
        if (this.commitContext != null) {
            resultStream = this.waitForSync(resultStream, ojaiConnection, sharedTable);
        }
        resultStream = this.addTimeout(resultStream, ojaiConnection);
        OjaiDocumentStore.logQueryPlan((DocumentStream)resultStream);
        return resultStream;
    }

    private QueryResult waitForSync(QueryResult docStream, OjaiConnection ojaiConnection, SharedResource<BaseJsonTable> sharedTable) {
        QueryResult resultStream = docStream;
        if (this.commitContext != null) {
            resultStream = new CommitWaitStream((DocumentStream)resultStream, sharedTable, this.commitContext);
        }
        return resultStream;
    }

    private QueryResult addTimeout(QueryResult docStream, OjaiConnection ojaiConnection) {
        QueryResult resultStream = docStream;
        long timeoutMs = this.getTimeout();
        if (timeoutMs != -1L) {
            ExecutorService executorService = ojaiConnection.getExecutorService();
            resultStream = new TimeoutDocumentFilter((DocumentStream)resultStream, executorService, timeoutMs);
        }
        return resultStream;
    }

    public QueryResult createDrillStream(OjaiConnection ojaiConnection, SharedTable sharedTable, QueryContext queryContext) {
        SharedDrillSession sharedDrillSession = new SharedDrillSession(ojaiConnection, queryContext.getClusterName());
        AbstractDocumentStream drillStream = new DrillDocumentStream(ojaiConnection, queryContext, sharedDrillSession);
        drillStream = this.waitForSync(drillStream, ojaiConnection, sharedTable);
        LinkedList<DrillOption> drillOptions = new LinkedList<DrillOption>();
        if (this.getForceNonCoveringSort()) {
            DrillOption drillOption = new DrillOption(DRILL_FORCE_SORT_NONCOVERING, true);
            drillOptions.add(drillOption);
        }
        if (this.options != null) {
            FieldProjector fieldProjector = new FieldProjector(new String[]{DRILL_OPTIONS_PREFIX});
            HashMap<String, Value> optionMap = new HashMap<String, Value>();
            DocumentFlattener.addToMap(optionMap, this.options, fieldProjector);
            for (Map.Entry<String, Value> entry : optionMap.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("ojai.mapr.drill.")) continue;
                String optionName = key.substring("ojai.mapr.drill.".length());
                Value value = entry.getValue();
                Object stringValue = value.toString();
                if (value.getType() == Value.Type.STRING) {
                    stringValue = "'" + (String)stringValue + "'";
                }
                DrillOption drillOption = new DrillOption(optionName, stringValue);
                drillOptions.add(drillOption);
            }
        }
        if (drillOptions.size() > 0) {
            for (DrillOption drillOption : drillOptions) {
                String alterSession = "alter session set `" + drillOption.name + "` = " + drillOption.value;
                drillStream = new DrillPreludeFilter((DocumentStream)drillStream, ojaiConnection, sharedDrillSession, alterSession);
            }
            for (DrillOption drillOption : drillOptions) {
                String resetSession = "alter session reset `" + drillOption.name + "`";
                drillStream = new DrillPostludeFilter((DocumentStream)drillStream, ojaiConnection, sharedDrillSession, resetSession);
            }
        }
        return drillStream;
    }

    public double getRowCpuIoRatio() {
        return this.rowCpuIoRatio;
    }

    public String getIndexHint() {
        if (this.options == null) {
            return null;
        }
        String optionVal = this.options.getString("ojai.mapr.query.hint-using-index");
        return optionVal;
    }

    private boolean getOption(String name, boolean defaultValue) {
        if (this.options == null) {
            return defaultValue;
        }
        Boolean optionVal = this.options.getBooleanObj(name);
        if (optionVal == null) {
            return defaultValue;
        }
        return optionVal;
    }

    public boolean getForceNonCoveringSort() {
        return this.getOption("ojai.mapr.query.force-noncovering-sort", false);
    }

    public boolean getForceDrill() {
        return this.getOption("ojai.mapr.query.force-drill", false);
    }

    public boolean getForceDirect() {
        return this.getOption("ojai.mapr.query.force-direct", false);
    }

    long getTimeout() {
        return this.timeout;
    }

    public OjaiQuery setTimeout(long timeoutInMilliseconds) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((timeoutInMilliseconds > 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
        this.timeout = timeoutInMilliseconds;
        return this;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public boolean isSortLimit() {
        return this.isSortLimit;
    }

    private void readRowCpuIoRatio() {
        this.rowCpuIoRatio = ROW_CPU_IO_RATIO;
        if (this.options != null) {
            Value optionVal = this.options.getValue(ROW_CPU_IO_RATIO_NAME);
            if (optionVal != null) {
                switch (optionVal.getType()) {
                    case INT: {
                        this.rowCpuIoRatio = optionVal.getInt();
                        break;
                    }
                    case LONG: {
                        this.rowCpuIoRatio = optionVal.getLong();
                        break;
                    }
                    case SHORT: {
                        this.rowCpuIoRatio = optionVal.getShort();
                        break;
                    }
                    case FLOAT: {
                        this.rowCpuIoRatio = optionVal.getFloat();
                        break;
                    }
                    case DOUBLE: {
                        this.rowCpuIoRatio = optionVal.getDouble();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("ojai.mapr.query.row-time-to-io-ratio must be a type that can fit in a double");
                    }
                }
            }
            if (this.rowCpuIoRatio <= 0.0) {
                throw new IllegalArgumentException("ojai.mapr.query.row-time-to-io-ratio must be a positive number");
            }
        }
    }

    public OjaiQuery build() {
        this.checkNotBuilt();
        if (!this.condition.isBuilt()) {
            this.condition.build();
        }
        QueryAnalyzer queryAnalyzer = this.getQueryAnalyzer();
        queryAnalyzer.build();
        this.includeId = this.isStarQuery || this.projectedFieldSet.size() == 0 || this.projectedFieldSet.contains(DocumentConstants.ID_FIELD);
        this.isSortLimit = this.limit != -1L && this.offset + this.limit <= (long)MAX_CLIENT_SORT_LIMIT && this.sortKeys != null && this.sortKeys.size() > 0;
        this.readRowCpuIoRatio();
        this.elementGroups = new ElementGroups(queryAnalyzer.getExpressionTree());
        this.built = true;
        return this;
    }

    private void checkNotBuilt() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"The OJAI Query is already built!");
    }

    public boolean includeId() {
        return this.includeId;
    }

    public boolean hasOrderBy() {
        return this.sortKeys != null && this.sortKeys.size() > 0;
    }

    public Set<FieldPath> getOrderByFields() {
        HashSet fields = Sets.newHashSet();
        if (this.hasOrderBy()) {
            for (SortKey sortKey : this.sortKeys) {
                fields.add(sortKey.fieldPath);
            }
        }
        return fields;
    }

    public IndexFieldDesc.Order getFieldOrdering(FieldPath fieldPath) {
        if (this.sortKeys == null) {
            return IndexFieldDesc.Order.None;
        }
        for (SortKey sortKey : this.sortKeys) {
            if (!sortKey.fieldPath.equals((Object)fieldPath)) continue;
            return sortKey.order;
        }
        return IndexFieldDesc.Order.None;
    }

    public boolean hasProjectionWithArrayIndex() {
        return this.hasProjectionWithArrayIndex;
    }

    private static Document copy(Document doc) {
        Preconditions.checkNotNull((Object)doc);
        DBDocumentBuilder docBuilder = new DBDocumentBuilder();
        Documents.writeReaderToBuilder((DocumentReader)doc.asReader(), (DocumentBuilder)docBuilder);
        Document newDoc = docBuilder.getDocument();
        return newDoc;
    }

    OjaiQuery() {
    }

    public OjaiQuery(Query theQuery) {
        Preconditions.checkArgument((boolean)(theQuery instanceof OjaiQuery));
        OjaiQuery query = (OjaiQuery)theQuery;
        this.built = query.built;
        this.commitContext = query.commitContext;
        this.condition = query.condition.cloneUnbuilt(Boolean.valueOf(true));
        if (query.condition.isBuilt()) {
            this.condition.build();
        }
        this.hasProjectionWithArrayIndex = query.hasProjectionWithArrayIndex;
        this.includeId = query.includeId;
        this.isSortLimit = query.isSortLimit;
        this.isStarQuery = query.isStarQuery;
        this.limit = query.limit;
        this.offset = query.offset;
        this.options = query.options == null ? null : OjaiQuery.copy(query.options);
        this.possiblyNeedProjection = query.possiblyNeedProjection;
        this.projectedFieldSet.addAll(query.projectedFieldSet);
        this.queryAnalyzer = query.queryAnalyzer;
        this.rowCpuIoRatio = query.rowCpuIoRatio;
        this.sortKeys = query.sortKeys == null ? null : new LinkedList<SortKey>(query.sortKeys);
        this.timeout = query.timeout;
    }

    public String toString() {
        CommaSeparated queryArgs = new CommaSeparated("OjaiQuery(", ")");
        if (this.projectedFieldSet != null && this.projectedFieldSet.size() > 0) {
            CommaSeparated selectList = new CommaSeparated("select = {", "}");
            for (FieldPath fieldPath : this.projectedFieldSet) {
                selectList.append(fieldPath.toString());
            }
            queryArgs.append(selectList.build());
        }
        if (this.condition != null) {
            queryArgs.append("condition = " + this.condition);
        }
        if (this.sortKeys != null && this.sortKeys.size() > 0) {
            CommaSeparated orderBy = new CommaSeparated("orderBy = {", "}");
            for (SortKey sortKey : this.sortKeys) {
                orderBy.append(sortKey.fieldString + "/" + sortKey.sortOrder);
            }
            queryArgs.append(orderBy.build());
        }
        if (this.limit != -1L) {
            queryArgs.append("limit = " + this.limit);
        }
        if (this.offset != 0L) {
            queryArgs.append("offset = " + this.offset);
        }
        if (this.options != null && this.options.size() > 0) {
            queryArgs.append("options = " + this.options.toString());
        }
        return queryArgs.build();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OjaiQuery)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        OjaiQuery other = (OjaiQuery)o;
        if (this.projectedFieldSet != null ? other.projectedFieldSet == null || !this.projectedFieldSet.equals(other.projectedFieldSet) : other.projectedFieldSet != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals((Object)other.condition) : other.condition != null) {
            return false;
        }
        if (this.sortKeys != null ? other.sortKeys == null || !this.sortKeys.equals(other.sortKeys) : other.sortKeys != null) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.options != null ? !Documents.equals((Document)this.options, (Document)other.options) : other.options != null);
    }

    public boolean isArrayQuery() {
        return this.condition.isArrayQuery();
    }

    boolean hasMultiLevelArrayCondtition() {
        return this.condition.hasMultiLevelArray();
    }

    public ConditionNode getRoot() {
        return this.condition.getRoot();
    }

    public String asJsonString() {
        SeparatorWriter itemSeparator;
        StringBuilder sb = new StringBuilder("{");
        SeparatorWriter sw = new SeparatorWriter(sb, COMMA_SPACE);
        String cond = this.condition.asJsonString();
        if (!cond.equals(EMPTY_COND)) {
            sw.writeSeparator();
            sb.append("\"$where\":");
            sb.append(cond);
            sw.needSeparator();
        }
        if (this.projectedFieldSet != null && !this.projectedFieldSet.isEmpty()) {
            sw.writeSeparator();
            sb.append("\"$select\":[");
            itemSeparator = new SeparatorWriter(sb, COMMA_SPACE);
            for (FieldPath fieldPath : this.projectedFieldSet) {
                itemSeparator.writeSeparator();
                sb.append('\"');
                sb.append(fieldPath.toString());
                sb.append('\"');
                itemSeparator.needSeparator();
            }
            sb.append(']');
            sw.needSeparator();
        }
        if (this.sortKeys != null && !this.sortKeys.isEmpty()) {
            sw.writeSeparator();
            sb.append("\"$orderby\":[");
            itemSeparator = new SeparatorWriter(sb, COMMA_SPACE);
            for (SortKey sortKey : this.sortKeys) {
                itemSeparator.writeSeparator();
                sb.append("{\"");
                sb.append(sortKey.fieldPath.toString());
                sb.append("\":\"");
                sb.append(sortKey.sortOrder.name());
                sb.append("\"}");
                itemSeparator.needSeparator();
            }
            sb.append(']');
            sw.needSeparator();
        }
        if (this.offset != 0L) {
            sw.writeSeparator();
            sb.append("\"$offset\":");
            sb.append(this.offset);
            sw.needSeparator();
        }
        if (this.limit != -1L) {
            sw.writeSeparator();
            sb.append("\"$limit\":");
            sb.append(this.limit);
            sw.needSeparator();
        }
        if (this.timeout != -1L) {
            sw.writeSeparator();
            sb.append("\"$timeout\":");
            sb.append(this.timeout);
            sw.needSeparator();
        }
        if (this.options != null) {
            sw.writeSeparator();
            sb.append("\"$options\":");
            sb.append(this.options.asJsonString());
            sw.needSeparator();
        }
        sb.append('}');
        return sb.toString();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        OP_TO_NAME = builder.put((Object)QueryCondition.Op.EQUAL, (Object)"=").put((Object)QueryCondition.Op.GREATER, (Object)">").put((Object)QueryCondition.Op.GREATER_OR_EQUAL, (Object)">=").put((Object)QueryCondition.Op.LESS, (Object)"<").put((Object)QueryCondition.Op.LESS_OR_EQUAL, (Object)"<=").put((Object)QueryCondition.Op.NOT_EQUAL, (Object)"<>").build();
        EQUIVALENCE = new QueryEquivalence();
        DRILL_OPTIONS_PREFIX = "ojai.mapr.drill.".substring(0, "ojai.mapr.drill.".length() - 1);
    }

    private static class MutableBoolean {
        boolean value;

        public MutableBoolean(boolean value) {
            this.value = value;
        }
    }

    private static class DrillOption {
        final String name;
        final Object value;

        DrillOption(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

