/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import org.ojai.annotation.API;
import org.ojai.exceptions.OjaiException;

@API.Internal
@API.NotThreadSafe
public class SharedResource<T extends AutoCloseable> {
    private int refCount;
    private final T resource;

    public SharedResource(T resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0);
        this.resource = resource;
        this.refCount = 1;
    }

    public synchronized void addRef() {
        Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0);
        ++this.refCount;
    }

    public synchronized void release() {
        Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0);
        if (--this.refCount == 0) {
            try {
                this.preCloseAction(this.resource);
                this.resource.close();
            }
            catch (Exception ex) {
                throw new OjaiException((Throwable)ex);
            }
        }
    }

    protected void preCloseAction(T resource) {
    }

    public T get() {
        Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0);
        return this.resource;
    }
}

