/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MultiGet;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.IdBufferIterator;
import com.mapr.ojai.store.impl.IdByteBufferStream;
import com.mapr.ojai.store.impl.LongValue;
import com.mapr.ojai.store.impl.SharedTable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;

public class RowkeyLookup
extends AbstractDocumentFilter {
    private final MultiGet multiGet;
    private static final String MAX_BATCH_SIZE_NAME = "ojai.mapr.driver.rowkey_lookup.max_batch_size";
    private static final String MAX_BATCH_SIZE_DEFAULT = "500";
    public static final int MAX_BATCH_SIZE = Integer.parseInt(System.getProperty("ojai.mapr.driver.rowkey_lookup.max_batch_size", "500"));
    private static final LongValue MAX_BATCH_SIZE_VALUE = new LongValue(){

        @Override
        public long getLongValue() {
            return MAX_BATCH_SIZE;
        }
    };
    private LongValue desiredRows = MAX_BATCH_SIZE_VALUE;
    private final Iterator<ByteBuffer> idIter;
    private final ByteBuffer[] batchId = new ByteBuffer[MAX_BATCH_SIZE];
    private int batchSize = 0;
    private List<Document> resultList = Collections.emptyList();
    private int resultIdx = MAX_BATCH_SIZE;
    private final SharedTable sharedTable;
    private final String priTablePath;
    private final QueryCondition condition;
    private final FieldPath[] projList;
    private long requestedRows;
    private long gotRows;

    public RowkeyLookup(DocumentStream upstreamStream, SharedTable sharedTable, QueryCondition queryCond, FieldPath ... fieldPaths) {
        super(upstreamStream);
        String[] fieldStrings;
        this.sharedTable = sharedTable;
        sharedTable.addRef();
        if (fieldPaths == null) {
            fieldStrings = null;
        } else {
            fieldStrings = new String[fieldPaths.length];
            int nextIdx = 0;
            for (FieldPath fieldPath : fieldPaths) {
                fieldStrings[nextIdx] = fieldPath.toString();
                ++nextIdx;
            }
        }
        BaseJsonTable jsonTable = (BaseJsonTable)sharedTable.get();
        this.priTablePath = jsonTable.getPath().toString();
        this.condition = queryCond;
        this.projList = fieldPaths;
        this.multiGet = new MultiGet(jsonTable, queryCond, jsonTable.isExcludeId(), fieldStrings);
        if (upstreamStream instanceof IdByteBufferStream) {
            IdByteBufferStream stream = (IdByteBufferStream)upstreamStream;
            this.idIter = stream.idBufferIterator();
        } else {
            this.idIter = new IdBufferIterator(super.iterator());
        }
    }

    private int getBatchSize(int attempt) {
        long lBatchSize = this.desiredRows.getLongValue();
        if (lBatchSize > (long)MAX_BATCH_SIZE) {
            return MAX_BATCH_SIZE;
        }
        if (this.gotRows > 0L) {
            double selectivity = (double)this.gotRows / (double)this.requestedRows;
            lBatchSize = (long)Math.ceil((double)lBatchSize / selectivity);
        } else {
            lBatchSize *= (long)attempt;
        }
        if (lBatchSize > (long)MAX_BATCH_SIZE) {
            return MAX_BATCH_SIZE;
        }
        return (int)lBatchSize;
    }

    private boolean hasNext() {
        int resultSize;
        if (this.resultIdx < this.resultList.size()) {
            return true;
        }
        int attempt = 0;
        do {
            int thisBatchMax = this.getBatchSize(++attempt);
            this.batchSize = 0;
            while (this.batchSize < thisBatchMax && this.idIter.hasNext()) {
                ByteBuffer idBuffer;
                this.batchId[this.batchSize] = idBuffer = this.idIter.next();
                ++this.batchSize;
            }
            if (this.batchSize == 0) {
                return false;
            }
            this.requestedRows += (long)this.batchSize;
            this.resultList = this.multiGet.doGet(this.batchId, this.batchSize);
            this.resultIdx = 0;
            resultSize = this.resultList.size();
            this.gotRows += (long)resultSize;
        } while (resultSize == 0);
        return true;
    }

    private Document next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.resultList.get(this.resultIdx++);
    }

    @Override
    public Iterator<Document> iterator() {
        this.checkState();
        return new ResultIterator();
    }

    @Override
    protected void closeDerived() {
        this.sharedTable.release();
        super.closeDerived();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("primaryTable", this.priTablePath);
        if (this.projList != null) {
            ArrayList<String> projectionList = new ArrayList<String>();
            for (FieldPath fp : this.projList) {
                projectionList.add(fp.toString());
            }
            valueMap.put("projection", projectionList);
        }
        if (this.condition != null) {
            valueMap.put("condition", this.condition.toString());
        }
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    @Override
    public void setDesiredRows(LongValue longValue) {
        Preconditions.checkNotNull((Object)longValue);
        this.desiredRows = longValue;
    }

    private class ResultIterator
    implements Iterator<Document> {
        private ResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return RowkeyLookup.this.hasNext();
        }

        @Override
        public Document next() {
            return RowkeyLookup.this.next();
        }
    }
}

