/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.IdCodec;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.ojai.Document;
import org.ojai.Value;

class IdBufferIterator
implements Iterator<ByteBuffer> {
    private final Iterator<Document> idDocIter;

    public IdBufferIterator(Iterator<Document> idDocIter) {
        this.idDocIter = idDocIter;
    }

    @Override
    public boolean hasNext() {
        return this.idDocIter.hasNext();
    }

    @Override
    public ByteBuffer next() {
        ByteBuffer idBuffer;
        Document doc = this.idDocIter.next();
        Value idValue = doc.getId();
        Value.Type idType = idValue.getType();
        switch (idType) {
            case BINARY: {
                idBuffer = idValue.getBinary();
                break;
            }
            case STRING: {
                String idString = idValue.getString();
                idBuffer = IdCodec.encode((String)idString);
                break;
            }
            default: {
                throw new IllegalStateException("_id values can only be of type BINARY or STRING");
            }
        }
        return idBuffer;
    }
}

