/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.ojai.store.impl.ElementOperator;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.RelationalOperator;
import com.mapr.ojai.store.impl.UnaryOperator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.QueryCondition;

public class ExpressionToCondition
extends ExpressionVisitor {
    private final OjaiDriver ojaiDriver;
    private QueryCondition queryCond;
    private static final QueryCondition EMPTY_CONDITION = MapRDBImpl.newCondition().build();
    static final Map<String, QueryCondition.Op> QUERY_CONDITIONS;

    public static QueryCondition convert(Expression expr, OjaiDriver ojaiDriver) {
        if (expr == null) {
            return EMPTY_CONDITION;
        }
        ExpressionToCondition etoc = new ExpressionToCondition(ojaiDriver);
        expr.visit(etoc);
        return etoc.queryCond;
    }

    private ExpressionToCondition(OjaiDriver ojaiDriver) {
        this.ojaiDriver = ojaiDriver;
    }

    @Override
    public void visitField(FieldExpression fieldExpr) {
        throw new IllegalStateException();
    }

    @Override
    public void visitLiteral(LiteralExpression literalExpr) {
        if (literalExpr.getType() != Value.Type.BOOLEAN) {
            throw new IllegalStateException("can't handle " + literalExpr.getType());
        }
        boolean b = literalExpr.getBoolean();
        this.addToCondTree(b ? ConditionImpl.QUERY_COND_TRUE : ConditionImpl.QUERY_COND_FALSE);
    }

    private void addToCondTree(QueryCondition newCond) {
        this.queryCond = this.queryCond == null ? newCond : this.ojaiDriver.newCondition().and().condition(this.queryCond).condition(newCond).close().build();
    }

    @Override
    public void visitNary(NaryOperator naryOp) {
        QueryCondition newCond = this.ojaiDriver.newCondition();
        String opName = naryOp.opName;
        if (opName.equals("and")) {
            newCond = newCond.and();
        } else if (opName.equals("or")) {
            newCond = newCond.or();
        } else if (opName.equals("elementAnd")) {
            newCond = newCond.elementAnd(((ElementOperator)naryOp).getPrefix());
        } else if (opName.equals("equals") || opName.equals("nequals") || opName.equals("matches") || opName.equals("notMatches")) {
            if (naryOp.arg.length > 2) {
                throw new IllegalArgumentException(opName + " takes two arguments");
            }
            if (!(naryOp.arg[0] instanceof FieldExpression)) {
                throw new IllegalArgumentException("The first argument to " + opName + " must be a field reference");
            }
            FieldPath fieldPath = ((FieldExpression)naryOp.arg[0]).getFieldPath();
            if (!(naryOp.arg[1] instanceof LiteralExpression)) {
                throw new IllegalArgumentException("The second argument to " + opName + " must be a literal");
            }
            LiteralExpression litExpr = (LiteralExpression)naryOp.arg[1];
            if (opName.equals("equals")) {
                Value.Type type = litExpr.getType();
                switch (type) {
                    case ARRAY: {
                        newCond = newCond.equals(fieldPath, litExpr.getList());
                        break;
                    }
                    case MAP: {
                        newCond = newCond.equals(fieldPath, litExpr.getMap());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unhandled type " + type);
                    }
                }
            } else if (opName.equals("nequals")) {
                Value.Type type = litExpr.getType();
                switch (type) {
                    case ARRAY: {
                        newCond = newCond.notEquals(fieldPath, litExpr.getList());
                        break;
                    }
                    case MAP: {
                        newCond = newCond.notEquals(fieldPath, litExpr.getMap());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unhandled type " + type);
                    }
                }
            } else {
                String regex = litExpr.getString();
                newCond = opName.equals("matches") ? newCond.matches(fieldPath, regex) : newCond.notMatches(fieldPath, regex);
            }
            this.addToCondTree(newCond.build());
            return;
        }
        int skipCount = -1;
        for (Expression arg : naryOp.arg) {
            QueryCondition argCond;
            if (++skipCount < naryOp.skipVisitArgs || ((ConditionImpl)(argCond = ExpressionToCondition.convert(arg, this.ojaiDriver))).isEmpty()) continue;
            newCond = newCond.condition(argCond);
        }
        newCond = newCond.close().build();
        this.addToCondTree(newCond);
    }

    @Override
    public void visitRelational(RelationalOperator relOp) {
        FieldPath fieldPath = relOp.getLeftField();
        QueryCondition.Op op = QUERY_CONDITIONS.get(relOp.opName);
        LiteralExpression literal = relOp.getRightLiteral();
        QueryCondition newCond = this.ojaiDriver.newCondition();
        if (relOp.arg[0] instanceof UnaryOperator) {
            UnaryOperator unOp = (UnaryOperator)relOp.arg[0];
            switch (unOp.opName) {
                case "typeOf": {
                    Value.Type typeValue = Value.Type.valueOf((int)literal.getInt());
                    if (op == QueryCondition.Op.EQUAL) {
                        newCond.typeOf(fieldPath, typeValue);
                        break;
                    }
                    if (op == QueryCondition.Op.NOT_EQUAL) {
                        newCond.notTypeOf(fieldPath, typeValue);
                        break;
                    }
                    throw new IllegalStateException();
                }
                case "sizeOf": {
                    if (literal.getType() != Value.Type.INT) {
                        throw new IllegalStateException();
                    }
                    newCond.sizeOf(fieldPath, op, (long)literal.getInt());
                    break;
                }
                default: {
                    throw new IllegalStateException("unary operator " + unOp.opName);
                }
            }
        } else {
            switch (literal.getType()) {
                case ARRAY: {
                    if (op != QueryCondition.Op.EQUAL) {
                        throw new IllegalStateException("arrays can only be equal");
                    }
                    newCond = newCond.equals(fieldPath, literal.getList());
                    break;
                }
                case BINARY: {
                    newCond = newCond.is(fieldPath, op, literal.getBinary());
                    break;
                }
                case BOOLEAN: {
                    newCond = newCond.is(fieldPath, op, literal.getBoolean());
                    break;
                }
                case BYTE: {
                    newCond = newCond.is(fieldPath, op, literal.getByte());
                    break;
                }
                case DATE: {
                    newCond = newCond.is(fieldPath, op, literal.getDate());
                    break;
                }
                case DECIMAL: {
                    throw new IllegalStateException("unimplemented");
                }
                case DOUBLE: {
                    newCond = newCond.is(fieldPath, op, literal.getDouble());
                    break;
                }
                case FLOAT: {
                    newCond = newCond.is(fieldPath, op, literal.getFloat());
                    break;
                }
                case INT: {
                    newCond = newCond.is(fieldPath, op, literal.getInt());
                    break;
                }
                case INTERVAL: {
                    newCond = newCond.is(fieldPath, op, literal.getInterval());
                    break;
                }
                case LONG: {
                    newCond = newCond.is(fieldPath, op, literal.getLong());
                    break;
                }
                case MAP: {
                    throw new IllegalStateException("unimplemented");
                }
                case NULL: {
                    if (op.equals((Object)QueryCondition.Op.EQUAL)) {
                        newCond = newCond.notExists(fieldPath);
                        break;
                    }
                    newCond = newCond.exists(fieldPath);
                    break;
                }
                case SHORT: {
                    newCond = newCond.is(fieldPath, op, literal.getShort());
                    break;
                }
                case STRING: {
                    newCond = newCond.is(fieldPath, op, literal.getString());
                    break;
                }
                case TIME: {
                    newCond = newCond.is(fieldPath, op, literal.getTime());
                    break;
                }
                case TIMESTAMP: {
                    newCond = newCond.is(fieldPath, op, literal.getTimestamp());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switch case " + literal.getType());
                }
            }
        }
        newCond = newCond.build();
        this.addToCondTree(newCond);
    }

    @Override
    public void visitUnary(UnaryOperator unaryOp) {
        throw new IllegalStateException("unknown operator " + unaryOp.opName);
    }

    static {
        HashMap<String, QueryCondition.Op> relopInverse = new HashMap<String, QueryCondition.Op>(6);
        relopInverse.put("=", QueryCondition.Op.EQUAL);
        relopInverse.put("<>", QueryCondition.Op.NOT_EQUAL);
        relopInverse.put("<", QueryCondition.Op.LESS);
        relopInverse.put("<=", QueryCondition.Op.LESS_OR_EQUAL);
        relopInverse.put(">", QueryCondition.Op.GREATER);
        relopInverse.put(">=", QueryCondition.Op.GREATER_OR_EQUAL);
        QUERY_CONDITIONS = Collections.unmodifiableMap(relopInverse);
    }
}

