/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;

public class DelayDocumentFilter
extends AbstractDocumentFilter {
    private final int delayMs;

    public DelayDocumentFilter(DocumentStream upstreamStream, int delayMs) {
        super(upstreamStream);
        this.delayMs = delayMs;
    }

    public Iterator<Document> iterator() {
        try {
            Thread.sleep(this.delayMs);
        }
        catch (InterruptedException iex) {
            throw new OjaiException((Throwable)iex);
        }
        return super.iterator();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", ((Object)((Object)this)).getClass().getSimpleName());
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
        valueMap.put("delayMs", this.delayMs);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

