/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.QueryStrategy;
import com.mapr.ojai.store.impl.doublylinked.DoublyLinked;
import com.mapr.ojai.store.impl.doublylinked.DoublyLinkedList;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class QueryStrategyCache {
    private final int sizeLimit;
    private int size;
    private final WeakHashMap<Equivalence.Wrapper<OjaiQuery>, LoadedQuery> cacheMap;
    private final DoublyLinkedList<LoadedQuery> cacheList = new DoublyLinkedList();
    private final StrategyLoader itemManager;

    public QueryStrategyCache(int sizeLimit, StrategyLoader itemManager) {
        this.sizeLimit = sizeLimit;
        this.itemManager = itemManager;
        this.cacheMap = new WeakHashMap(sizeLimit);
    }

    private void addToCacheList(LoadedQuery loadedQuery) {
        loadedQuery.cacheKeepalive = (Equivalence.Wrapper)loadedQuery.keyQuery.get();
        this.cacheList.addFirst(loadedQuery);
        if (this.size < this.sizeLimit) {
            ++this.size;
        } else {
            LoadedQuery lastLoaded = this.cacheList.getLast();
            lastLoaded.cacheKeepalive = null;
            lastLoaded.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapping get(OjaiQuery query) {
        QueryStrategy queryStrategy;
        LoadedQuery loadedQuery;
        Lock wlock = null;
        WeakHashMap<Equivalence.Wrapper<OjaiQuery>, LoadedQuery> weakHashMap = this.cacheMap;
        synchronized (weakHashMap) {
            loadedQuery = this.cacheMap.get(query);
            if (loadedQuery != null) {
                Equivalence.Wrapper originalWrapper = (Equivalence.Wrapper)loadedQuery.keyQuery.get();
                if (originalWrapper == null) {
                    Equivalence.Wrapper newWrapper = OjaiQuery.EQUIVALENCE.wrap((Object)query);
                    loadedQuery.keyQuery = new WeakReference<Equivalence.Wrapper>(newWrapper);
                    this.cacheMap.put((Equivalence.Wrapper<OjaiQuery>)newWrapper, loadedQuery);
                }
                if (loadedQuery.isOnList()) {
                    LoadedQuery previousLoaded = loadedQuery.getPrevious(this.cacheList);
                    if (previousLoaded != null) {
                        loadedQuery.removeUnsafe();
                        loadedQuery.addBefore(previousLoaded);
                    }
                } else {
                    this.addToCacheList(loadedQuery);
                }
                return new Mapping(loadedQuery);
            }
            Equivalence.Wrapper queryWrapper = OjaiQuery.EQUIVALENCE.wrap((Object)query);
            loadedQuery = new LoadedQuery((Equivalence.Wrapper<OjaiQuery>)queryWrapper);
            this.cacheMap.put((Equivalence.Wrapper<OjaiQuery>)queryWrapper, loadedQuery);
            this.addToCacheList(loadedQuery);
            wlock = loadedQuery.rwlock.writeLock();
            wlock.lock();
        }
        try {
            queryStrategy = this.itemManager.load(query);
        }
        catch (Exception ex) {
            queryStrategy = null;
            loadedQuery.ex = ex;
        }
        loadedQuery.queryStrategy = queryStrategy;
        wlock.unlock();
        return new Mapping(loadedQuery);
    }

    @VisibleForTesting
    public Set<OjaiQuery> getCached() {
        HashSet<OjaiQuery> querySet = new HashSet<OjaiQuery>();
        Set<Map.Entry<Equivalence.Wrapper<OjaiQuery>, LoadedQuery>> entrySet = this.cacheMap.entrySet();
        for (Map.Entry<Equivalence.Wrapper<OjaiQuery>, LoadedQuery> mapEntry : entrySet) {
            OjaiQuery ojaiQuery = (OjaiQuery)mapEntry.getKey().get();
            LoadedQuery loadedQuery = mapEntry.getValue();
            if (!loadedQuery.isOnList()) continue;
            querySet.add(ojaiQuery);
        }
        return querySet;
    }

    public static class Mapping
    implements AutoCloseable {
        private final LoadedQuery loadedQuery;
        private Equivalence.Wrapper<OjaiQuery> inUseKeepalive;
        private Lock lock;

        public Mapping(LoadedQuery loadedQuery) {
            this.loadedQuery = loadedQuery;
            this.inUseKeepalive = (Equivalence.Wrapper)loadedQuery.keyQuery.get();
        }

        @Override
        public void close() throws Exception {
            if (this.lock != null) {
                this.lock.unlock();
                this.lock = null;
            }
            this.inUseKeepalive = null;
        }

        public QueryStrategy getStrategy() throws Exception {
            if (this.lock == null) {
                this.lock = this.loadedQuery.rwlock.readLock();
                this.lock.lock();
            }
            if (this.loadedQuery.ex != null) {
                this.lock.unlock();
                this.lock = null;
                throw this.loadedQuery.ex;
            }
            return this.loadedQuery.queryStrategy;
        }
    }

    private static class LoadedQuery
    extends DoublyLinked<LoadedQuery> {
        private WeakReference<Equivalence.Wrapper<OjaiQuery>> keyQuery;
        private volatile Equivalence.Wrapper<OjaiQuery> cacheKeepalive;
        private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
        private QueryStrategy queryStrategy;
        private Exception ex;

        public LoadedQuery(Equivalence.Wrapper<OjaiQuery> queryWrapper) {
            this.keyQuery = new WeakReference<Equivalence.Wrapper<OjaiQuery>>(queryWrapper);
        }
    }

    public static interface StrategyLoader {
        public QueryStrategy load(OjaiQuery var1);
    }
}

