/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.ojai.store.impl.OjaiConnection;
import org.apache.drill.exec.rpc.user.clusterclient.DrillSession;
import org.ojai.exceptions.OjaiException;

public class SharedDrillSession
implements AutoCloseable {
    private DrillSession drillSession;
    private int refCount;
    private final OjaiConnection ojaiConnection;
    private final String clusterName;
    private boolean isClosed;

    public SharedDrillSession(OjaiConnection ojaiConnection, String clusterName) {
        this.ojaiConnection = ojaiConnection;
        this.clusterName = clusterName != null ? clusterName : ojaiConnection.getDefaultClusterName();
    }

    public synchronized void addRef() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0);
        ++this.refCount;
    }

    public synchronized DrillSession getSession() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0);
        Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0);
        if (this.drillSession == null) {
            this.drillSession = this.ojaiConnection.getDrillSession(this.clusterName);
        }
        return this.drillSession;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0);
        if (--this.refCount == 0) {
            this.isClosed = true;
            if (this.drillSession != null) {
                this.ojaiConnection.getExecutorService().execute(new SessionCloser(this.drillSession));
            }
            this.drillSession = null;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private static class SessionCloser
    implements Runnable {
        private final DrillSession drillSession;

        public SessionCloser(DrillSession drillSession) {
            this.drillSession = drillSession;
        }

        @Override
        public void run() {
            try {
                this.drillSession.close();
            }
            catch (Exception e) {
                throw new OjaiException((Throwable)e);
            }
        }
    }
}

