/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.DocumentStreamFactory;
import com.mapr.ojai.store.impl.QueryDocumentStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.DocumentStream;

public class UnionDocumentStream
extends QueryDocumentStream {
    private DocumentStream currentStream;
    private final DocumentStreamFactory streamFactory;

    public UnionDocumentStream(DocumentStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public Iterator<Document> iterator() {
        return new UnionIterator();
    }

    @Override
    protected void cancelQuery() {
        if (this.currentStream != null) {
            this.currentStream.close();
        }
    }

    @Override
    public String getIndexUsed() {
        return null;
    }

    @Override
    public void getQueryPlan(List<Map<String, Object>> planList) {
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", UnionDocumentStream.class.getSimpleName());
        HashMap<String, String> valueMap = new HashMap<String, String>();
        myMap.put("parameters", valueMap);
        valueMap.put("streamFactoryClass", this.streamFactory.getClass().getName());
        planList.add(myMap);
    }

    private class UnionIterator
    implements Iterator<Document> {
        private Iterator<Document> currentIter;
        private Document nextDoc;

        public UnionIterator() {
            UnionDocumentStream.this.currentStream = UnionDocumentStream.this.streamFactory.create();
            if (UnionDocumentStream.this.currentStream != null) {
                this.currentIter = UnionDocumentStream.this.currentStream.iterator();
            }
        }

        private void advanceToNext() {
            while (this.currentIter != null && !this.currentIter.hasNext()) {
                if (UnionDocumentStream.this.currentStream != null) {
                    UnionDocumentStream.this.currentStream.close();
                }
                UnionDocumentStream.this.currentStream = UnionDocumentStream.this.streamFactory.create();
                if (UnionDocumentStream.this.currentStream == null) {
                    this.currentIter = null;
                    return;
                }
                this.currentIter = UnionDocumentStream.this.currentStream.iterator();
            }
            if (this.currentIter == null) {
                return;
            }
            this.nextDoc = this.currentIter.next();
        }

        @Override
        public boolean hasNext() {
            if (this.nextDoc == null) {
                this.advanceToNext();
            }
            return this.nextDoc != null;
        }

        @Override
        public Document next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Document returnDocument = this.nextDoc;
            this.nextDoc = null;
            return returnDocument;
        }
    }
}

