/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.ConditionNode;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.PredicateManager;
import java.util.ArrayList;
import java.util.List;
import org.ojai.FieldPath;

public class ElementOperator
extends NaryOperator {
    private final FieldPath prefixPath;

    public ElementOperator(String opName, List<Expression> arg, ConditionNode originalNode) {
        super(opName, true, 1, arg, originalNode);
        if (arg.size() < 2) {
            throw new IllegalArgumentException("elementAnd requires at least two arguments");
        }
        Expression pathExpr = arg.get(0);
        if (!(pathExpr instanceof FieldExpression)) {
            throw new IllegalArgumentException("elementAnd's first argument must be an array FieldPath, was " + pathExpr);
        }
        FieldExpression fieldExpr = (FieldExpression)pathExpr;
        this.prefixPath = fieldExpr.getFieldPath();
    }

    public FieldPath getPrefix() {
        return this.prefixPath;
    }

    @Override
    public void gatherExpressions(int depth, PredicateManager predicateManager) {
        predicateManager.pushPath(this.prefixPath);
        super.gatherExpressions(depth, predicateManager);
        predicateManager.popPath();
    }

    @Override
    public void visit(ExpressionVisitor ev) {
        ev.pushPath(this.prefixPath);
        ev.visitElement(this);
        ev.popPath();
    }

    private ArrayList<Expression> prependPrefixArg(ArrayList<Expression> args) {
        FieldExpression prefixExpr = new FieldExpression(this.prefixPath);
        ArrayList<Expression> newArgs = new ArrayList<Expression>(args.size() + 1);
        newArgs.add(prefixExpr);
        newArgs.addAll(args);
        return newArgs;
    }

    @Override
    public NaryOperator recreateWithNewArgs(ArrayList<Expression> newArgs) {
        return new ElementOperator(this.opName, this.prependPrefixArg(newArgs), this.originalNode);
    }
}

