/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.QueryStrategy;
import com.mapr.ojai.store.impl.QueryStrategyCache;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;

public class TestQueryStrategyCache
extends OjaiTest {
    private final OjaiDriver driver = TestQueryStrategyCache.getDriver();
    private final OjaiQuery QUERY1 = this.makeQuery1(5);
    private final OjaiQuery QUERY2 = this.makeQuery2(17);
    private final OjaiQuery QUERY3 = this.makeQuery3(17);
    private final OjaiQuery QUERY4 = this.makeQuery4(42);
    private final OjaiQuery QUERY5 = this.makeQuery5();
    private final OjaiQuery[] QUERIES = new OjaiQuery[]{this.QUERY1, this.QUERY2, this.QUERY3, this.QUERY4, this.QUERY5};
    private final QueryStrategy STRATEGY1 = new DummyQueryStrategy(this.QUERY1, 1);
    private final QueryStrategy STRATEGY2 = new DummyQueryStrategy(this.QUERY2, 1);
    private final QueryStrategy STRATEGY3 = new DummyQueryStrategy(this.QUERY3, 1);
    private final QueryStrategy STRATEGY4 = new DummyQueryStrategy(this.QUERY4, 1);
    private final QueryStrategy STRATEGY5 = new DummyQueryStrategy(this.QUERY5, 1);
    private final QueryStrategy[] STRATEGIES = new QueryStrategy[]{this.STRATEGY1, this.STRATEGY2, this.STRATEGY3, this.STRATEGY4, this.STRATEGY5};
    private final QueryStrategyCache.StrategyLoader itemManager = new QueryStrategyCache.StrategyLoader(){

        public QueryStrategy load(OjaiQuery query) {
            for (int i = 0; i < TestQueryStrategyCache.this.QUERIES.length; ++i) {
                if (!query.structuralEquals(TestQueryStrategyCache.this.QUERIES[i])) continue;
                return TestQueryStrategyCache.this.STRATEGIES[i];
            }
            return null;
        }
    };

    private OjaiQuery makeQuery1(int v) {
        Query query = this.driver.newQuery().select(new String[]{"foo", "bar"}).where(this.driver.newCondition().is("foo", QueryCondition.Op.EQUAL, v).build()).build();
        return (OjaiQuery)query;
    }

    private OjaiQuery makeQuery2(int v) {
        Query query = this.driver.newQuery().select(new String[]{"foo", "bar"}).where(this.driver.newCondition().is("bar", QueryCondition.Op.EQUAL, v).build()).build();
        return (OjaiQuery)query;
    }

    private OjaiQuery makeQuery3(int v) {
        Query query = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().is("bar", QueryCondition.Op.EQUAL, v).build()).build();
        return (OjaiQuery)query;
    }

    private OjaiQuery makeQuery4(int v) {
        Query query = this.driver.newQuery().select(new String[]{"bar"}).where(this.driver.newCondition().is("foo", QueryCondition.Op.EQUAL, v).build()).build();
        return (OjaiQuery)query;
    }

    private OjaiQuery makeQuery5() {
        Query query = this.driver.newQuery().select(new String[]{"foo", "bar"}).where(this.driver.newCondition().is("baz", QueryCondition.Op.EQUAL, "igloo").build()).build();
        return (OjaiQuery)query;
    }

    @Test
    public void testStructuralMethods() {
        OjaiQuery q1 = this.makeQuery1(95);
        Assert.assertTrue((boolean)q1.structuralEquals(this.QUERY1));
        Assert.assertTrue((boolean)this.QUERY1.structuralEquals(q1));
        Assert.assertEquals((long)q1.structuralHashCode(), (long)this.QUERY1.structuralHashCode());
        OjaiQuery q3 = this.makeQuery3(417);
        Assert.assertTrue((boolean)q3.structuralEquals(this.QUERY3));
        Assert.assertTrue((boolean)this.QUERY3.structuralEquals(q3));
        Assert.assertEquals((long)q3.structuralHashCode(), (long)this.QUERY3.structuralHashCode());
        OjaiQuery q4 = this.makeQuery4(942);
        Assert.assertTrue((boolean)q4.structuralEquals(this.QUERY4));
        Assert.assertTrue((boolean)this.QUERY4.structuralEquals(q4));
        Assert.assertEquals((long)q4.structuralHashCode(), (long)this.QUERY4.structuralHashCode());
        for (int i = 0; i < this.QUERIES.length; ++i) {
            for (int j = i + 1; j < this.QUERIES.length; ++j) {
                Assert.assertFalse((boolean)this.QUERIES[i].structuralEquals(this.QUERIES[j]));
                Assert.assertFalse((boolean)this.QUERIES[j].structuralEquals(this.QUERIES[i]));
            }
        }
    }

    @Test
    public void testCacheLookup() throws Exception {
        int i;
        int CACHE_SIZE = 3;
        Assert.assertTrue((3 < this.QUERIES.length ? 1 : 0) != 0);
        QueryStrategyCache qsc = new QueryStrategyCache(3, this.itemManager);
        for (int i2 = this.QUERIES.length - 1; i2 >= 0; --i2) {
            QueryStrategyCache.Mapping mapping = qsc.get(this.QUERIES[i2]);
            QueryStrategy queryStrategy = mapping.getStrategy();
            Assert.assertTrue((boolean)((DummyQueryStrategy)queryStrategy).isForQuery(this.QUERIES[i2]));
            mapping.close();
        }
        Set cachedQueries = qsc.getCached();
        Assert.assertEquals((long)3L, (long)cachedQueries.size());
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)cachedQueries.contains(this.QUERIES[i]));
        }
        for (i = 3; i < this.QUERIES.length; ++i) {
            Assert.assertFalse((boolean)cachedQueries.contains(this.QUERIES[i]));
        }
    }

    private static class DummyQueryStrategy
    implements QueryStrategy {
        private final OjaiQuery ojaiQuery;
        private final int id;

        public DummyQueryStrategy(OjaiQuery ojaiQuery, int id) {
            this.ojaiQuery = ojaiQuery;
            this.id = id;
        }

        public boolean isForQuery(OjaiQuery ojaiQuery) {
            return this.ojaiQuery.structuralEquals(ojaiQuery);
        }

        public void createPipeline(OjaiQuery query) {
        }
    }
}

