/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.ojai.store.impl.ElementOperator;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.ojai.FieldPath;

public class ElementGroups {
    private final List<Set<String>> groups = new LinkedList<Set<String>>();

    public ElementGroups(Expression expr) {
        if (expr != null) {
            ElementVisitor ev = new ElementVisitor();
            expr.visit(ev);
        }
    }

    public boolean mustCorrelate(FieldPath fieldPath, Set<String> indexedArrayFields) {
        if (this.groups.size() == 0) {
            return false;
        }
        if (indexedArrayFields.size() == 0) {
            return false;
        }
        String fieldPathStr = fieldPath.toString();
        for (Set<String> fieldGroup : this.groups) {
            if (!fieldGroup.contains(fieldPathStr)) continue;
            int nContained = 0;
            for (String indexedArrayField : indexedArrayFields) {
                if (indexedArrayField.equals(fieldPathStr) || !fieldGroup.contains(indexedArrayField)) continue;
                ++nContained;
            }
            if (nContained != 0) continue;
            return false;
        }
        return true;
    }

    private class ElementVisitor
    extends ExpressionVisitor {
        private final Stack<ElementGroup> elemStack = new Stack();
        private Set<String> fieldSet;

        private ElementVisitor() {
        }

        private void push(ElementOperator elemOp) {
            if (this.fieldSet == null) {
                assert (this.elemStack.isEmpty());
                this.fieldSet = new HashSet<String>();
                ElementGroups.this.groups.add(this.fieldSet);
            }
            this.elemStack.push(new ElementGroup(this.fieldSet));
        }

        private void pop() {
            this.elemStack.pop();
            this.fieldSet = this.elemStack.isEmpty() ? null : this.elemStack.peek().fieldSet;
        }

        @Override
        public void visitElement(ElementOperator elemOp) {
            this.push(elemOp);
            super.visitElement(elemOp);
            this.pop();
        }

        @Override
        public void visitField(FieldExpression fieldExpr) {
            if (this.fieldSet != null) {
                FieldPath fullPath = this.getPath(fieldExpr.getFieldPath());
                this.fieldSet.add(fullPath.toString());
            }
        }

        private class ElementGroup {
            final Set<String> fieldSet;

            public ElementGroup(Set<String> fieldSet) {
                this.fieldSet = fieldSet;
            }
        }
    }
}

