/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import com.mapr.utils.IndentingStringBuilder;
import java.util.Stack;

public class PrettyStringBuilder
extends IndentingStringBuilder {
    private final int indentSpaces;
    private final Stack<String> indentStack = new Stack();
    private static final String EMPTY_STRING = "";

    private static String makeIndentString(int nSpaces) {
        StringBuilder indentBuilder = new StringBuilder(nSpaces);
        for (int i = 0; i < nSpaces; ++i) {
            indentBuilder.append(' ');
        }
        return indentBuilder.toString();
    }

    public PrettyStringBuilder(StringBuilder sb, int indentSpaces) {
        super(sb);
        this.indentSpaces = indentSpaces;
        this.indentStack.push(EMPTY_STRING);
    }

    @Override
    public IndentingStringBuilder nextLine() {
        this.sb.append('\n');
        this.sb.append(this.indentStack.peek());
        return this;
    }

    @Override
    public IndentingStringBuilder pushIndent() {
        String newIndentString = PrettyStringBuilder.makeIndentString(this.indentStack.peek().length() + this.indentSpaces);
        this.indentStack.push(newIndentString);
        return this;
    }

    @Override
    public IndentingStringBuilder popIndent() {
        this.indentStack.pop();
        if (this.indentStack.isEmpty()) {
            this.addComment("indentStack became empty");
            this.indentStack.push(EMPTY_STRING);
        }
        return this;
    }

    @Override
    public IndentingStringBuilder addComment(String comment) {
        this.sb.append("/* ");
        this.sb.append(comment);
        this.sb.append(" */");
        return this;
    }
}

