/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import com.google.common.base.Preconditions;
import com.mapr.utils.SeparatorWriter;

public class CommaSeparated {
    private final SeparatorWriter sw;
    private final StringBuilder sb;
    private boolean isBuilt = false;
    private String built;
    private final String endString;
    private static final String SEPARATOR = ", ";

    public CommaSeparated(String startString, String endString) {
        this(new StringBuilder(), startString, endString);
    }

    public CommaSeparated(StringBuilder sb, String startString, String endString) {
        this.sw = new SeparatorWriter(sb, SEPARATOR);
        this.sb = sb;
        sb.append(startString);
        this.endString = endString;
    }

    public CommaSeparated append(char c) {
        Preconditions.checkState((!this.isBuilt ? 1 : 0) != 0);
        this.sw.writeSeparator();
        this.sb.append(c);
        this.sw.needSeparator();
        return this;
    }

    public CommaSeparated append(String s) {
        Preconditions.checkState((!this.isBuilt ? 1 : 0) != 0);
        this.sw.writeSeparator();
        this.sb.append(s);
        this.sw.needSeparator();
        return this;
    }

    public String build() {
        if (!this.isBuilt) {
            this.sb.append(this.endString);
            this.built = this.sb.toString();
            this.isBuilt = true;
        }
        return this.built;
    }

    public String toString() {
        if (this.isBuilt) {
            return this.built;
        }
        return this.sb.toString();
    }
}

