/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.client.examples;

import com.mapr.security.client.ClientSecurity;
import com.mapr.security.client.MapRClientSecurityException;
import com.mapr.security.client.examples.DefaultHostVerifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class MapRClient {
    private static final String EXEC = "exec";
    private static final String EXEC_HELP = "Calls the REST API given in the URL, given the token";
    private static final String GET_TOKEN = "gettoken";
    private static final String GET_TOKEN_HELP = "Performs the MapR challenge-response handshake, and retrieves an \n\t\t\tauthentication token that can be used in REST API authentication requests";
    private static final String DO_CHALLENGE_RESPONSE = "challengeresponse";
    private static final String DO_CHALLENGE_RESPONSE_HELP = "Performs the MapR challenge-response handshake only";
    private static final String AUTHTEST = "authtest";
    private static final String AUTHTEST_HELP = "test authentication as a generic client";
    private static boolean verbose = false;
    private static String clusterName;
    public static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private HttpURLConnection conn;
    private static ClientSecurity cs;

    private MapRClient() {
    }

    public static void getTokenFromResponseMessage(HttpURLConnection conn, URL url, Token token) throws MapRClientSecurityException, IOException {
        if (conn == null) {
            conn = (HttpsURLConnection)url.openConnection();
        }
        String base64EncodedAuthResponse = MapRClient.readResponse(conn);
        System.out.println("Obtained Base-64 encoded response " + base64EncodedAuthResponse);
        cs.validateServerResponseToChallenge(base64EncodedAuthResponse);
        if (token != null) {
            System.out.println("Extracting token from response message");
            MapRClient.extractToken(conn, token);
        }
    }

    private static String readResponse(HttpURLConnection conn) throws IOException, MapRClientSecurityException {
        int status = conn.getResponseCode();
        String authorizationError = conn.getHeaderField("WWW-MAPR-Err-Authenticate");
        if (authorizationError != null) {
            String err = authorizationError.trim();
            throw new MapRClientSecurityException("Exception in server: " + err);
        }
        if (status == 200) {
            String authHeader = null;
            Map<String, List<String>> headers = conn.getHeaderFields();
            List<String> wwwAuthHeaders = headers.get("Authorization");
            if (wwwAuthHeaders == null) {
                throw new MapRClientSecurityException("No header : Authorization is present");
            }
            for (String header : wwwAuthHeaders) {
                if (header == null || !header.trim().startsWith("MAPR-Negotiate")) continue;
                authHeader = header;
            }
            if (authHeader == null) {
                throw new MapRClientSecurityException("Invalid sequence, incorrect header" + wwwAuthHeaders);
            }
            String negotiation = authHeader.trim().substring("MAPR-Negotiate ".length()).trim();
            return negotiation;
        }
        throw new MapRClientSecurityException("Incorrect status" + status);
    }

    private static void extractToken(HttpURLConnection conn, Token token) throws IOException, MapRClientSecurityException {
        int respCode = conn.getResponseCode();
        if (respCode == 200 || respCode == 201 || respCode == 202) {
            Map<String, List<String>> headers = conn.getHeaderFields();
            List<String> cookies = headers.get("Set-Cookie");
            if (cookies != null) {
                for (String cookie : cookies) {
                    if (!cookie.startsWith(AUTH_COOKIE_EQ)) continue;
                    String value = cookie.substring(AUTH_COOKIE_EQ.length());
                    int separator = value.indexOf(";");
                    if (separator > -1) {
                        value = value.substring(0, separator);
                    }
                    if (value.length() <= 0) continue;
                    System.out.println("Found token in response message");
                    token.set(value);
                }
            }
        } else {
            token.set(null);
            throw new MapRClientSecurityException("Authentication failed, status: " + conn.getResponseCode() + ", message: " + conn.getResponseMessage());
        }
    }

    public static void injectToken(HttpURLConnection conn, Token token) {
        Object t = token.token;
        if (t != null) {
            if (!((String)t).startsWith("\"")) {
                t = "\"" + (String)t + "\"";
            }
            conn.addRequestProperty("Cookie", AUTH_COOKIE_EQ + (String)t);
        }
    }

    public boolean isNegotiate() throws IOException {
        Map<String, List<String>> headers;
        List<String> wwwAuthHeaders;
        boolean negotiate = false;
        if (this.conn.getResponseCode() == 401 && (wwwAuthHeaders = (headers = this.conn.getHeaderFields()).get("WWW-Authenticate")) != null) {
            for (String authHeader : wwwAuthHeaders) {
                if (authHeader == null || !authHeader.trim().startsWith("MAPR-Negotiate")) continue;
                return true;
            }
        }
        return negotiate;
    }

    private static void sendChallenge(HttpURLConnection conn, URL url, String authorizationToken) throws IOException, MapRClientSecurityException {
        System.out.println("Sending challenge to server");
        if (conn == null) {
            conn = (HttpsURLConnection)url.openConnection();
        }
        conn.setRequestMethod("OPTIONS");
        conn.setRequestProperty("Authorization", "MAPR-Negotiate " + authorizationToken);
        conn.connect();
    }

    public static void doMaprHandshake(HttpURLConnection conn, URL url, boolean getToken, Token token) throws IOException, MapRClientSecurityException {
        String challengeString = cs.generateChallenge();
        System.out.println("Obtained challenge string " + challengeString);
        MapRClient.sendChallenge(conn, url, challengeString);
        if (getToken) {
            MapRClient.getTokenFromResponseMessage(conn, url, token);
        } else {
            MapRClient.getTokenFromResponseMessage(conn, url, null);
        }
    }

    private static void printGetTokenHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(GET_TOKEN);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -url rest-URL ]");
        System.out.println(builder.toString());
    }

    private static void printDoChallengeResponseHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(DO_CHALLENGE_RESPONSE);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -url rest-URL ]");
        System.out.println(builder.toString());
    }

    private static void printExecHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(EXEC);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -url rest-URL -token auth-token -request GET|POST|PUT|DELETE ]");
        System.out.println(builder.toString());
    }

    private static void printAuthTestHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(AUTHTEST);
        builder.append("\n");
        builder.append("\t");
        builder.append("[ -cluster mapr cluster name ]");
        System.out.println(builder.toString());
    }

    private static void printHelp(String command) {
        if (command.equals(GET_TOKEN)) {
            MapRClient.printGetTokenHelp();
        } else if (command.equals(DO_CHALLENGE_RESPONSE)) {
            MapRClient.printDoChallengeResponseHelp();
        } else if (command.equals(EXEC)) {
            MapRClient.printExecHelp();
        } else if (command.equals(AUTHTEST)) {
            MapRClient.printAuthTestHelp();
        } else {
            MapRClient.printUsage();
        }
    }

    private static String doHandshakeWithToken(String restURL, boolean getToken, boolean verbose) {
        if (!cs.isClusterNameValid()) {
            System.out.println("ERROR: Invalid cluster name " + clusterName);
            return null;
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println("SSL exception: " + e.getMessage());
        }
        DefaultHostVerifier allHostsValid = new DefaultHostVerifier();
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        try {
            URL url = new URL(restURL);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            if (getToken) {
                Token token = new Token();
                MapRClient.doMaprHandshake(connection, url, true, token);
                System.out.println("Obtained token: " + token.toString());
                return token.toString();
            }
            MapRClient.doMaprHandshake(connection, url, false, null);
            return null;
        }
        catch (Exception e) {
            System.out.println("Exception occurred: " + e.getMessage());
            return null;
        }
    }

    private static void execurl(String restURL, String restRequest, String authToken, boolean verbose) {
        if (!cs.isClusterNameValid()) {
            System.out.println("ERROR: Invalid cluster name " + clusterName);
            return;
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println("SSL exception");
            e.printStackTrace();
        }
        DefaultHostVerifier allHostsValid = new DefaultHostVerifier();
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        try {
            String inputLine;
            Token token = new Token();
            token.set(authToken);
            URL url = new URL(restURL);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod(restRequest);
            MapRClient.injectToken(connection, token);
            connection.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            System.out.println(response);
        }
        catch (Exception e) {
            System.out.println("Exception occurred: " + e.getMessage());
        }
    }

    private static void execute(String[] args) throws MapRClientSecurityException {
        String command = args[0];
        boolean clusterNameSpecified = false;
        boolean urlStringSet = false;
        boolean restRequestSet = false;
        String restRequestString = null;
        boolean authTokenSet = false;
        String authTokenString = null;
        String urlString = null;
        verbose = false;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-cluster") && i != args.length - 1) {
                clusterName = args[i + 1];
                clusterNameSpecified = true;
                ++i;
                continue;
            }
            if (args[i].equals("-url") && i != args.length - 1) {
                urlString = args[i + 1];
                urlStringSet = true;
                ++i;
                continue;
            }
            if (args[i].equals("-token") && i != args.length - 1) {
                authTokenString = args[i + 1];
                authTokenSet = true;
                ++i;
                continue;
            }
            if (args[i].equals("-request") && i != args.length - 1) {
                restRequestString = args[i + 1];
                restRequestSet = true;
                ++i;
                continue;
            }
            if (args[i].equals("-v") || args[i].equals("--verbose")) {
                verbose = true;
                continue;
            }
            System.out.println("Invalid option: " + args[i]);
            MapRClient.printHelp(command);
            System.exit(1);
        }
        cs = !clusterNameSpecified ? new ClientSecurity() : new ClientSecurity(clusterName);
        clusterName = cs.getClusterName();
        System.out.println("Using cluster name " + clusterName);
        if (command.equals(AUTHTEST)) {
            System.out.println("Attempting to pick up credentials for cluster " + clusterName);
            System.out.println("Using ticket file at " + cs.getUserTicketAndKeyFileLocation());
            if (!cs.isClusterNameValid()) {
                System.out.println("Invalid cluster name " + clusterName);
                return;
            }
            if (cs.hasValidTicket()) {
                System.out.println("Found a ticket that appears valid.");
            }
            return;
        }
        if (command.equals(DO_CHALLENGE_RESPONSE)) {
            if (verbose) {
                System.out.println("Using ticket file at " + cs.getUserTicketAndKeyFileLocation());
            }
            if (urlStringSet) {
                MapRClient.doHandshakeWithToken(urlString, false, verbose);
            } else {
                MapRClient.printGetTokenHelp();
                System.exit(1);
            }
        } else if (command.equals(GET_TOKEN)) {
            if (verbose) {
                System.out.println("Using ticket file at " + cs.getUserTicketAndKeyFileLocation());
            }
            if (urlStringSet) {
                MapRClient.doHandshakeWithToken(urlString, true, verbose);
            } else {
                MapRClient.printGetTokenHelp();
                System.exit(1);
            }
        } else if (command.equals(EXEC)) {
            if (verbose) {
                System.out.println("Using ticket file at " + cs.getUserTicketAndKeyFileLocation());
            }
            if (urlStringSet && authTokenSet) {
                if (!restRequestSet) {
                    restRequestString = "GET";
                }
                if (verbose) {
                    System.out.println("Using REST request " + restRequestString + " for URL " + urlString);
                }
                MapRClient.execurl(urlString, restRequestString, authTokenString, verbose);
            } else {
                MapRClient.printExecHelp();
                System.exit(1);
            }
        } else {
            MapRClient.printHelp(command);
            System.exit(1);
        }
    }

    private static void printUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append("List of commands: \n");
        builder.append("\n");
        builder.append("  ");
        builder.append("challengeresponse  ");
        builder.append("\t");
        builder.append(DO_CHALLENGE_RESPONSE_HELP);
        builder.append("\n");
        builder.append("  ");
        builder.append("gettoken  ");
        builder.append("\t\t");
        builder.append(GET_TOKEN_HELP);
        builder.append("\n");
        builder.append("  ");
        builder.append("exec  ");
        builder.append("\t\t");
        builder.append(EXEC_HELP);
        builder.append("\n");
        builder.append("  ");
        builder.append("authtest  ");
        builder.append("\t\t");
        builder.append(AUTHTEST_HELP);
        System.out.println(builder.toString());
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            MapRClient.printUsage();
            return;
        }
        try {
            MapRClient.execute(args);
        }
        catch (MapRClientSecurityException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static class Token {
        private String token;

        public Token() {
        }

        public Token(String tokenStr) {
            if (tokenStr == null) {
                throw new IllegalArgumentException("tokenStr cannot be null");
            }
            this.set(tokenStr);
        }

        public boolean isSet() {
            return this.token != null;
        }

        void set(String tokenStr) {
            this.token = tokenStr;
        }

        public String toString() {
            return this.token;
        }
    }
}

