/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.FSOpsThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class TestTierOffload
implements Cloneable {
    private long numVols_ = 0L;
    private String topDir_ = "/";
    private String ruleExpr_ = "p";
    private long duration_ = 120L;
    private boolean cleanup_ = false;
    private long maxFileSize_ = 0x800000L;
    private long seed_ = 2049L;
    private long maxOps_ = 1024L;
    private String testTierRule_ = "testTierRule";
    private String testTierName_ = "testTier";
    private String tierURL_ = "10.10.100.180:9000";
    private String credsFile_ = "/root/rboddu/AudiDemo/180creds.txt";
    private String testTierSchedule_ = "FiveMinSchedule";
    private String testTierScheduleId_;
    private ArrayList<String> volNames_;
    private ArrayList<String> volPaths_;
    private static final String VOLNAME_PREFIX = "testTierOffloadVol";
    private FileSystem fs_;
    public static final String MAPRFS_URI = "maprfs:///";

    TestTierOffload() {
        this.PopulateFileSystem();
    }

    public static void Usage() {
        System.out.println("testtieroffload -n <numVols> -t <topDir>\n -r <ruleAceExpr> -d <durationOfRunInMins>\n -s <seed> -o <maxOps> -f <maxFileSize>\n -u <tierURL> -a <credsFileLocation>\n -c <cleanup>\n");
        System.out.println("Please use all '-' arguments first and then options with arguments");
        System.exit(1);
    }

    private void PopulateFileSystem() {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", MAPRFS_URI);
        conf.set("dfs.replication", "1");
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("io.file.buffer.size", "65536");
        try {
            this.fs_ = FileSystem.get((URI)URI.create(MAPRFS_URI), (Configuration)conf);
        }
        catch (IOException e) {
            System.out.println("Fs get failed()");
        }
    }

    private int RunShellCommand(String cmd) {
        System.out.println("Running command: " + cmd);
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", cmd});
            int exitVal = p.waitFor();
            if (exitVal != 0) {
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader errInput = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String line = null;
                while ((line = stdInput.readLine()) != null) {
                    System.out.println(line);
                }
                while ((line = errInput.readLine()) != null) {
                    System.out.println(line);
                }
            }
            return exitVal;
        }
        catch (Exception e) {
            System.out.println("Command failed execution: " + e);
            return 1;
        }
    }

    private String GetScheduleId(String scheduleName) {
        String cmd = "maprcli schedule list | grep " + scheduleName + " | awk '{print $4}'";
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", cmd});
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int exitVal = p.waitFor();
            if (exitVal == 0) {
                return stdInput.readLine();
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("Command failed execution: " + e);
            return null;
        }
    }

    private int CreateTierVolumes() {
        this.volNames_ = new ArrayList();
        this.volPaths_ = new ArrayList();
        String scheduleId = this.GetScheduleId(this.testTierSchedule_);
        if (scheduleId == null) {
            return 1;
        }
        int i = 0;
        while ((long)i < this.numVols_) {
            String vol = VOLNAME_PREFIX + i;
            String volMntPath = this.topDir_ + "/testTierOffloadVol" + i;
            this.volNames_.add(vol);
            this.volPaths_.add(volMntPath);
            String cmd = "/usr/bin/maprcli volume create -name " + vol + " -path " + volMntPath + " -tieringenable true -tiername " + this.testTierName_ + " -tieringrule " + this.testTierRule_ + " -offloadschedule " + scheduleId + " -schedule " + scheduleId + " -tierencryption false";
            if (this.RunShellCommand(cmd) != 0) {
                System.out.println("Volume creation failed for " + vol);
                return 1;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                System.out.println("Exception received: " + e);
            }
            ++i;
        }
        return 0;
    }

    private int SetUpTierConfig() {
        this.RunShellCommand("maprcli tier rule create -name " + this.testTierRule_ + " -expr " + this.ruleExpr_);
        this.RunShellCommand("maprcli tier create -name " + this.testTierName_ + " -type cold -url " + this.tierURL_ + " -credential " + this.credsFile_);
        this.RunShellCommand("maprcli trace setlevel -module MASTGateway -level Debug -port 8660");
        this.RunShellCommand("maprcli schedule create -schedule '{\"name\":\"" + this.testTierSchedule_ + "\",\"rules\":[{\"frequency\":\"fiveminutes\",\"retain\":\"15mi\"}]}'");
        return 0;
    }

    private int DeleteTierConfigs() {
        this.RunShellCommand("maprcli tier rule remove -name " + this.testTierRule_);
        this.RunShellCommand("maprcli tier remove -name " + this.testTierName_);
        String scheduleId = this.GetScheduleId(this.testTierSchedule_);
        if (scheduleId != null) {
            this.RunShellCommand("maprcli schedule remove -id " + scheduleId);
        }
        int i = 0;
        while ((long)i < this.numVols_) {
            String vol = VOLNAME_PREFIX + i;
            String volMntPath = this.topDir_ + VOLNAME_PREFIX + i;
            String cmd = "/usr/bin/maprcli volume remove -name " + vol + " -force true";
            if (this.RunShellCommand(cmd) != 0) {
                System.out.println("Volume deletion failed for " + vol);
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public void Test() {
        if (this.numVols_ == 0L) {
            System.out.println("numVols is required");
            System.exit(1);
        }
        if (this.cleanup_) {
            this.DeleteTierConfigs();
            return;
        }
        this.SetUpTierConfig();
        this.CreateTierVolumes();
        try {
            FSOpsThread fsOpsThread = new FSOpsThread(this.seed_, this.maxOps_, this.maxFileSize_, this.volPaths_, this.volNames_, this.duration_ * 60L);
            fsOpsThread.start();
            fsOpsThread.join();
        }
        catch (InterruptedException e) {
            System.out.println("Exception received: " + e);
        }
    }

    public static void main(String[] Args) {
        TestTierOffload TestTier = new TestTierOffload();
        int i = 0;
        if (Args.length == 0) {
            TestTierOffload.Usage();
        }
        block12: while (i < Args.length) {
            String arg = Args[i++];
            char c = arg.charAt(1);
            switch (c) {
                case 'n': {
                    TestTier.numVols_ = Long.parseLong(Args[i++]);
                    continue block12;
                }
                case 't': {
                    TestTier.topDir_ = Args[i++];
                    continue block12;
                }
                case 'r': {
                    TestTier.ruleExpr_ = Args[i++];
                    continue block12;
                }
                case 'd': {
                    TestTier.duration_ = Long.parseLong(Args[i++]);
                    continue block12;
                }
                case 'c': {
                    TestTier.cleanup_ = true;
                    continue block12;
                }
                case 's': {
                    TestTier.seed_ = Long.parseLong(Args[i++]);
                    continue block12;
                }
                case 'o': {
                    TestTier.maxOps_ = Long.parseLong(Args[i++]);
                    continue block12;
                }
                case 'f': {
                    TestTier.maxFileSize_ = Long.parseLong(Args[i++]);
                    continue block12;
                }
                case 'u': {
                    TestTier.tierURL_ = Args[i++];
                    continue block12;
                }
                case 'a': {
                    TestTier.credsFile_ = Args[i++];
                    continue block12;
                }
            }
            TestTierOffload.Usage();
        }
        TestTier.Test();
    }
}

