/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.tables.MapRAdmin;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class FSTests {
    private static Random rand = new Random(System.currentTimeMillis());
    private static Path TEST_ROOT = new Path("/tmp", "test-" + Math.abs(rand.nextInt()));
    private static volatile MapRFileSystem maprfs_;
    private static volatile MapRAdmin maprAdmin_;
    private static volatile Configuration conf_;

    public static synchronized MapRFileSystem maprfs() throws IOException {
        if (maprfs_ == null) {
            try {
                maprfs_ = new MapRFileSystem();
                maprfs_.initialize(new URI("maprfs:///"), FSTests.getConf());
            }
            catch (IOException | URISyntaxException e) {
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
        return maprfs_;
    }

    public static synchronized MapRAdmin mapradmin() throws IOException {
        if (maprAdmin_ == null) {
            maprAdmin_ = new MapRAdmin(FSTests.maprfs());
        }
        return maprAdmin_;
    }

    public static synchronized Configuration getConf() {
        if (conf_ == null) {
            conf_ = new Configuration();
        }
        return conf_;
    }

    public static Path getTestRoot() {
        try {
            if (!FSTests.maprfs().exists(TEST_ROOT)) {
                FSTests.maprfs().mkdirs(TEST_ROOT);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return TEST_ROOT;
    }

    public static Path getTestRoot(String clusterPrefix) {
        Path test_root = Path.mergePaths((Path)new Path(clusterPrefix), (Path)TEST_ROOT);
        try {
            if (!FSTests.maprfs().exists(test_root)) {
                FSTests.maprfs().mkdirs(test_root);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return test_root;
    }
}

