/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class TableOps {
    public static void TestBasicCRUD(Configuration config) throws Exception {
        int j;
        int j2;
        Get g;
        Put put;
        int NUM_CF = 2;
        int NUM_PUT = 1500;
        int NUM_DEL = 15;
        String tableName = "/tblOp";
        HTable table = null;
        String[] cf = new String[NUM_CF];
        for (int i = 0; i < NUM_CF; ++i) {
            cf[i] = "CF-" + i;
        }
        String cq = "cl-qualifier";
        String value = "Value";
        String row = "row";
        HBaseAdmin admin = new HBaseAdmin(config);
        HTableDescriptor des = new HTableDescriptor("/tblOp".getBytes());
        des.setName("/tblOp".getBytes());
        if (admin.tableExists("/tblOp")) {
            admin.deleteTable("/tblOp");
            System.out.println("deleted table /tblOp");
        }
        for (String cfmy : cf) {
            des.addFamily(new HColumnDescriptor(cfmy.getBytes()));
        }
        admin.createTable(des);
        admin.close();
        table = new HTable(config, "/tblOp");
        int numOfRowsAfterDelete = 0;
        int printper = 1000;
        ArrayList<Put> puts = new ArrayList<Put>(NUM_PUT);
        long start = System.currentTimeMillis();
        for (int j3 = 0; j3 < NUM_CF; ++j3) {
            System.out.print("CF " + j3 + " put iter ... ");
            for (int i = 0; i < NUM_PUT; ++i) {
                put = new Put((row + i).getBytes());
                put.add(cf[j3].getBytes(), (cq + i).getBytes(), (value + i).getBytes());
                put.add(cf[j3].getBytes(), (cq + i + i).getBytes(), 222L, (value + i).getBytes());
                puts.add(put);
                if (i != 0 && i % printper == 0) {
                    long end = System.currentTimeMillis();
                    long diff = end - start;
                    start = System.currentTimeMillis();
                }
                table.put(puts);
                puts.clear();
            }
            System.out.println(" done.");
        }
        table.flushCommits();
        System.out.println("Mark " + NUM_DEL + " rows for delete");
        ArrayList<Delete> delList = new ArrayList<Delete>();
        Delete delete = null;
        for (int i = 0; i < NUM_DEL; ++i) {
            delete = new Delete((row + i).getBytes());
            delList.add(delete);
        }
        table.delete(delList);
        delList.clear();
        table.flushCommits();
        ArrayList<Get> gList = new ArrayList<Get>();
        for (int j4 = 0; j4 < NUM_CF; ++j4) {
            int i;
            System.out.print("CF " + j4 + " get iter  ... ");
            for (int i2 = 0; i2 < NUM_PUT; ++i2) {
                g = new Get((row + i2).getBytes());
                g.setMaxVersions(1);
                g.addColumn(cf[j4].getBytes(), (cq + i2).getBytes());
                gList.add(g);
            }
            Result[] result = table.get(gList);
            if (NUM_PUT != 0) {
                Assert.assertEquals((long)NUM_PUT, (long)result.length);
            }
            for (i = 0; i < NUM_DEL; ++i) {
                Assert.assertTrue((boolean)result[i].isEmpty());
            }
            for (i = NUM_DEL; i < (NUM_PUT != 0 ? result.length : NUM_PUT); ++i) {
                Assert.assertFalse((boolean)result[i].isEmpty());
                Assert.assertEquals((Object)new String(result[i].getValue(cf[j4].getBytes(), (cq + i).getBytes())), (Object)(value + i));
            }
            System.out.println(" done.");
            gList.clear();
        }
        Scan scan = new Scan();
        ResultScanner scanner = table.getScanner(scan);
        System.out.print("Start scanning...");
        Result[] rr = scanner.next(2);
        while (rr != null) {
            numOfRowsAfterDelete += rr.length;
            rr = scanner.next(2);
        }
        System.out.println(" done. Got " + numOfRowsAfterDelete + " rows.");
        scanner.close();
        if (NUM_PUT != 0) {
            Assert.assertEquals((long)(NUM_PUT - NUM_DEL), (long)numOfRowsAfterDelete);
        }
        for (j2 = 0; j2 < NUM_CF; ++j2) {
            for (int i = 0; i < NUM_DEL; ++i) {
                put = new Put((row + i).getBytes());
                put.add(cf[j2].getBytes(), (cq + i).getBytes(), (value + i).getBytes());
                table.put(put);
            }
        }
        table.flushCommits();
        System.out.println("Added the first " + NUM_DEL + " rowkey's back.");
        System.out.print("Start scanning...");
        scanner = table.getScanner(scan);
        numOfRowsAfterDelete = 0;
        rr = scanner.next(2);
        while (rr != null) {
            numOfRowsAfterDelete += rr.length;
            rr = scanner.next(2);
        }
        scanner.close();
        System.out.println(" done. Got " + numOfRowsAfterDelete + " rows.");
        for (int i = NUM_DEL; i < 2 * NUM_DEL; ++i) {
            delete = new Delete((row + i).getBytes());
            delList.add(delete);
        }
        table.delete(delList);
        table.flushCommits();
        delList.clear();
        System.out.println("Deleted " + NUM_DEL + " to " + 2 * NUM_DEL + " rowkeys.");
        for (j2 = 0; j2 < NUM_CF; ++j2) {
            int i;
            System.out.print("CF " + j2 + " get iter  ... ");
            for (int i3 = 0; i3 < NUM_PUT; ++i3) {
                g = new Get((row + i3).getBytes());
                g.setMaxVersions(1);
                g.addColumn(cf[j2].getBytes(), (cq + i3).getBytes());
                gList.add(g);
            }
            Result[] result = table.get(gList);
            if (NUM_PUT != 0) {
                Assert.assertEquals((long)NUM_PUT, (long)result.length);
            }
            for (i = NUM_DEL; i < 2 * NUM_DEL; ++i) {
                if (NUM_PUT == 0) continue;
                Assert.assertTrue((boolean)result[i].isEmpty());
            }
            for (i = 0; i < NUM_DEL; ++i) {
                Assert.assertFalse((boolean)result[i].isEmpty());
                Assert.assertEquals((Object)new String(result[i].getValue(cf[j2].getBytes(), (cq + i).getBytes())), (Object)(value + i));
            }
            for (i = 2 * NUM_DEL; i < (NUM_PUT != 0 ? result.length : NUM_PUT); ++i) {
                Assert.assertFalse((boolean)result[i].isEmpty());
                Assert.assertEquals((Object)new String(result[i].getValue(cf[j2].getBytes(), (cq + i).getBytes())), (Object)(value + i));
            }
            System.out.println(" done.");
            gList.clear();
        }
        numOfRowsAfterDelete = 0;
        scan = new Scan();
        scanner = table.getScanner(scan);
        System.out.print("Start scanning...");
        rr = scanner.next(26);
        while (rr != null) {
            numOfRowsAfterDelete += rr.length;
            rr = scanner.next(26);
        }
        System.out.println(" done. Got " + numOfRowsAfterDelete + " rows.");
        scanner.close();
        if (NUM_PUT != 0) {
            Assert.assertEquals((long)(NUM_PUT - NUM_DEL), (long)numOfRowsAfterDelete);
        }
        System.out.print("Start RowMut for row0 to 10x value and del some colQual ... ");
        int idx = 0;
        RowMutations mt = new RowMutations((row + idx).getBytes());
        for (j = 0; j < NUM_CF; ++j) {
            int i;
            for (i = 0; i < NUM_PUT; ++i) {
                Put p = new Put((row + idx).getBytes());
                p.add(cf[j].getBytes(), (cq + i).getBytes(), (value + i * 10).getBytes());
                mt.add(p);
            }
            for (i = 2 * NUM_DEL; i < 4 * NUM_DEL; ++i) {
                Delete d = new Delete((row + idx).getBytes());
                d.deleteColumn(cf[j].getBytes(), (cq + i).getBytes());
                mt.add(d);
            }
        }
        table.mutateRow(mt);
        System.out.println(" done.");
        numOfRowsAfterDelete = 0;
        scan = new Scan();
        scanner = table.getScanner(scan);
        System.out.print("Start scanning...");
        rr = scanner.next(26);
        while (rr != null) {
            numOfRowsAfterDelete += rr.length;
            rr = scanner.next(26);
        }
        System.out.println(" done. Got " + numOfRowsAfterDelete + " rows.");
        scanner.close();
        if (NUM_PUT != 0) {
            Assert.assertEquals((long)(NUM_PUT - NUM_DEL), (long)numOfRowsAfterDelete);
        }
        for (j = 0; j < NUM_CF; ++j) {
            int i;
            System.out.print("CF " + j + " get iter ...");
            for (int i4 = 0; i4 < NUM_PUT; ++i4) {
                g = new Get((row + idx).getBytes());
                g.setMaxVersions(1);
                g.addColumn(cf[j].getBytes(), (cq + i4).getBytes());
                gList.add(g);
            }
            Result[] result = table.get(gList);
            if (NUM_PUT != 0) {
                Assert.assertEquals((long)NUM_PUT, (long)result.length);
            }
            for (i = 2 * NUM_DEL; i < 4 * NUM_DEL; ++i) {
                Assert.assertTrue((boolean)result[i].isEmpty());
            }
            for (i = 0; i < 2 * NUM_DEL; ++i) {
                Assert.assertEquals((Object)new String(result[i].getValue(cf[j].getBytes(), (cq + i).getBytes())), (Object)(value + i * 10));
            }
            for (i = 4 * NUM_DEL; i < (NUM_PUT != 0 ? result.length : NUM_PUT); ++i) {
                Assert.assertEquals((Object)new String(result[i].getValue(cf[j].getBytes(), (cq + i).getBytes())), (Object)(value + i * 10));
            }
            System.out.println(" done");
            gList.clear();
        }
        put = new Put(row.getBytes());
        long initVal = 1L;
        put.add(cf[0].getBytes(), (cq + "0").getBytes(), Bytes.toBytes((long)initVal));
        table.put(put);
        table.flushCommits();
        Increment incr = new Increment(row.getBytes());
        incr.addColumn(cf[0].getBytes(), (cq + "0").getBytes(), 5L);
        table.increment(incr);
        table.flushCommits();
        g = new Get(row.getBytes());
        g.addColumn(cf[0].getBytes(), (cq + "0").getBytes());
        Result result = table.get(g);
        ByteBuffer rbb = result.getValueAsByteBuffer(cf[0].getBytes(), (cq + "0").getBytes());
        Assert.assertEquals((long)rbb.getLong(), (long)6L);
        System.out.println("Increment test done.");
        Put p1 = new Put(row.getBytes());
        p1.add(cf[0].getBytes(), (cq + "0").getBytes(), Bytes.toBytes((long)(initVal + 15L)));
        boolean capRet = table.checkAndPut(row.getBytes(), cf[0].getBytes(), (cq + "0").getBytes(), Bytes.toBytes((long)6L), p1);
        Assert.assertEquals((Object)capRet, (Object)true);
        g = new Get(row.getBytes());
        g.addColumn(cf[0].getBytes(), (cq + "0").getBytes());
        result = table.get(g);
        rbb = result.getValueAsByteBuffer(cf[0].getBytes(), (cq + "0").getBytes());
        Assert.assertEquals((long)rbb.getLong(), (long)16L);
        System.out.println("CheckAndPut done.");
        System.out.print("Appending... ");
        Append apnd = new Append(row.getBytes());
        apnd.add(cf[0].getBytes(), (cq + "0").getBytes(), "v".getBytes());
        table.append(apnd);
        table.flushCommits();
        g = new Get(row.getBytes());
        g.addColumn(cf[0].getBytes(), (cq + "0").getBytes());
        result = table.get(g);
        rbb = result.getValueAsByteBuffer(cf[0].getBytes(), (cq + "0").getBytes());
        Assert.assertEquals((long)rbb.getLong(), (long)16L);
        System.out.println(" done.");
    }

    public static void JSONTest(Configuration config) throws Exception {
        String tableName = "/JSONtblOp";
        HTable table = null;
        HBaseAdmin admin = new HBaseAdmin(config);
        HTableDescriptor des = new HTableDescriptor("/JSONtblOp".getBytes());
        des.addFamily(new HColumnDescriptor("default".getBytes()));
        if (admin.tableExists("/JSONtblOp")) {
            admin.deleteTable("/JSONtblOp");
            System.out.println("deleted table /JSONtblOp");
        }
        admin.createTable(des);
        admin.close();
        try {
            table = new HTable(config, "/JSONtblOp");
            Assert.fail((String)"JSON table cannot be allowed to use HBase API's.");
        }
        catch (UnsupportedOperationException uoe) {
            System.out.println("JSON table test to not use HBase API done.");
        }
        catch (IOException rte) {
            System.out.println("JSON table test to not use HBase API done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void TestDeletes(Configuration config) throws Exception {
        String cq = "cl-qualifier";
        String value = "Value";
        String row = "row";
        String tableName = "/t12731";
        String cf1 = "fam0";
        String cf2 = "fam1";
        HBaseAdmin admin = new HBaseAdmin(config);
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            System.out.println("deleted old table");
        }
        HTableDescriptor des = new HTableDescriptor(tableName.getBytes());
        for (int i = 0; i < 2; ++i) {
            des.addFamily(new HColumnDescriptor("fam" + i));
        }
        try (HTable myTable = null;){
            admin.createTable(des);
            System.out.println("created table");
            admin.close();
            myTable = new HTable(config, tableName);
            myTable.setAutoFlush(true);
            ArrayList<Put> pList = new ArrayList<Put>();
            for (int i = 0; i < 5; ++i) {
                Put p = new Put(row.getBytes());
                p.add(cf1.getBytes(), new String(cq + i).getBytes(), (long)(20 + i), new String(cf1 + value + i).getBytes());
                p.add(cf2.getBytes(), new String(cq + i).getBytes(), (long)(20 + i), new String(cf2 + value + i).getBytes());
                pList.add(p);
            }
            myTable.put(pList);
            myTable.flushCommits();
            Delete d = new Delete(row.getBytes());
            d.deleteFamily(cf1.getBytes());
            d.deleteColumn(cf1.getBytes(), new String(cq + "1").getBytes());
            d.deleteColumns(cf1.getBytes(), new String(cq + "0").getBytes());
            myTable.delete(d);
            System.out.println("Delete CF + specific column done");
            d.deleteFamily(cf1.getBytes());
            d.deleteColumn(cf1.getBytes(), new String(cq + "0").getBytes(), 20L);
            myTable.delete(d);
            System.out.println("Delete CF + specific column + ts done");
            d.deleteFamily(cf1.getBytes(), 20L);
            d.deleteColumn(cf1.getBytes(), new String(cq + "0").getBytes(), 21L);
            myTable.delete(d);
            System.out.println("Delete CF ts < specific column ts - done");
            d.deleteFamily(cf1.getBytes(), 21L);
            d.deleteColumn(cf1.getBytes(), new String(cq + "0").getBytes(), 22L);
            d.deleteColumn(cf1.getBytes(), new String(cq + "1").getBytes(), 23L);
            myTable.delete(d);
            System.out.println("Delete CF + multicolumn + ts done");
            d.deleteFamily(cf1.getBytes(), 21L);
            d.deleteFamily(cf1.getBytes(), 22L);
            myTable.delete(d);
            System.out.println("Delete CF @ 2 ts done");
            d.deleteFamily(cf1.getBytes(), 21L);
            d.deleteFamily(cf1.getBytes(), 22L);
            d.deleteFamily(cf1.getBytes(), 20L);
            d.deleteColumn(cf1.getBytes(), new String(cq + "0").getBytes());
            d.deleteColumn(cf1.getBytes(), new String(cq + "1").getBytes());
            d.deleteColumn(cf1.getBytes(), new String(cq + "3").getBytes(), 22L);
            myTable.delete(d);
            System.out.println("Delete CF ts + delete CF + specific column done");
            d = new Delete(row.getBytes());
            d.deleteFamily(cf2.getBytes(), 22L);
            d.deleteColumn(cf2.getBytes(), new String(cq + "0").getBytes());
            myTable.delete(d);
            System.out.println("Delete 2 CF's done");
            d.deleteColumn(cf2.getBytes(), new String(cq + "0").getBytes());
            myTable.delete(d);
            System.out.println("Delete 2 CF + specific column done");
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Configuration config = HBaseConfiguration.create();
            if (args.length != 0 && args[0].equals("-debug")) {
                config.set("fs.mapr.trace", "debug");
            }
            TableOps.TestBasicCRUD(config);
        }
        catch (Exception ie) {
            ie.printStackTrace();
            Assert.fail((String)ie.getMessage());
        }
    }
}

