/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.tables.impl;

import com.google.common.collect.ImmutableList;
import com.mapr.fs.tables.ExtIndexDesc;
import com.mapr.fs.tables.ExtIndexFieldDesc;
import com.mapr.utils.JsonUtils;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;

public final class ExtIndexDescImpl
implements ExtIndexDesc {
    private final List<ExtIndexFieldDesc> indexedFields;
    private final Collection<ExtIndexFieldDesc> coveredFields;
    private final boolean isUnique;
    private final boolean isExternal;
    private final boolean isDisabled;
    private final Path primaryTablePath;
    private final String indexFid;
    private final String indexName;
    private final String systemName;
    private final String clusterName;
    private final String connectionString;

    private ExtIndexDescImpl(List<ExtIndexFieldDesc> indexedFields, Collection<ExtIndexFieldDesc> coveredFields, boolean isUnique, boolean isExternal, boolean isDisabled, Path primaryTablePath, String indexFid, String indexName, String systemName, String clusterName, String connectionString) {
        this.indexedFields = indexedFields;
        this.coveredFields = coveredFields;
        this.isUnique = isUnique;
        this.isExternal = isExternal;
        this.isDisabled = isDisabled;
        this.primaryTablePath = primaryTablePath;
        this.indexFid = indexFid;
        this.indexName = indexName;
        this.systemName = systemName;
        this.clusterName = clusterName;
        this.connectionString = connectionString;
    }

    @Override
    public List<ExtIndexFieldDesc> getIndexedFields() {
        return this.indexedFields;
    }

    @Override
    public Collection<ExtIndexFieldDesc> getCoveredFields() {
        return this.coveredFields;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public String getPrimaryTablePath() {
        return this.primaryTablePath.toString();
    }

    @Override
    public String getIndexFid() {
        return this.indexFid;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String getSystem() {
        return this.systemName;
    }

    @Override
    public String getCluster() {
        return this.clusterName;
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    public String toString() {
        return "{\"indexedFields\":" + this.indexedFields + ", \"coveredFields\":" + this.coveredFields + ", \"isUnique\":" + this.isUnique + ", \"isExternal\":" + this.isExternal + ", \"isDisabled\":" + this.isDisabled + ", \"primaryTablePath\":" + this.primaryTablePath + ", \"indexName\":" + JsonUtils.toJsonValue((String)this.indexName) + ", \"systemName\":" + JsonUtils.toJsonValue((String)this.systemName) + ", \"clusterName\":" + JsonUtils.toJsonValue((String)this.clusterName) + ", \"connectionString\":" + JsonUtils.toJsonValue((String)this.connectionString) + "}";
    }

    public static final class Builder {
        private ImmutableList.Builder<ExtIndexFieldDesc> indexedFieldsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<ExtIndexFieldDesc> coveredFieldsBuilder = ImmutableList.builder();
        private boolean isUnique;
        private boolean isExternal;
        private boolean isDisabled;
        private Path primaryTablePath;
        private String indexFid;
        private String indexName;
        private String systemName;
        private String clusterName;
        private String connectionString;

        public ExtIndexDescImpl build() {
            return new ExtIndexDescImpl((List<ExtIndexFieldDesc>)this.indexedFieldsBuilder.build(), (Collection<ExtIndexFieldDesc>)this.coveredFieldsBuilder.build(), this.isUnique, this.isExternal, this.isDisabled, this.primaryTablePath, this.indexFid, this.indexName, this.systemName, this.clusterName, this.connectionString);
        }

        public Builder addIndexedField(ExtIndexFieldDesc desc) {
            this.indexedFieldsBuilder.add((Object)desc);
            return this;
        }

        public Builder addCoveredFields(ExtIndexFieldDesc desc) {
            this.coveredFieldsBuilder.add((Object)desc);
            return this;
        }

        public Builder setUnique(boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public Builder setExternal(boolean isExternal) {
            this.isExternal = isExternal;
            return this;
        }

        public Builder setDisabled(boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public Builder setPrimaryTablePath(Path primaryTablePath) {
            this.primaryTablePath = primaryTablePath;
            return this;
        }

        public Builder setIndexFid(String indexFid) {
            this.indexFid = indexFid;
            return this;
        }

        public Builder setIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder setSystemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder setConnectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }
    }
}

