/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.util;

import com.mapr.fs.FidInfo;
import com.mapr.fs.proto.Common;
import java.io.IOException;
import java.util.regex.Pattern;

public class Fids {
    private static final Pattern FID_PATTERN = Pattern.compile("[0-9]+.[0-9]+.[0-9]+");

    public static boolean isFidString(String fid) {
        return fid != null && FID_PATTERN.matcher(fid).matches();
    }

    public static void validateFid(String fid) throws IOException {
        if (!Fids.isFidString(fid)) {
            throw new IOException(fid + ": Incorrect fid format");
        }
    }

    public static String fidToString(Common.FidMsg fid) {
        StringBuilder builder = new StringBuilder();
        builder.append(fid.getCid());
        builder.append(".");
        builder.append(fid.getCinum());
        builder.append(".");
        builder.append(fid.getUniq());
        return builder.toString();
    }

    public static String fidToString(FidInfo fid) {
        return Fids.fidToString(fid.getFidMsg());
    }
}

