/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.tables;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TabletStats {
    private final Logger LOG = Logger.getLogger(TabletStats.class);
    private static ExecutorService tabletStatRpcService = Executors.newFixedThreadPool(10);
    private Map<Dbserver.TabletDesc, Future<Dbserver.TabletStatResponse>> futureResponses;
    private final Path path;
    private final String indexFid;
    private final MapRFileSystem fs_;
    private MapRTabletScanner scanner_;

    private boolean isInited() {
        return this.scanner_ != null;
    }

    public TabletStats(MapRFileSystem fs, Path path) {
        this(fs, path, null);
    }

    public TabletStats(MapRFileSystem fs, Path path, String indexFid) {
        this.fs_ = fs;
        this.path = path;
        this.indexFid = indexFid;
        this.scanner_ = null;
    }

    private void ensureInitialized() throws IOException {
        if (this.isInited()) {
            return;
        }
        try {
            this.scanner_ = this.fs_.getTabletScanner(this.path, this.indexFid);
        }
        catch (IOException e) {
            this.LOG.error((Object)("Failed to load tablets for table " + this.path + ", error: " + e.getMessage()));
            throw e;
        }
    }

    public long getNumTablets() {
        try {
            this.ensureInitialized();
        }
        catch (IOException e) {
            this.LOG.error((Object)("Failed to estimate number of tablets for table " + this.path + ", error: " + e.getMessage()));
            return 0L;
        }
        return this.scanner_.getTotal();
    }

    public List<Dbserver.TabletDesc> getTablets(int start, int limit) {
        ArrayList tablets = Lists.newArrayList();
        try {
            Dbserver.TabletDesc nextTablet;
            this.ensureInitialized();
            while ((nextTablet = this.scanner_.next()) != null) {
                if (start > 0) {
                    --start;
                    continue;
                }
                if (start == 0 && limit > 0) {
                    tablets.add(nextTablet);
                    --limit;
                    continue;
                }
                if (limit != 0) continue;
            }
            this.futureResponses = Maps.newHashMap();
            for (final Dbserver.TabletDesc tablet : tablets) {
                this.futureResponses.put(tablet, tabletStatRpcService.submit(new Callable<Dbserver.TabletStatResponse>(){

                    @Override
                    public Dbserver.TabletStatResponse call() {
                        try {
                            return TabletStats.this.fs_.getTabletStat(TabletStats.this.path, tablet.getFid());
                        }
                        catch (Exception ioe) {
                            TabletStats.this.LOG.error((Object)("Error fetching tablet stats for fid: " + tablet.getFid()), (Throwable)ioe);
                            return null;
                        }
                    }
                }));
            }
        }
        catch (IOException e) {
            return null;
        }
        return tablets;
    }

    public Dbserver.TabletStatResponse getTabletStatResponse(Dbserver.TabletDesc tablet) throws InterruptedException, ExecutionException {
        return this.futureResponses.get(tablet).get();
    }
}

