/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.security.JNISecurity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterConf
implements MapRConstants {
    private static final Log LOG = LogFactory.getLog(ClusterConf.class);
    private static final String HASH = "#";
    private static final String EQUALTO = "=";
    private String clusterConfFile;
    long cldbInfoRefreshPeriod = 600000L;
    private List<ClusterEntry> clusterList = new ArrayList<ClusterEntry>();

    private void addSocketAddrToList(List<CLDBRpcCommonUtils.SocketAddr> socketAddrsList, List<Long> numIpsPerCldbList, String addrArr, String cName) {
        long ipsCount = 0L;
        for (String addr : addrArr.split(";")) {
            CLDBRpcCommonUtils.SocketAddr sockAddr;
            if ((addr = addr.trim()).isEmpty()) continue;
            int idx = addr.indexOf(",");
            String hostname = null;
            if (idx != -1) {
                hostname = addr.substring(0, idx);
                addr = addr.substring(idx + 1);
            }
            String ipStr = null;
            if (addr.contains(":")) {
                String[] arr = addr.split(":");
                int port = 0;
                int lastIndex = arr.length - 1;
                if (!arr[lastIndex].contains("]")) {
                    port = Integer.parseInt(arr[lastIndex]);
                    if (port < 0 || port > 65535) {
                        if (cName == null || cName.isEmpty()) continue;
                        System.err.println("Invalid port # for cluster " + cName);
                        continue;
                    }
                    ipStr = addr.substring(0, addr.lastIndexOf(":")).replaceAll("^\\[(.*)\\]$", "$1");
                } else {
                    ipStr = addr.replaceAll("^\\[(.*)\\]$", "$1");
                    port = 7222;
                }
                sockAddr = new CLDBRpcCommonUtils.SocketAddr(ipStr, Integer.valueOf(port));
                sockAddr.getIpAddr().setHostName(hostname);
            } else {
                sockAddr = new CLDBRpcCommonUtils.SocketAddr(addr.replaceAll("^\\[(.*)\\]$", "$1"), Integer.valueOf(7222));
                sockAddr.getIpAddr().setHostName(hostname);
            }
            ++ipsCount;
            socketAddrsList.add(sockAddr);
        }
        numIpsPerCldbList.add(ipsCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterEntry(MapRFileSystem fs, String cName, String[] cldbLocations) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            Iterator<ClusterEntry> iter = clusters.iterator();
            while (iter.hasNext()) {
                ClusterEntry centry = iter.next();
                if (!centry.getClusterName().equals(cName)) continue;
                iter.remove();
            }
            ArrayList<CLDBRpcCommonUtils.SocketAddr> sockAddrsList = new ArrayList<CLDBRpcCommonUtils.SocketAddr>();
            ArrayList<Long> numIpsPerCldbList = new ArrayList<Long>();
            try {
                for (String cldb : cldbLocations) {
                    this.addSocketAddrToList(sockAddrsList, numIpsPerCldbList, cldb, null);
                }
                if (sockAddrsList.size() != 0) {
                    ClusterEntry centry = new ClusterEntry(cName, sockAddrsList, numIpsPerCldbList);
                    clusters.add(centry);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateClusterEntry(String cName, String[] cldbLocations) {
        this.updateClusterEntry(null, cName, cldbLocations);
    }

    public ClusterConf() {
        this.readAndUpdateCldbInfo(false, null, null, null, null);
    }

    public void refreshClusterList() {
        this.readAndUpdateCldbInfo(false, null, null, null, null);
    }

    private String ClusterConfPath() {
        String maprHome = System.getProperty("mapr.home.dir");
        if (maprHome == null && (maprHome = System.getenv("MAPR_HOME")) == null) {
            maprHome = "/opt/mapr/";
        }
        if (maprHome.startsWith("\"")) {
            maprHome = maprHome.substring(1, maprHome.length() - 1);
        }
        String hadoopVersionPath = maprHome + "hadoop/hadoopversion";
        String hadoopVersion = null;
        try {
            hadoopVersion = Files.readAllLines(Paths.get(hadoopVersionPath, new String[0])).get(0);
        }
        catch (IOException e) {
            return maprHome + "/conf/mapr-clusters.conf";
        }
        String hadoopClusterConfFile = maprHome + "hadoop/hadoop-" + hadoopVersion + "/etc/mapr-clusters.conf";
        File f = new File(hadoopClusterConfFile);
        return f.exists() ? hadoopClusterConfFile : maprHome + "/conf/mapr-clusters.conf";
    }

    private String globalClusterConfPath() {
        String maprHome = System.getProperty("mapr.home.dir");
        if (maprHome == null && (maprHome = System.getenv("MAPR_HOME")) == null) {
            maprHome = "/opt/mapr/";
        }
        if (maprHome.startsWith("\"")) {
            maprHome = maprHome.substring(1, maprHome.length() - 1);
        }
        return maprHome + "/conf/global-mapr-clusters.conf";
    }

    private boolean readGlobalConf(boolean searchOneCluster, String clusterName, List<CLDBRpcCommonUtils.SocketAddr> inputSocketAddrsList, List<Long> inputNumIpsPerCldbList) {
        boolean found = false;
        String globalConfFile = this.globalClusterConfPath();
        LOG.debug((Object)"reading global cluster conf");
        try {
            String clusterConfLine;
            FileReader fr = new FileReader(globalConfFile);
            BufferedReader b = new BufferedReader(fr);
            while ((clusterConfLine = b.readLine()) != null && !(found = this.ParseAndAddCluster(clusterConfLine, searchOneCluster, true, clusterName, inputSocketAddrsList, inputNumIpsPerCldbList))) {
            }
            b.close();
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)"file /conf/global-mapr-clusters.conf doesn't exist.");
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to build cluster list from " + globalConfFile));
        }
        return found;
    }

    private int fetchGNSClusters(MapRFileSystem fs) {
        int err = 5;
        try {
            err = fs.fetchGNSConf();
            if (err != 0) {
                LOG.error((Object)("Failed to fetch GNS conf " + err));
            }
            return err;
        }
        catch (IOException e) {
            LOG.error((Object)("fetchGNSClusters " + e));
            return err;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean ParseAndAddCluster(String clusterConfLine, boolean searchOneCluster, boolean overwrite, String clusterName, List<CLDBRpcCommonUtils.SocketAddr> sockAddrsList, List<Long> inputNumIpsPerCldbList) {
        ArrayList<Long> numIpsPerCldbList;
        List<Object> sockIpAddrsList;
        boolean found = false;
        if ((clusterConfLine = clusterConfLine.trim()).isEmpty()) return false;
        if (clusterConfLine.startsWith(HASH)) {
            return false;
        }
        String[] tokens = clusterConfLine.split("[\\s]+");
        if (tokens.length < 2) {
            return false;
        }
        String cName = tokens[0];
        if (searchOneCluster) {
            if (!cName.equals(clusterName)) return false;
            found = true;
            sockIpAddrsList = sockAddrsList;
            numIpsPerCldbList = inputNumIpsPerCldbList;
        } else {
            sockIpAddrsList = new ArrayList();
            numIpsPerCldbList = new ArrayList();
        }
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].contains(EQUALTO)) {
                String[] arr = tokens[i].split(EQUALTO);
                if (arr.length == 2 && JNISecurity.SetClusterOption((String)cName, (String)arr[0], (String)arr[1]) == 0) continue;
                LOG.error((Object)("Invalid Conf options:" + tokens[i] + " for cluster " + cName));
                continue;
            }
            this.addSocketAddrToList(sockIpAddrsList, numIpsPerCldbList, tokens[i], cName);
        }
        if (!searchOneCluster && sockIpAddrsList.size() != 0) {
            try {
                ClusterEntry centry = new ClusterEntry(cName, sockIpAddrsList, numIpsPerCldbList);
                this.updateClusterList(centry, overwrite);
            }
            catch (Exception e) {
                System.err.println("Failed to build cluster list from " + clusterConfLine);
                System.err.println(e.getLocalizedMessage());
            }
        }
        JNISecurity.SetParsingDone();
        return found;
    }

    private void updateClusterList(ClusterEntry newCentry, boolean overwrite) {
        String cName = newCentry.getClusterName();
        Iterator<ClusterEntry> iter = this.clusterList.iterator();
        while (iter.hasNext()) {
            ClusterEntry centry = iter.next();
            if (!centry.getClusterName().equals(cName) || !overwrite) continue;
            iter.remove();
        }
        this.clusterList.add(newCentry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readAndUpdateCldbInfo(boolean searchOneCluster, String clusterName, List<CLDBRpcCommonUtils.SocketAddr> inputSocketAddrsList, List<Long> inputNumIpsPerCldbList, MapRFileSystem fs) {
        boolean found = false;
        List<ClusterEntry> list = this.clusterList;
        synchronized (list) {
            this.clusterConfFile = this.ClusterConfPath();
            try {
                FileReader fr = new FileReader(this.clusterConfFile);
                if (fr != null) {
                    int ret;
                    String clusterConfLine;
                    BufferedReader b = new BufferedReader(fr);
                    while ((clusterConfLine = b.readLine()) != null && !(found = this.ParseAndAddCluster(clusterConfLine, searchOneCluster, false, clusterName, inputSocketAddrsList, inputNumIpsPerCldbList))) {
                    }
                    b.close();
                    if (!found) {
                        found = this.readGlobalConf(searchOneCluster, clusterName, inputSocketAddrsList, inputNumIpsPerCldbList);
                    }
                    if (fs != null && !found && (ret = this.fetchGNSClusters(fs)) == 0) {
                        found = this.readGlobalConf(searchOneCluster, clusterName, inputSocketAddrsList, inputNumIpsPerCldbList);
                    }
                    if (!found && clusterName != null && !clusterName.isEmpty()) {
                        Hashtable<String, String> env = new Hashtable<String, String>();
                        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                        InitialDirContext dirContext = new InitialDirContext(env);
                        Attributes attrs = null;
                        attrs = dirContext.getAttributes(clusterName, new String[]{"TXT"});
                        if (attrs.size() != 0) {
                            Attribute txt = attrs.get("TXT");
                            NamingEnumeration<?> e = txt.getAll();
                            while (e.hasMore()) {
                                String strTxt = e.next().toString();
                                strTxt = strTxt.substring(1, strTxt.length() - 1);
                                found = this.ParseAndAddCluster(strTxt, searchOneCluster, false, clusterName, inputSocketAddrsList, inputNumIpsPerCldbList);
                            }
                        }
                    }
                }
            }
            catch (FileNotFoundException fr) {
            }
            catch (NamingException ne) {
                LOG.debug((Object)("Failed to read info from dns for cluster " + clusterName));
            }
            catch (Exception e) {
                this.clusterList.clear();
                System.err.println("Failed to build cluster list from " + this.clusterConfFile);
                System.err.println(e.getLocalizedMessage());
            }
            if (!found) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterEntry getFirstClusterEntry(MapRFileSystem fs) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            if (clusters.size() == 0) {
                return null;
            }
            return clusters.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterEntry getClusterEntryByAddr(MapRFileSystem fs, String ip, int port) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            for (ClusterEntry centry : clusters) {
                for (CLDBRpcCommonUtils.SocketAddr ipPort : centry.getSocketAddrsList()) {
                    if (!ipPort.getIpAddr().toString().equals(ip) || ipPort.getPort() != port) continue;
                    return centry;
                }
            }
            ArrayList<CLDBRpcCommonUtils.SocketAddr> sockAddrsList = new ArrayList<CLDBRpcCommonUtils.SocketAddr>();
            ArrayList<Long> numIpsPerCldbList = new ArrayList<Long>();
            LOG.info((Object)("*****IP: " + ip + " Port:" + String.valueOf(port)));
            CLDBRpcCommonUtils.SocketAddr ipPort = new CLDBRpcCommonUtils.SocketAddr(ip, Integer.valueOf(port));
            sockAddrsList.add(ipPort);
            numIpsPerCldbList.add(1L);
            String clusterName = ip + ":" + port;
            try {
                ClusterEntry centry = new ClusterEntry(clusterName, sockAddrsList, numIpsPerCldbList);
                clusters.add(centry);
                return centry;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public ClusterEntry getClusterEntryByAddr(String ip, int port) {
        return this.getClusterEntryByAddr(null, ip, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterEntry getClusterEntryByName(MapRFileSystem fs, String clusterName) {
        List<ClusterEntry> clusters = fs != null && !fs.getClusterNameUnique() ? fs.getClusterList() : this.clusterList;
        List<ClusterEntry> list = clusters;
        synchronized (list) {
            for (ClusterEntry centry : clusters) {
                if (!centry.getClusterName().equals(clusterName)) continue;
                return centry;
            }
        }
        try {
            ArrayList<CLDBRpcCommonUtils.SocketAddr> newSocketAddrsList = new ArrayList<CLDBRpcCommonUtils.SocketAddr>();
            ArrayList<Long> newNumIpsPerCldbList = new ArrayList<Long>();
            if (this.readAndUpdateCldbInfo(true, clusterName, newSocketAddrsList, newNumIpsPerCldbList, fs) == -1) {
                return null;
            }
            ClusterEntry newEntry = new ClusterEntry(clusterName, newSocketAddrsList, newNumIpsPerCldbList);
            List<ClusterEntry> list2 = clusters;
            synchronized (list2) {
                clusters.add(newEntry);
            }
            return newEntry;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
            return null;
        }
    }

    public ClusterEntry getClusterEntryByName(String clusterName) {
        return this.getClusterEntryByName(null, clusterName);
    }

    private int getPort(int port) {
        if (port < 0) {
            port = 7222;
        } else if (port == 0 || port > 65535) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Invalid port " + port + " specified in " + this.clusterConfFile + ", using default port 7222 instead"));
            }
            port = 7222;
        }
        return port;
    }

    public ClusterEntry getClusterByUri(MapRFileSystem fs, URI name) throws IOException {
        return this.fastClusterByPath(fs, name, null);
    }

    public ClusterEntry getClusterByUri(URI name) throws IOException {
        return this.getClusterByUri(null, name);
    }

    private ClusterEntry fastClusterByPath(MapRFileSystem fs, URI pathURI, String fsClusterName) throws IOException {
        ClusterEntry centry = null;
        if (pathURI.getHost() == null) {
            String exceptMsg = null;
            if (fsClusterName == null) {
                exceptMsg = "No default cluster in " + this.clusterConfFile;
                String rawPath = pathURI.getPath();
                if (rawPath.matches("^/mapr/.+")) {
                    String clusterName = rawPath.split("/")[2];
                    centry = this.getClusterEntryByName(clusterName);
                } else {
                    centry = this.getFirstClusterEntry(fs);
                }
            } else {
                exceptMsg = "Cluster " + fsClusterName + " not found in " + this.clusterConfFile;
                centry = this.getClusterEntryByName(fs, fsClusterName);
            }
            if (centry == null) {
                throw new IOException(exceptMsg);
            }
        } else if (pathURI.getPort() != -1) {
            centry = this.getClusterEntryByAddr(fs, pathURI.getHost(), this.getPort(pathURI.getPort()));
        } else {
            centry = this.getClusterEntryByName(fs, pathURI.getHost());
            if (centry == null) {
                centry = this.getClusterEntryByAddr(fs, pathURI.getHost(), 7222);
            }
        }
        return centry;
    }

    public ClusterEntry getClusterByPath(MapRFileSystem fs, URI p, URI fsUri, String fsClusterName) throws IOException {
        String rawPath = p.getPath();
        if (!rawPath.startsWith("/") || !rawPath.startsWith("/mapr")) {
            return this.fastClusterByPath(fs, p, fsClusterName);
        }
        if (rawPath.matches("^/mapr/.+")) {
            String clusterName = rawPath.split("/")[2];
            ClusterEntry centry = this.getClusterEntryByName(fs, clusterName);
            if (centry == null) {
                throw new IOException("Cluster " + clusterName + " has no entry in " + this.clusterConfFile + " and Global Name Space.");
            }
            return centry;
        }
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            throw new IOException("Invalid path " + rawPath + ". The correct format for fully-qualified names is: /mapr/<cluster>/<path>");
        }
        return this.fastClusterByPath(fs, p, fsClusterName);
    }

    public ClusterEntry getClusterByPath(URI p, URI fsUri, String fsClusterName) throws IOException {
        return this.getClusterByPath(null, p, fsUri, fsClusterName);
    }

    public List<ClusterEntry> getClusterList() {
        return this.clusterList;
    }

    public class ClusterEntry {
        private String clusterName;
        private List<CLDBRpcCommonUtils.SocketAddr> sockAddrsList;
        private List<Long> numIpsPerCldbList;
        private CLDBRpcCommonUtils.SocketAddr[] ips = null;
        private long[] numIpsPerCldb = null;
        long cldbInfoUpdatedTime;

        public ClusterEntry(String clusterName, List<CLDBRpcCommonUtils.SocketAddr> sockAddrsList, List<Long> numIpsPerCldbList) throws UnknownHostException {
            this.clusterName = clusterName;
            this.sockAddrsList = sockAddrsList;
            this.numIpsPerCldbList = numIpsPerCldbList;
            this.cldbInfoUpdatedTime = System.currentTimeMillis();
        }

        public String getClusterName() {
            return this.clusterName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rereadConf(MapRFileSystem fs) throws IOException {
            ClusterEntry clusterEntry = this;
            synchronized (clusterEntry) {
                this.sockAddrsList.clear();
                this.numIpsPerCldbList.clear();
                if (ClusterConf.this.readAndUpdateCldbInfo(true, this.clusterName, this.sockAddrsList, this.numIpsPerCldbList, fs) == -1) {
                    throw new IOException("Could not resolve any CLDB hostnames for the cluster: " + this.clusterName);
                }
                this.ips = null;
                this.numIpsPerCldb = null;
                this.cldbInfoUpdatedTime = System.currentTimeMillis();
            }
            LOG.info((Object)("Updated centry for the cluster " + this.clusterName));
        }

        public List<CLDBRpcCommonUtils.SocketAddr> getSocketAddrsList() {
            return this.sockAddrsList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CLDBRpcCommonUtils.SocketAddr[] getIPs(MapRFileSystem fs) throws IOException {
            long duration = System.currentTimeMillis() - this.cldbInfoUpdatedTime;
            if (duration >= ClusterConf.this.cldbInfoRefreshPeriod) {
                this.rereadConf(fs);
            }
            if (this.ips == null) {
                ClusterEntry clusterEntry = this;
                synchronized (clusterEntry) {
                    ArrayList<CLDBRpcCommonUtils.SocketAddr> arr = new ArrayList<CLDBRpcCommonUtils.SocketAddr>();
                    for (CLDBRpcCommonUtils.SocketAddr sockAddr : this.sockAddrsList) {
                        arr.add(sockAddr);
                    }
                    if (!arr.isEmpty()) {
                        this.ips = new CLDBRpcCommonUtils.SocketAddr[arr.size()];
                        for (int i = 0; i < arr.size(); ++i) {
                            this.ips[i] = (CLDBRpcCommonUtils.SocketAddr)arr.get(i);
                        }
                    }
                }
            }
            if (this.ips == null) {
                throw new IOException("Could not resolve any CLDB hostnames for cluster: " + this.clusterName);
            }
            return this.ips;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long[] getNumIpsPerCldb() throws IOException {
            if (this.numIpsPerCldb == null) {
                ClusterEntry clusterEntry = this;
                synchronized (clusterEntry) {
                    this.numIpsPerCldb = new long[this.numIpsPerCldbList.size()];
                    for (int i = 0; i < this.numIpsPerCldbList.size(); ++i) {
                        this.numIpsPerCldb[i] = this.numIpsPerCldbList.get(i);
                    }
                }
            }
            if (this.numIpsPerCldb == null) {
                throw new IOException("Could not resolve numIpsPerCldb for cluster: " + this.clusterName);
            }
            return this.numIpsPerCldb;
        }
    }
}

