/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.utils.ssh;

import com.jcraft.jsch.ChannelExec;
import com.mapr.fs.utils.ssh.NodeTask;
import com.mapr.fs.utils.ssh.SSHSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunCommand
extends NodeTask<RunCommand> {
    private static final Logger _logger = LoggerFactory.getLogger(RunCommand.class);
    private static final CharsetDecoder DECODER = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    private String cmd;
    private String stdout;
    private String stderr;
    private int exitCode;

    public RunCommand(String host, String cmd) {
        this(null, host, cmd);
    }

    public RunCommand(String user, String host, String cmd) {
        super(user, host);
        this.cmd = cmd;
    }

    @Override
    public RunCommand run(SSHSession session) throws Exception {
        this.cmd = session.substituteId(this.cmd);
        ChannelExec channel = session.openChannelExec("exec");
        channel.setCommand(this.cmd);
        channel.setInputStream(null);
        _logger.debug("Executing command '{}'.", (Object)this.cmd);
        channel.connect();
        BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(channel.getErrStream(), DECODER), 1024);
        BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(channel.getInputStream(), DECODER), 1024);
        _logger.debug("Reading from stream.");
        StringBuilder out = new StringBuilder();
        if (!this.consumeReader(channel, stdErrReader, out)) {
            out.setLength(0);
        }
        this.stderr = out.toString();
        out.setLength(0);
        if (!this.consumeReader(channel, stdOutReader, out)) {
            out.setLength(0);
        }
        this.stdout = out.toString();
        if (this.stderr.length() > 0 || this.stdout.length() > 0) {
            _logger.debug("\n{}", (Object)this.getOutput());
        }
        this.exitCode = channel.getExitStatus();
        _logger.debug("Command completed, exit-status: {}.", (Object)this.exitCode);
        channel.disconnect();
        _logger.debug("Channel disconnected.");
        return this;
    }

    private boolean consumeReader(ChannelExec channel, BufferedReader reader, StringBuilder out) throws IOException {
        boolean hadData = false;
        while (true) {
            int ch;
            if ((ch = reader.read()) > 0) {
                hadData = true;
                out.append((char)ch);
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        return hadData;
    }

    public String getStdOut() {
        return this.stdout;
    }

    public String getStdErr() {
        return this.stderr;
    }

    public String getOutput() {
        return String.format("Output:\n%s\nError:\n%s", this.stdout, this.stderr);
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

