/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFsPermission;
import com.mapr.fs.jni.JNIFileStatus;
import com.mapr.fs.jni.MapRConstants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;

public class MapRFileStatus
extends FileStatus
implements MapRConstants {
    private Path path;
    private FsPermission permission;
    private Path symlink;
    private JNIFileStatus internalStatus;

    public MapRFileStatus() {
        this(new JNIFileStatus());
    }

    public MapRFileStatus(String dir, long time) {
        this(new JNIFileStatus(dir, time));
    }

    public MapRFileStatus(JNIFileStatus proxy) {
        this(proxy, "maprfs");
    }

    public MapRFileStatus(JNIFileStatus proxy, String scheme) {
        this.internalStatus = proxy;
        this.permission = new MapRFsPermission(proxy.mode, proxy.hasAce);
        this.symlink = proxy.symlink != null ? new Path(proxy.symlink) : null;
        this.path = new Path(scheme, proxy.authority, proxy.pathStr);
    }

    public long getLength() {
        return this.internalStatus.length;
    }

    public boolean getCompress() {
        return this.internalStatus.compress;
    }

    public String getCompressionName() {
        return this.internalStatus.compressionName;
    }

    public boolean hasAce() {
        return this.internalStatus.hasAce;
    }

    public String getAceString() {
        if (this.internalStatus.hasAce) {
            return "+";
        }
        return " ";
    }

    public String getCompressString() {
        if (!this.getCompress()) {
            return " U";
        }
        String compName = this.getCompressionName();
        if (compName.equals("lzf")) {
            return " L";
        }
        if (compName.equals("zlib")) {
            return " z";
        }
        return " Z";
    }

    public boolean getWireSecurityEnabled() {
        return this.internalStatus.wireSecurityEnabled;
    }

    public String getWireSecurity() {
        if (this.internalStatus.wireSecurityEnabled) {
            return " E";
        }
        return " U";
    }

    public boolean getDiskFlushEnabled() {
        return this.internalStatus.diskFlushEnabled;
    }

    public String getDiskFlush() {
        if (this.internalStatus.diskFlushEnabled) {
            return " F";
        }
        return " U";
    }

    public String getAudit() {
        if (this.internalStatus.audit) {
            return " A";
        }
        return " U";
    }

    public String getType() {
        return this.internalStatus.type;
    }

    public String getsubType() {
        return this.internalStatus.subType;
    }

    public int getMode() {
        return this.internalStatus.mode;
    }

    public int getNlink() {
        return this.internalStatus.nlink;
    }

    public int getCid() {
        return this.internalStatus.cid;
    }

    public int getCinum() {
        return this.internalStatus.cinum;
    }

    public int getUniq() {
        return this.internalStatus.uniq;
    }

    public long getBlocks() {
        return this.internalStatus.nblocks;
    }

    public String getFidStr() {
        return this.internalStatus.cid + "." + this.internalStatus.cinum + "." + this.internalStatus.uniq;
    }

    public String getPFidStr() {
        if (this.internalStatus.pcid > 0) {
            return this.internalStatus.pcid + "." + this.internalStatus.pcinum + "." + this.internalStatus.puniq;
        }
        return this.internalStatus.cid + "." + this.internalStatus.pcinum + "." + this.internalStatus.puniq;
    }

    public int getMajor() {
        return this.internalStatus.major;
    }

    public int getMinor() {
        return this.internalStatus.minor;
    }

    public String getVolName() {
        return this.internalStatus.volInfo != null ? this.internalStatus.volInfo.name : null;
    }

    public int getVolLinkAttrType() {
        return this.internalStatus.volInfo != null ? this.internalStatus.volInfo.linkAttrType : 0;
    }

    public long getLen() {
        return this.internalStatus.length;
    }

    public boolean isDir() {
        return this.internalStatus.isdir;
    }

    public boolean isDirectory() {
        return this.isDir();
    }

    public boolean isFile() {
        return !this.isDir() && !this.isSymlink() && !this.isTable();
    }

    public boolean isRegular() {
        return this.internalStatus.isRegular;
    }

    public boolean isVol() {
        return this.internalStatus.volInfo != null;
    }

    public JNIFileStatus.VolumeInfo getVolumeInfo() {
        return this.internalStatus.volInfo;
    }

    public boolean isTable() {
        return this.internalStatus.isTable;
    }

    public long getBlockSize() {
        if (this.internalStatus.chunkSize == 0L) {
            return 0x40000000L;
        }
        return this.internalStatus.chunkSize;
    }

    public long getChunkSize() {
        return this.internalStatus.chunkSize;
    }

    public short getReplication() {
        return this.internalStatus.block_replication;
    }

    public long getModificationTime() {
        return this.internalStatus.modification_time;
    }

    public long getAccessTime() {
        return this.internalStatus.access_time;
    }

    public long getChangeTime() {
        return this.internalStatus.change_time;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    public String getOwner() {
        return this.internalStatus.owner;
    }

    public String getGroup() {
        return this.internalStatus.group;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path p) {
        this.path = p;
    }

    protected void setPermission(FsPermission permission) {
        this.permission = permission == null ? FsPermission.getDefault() : permission;
    }

    protected void setOwner(String owner) {
        this.internalStatus.owner = owner == null ? "" : owner;
    }

    protected void setGroup(String group) {
        this.internalStatus.group = group == null ? "" : group;
    }

    public boolean isSymlink() {
        return this.symlink != null;
    }

    public Path getSymlink() throws IOException {
        if (!this.isSymlink()) {
            throw new IOException("Path " + this.path + " is not a symbolic link");
        }
        return this.symlink;
    }

    public void setSymlink(Path p) {
        this.symlink = p;
    }

    private boolean compareFids(MapRFileStatus other) {
        return this.getCid() == other.getCid() && this.getCinum() == other.getCinum() && this.getUniq() == other.getUniq();
    }

    public long getOffset() {
        return this.internalStatus.offset;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.getPath().toString());
        out.writeLong(this.internalStatus.length);
        out.writeBoolean(this.internalStatus.isdir);
        out.writeShort(this.internalStatus.block_replication);
        out.writeLong(this.internalStatus.chunkSize);
        out.writeLong(this.internalStatus.modification_time);
        out.writeLong(this.internalStatus.access_time);
        this.permission.write(out);
        Text.writeString((DataOutput)out, (String)this.internalStatus.owner);
        Text.writeString((DataOutput)out, (String)this.internalStatus.group);
        out.writeBoolean(this.isSymlink());
        if (this.isSymlink()) {
            Text.writeString((DataOutput)out, (String)this.getSymlink().toString());
        }
    }

    public void readFields(DataInput in) throws IOException {
        String strPath = Text.readString((DataInput)in);
        this.path = new Path(strPath);
        this.internalStatus.length = in.readLong();
        this.internalStatus.isdir = in.readBoolean();
        this.internalStatus.block_replication = in.readShort();
        this.internalStatus.chunkSize = in.readLong();
        this.internalStatus.modification_time = in.readLong();
        this.internalStatus.access_time = in.readLong();
        this.permission.readFields(in);
        this.internalStatus.owner = Text.readString((DataInput)in);
        this.internalStatus.group = Text.readString((DataInput)in);
        this.symlink = in.readBoolean() ? new Path(Text.readString((DataInput)in)) : null;
    }

    public int compareTo(Object o) {
        FileStatus other = (FileStatus)o;
        return this.getPath().compareTo(other.getPath());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStatus)) {
            return false;
        }
        FileStatus other = (FileStatus)o;
        return this.getPath().equals((Object)other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public static MapRFileStatus getStatus(JNIFileStatus status) {
        return MapRFileStatus.getStatus(status, "maprfs");
    }

    public static MapRFileStatus getStatus(JNIFileStatus status, String scheme) {
        if (status == null) {
            return null;
        }
        return new MapRFileStatus(status, scheme);
    }

    public static MapRFileStatus[] getStatus(JNIFileStatus[] statuses) {
        return MapRFileStatus.getStatus(statuses, "maprfs");
    }

    public static MapRFileStatus[] getStatus(JNIFileStatus[] statuses, String scheme) {
        if (statuses == null) {
            return null;
        }
        MapRFileStatus[] s2 = new MapRFileStatus[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            s2[i] = new MapRFileStatus(statuses[i], scheme);
        }
        return s2;
    }
}

