/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.org.apache.hadoop.metrics;

import com.mapr.org.apache.hadoop.classification.InterfaceAudience;
import com.mapr.org.apache.hadoop.classification.InterfaceStability;
import com.mapr.org.apache.hadoop.metrics.ContextFactory;
import com.mapr.org.apache.hadoop.metrics.MetricsContext;
import com.mapr.org.apache.hadoop.metrics.MetricsRecord;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class MetricsUtil {
    public static final Logger LOG = LoggerFactory.getLogger(MetricsUtil.class);
    private static final String hostName = MetricsUtil.getHostName();

    private MetricsUtil() {
    }

    public static MetricsContext getContext(String contextName) {
        return MetricsUtil.getContext(contextName, contextName);
    }

    public static MetricsContext getContext(String refName, String contextName) {
        MetricsContext metricsContext;
        try {
            metricsContext = ContextFactory.getFactory().getContext(refName, contextName);
            if (!metricsContext.isMonitoring()) {
                metricsContext.startMonitoring();
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to create metrics context " + contextName, (Throwable)ex);
            metricsContext = ContextFactory.getNullContext(contextName);
        }
        return metricsContext;
    }

    public static MetricsRecord createRecord(MetricsContext context, String recordName) {
        MetricsRecord metricsRecord = context.createRecord(recordName);
        metricsRecord.setTag("hostName", hostName);
        return metricsRecord;
    }

    private static String getHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOG.info("Unable to obtain hostName", (Throwable)ex);
            hostName = "unknown";
        }
        return hostName;
    }
}

