/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.tables;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsUtil;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.CFPermissions;
import com.mapr.fs.tables.ExtIndexDesc;
import com.mapr.fs.tables.ExtIndexFieldDesc;
import com.mapr.fs.tables.FamilyNotFoundException;
import com.mapr.fs.tables.TableProperties;
import com.mapr.fs.tables.TabletStats;
import com.mapr.fs.tables.impl.ExtIndexDescImpl;
import com.mapr.fs.tables.impl.ExtIndexFieldDescImpl;
import com.mapr.fs.tables.impl.SchemaUtil;
import com.mapr.fs.util.Fids;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.yaml.snakeyaml.Yaml;

public class MapRAdmin {
    private static final Log LOG = LogFactory.getLog(MapRAdmin.class);
    private final MapRFileSystem fs_;

    public MapRAdmin(MapRFileSystem fs) {
        this.fs_ = fs;
    }

    public List<CFPermissions> getFamilyPermissions(Path table) throws IOException {
        ArrayList<CFPermissions> cfPermissions = new ArrayList<CFPermissions>();
        for (Dbserver.ColumnFamilyAttr cfa : this.fs_.listColumnFamily(table, true)) {
            CFPermissions familyPerm = new CFPermissions(cfa.getSchFamily().getName());
            cfPermissions.add(familyPerm);
            for (Dbserver.AccessControlExpression ace : cfa.getAcesList()) {
                String expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
                familyPerm.addCFPermission((String)AceHelper.cfPermissionMap.get(ace.getAccessType()), expr);
            }
            for (int i = 0; i < cfa.getColumnAttrCount(); ++i) {
                Dbserver.ColumnAttr col = cfa.getColumnAttr(i);
                for (Dbserver.AccessControlExpression ace : col.getAcesList()) {
                    String expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
                    String colName = Bytes.toStringBinary((byte[])col.getQualifier().toByteArray());
                    if (!cfa.getSchFamily().getName().equals("default")) {
                        colName = MapRFsUtil.getUnPrefixedColName(colName);
                    }
                    familyPerm.addColPermission(colName, (String)AceHelper.colPermissionMap.get(ace.getAccessType()), expr);
                }
            }
        }
        return cfPermissions;
    }

    public void setFamilyPermissions(Path table, String family, CFPermissions cfPermissions) throws IOException {
        Dbserver.ColumnFamilyAttr familyAttr = this.getColumnFamily(table, family, true);
        Dbserver.ColumnFamilyAttr.Builder cfAttrBuilder = familyAttr.toBuilder();
        cfAttrBuilder.clearSchFamily();
        cfAttrBuilder.clearJsonFamilyPath();
        final Map<String, String> cfPerms = cfPermissions.getCfPermissions();
        if (cfPerms.size() > 0) {
            ArrayList cfAces = AceHelper.getCfPermission((AceHelper.DBPermission)new AceHelper.DBPermission(){

                public String getCliParam(String key) throws IOException {
                    return (String)cfPerms.get(key);
                }
            });
            Collection<Dbserver.AccessControlExpression> mergedAces = this.mergeAces(cfAttrBuilder.getAcesList(), cfAces);
            cfAttrBuilder.clearAces().addAllAces(mergedAces);
        }
        if (cfPermissions.getColumnNames().size() > 0) {
            List columnAttrs = familyAttr.getColumnAttrList();
            for (String columnName : cfPermissions.getColumnNames()) {
                final Map<String, String> colPerms = cfPermissions.getColPermission(columnName);
                ArrayList colAces = AceHelper.getColumnPermission((AceHelper.DBPermission)new AceHelper.DBPermission(){

                    public String getCliParam(String key) throws IOException {
                        return (String)colPerms.get(key);
                    }
                });
                ByteString colByteName = null;
                colByteName = family.equals("default") ? ByteString.copyFrom((byte[])Bytes.toBytesBinary((String)columnName)) : ByteString.copyFrom((byte[])Bytes.toBytesBinary((String)MapRFsUtil.getPrefixedColName(columnName)));
                int index = this.getColumnAttrIndex(colByteName, columnAttrs);
                if (index == -1) {
                    Dbserver.ColumnAttr.Builder builder = Dbserver.ColumnAttr.newBuilder().setQualifier(colByteName).addAllAces((Iterable)colAces);
                    cfAttrBuilder.addColumnAttr(builder.build());
                    continue;
                }
                Dbserver.ColumnAttr columnAttr = (Dbserver.ColumnAttr)columnAttrs.get(index);
                Collection<Dbserver.AccessControlExpression> mergedAces = this.mergeAces(columnAttr.getAcesList(), colAces);
                Dbserver.ColumnAttr.Builder builder = columnAttr.toBuilder().clearAces().addAllAces(mergedAces);
                cfAttrBuilder.setColumnAttr(index, builder);
            }
        }
        this.fs_.modifyColumnFamily(table, family, cfAttrBuilder.build());
    }

    public void deleteColumnPermission(Path table, String column, String permission) throws IOException {
        Dbserver.DBAccessType accessType;
        String family = column;
        String qualifier = null;
        if (column.contains(":")) {
            String[] parts = column.split(":");
            family = parts[0];
            qualifier = parts[1];
        }
        Dbserver.ColumnFamilyAttr familyAttr = this.getColumnFamily(table, family, true);
        Dbserver.ColumnFamilyAttr.Builder cfAttrBuilder = familyAttr.toBuilder().clearSchFamily();
        if (qualifier != null) {
            accessType = (Dbserver.DBAccessType)AceHelper.colAccessTypeMap.get(permission);
            List columnAttrs = familyAttr.getColumnAttrList();
            ByteString colByteName = ByteString.copyFrom((byte[])Bytes.toBytesBinary((String)qualifier));
            int index = this.getColumnAttrIndex(colByteName, columnAttrs);
            if (index == -1) {
                throw new IllegalArgumentException(String.format("No permission is set on column '%s' of table '%s'.", column, table));
            }
            Dbserver.ColumnAttr columnAttr = (Dbserver.ColumnAttr)columnAttrs.get(index);
            Collection<Dbserver.AccessControlExpression> newAces = this.removeAce(columnAttr.getAcesList(), accessType, true);
            Dbserver.ColumnAttr.Builder builder = columnAttr.toBuilder().clearAces().addAllAces(newAces);
            cfAttrBuilder.setColumnAttr(index, builder);
        } else {
            accessType = (Dbserver.DBAccessType)AceHelper.cfAccessTypeMap.get(permission);
            Collection<Dbserver.AccessControlExpression> newAces = this.removeAce(cfAttrBuilder.getAcesList(), accessType, false);
            cfAttrBuilder.clearAces().addAllAces(newAces);
        }
        this.fs_.modifyColumnFamily(table, family, cfAttrBuilder.build());
    }

    public Map<String, String> getTablePermissions(Path table) throws IOException {
        String expr;
        HashMap<String, String> permissions = new HashMap<String, String>();
        TableProperties tableProp = this.fs_.getTableProperties(table);
        Dbserver.TableAces aces = tableProp.getAces();
        for (Dbserver.AccessControlExpression ace : aces.getAcesList()) {
            expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
            permissions.put((String)AceHelper.tblPermissionMap.get(ace.getAccessType()), expr);
        }
        for (Dbserver.AccessControlExpression ace : aces.getDefaultColumnFamilyAcesList()) {
            expr = AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8());
            permissions.put((String)AceHelper.cfDefPermissionMap.get(ace.getAccessType()), expr);
        }
        return permissions;
    }

    public void setTablePermissions(Path table, final Map<String, String> permissions) throws IOException {
        this.fs_.modifyTableAttr(table, Dbserver.TableAttr.newBuilder().build(), new AceHelper.DBPermission(){

            public String getCliParam(String key) throws IOException {
                return (String)permissions.get(key);
            }
        });
    }

    public void deleteTablePermission(Path table, String permission) throws IOException {
        Map<String, String> permissions = this.getTablePermissions(table);
        if (!permissions.containsKey(permission)) {
            throw new IllegalArgumentException(String.format("Permission '%s' is not set on table '%s'.", permission, table));
        }
        permissions.put(permission, "");
        this.setTablePermissions(table, permissions);
    }

    public void split(Path tablePath, String fid) throws IOException {
        List<Dbserver.TabletDesc> nextSet;
        if (fid != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Splitting table %s, tablet %s.", tablePath.toString(), fid));
            }
            this.fs_.splitTableRegion(tablePath, fid, true);
            return;
        }
        MapRTabletScanner scanner = this.fs_.getTabletScanner(tablePath, null);
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                String fidString = Fids.fidToString(tablet.getFid());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Splitting table %s, tablet %s.", tablePath.toString(), fidString));
                }
                this.fs_.splitTableRegion(tablePath, fidString, true);
            }
        }
    }

    public long getNumRows(String tablePath) throws IOException {
        return this.getNumRows(new Path(tablePath));
    }

    public long getNumRows(Path tablePath) throws IOException {
        return this.getNumRows(tablePath, null);
    }

    public long getNumRows(Path tablePath, String indexFid) throws IOException {
        try {
            long totalNumRows = 0L;
            long totalNumTablets = 0L;
            long GET_STATS_MAX_TABLETS = 100L;
            long MIN_NUM_ROWS_PER_TABLET = 10000L;
            if (this.fs_.getMapRFileStatus(tablePath).isTable()) {
                TabletStats tabletStats = new TabletStats(this.fs_, tablePath, indexFid);
                List<Dbserver.TabletDesc> tablets = tabletStats.getTablets(0, 100);
                if (tablets == null) {
                    throw new IOException("Unable to list all tablets for table " + tablePath);
                }
                totalNumTablets = tabletStats.getNumTablets();
                for (Dbserver.TabletDesc tablet : tablets) {
                    try {
                        Dbserver.TabletStatResponse tsr = tabletStats.getTabletStatResponse(tablet);
                        if (tsr == null || !tsr.hasUsage()) continue;
                        Dbserver.SpaceUsage su = tsr.getUsage();
                        totalNumRows += su.getNumRows();
                    }
                    catch (Exception e) {
                        throw new IOException("Error fetching tablet stats", e);
                    }
                }
                if (totalNumRows == 0L) {
                    return 10000L * totalNumTablets;
                }
                long numTablets = totalNumTablets < 100L ? totalNumTablets : 100L;
                long numRowsPerTablet = totalNumRows / 100L;
                totalNumRows = Math.max(totalNumRows, numRowsPerTablet * numTablets);
            }
            return totalNumRows;
        }
        catch (Exception e) {
            throw new IOException("Error accessing the maprfs", e);
        }
    }

    public Dbserver.ColumnFamilyAttr getColumnFamily(Path table, String cfName, boolean wantAce) throws IOException {
        List<Dbserver.ColumnFamilyAttr> families = this.fs_.listColumnFamily(table, wantAce, false);
        if (families != null && families.size() > 0) {
            for (Dbserver.ColumnFamilyAttr cf : families) {
                if (!cf.getSchFamily().getName().equals(cfName)) continue;
                return cf;
            }
        }
        throw new FamilyNotFoundException("Column family '" + cfName + "' does not exist for table '" + table + "'");
    }

    private Collection<Dbserver.AccessControlExpression> removeAce(List<Dbserver.AccessControlExpression> originalAces, Dbserver.DBAccessType accessType, boolean isForColumn) {
        ArrayList<Dbserver.AccessControlExpression> newAces = new ArrayList<Dbserver.AccessControlExpression>();
        for (Dbserver.AccessControlExpression ace : originalAces) {
            if (ace.getAccessType() != accessType) {
                newAces.add(ace);
                continue;
            }
            if (isForColumn) continue;
            newAces.add(Dbserver.AccessControlExpression.newBuilder().setAccessType(accessType).setBooleanExpression(ByteString.copyFromUtf8((String)"")).build());
        }
        return newAces;
    }

    private int getColumnAttrIndex(ByteString colByteName, List<Dbserver.ColumnAttr> columnAttrs) {
        if (columnAttrs != null) {
            for (int index = 0; index < columnAttrs.size(); ++index) {
                Dbserver.ColumnAttr columnAttr = columnAttrs.get(index);
                if (!columnAttr.getQualifier().equals((Object)colByteName)) continue;
                return index;
            }
        }
        return -1;
    }

    private Collection<Dbserver.AccessControlExpression> mergeAces(List<Dbserver.AccessControlExpression> originalAces, List<Dbserver.AccessControlExpression> overrideAces) {
        HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression> aceMap = new HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression>();
        for (Dbserver.AccessControlExpression a : originalAces) {
            aceMap.put(a.getAccessType(), a);
        }
        for (Dbserver.AccessControlExpression a : overrideAces) {
            aceMap.put(a.getAccessType(), a);
        }
        return aceMap.values();
    }

    public Collection<ExtIndexDesc> getTableExternalIndexes(Path tablePath, boolean refreshNow) throws IOException {
        assert (!this.fs_.isJsonTable(tablePath)) : "getTableExternalIndexes() is only supported for Binary Tables";
        List<Dbserver.ColumnFamilyAttr> colList = this.fs_.listColumnFamily(tablePath, false);
        HashSet familySet = Sets.newHashSet();
        for (Dbserver.ColumnFamilyAttr columnFamilyAttr : colList) {
            familySet.add(columnFamilyAttr.getSchFamily().getName());
        }
        StringBuilder fieldBuilder = new StringBuilder(100);
        HashSet replicatedFields = Sets.newHashSet();
        ImmutableList.Builder indexListBuilder = ImmutableList.builder();
        Dbserver.TableReplicaListResponse resp = this.fs_.listTableReplicas(tablePath, false, refreshNow, false);
        for (Dbserver.TableReplicaDesc rd : resp.getReplicasList()) {
            if (!rd.hasExternal() || !rd.getExternal() || !rd.hasIndexedFields() || !this.fs_.exists(new Path(rd.getTablePath())) || !rd.getTablePath().startsWith("/opt/external/elasticsearch/replicas")) continue;
            String replicaClusterName = null;
            String replicaIndexName = null;
            try (FSDataInputStream is = this.fs_.open(new Path(rd.getTablePath()));){
                Yaml yaml = new Yaml();
                Map confMap = (Map)yaml.load((InputStream)is);
                replicaClusterName = (String)confMap.get("es.target.name");
                replicaIndexName = (String)confMap.get("es.index.name") + "/" + (String)confMap.get("es.index.type");
            }
            replicatedFields.clear();
            if (rd.getQualifiersCount() > 0) {
                for (Dbserver.Qualifier qual : rd.getQualifiersList()) {
                    String familyName = SchemaUtil.familyIdToName(colList, qual.getFamily());
                    if (qual.getQualifiersCount() > 0) {
                        for (ByteString column : qual.getQualifiersList()) {
                            replicatedFields.add(familyName + ":" + column.toStringUtf8());
                        }
                        continue;
                    }
                    replicatedFields.add(familyName);
                }
            } else {
                replicatedFields.addAll(familySet);
            }
            String indexedColList = rd.getIndexedFields();
            for (String indexedFields : indexedColList.split(",")) {
                HashSet coveredFields = Sets.newHashSet((Iterable)replicatedFields);
                ExtIndexDescImpl.Builder indexDescBuilder = new ExtIndexDescImpl.Builder().setSystemName("elastic").setClusterName(replicaClusterName).setIndexName(replicaIndexName).setExternal(true).setDisabled(rd.getIsPaused()).setUnique(false);
                for (String indexedField : indexedFields.split(";")) {
                    fieldBuilder.setLength(0);
                    String[] fieldParts = indexedField.split(":", 2);
                    fieldBuilder.append(fieldParts[0].trim());
                    if (fieldParts.length > 1) {
                        fieldBuilder.append(":").append(fieldParts[1].trim());
                    }
                    ExtIndexFieldDescImpl indexFieldDesc = new ExtIndexFieldDescImpl(fieldBuilder.toString(), ExtIndexFieldDesc.Order.Asc, false, false, null);
                    indexDescBuilder.addIndexedField(indexFieldDesc);
                    coveredFields.remove(indexFieldDesc.getFieldName());
                }
                for (String coveredField : coveredFields) {
                    indexDescBuilder.addCoveredFields(new ExtIndexFieldDescImpl(coveredField, ExtIndexFieldDesc.Order.None, false, false, null));
                }
                indexListBuilder.add((Object)indexDescBuilder.build());
            }
        }
        return indexListBuilder.build();
    }
}

