/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.clicommands;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.FileAceEntry;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.jni.JNIFileStatus;
import com.mapr.fs.jni.JNIFileTierStatus;
import com.mapr.fs.jni.MapRFileCount;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Security;
import com.mapr.fs.tables.TableProperties;
import com.mapr.security.UnixUserGroupHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MapRCliCommands
extends Configured
implements Tool,
AceHelper.FSPermission {
    private static final int MAX_SYMLINK_HEIGHT = 8;
    private static final int MAX_BLOCKS_IN_ONE_GO = 100;
    private static final Log LOG = LogFactory.getLog(MapRCliCommands.class);
    private int symlinkHeight;
    public static int RecursiveBit = 1;
    public static int DirOnlyBit = 2;
    public static int DiskBlockOnlyBit = 4;
    public static int DereferenceSymlinkBit = 8;
    public static int SingleVolumeBit = 16;
    public static int FidBit = 32;
    public static int NoFidMap = 64;
    public static int LiteLsBit = 128;
    protected static MapRFileSystem fs;
    private Configuration conf;
    private static UnixUserGroupHelper ui;
    public static final SimpleDateFormat dateForm;
    protected static final SimpleDateFormat modifFmt;
    public static final String multiAceArg = "aces";
    public static final Map<Common.FSAccessType, String> fsAccessTypeMap;
    BasicParser parser;
    CommandLine cmdLine;
    private static final String SETINHERIT = "setinherit";
    private static final String PRESERVEMODEBITS = "preservemodebits";
    private static final Comparator<MapRFileStatus> fileStatusComparator;

    public MapRCliCommands(Configuration conf) {
        super(conf);
        fs = null;
        this.conf = conf;
    }

    public MapRCliCommands() {
        this(null);
    }

    protected void init() throws IOException {
        if (this.conf == null) {
            this.conf = this.getConf();
        }
        this.conf.setQuietMode(true);
    }

    private Path verifyAndGetPath(String srcf) throws IOException {
        Path p = new Path(srcf);
        if (!this.isMapRFsPath(p)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        return p;
    }

    private boolean isMapRFsPath(Path p) throws IOException {
        FileSystem f = p.getFileSystem(this.conf);
        if (f.getUri().getScheme().toString().equals("maprfs")) {
            fs = (MapRFileSystem)f;
            return true;
        }
        return false;
    }

    private int ls(String cmd, String srcf, int lsFlag) throws Exception {
        int numOfErrors;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(cmd + " srcf=" + srcf + " flag=" + lsFlag));
        }
        FileStatus[] srcs = null;
        if ((lsFlag & FidBit) != 0) {
            this.isMapRFsPath(new Path("maprfs:///dummy"));
            String mntPath = fs.getMountPathFid(srcf);
            if (mntPath == null) {
                throw new FileNotFoundException(srcf + ": No path for fid");
            }
            srcs = new FileStatus[]{fs.getFileStatus(new Path(mntPath))};
        } else {
            Path srcPath = new Path(srcf);
            if (!this.isMapRFsPath(srcPath)) {
                throw new FileNotFoundException("Not a MapRFs uri " + srcf);
            }
            srcs = fs.globStatus(srcPath);
        }
        if (srcs == null) {
            throw new FileNotFoundException("Cannot access " + srcf + ": No such file or directory.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("globStatus: " + srcs.length));
        }
        return (numOfErrors = this.ls(cmd, srcs, lsFlag)) == 0 ? 0 : -1;
    }

    private String getTableType(MapRFileStatus file) throws Exception {
        TableProperties tprop = fs.getTableProperties(file.getPath());
        if (tprop.getAttr().getIsMarlinTable()) {
            return "m";
        }
        return "t";
    }

    private int ls(String cmd, FileStatus[] src, int lsFlag) throws Exception {
        boolean isLiteLs;
        boolean dironly = (lsFlag & DirOnlyBit) != 0;
        boolean recursive = (lsFlag & RecursiveBit) != 0;
        boolean followlinks = (lsFlag & DereferenceSymlinkBit) != 0;
        boolean singleVolume = (lsFlag & SingleVolumeBit) != 0;
        boolean printfidmap = (lsFlag & NoFidMap) == 0 || (lsFlag & DiskBlockOnlyBit) != 0;
        boolean bl = isLiteLs = (lsFlag & LiteLsBit) != 0;
        if (isLiteLs) {
            return MapRCliCommands.shellListStatusLite(cmd, src);
        }
        ShellListResult res = MapRCliCommands.shellListStatus(cmd, src, dironly, recursive);
        MapRFileStatus[] items = res.lsResult;
        int lsBufferMaxLength = 0xA00000;
        int numOfErrors = res.lsErrors;
        if (!recursive && items.length != 0) {
            System.out.println("Found " + items.length + " items");
        }
        int maxReplication = 3;
        int maxLen = 10;
        int maxBlockLen = 10;
        int maxOwner = 0;
        int maxGroup = 0;
        boolean getBlockError = false;
        for (int i = 0; i < items.length; ++i) {
            MapRFileStatus stat = items[i];
            int replication = String.valueOf(stat.getReplication()).length();
            int len = String.valueOf(stat.getLen()).length();
            int blockLen = String.valueOf(stat.getChunkSize()).length();
            int owner = String.valueOf(stat.getOwner()).length();
            int group = String.valueOf(stat.getGroup()).length();
            if (replication > maxReplication) {
                maxReplication = replication;
            }
            if (len > maxLen) {
                maxLen = len;
            }
            if (blockLen > maxBlockLen) {
                maxBlockLen = blockLen;
            }
            if (owner > maxOwner) {
                maxOwner = owner;
            }
            if (group <= maxGroup) continue;
            maxGroup = group;
        }
        StringBuilder fmt = new StringBuilder();
        fmt.append("%s%s%s%s%s%s%s ");
        fmt.append("%" + maxReplication + "s ");
        fmt.append((String)(maxOwner > 0 ? "%-" + maxOwner + "s " : "%s"));
        fmt.append((String)(maxGroup > 0 ? "%-" + maxGroup + "s " : "%s"));
        fmt.append("%" + maxLen + "d ");
        fmt.append("%s ");
        fmt.append("%" + maxBlockLen + "d ");
        String lineFormat = fmt.toString();
        StringBuilder lsBuilder = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            String fileType;
            int vCid = 0;
            int vCinum = 0;
            int vUniq = 0;
            int volLinkAttrType = 0;
            String volName = null;
            long totalDiskBlocks = 0L;
            MapRBlockLocation[] blocks = null;
            MapRFileStatus stat = items[i];
            boolean isVolumeDir = stat.isVol();
            if (isVolumeDir) {
                fileType = "v";
                JNIFileStatus.VolumeInfo volInfo = stat.getVolumeInfo();
                vCid = volInfo.getCid();
                vCinum = volInfo.getCinum();
                vUniq = volInfo.getUniq();
                volName = volInfo.getName();
                volLinkAttrType = volInfo.getVolLinkAttrType();
            } else {
                fileType = stat.isDir() ? "d" : (stat.isSymlink() ? "l" : (stat.isTable() ? this.getTableType(stat) : "-"));
            }
            Path cur = stat.getPath();
            if (followlinks && stat.isSymlink()) {
                if (this.symlinkHeight < 8) {
                    Path symlinkPath = stat.getSymlink();
                    String symlinkStr = symlinkPath.isAbsolute() ? symlinkPath.toString() : new Path(cur.getParent(), symlinkPath).toString();
                    ++this.symlinkHeight;
                    numOfErrors += this.ls(cmd, symlinkStr, lsFlag);
                    --this.symlinkHeight;
                } else {
                    System.out.println("Cannot access " + cur + ": Too many levels of symbolic links");
                }
            } else {
                boolean skipVolumeLs;
                lsBuilder.append(String.format(lineFormat, fileType, stat.getPermission(), stat.getAceString(), stat.getCompressString(), stat.getWireSecurity(), stat.getAudit(), stat.getDiskFlush(), !stat.isDir() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), stat.getLen(), dateForm.format(new Date(stat.getModificationTime())), stat.getChunkSize()));
                if (stat.isSymlink()) {
                    lsBuilder.append(cur.toUri().getPath() + " -> " + stat.getSymlink().toString() + "\n");
                } else {
                    lsBuilder.append(cur.toUri().getPath() + "\n");
                }
                if (printfidmap) {
                    long blockIndex = 0L;
                    long startOffset = 0L;
                    long fileLengthInOneGo = stat.getChunkSize() > 0L ? stat.getChunkSize() * 100L : stat.getLen();
                    do {
                        try {
                            blocks = null;
                            blocks = fs.getMapRFileBlockLocations(stat, startOffset, fileLengthInOneGo, true, true, true);
                            if (blocks != null && (lsFlag & DiskBlockOnlyBit) != 0) {
                                for (MapRBlockLocation b : blocks) {
                                    totalDiskBlocks += b.getNumDiskBlocks();
                                }
                            }
                            String fmap = this.fidmap(blocks, maxLen, volName, volLinkAttrType, vCid, vCinum, vUniq, (lsFlag & DiskBlockOnlyBit) != 0, blockIndex);
                            lsBuilder.append(fmap);
                        }
                        catch (Exception e) {
                            System.out.println("\nException while fetching blocklocations for " + cur.toUri().getPath() + ", error: " + e.getMessage());
                            ++numOfErrors;
                            getBlockError = true;
                            break;
                        }
                        if (!stat.isRegular() || blocks == null) break;
                        MapRBlockLocation finalBlock = blocks[blocks.length - 1];
                        long endOffset = finalBlock.getOffset() + finalBlock.getLength() - 1L;
                        startOffset = endOffset + 1L;
                        blockIndex += (long)blocks.length;
                    } while (startOffset < stat.getLen());
                    if (getBlockError) {
                        getBlockError = false;
                        if (lsBuilder.length() <= 0xA00000 && i != items.length - 1) continue;
                        System.out.println(lsBuilder.toString());
                        if (i == items.length - 1) continue;
                        lsBuilder = new StringBuilder();
                        continue;
                    }
                    if ((lsFlag & DiskBlockOnlyBit) != 0) {
                        lsBuilder.append("\t       Total Disk Blocks : " + totalDiskBlocks + "\n");
                    }
                }
                boolean bl2 = skipVolumeLs = isVolumeDir && singleVolume;
                if (recursive && stat.isDir() && !skipVolumeLs) {
                    numOfErrors += this.ls(cmd, new MapRFileStatus[]{stat}, lsFlag);
                } else if (stat.isTable() && printfidmap) {
                    try {
                        String tmap = this.printTablets(cur);
                        lsBuilder.append(tmap);
                    }
                    catch (Exception e) {
                        System.out.println("\nCannot display tablets for " + cur + ", Error: " + e.getMessage());
                        ++numOfErrors;
                    }
                }
            }
            if (lsBuilder.length() <= 0xA00000 && i != items.length - 1) continue;
            System.out.println(lsBuilder.toString());
            if (i == items.length - 1) continue;
            lsBuilder = new StringBuilder();
        }
        return numOfErrors;
    }

    private static ShellListResult shellListStatus(String cmd, FileStatus[] statusArray, boolean dironly, boolean recursive) {
        int lsErrors = 0;
        LinkedList<MapRFileStatus> result = new LinkedList<MapRFileStatus>();
        for (FileStatus src : statusArray) {
            Path path = src.getPath();
            if (!src.isDir() || dironly) {
                result.add((MapRFileStatus)src);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Adding path to result: dir=" + src.isDir() + " " + path));
                continue;
            }
            try {
                MapRFileStatus[] files = fs.listMapRStatus(path, true, !recursive);
                if (files == null) {
                    ++lsErrors;
                    System.err.println(cmd + ": could not get listing for '" + path + "'");
                    continue;
                }
                for (MapRFileStatus f : files) {
                    result.add(f);
                }
            }
            catch (IOException e) {
                ++lsErrors;
                System.err.println(cmd + ": could not get listing for '" + path + "' : " + e.getMessage().split("\n")[0]);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ShellListResult: statuses=" + result.size() + " errors=" + lsErrors));
        }
        MapRFileStatus[] resultArray = new MapRFileStatus[result.size()];
        result.toArray(resultArray);
        Arrays.sort(resultArray, fileStatusComparator);
        return new ShellListResult(resultArray, lsErrors);
    }

    private static String getFileType(MapRFileStatus file) throws Exception {
        if (file.isSymlink()) {
            return "l";
        }
        if (file.isDir()) {
            return "d";
        }
        if (file.isTable()) {
            TableProperties tprop = fs.getTableProperties(file.getPath());
            if (tprop.getAttr().getIsMarlinTable()) {
                return "m";
            }
            return "t";
        }
        return "-";
    }

    private static int shellListStatusLite(String cmd, FileStatus[] statusArray) throws Exception {
        int lsErrors = 0;
        for (FileStatus src : statusArray) {
            Path path = src.getPath();
            long cookie = 0L;
            if (!src.isDir()) {
                MapRFileStatus stat = (MapRFileStatus)src;
                if (stat.isSymlink()) {
                    System.out.println(MapRCliCommands.getFileType(stat) + " " + stat.getFidStr() + "\t" + stat.getPath().toUri().getPath() + " -> " + stat.getSymlink().toString());
                    continue;
                }
                System.out.println(MapRCliCommands.getFileType(stat) + " " + stat.getFidStr() + "\t" + stat.getPath().toUri().getPath());
                continue;
            }
            URI u = fs.makeAbsolute(path).toUri();
            String authority = u.getAuthority();
            String rawPath = u.getPath();
            if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
                MapRFileStatus[] statuses;
                for (MapRFileStatus stat : statuses = fs.slashReaddir(authority)) {
                    MapRBlockLocation[] blocks = null;
                    Path cur = stat.getPath();
                    try {
                        blocks = fs.getMapRFileBlockLocations(stat, 0L, 65536L, true, true, true);
                        System.out.println("d " + blocks[0].getCid() + "." + blocks[0].getCinum() + "." + blocks[0].getUniq() + "\t" + cur.toUri().getPath());
                    }
                    catch (Exception e) {
                        System.out.println("\nException while fetching blocklocations for " + cur.toUri().getPath() + ", error: " + e.getMessage());
                        ++lsErrors;
                    }
                }
                continue;
            }
            if (fs.listDirLite(path) == 0) continue;
            ++lsErrors;
        }
        return lsErrors;
    }

    private String fidmap(MapRBlockLocation[] blocks, int maxLen, String volName, int volLinkAttrType, int vCid, int vCinum, int vUniq, boolean needNumDiskBlocks, long startBlock) throws IOException {
        StringBuilder fmapBuilder = new StringBuilder();
        if (blocks == null || blocks.length == 0) {
            return null;
        }
        String volLinkAttrName = null;
        if (volName != null) {
            volLinkAttrName = volLinkAttrType == 1 ? "writeable" : (volLinkAttrType == 2 ? "mirror" : "default");
        }
        int i = 0;
        while (i < blocks.length) {
            String master;
            fmapBuilder.append("\t       " + (Serializable)(startBlock == 0L ? "p" : Long.valueOf(startBlock - 1L)) + " ");
            if (volName != null) {
                fmapBuilder.append(volName + " " + volLinkAttrName + " " + vCid + "." + vCinum + "." + vUniq + " -> ");
            }
            fmapBuilder.append(blocks[i].getCid() + "." + blocks[i].getCinum() + "." + blocks[i].getUniq() + "  ");
            if (volName == null && needNumDiskBlocks) {
                fmapBuilder.append(String.format("%" + 2 * (maxLen - 1) + "d ", blocks[i].getNumDiskBlocks()));
            }
            if ((master = blocks[i].getMaster()) != null && !master.isEmpty()) {
                fmapBuilder.append(master + " ");
                for (String host : blocks[i].getNames()) {
                    if (host.equalsIgnoreCase(master)) continue;
                    fmapBuilder.append(host + " ");
                }
            }
            fmapBuilder.append("\n");
            ++i;
            ++startBlock;
        }
        return fmapBuilder.toString();
    }

    private String printTablets(Path path) throws Exception {
        List<Dbserver.TabletDesc> nextSet;
        MapRTabletScanner scanner = fs.getTabletScanner(path, null);
        StringBuilder tmapBuilder = new StringBuilder();
        while ((nextSet = scanner.nextSet()) != null) {
            ArrayList<Integer> cidList = new ArrayList<Integer>();
            for (Dbserver.TabletDesc tablet : nextSet) {
                cidList.add(tablet.getFid().getCid());
            }
            List<CLDBProto.ContainerInfo> containers = this.getContainersForCids(path, cidList);
            if (containers == null || containers.size() != nextSet.size()) {
                throw new IOException("Container lookup response has no containers in it ");
            }
            int i = 0;
            for (Dbserver.TabletDesc tablet : nextSet) {
                tmapBuilder.append("\t       r " + tablet.getFid().getCid() + "." + tablet.getFid().getCinum() + "." + tablet.getFid().getUniq() + "  ");
                CLDBProto.ContainerInfo cInfo = containers.get(i);
                String primaryNode = ((Common.IPAddress)cInfo.getMServer().getIpsList().get(0)).getHostname() + ":" + ((Common.IPAddress)cInfo.getMServer().getIpsList().get(0)).getPort();
                tmapBuilder.append(primaryNode + " " + this.getSecondaryNodes(cInfo) + "\n");
                ++i;
            }
        }
        return tmapBuilder.toString();
    }

    private List<CLDBProto.ContainerInfo> getContainersForCids(Path path, List<Integer> cidList) throws Exception {
        ArrayList<CLDBProto.ContainerInfo> containers = new ArrayList<CLDBProto.ContainerInfo>();
        int from = 0;
        int to = 50;
        while (to < cidList.size()) {
            containers.addAll(this.fetchContainersFromCLDB(path, cidList.subList(from, to)));
            from = to;
            to = from + 50;
        }
        if (from < cidList.size()) {
            containers.addAll(this.fetchContainersFromCLDB(path, cidList.subList(from, cidList.size())));
        }
        return containers;
    }

    private List<CLDBProto.ContainerInfo> fetchContainersFromCLDB(Path path, List<Integer> cidList) throws Exception {
        byte[] replyData = fs.getContainerInfo(path, cidList);
        if (replyData == null) {
            throw new IOException("Failed to connect to CLDB");
        }
        CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])replyData);
        if (resp.getStatus() != 0) {
            throw new IOException("Container lookup failed. Error: " + Errno.toString((int)resp.getStatus()));
        }
        return resp.getContainersList();
    }

    private Security.CredentialsMsg getUserCredentials() {
        String user = ui.getLoggedinUsername();
        return this.getUserCredentials(user);
    }

    private Security.CredentialsMsg getUserCredentials(String user) {
        int uid = ui.getUserId(user);
        int[] gids = ui.getGroups(user);
        Security.CredentialsMsg.Builder msg = Security.CredentialsMsg.newBuilder().setUid(uid);
        for (int gid : gids) {
            msg.addGids(gid);
        }
        return msg.build();
    }

    private String getSecondaryNodes(CLDBProto.ContainerInfo containerInfo) {
        StringBuilder secondaryNodesBuilder = new StringBuilder();
        boolean first = true;
        for (Common.Server secondaryServers : containerInfo.getAServersList()) {
            if (MapRCliCommands.compareIPAddress(Util.getIPAddress((Common.Server)containerInfo.getMServer(), (boolean)false), Util.getIPAddress((Common.Server)secondaryServers, (boolean)false))) continue;
            if (!first) {
                secondaryNodesBuilder.append(" ");
            }
            String host = null;
            if (secondaryServers.hasHostname()) {
                host = secondaryServers.getHostname();
            }
            if (host == null || host.isEmpty()) {
                host = Util.getHostname((Common.Server)secondaryServers, (int)0);
            }
            secondaryNodesBuilder.append(host + ":" + Util.getPort((Common.Server)secondaryServers, (int)0));
            first = false;
        }
        return secondaryNodesBuilder.toString();
    }

    public static boolean compareIPAddress(Common.IPAddress a, Common.IPAddress b) {
        if (a == null || b == null) {
            return false;
        }
        return (a.getHostname().equalsIgnoreCase(b.getHostname()) || a.getHost() == b.getHost()) && a.getPort() == b.getPort();
    }

    private int setcompression(String srcf, boolean val, String compType) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        return fs.setCompression(srcPath, val, compType);
    }

    private int stat(String srcf) throws IOException {
        Path srcPath = this.verifyAndGetPath(srcf);
        MapRFileStatus status = fs.getStat(srcPath);
        if (status == null) {
            return -1;
        }
        String mdate = modifFmt.format(new Date(status.getModificationTime()));
        String adate = modifFmt.format(new Date(status.getAccessTime()));
        StringBuilder builder = new StringBuilder();
        builder.append("Path: " + srcf + "\n");
        builder.append("  fid: " + status.getFidStr() + "\n");
        builder.append("  uid: " + status.getOwner() + "\n");
        builder.append("  gid: " + status.getGroup() + "\n");
        builder.append("  atime: " + adate + "\n");
        builder.append("  mtime: " + mdate + "\n");
        builder.append("  nlink: " + status.getNlink() + "\n");
        builder.append("  type: " + status.getType() + "\n");
        builder.append("  subtype: " + status.getsubType() + "\n");
        builder.append("  size: " + status.getLength() + "\n");
        builder.append("  blocksize: " + status.getChunkSize() + "\n");
        builder.append("  mode: " + Integer.toOctalString(status.getMode()) + "\n");
        builder.append("  networkencryption: " + status.getWireSecurityEnabled() + "\n");
        builder.append("  compression: " + (status.getCompress() ? status.getCompressionName() : "off") + "\n");
        builder.append("  diskflush: " + status.getDiskFlushEnabled() + "\n");
        if (status.getType().equals("FTDevice")) {
            builder.append("  major: " + status.getMajor() + "\n");
            builder.append("  minor: " + status.getMinor() + "\n");
        }
        System.out.println(builder.toString());
        return 0;
    }

    private int count(String srcf) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        MapRFileCount dirCount = fs.getFileCount(srcPath);
        if (dirCount == null) {
            throw new IOException("Cannot get the file count for " + srcPath);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Path: " + srcf + "\n");
        buffer.append("Directories   : " + dirCount.getDirCount() + "\n");
        buffer.append("Regular files : " + dirCount.getRegularFileCount() + "\n");
        buffer.append("Symlinks      : " + dirCount.getSymlinkCount() + "\n");
        buffer.append("Vollinks      : " + dirCount.getVollinkCount() + "\n");
        buffer.append("Devices       : " + dirCount.getDeviceCount() + "\n");
        buffer.append("Kvstores      : " + dirCount.getKvstoreCount() + "\n");
        buffer.append("Total files   : " + dirCount.getTotalCount() + "\n");
        System.out.println(buffer.toString());
        return 0;
    }

    private int modifyAudit(String srcf, boolean val) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        return fs.modifyAudit(srcPath, val);
    }

    private int setnetworkencryption(String srcf, boolean val) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        return fs.setWireSecurity(srcPath, val);
    }

    private int setdiskflush(String srcf, boolean val) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        return fs.setDiskFlush(srcPath, val);
    }

    private int setchunksize(String srcf, long val) throws IOException {
        Path srcPath = new Path(srcf);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + srcf);
        }
        if (val % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        return fs.setChunkSize(srcPath, val);
    }

    private int ln(String target, String link, boolean hardlink) throws IOException {
        Path srcPath = new Path(link);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + link);
        }
        if (!hardlink) {
            System.out.println("Creating Symlink: " + link + " -> " + target);
            return fs.createSymlink(target, srcPath, true);
        }
        Path oldpath = new Path(target);
        Path newpath = new Path(link);
        System.out.println("Creating Hardlink: " + link + " -> " + target);
        return fs.createHardlink(oldpath, newpath);
    }

    private int rmr(String target) throws IOException {
        Path tPath = new Path(target);
        System.out.println("Are you sure you want to delete " + target + " [y/n]");
        Scanner scan = new Scanner(System.in);
        char c = scan.next().charAt(0);
        if (c != 'Y' && c != 'y') {
            System.out.println("Exiting");
            return 0;
        }
        if (!this.isMapRFsPath(tPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + target);
        }
        return fs.removeRecursive(tPath);
    }

    private void printHelp(String cmd) {
        String summary = "hadoop mfs is the command to execute MapR shell commands. The full syntax is: \n\nhadoop mfs [-ls] [-lsr] [-lsrv] [-Lsr] [-lsd] [-lsfid]  [-lss] [-lssr] [-lso] [-lssr] [-ln] [-lnh] [-rmr] [-setcompression] [-setaudit] [-setchunksize] [-setnetworkencryption] [-setdiskflush] [-stat] [-count] [-tierstatus] [-offload] [-recall] [-addsecuritypolicytag] [-getsecuritypolicytag] [-removesecuritypolicytag] [-removeallsecuritypolicytags] [-setsecuritypolicytag] [-help [cmd]]\n";
        String ls = "-ls <path>: \t\t\tList the contents that match the specified file pattern. If\n\t\t\t\tpath is not specified, the contents of /user/<currentUser>\n\t\t\t\twill be listed. Directory entries are of the form \n\t\t\t\t\tdirName (full path) <dir> \n\t\t\t\tand file entries are of the form \n\t\t\t\t\tfileName(full path) <r n> size \n\t\t\t\twhere n is the number of replicas specified for the file \n\t\t\t\tand size is the size of the file, in bytes.\n";
        String lsr = "-lsr <path>: \t\t\tRecursively list the contents that match the specified\n\t\t\t\tfile pattern.  Behaves very similarly to hadoop fs -ls,\n\t\t\t\texcept that the data is shown for all the entries in the\n\t\t\t\tsubtree.\n";
        String lsrv = "-lsrv <path>: \t\t\tEquivalent to lsr; does not follow volume links\n";
        String Lsr = "-Lsr <path>: \t\t\tEquivalent to lsr; in addition derefernces symbolic links\n";
        String lsd = "-lsd <path>: \t\t\tList the properties of the directory that match the\n\t\t\t\tspecified pattern.\n";
        String lsfid = "-lsfid <cid.cinum.uniq>: \t\t\tList the properties of the\t\t\t\tpath specified by the fid. Requires root privileges.\n";
        String lso = "-lso <path>: \t\t\t Same as ls but won't print fid/tablet map.\n";
        String lsor = "-lsor <path>: \t\t\t Same as lsr but won't print fid/tablet map.\n";
        String lsf = "-lsf <path> \t\t\tList the contents that match the specified file pattern.\t\t\t\tFaster version of -ls that does not sort the output.\n";
        String ln = "-ln <target> <link>: \t\tCreate a symbolic link to a target.\n";
        String lnh = "-lnh <target> <link>: \t\tCreate a hard link to a target.\n";
        String rmr = "-rmr <path>\n";
        String setcompression = "-setcompression <on|off|lzf|lz4|zlib> <dir|table>: Set the compression on a directory or a table.\n";
        String audit = "-setaudit <on|off> <dir | file | table>: Enable or disable auditing from a file or a directory.";
        String setnetworkencryption = "-setnetworkencryption <on|off> <file|dir|table>: Set network encryption on a file or a directory or a table.\n";
        String setdiskflush = "-setdiskflush <on|off> <file>: Set disk flush on a file.\n";
        String setchunksize = "-setchunksize <size> <dir>: \tSet the Chunk Size in bytes (multiple of 64K), on a directory.\n";
        String lss = "-lss <path>: \t\t\tList the contents that match the specified file pattern.\n\t\t\t\tIn addition, list the number of disk-blocks (of size 8192 bytes) per block\n";
        String lssr = "-lssr <path>: \t\t\tRecursively list the contents that match the specified file pattern.\n\t\t\t\tIn addition, list the number of disk-blocks (of size 8192 bytes) per block\n";
        String stat = "-stat <path>: Get the statistics of the path.\n";
        String count = "-count <path>: Get the file count of the directory.\n";
        String tierstatus = "-tierstatus <path> [-v]: Get the tier status of <path>.\n";
        String offload = "-offload <path> [-v]: Tiered Offload of file at <path>.\n";
        String recall = "-recall <path> [-v]: Tiered recall of file at <path>.\n";
        String addsecuritypolicytag = "-addsecuritypolicytag [-R] <comma-separated list of security policy tags> <path>.\n";
        String getsecuritypolicytag = "-getsecuritypolicytag [-R] <path>.\n";
        String removesecuritypolicytag = "-removesecuritypolicytag [-R] <comma-separated list of security policy tags> <path>.\n";
        String removeallsecuritypolicytags = "-removeallsecuritypolicytags [-R] <path>.\n";
        String setsecuritypolicytag = "-setsecuritypolicytag [-R] <comma-separated list of security policy tags> <path>.\n";
        String help = "-help [cmd]: \t\t\tDisplays help for given command or all commands if none\n\t\t\t\tis specified.\n";
        if ("ls".equals(cmd)) {
            System.out.println(ls);
        } else if ("lsr".equals(cmd)) {
            System.out.println(lsr);
        } else if ("lsrv".equals(cmd)) {
            System.out.println(lsrv);
        } else if ("Lsr".equals(cmd)) {
            System.out.println(Lsr);
        } else if ("lsd".equals(cmd)) {
            System.out.println(lsd);
        } else if ("lsfid".equals(cmd)) {
            System.out.println(lsfid);
        } else if ("lsf".equals(cmd)) {
            System.out.println(lsf);
        } else if ("lso".equals(cmd)) {
            System.out.println(lso);
        } else if ("lsor".equals(cmd)) {
            System.out.println(lsor);
        } else if ("ln".equals(cmd)) {
            System.out.println(ln);
        } else if ("lnh".equals(cmd)) {
            System.out.println(lnh);
        } else if ("rmr".equals(cmd)) {
            System.out.println(rmr);
        } else if ("setcompression".equals(cmd)) {
            System.out.println(setcompression);
        } else if ("setaudit".equals(cmd)) {
            System.out.println(audit);
        } else if ("setnetworkencryption".equals(cmd)) {
            System.out.println(setnetworkencryption);
        } else if ("setchunksize".equals(cmd)) {
            System.out.println(setchunksize);
        } else if ("lss".equals(cmd)) {
            System.out.println(lss);
        } else if ("lssr".equals(cmd)) {
            System.out.println(lssr);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else if ("stat".equals(cmd)) {
            System.out.println(stat);
        } else if ("count".equals(cmd)) {
            System.out.println(count);
        } else if ("setdiskflush".equals(cmd)) {
            System.out.println(setdiskflush);
        } else if ("tierstatus".equals(cmd)) {
            System.out.println(tierstatus);
        } else if ("offload".equals(cmd)) {
            System.out.println(offload);
        } else if ("recall".equals(cmd)) {
            System.out.println(recall);
        } else if ("addsecuritypolicytag".equals(cmd)) {
            System.out.println(addsecuritypolicytag);
        } else if ("getsecuritypolicytag".equals(cmd)) {
            System.out.println(getsecuritypolicytag);
        } else if ("removesecuritypolicytag".equals(cmd)) {
            System.out.println(removesecuritypolicytag);
        } else if ("removeallsecuritypolicytags".equals(cmd)) {
            System.out.println(removeallsecuritypolicytags);
        } else if ("setsecuritypolicytag".equals(cmd)) {
            System.out.println(setsecuritypolicytag);
        } else {
            System.out.println(summary);
            System.out.println(ls);
            System.out.println(lsr);
            System.out.println(lsrv);
            System.out.println(Lsr);
            System.out.println(lsd);
            System.out.println(lsfid);
            System.out.println(lsf);
            System.out.println(lss);
            System.out.println(lssr);
            System.out.println(lso);
            System.out.println(lsor);
            System.out.println(ln);
            System.out.println(lnh);
            System.out.println(rmr);
            System.out.println(setcompression);
            System.out.println(audit);
            System.out.println(setnetworkencryption);
            System.out.println(setchunksize);
            System.out.println(setdiskflush);
            System.out.println(stat);
            System.out.println(count);
            System.out.println(tierstatus);
            System.out.println(offload);
            System.out.println(recall);
            System.out.println(addsecuritypolicytag);
            System.out.println(getsecuritypolicytag);
            System.out.println(removesecuritypolicytag);
            System.out.println(removeallsecuritypolicytags);
            System.out.println(setsecuritypolicytag);
            System.out.println(help);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doall(String cmd, String[] argv, int startindex) {
        String securityPolicyTags;
        boolean verbose;
        boolean audit;
        int preservemodebits;
        int noinherit;
        int serveridx;
        boolean recursive;
        ArrayList aces;
        int numArgs;
        String[] aceArgs;
        long chunksize;
        String compressiontype;
        boolean diskflush;
        boolean wiresecure;
        boolean compress;
        int exitCode;
        block105: {
            exitCode = 0;
            compress = false;
            wiresecure = false;
            diskflush = false;
            compressiontype = null;
            chunksize = 0L;
            aceArgs = null;
            numArgs = argv.length;
            aces = null;
            recursive = false;
            serveridx = -1;
            noinherit = -1;
            preservemodebits = -1;
            audit = false;
            verbose = false;
            securityPolicyTags = null;
            if ("-setnetworkencryption".equals(cmd)) {
                if (argv[startindex].equals("on")) {
                    wiresecure = true;
                } else {
                    if (!argv[startindex].equals("off")) {
                        MapRCliCommands.printUsage(cmd);
                        return -1;
                    }
                    wiresecure = false;
                }
                ++startindex;
            } else if ("-setdiskflush".equals(cmd)) {
                if (argv[startindex].equals("on")) {
                    diskflush = true;
                } else {
                    if (!argv[startindex].equals("off")) {
                        MapRCliCommands.printUsage(cmd);
                        return -1;
                    }
                    diskflush = false;
                }
                ++startindex;
            } else if ("-setcompression".equals(cmd)) {
                if (argv[startindex].equals("on")) {
                    compress = true;
                } else if (argv[startindex].equals("off")) {
                    compress = false;
                } else {
                    if (!(argv[startindex].equals("lzf") || argv[startindex].equals("lz4") || argv[startindex].equals("zlib"))) {
                        MapRCliCommands.printUsage(cmd);
                        return -1;
                    }
                    compress = true;
                    compressiontype = argv[startindex];
                }
                ++startindex;
            } else if ("-setaudit".equals(cmd)) {
                if (argv[startindex].equals("on")) {
                    audit = true;
                } else {
                    if (!argv[startindex].equals("off")) {
                        MapRCliCommands.printUsage(cmd);
                        return -1;
                    }
                    audit = false;
                }
                ++startindex;
            } else if ("-setchunksize".equals(cmd)) {
                chunksize = Long.valueOf(argv[startindex]);
                ++startindex;
            } else if ("-delace".equals(cmd)) {
                if (argv[startindex].equals("-R")) {
                    recursive = true;
                    ++startindex;
                }
            } else if ("-tierstatus".equals(cmd) || "-offload".equals(cmd) || "-recall".equals(cmd)) {
                if (argv.length == 3) {
                    if (!argv[argv.length - 1].equals("-v")) {
                        MapRCliCommands.printUsage(cmd);
                        return -1;
                    }
                    verbose = true;
                    --numArgs;
                } else if (argv.length > 3) {
                    MapRCliCommands.printUsage(cmd);
                    return -1;
                }
            } else if ("-getace".equals(cmd)) {
                if (argv[startindex].equals("-R")) {
                    recursive = true;
                    ++startindex;
                }
                if (argv[startindex].equals("-serveridx")) {
                    serveridx = Integer.valueOf(argv[++startindex]);
                    ++startindex;
                }
            } else {
                if ("-setace".equals(cmd)) {
                    try {
                        String preserveModeBitsStr;
                        int aceArgsStartIndex = 1;
                        int aceArgsCount = argv.length - 1;
                        if (argv[startindex].equals("-R")) {
                            recursive = true;
                            ++aceArgsStartIndex;
                            --aceArgsCount;
                            ++startindex;
                        }
                        if (argv[startindex].equals("-aces")) {
                            int aceStrArgCount;
                            String[] stringArray = new String[2 * AceHelper.FS_PERM_SHORT_MAP.size() + aceArgsCount];
                            if ((aceStrArgCount = this.ParseAceStringArgs(argv, ++aceArgsStartIndex, argv.length, stringArray)) < 0) {
                                return -1;
                            }
                            this.parseSetAceOptions(stringArray, 0, aceStrArgCount);
                        } else {
                            this.parseSetAceOptions(argv, aceArgsStartIndex, aceArgsCount);
                        }
                        aceArgs = this.cmdLine.getArgs();
                        MapRCliCommands mapRCliCommands = this;
                        aces = AceHelper.getFilePermission((AceHelper.FSPermission)mapRCliCommands);
                        String noinheritStr = this.getCliParam(SETINHERIT);
                        if (noinheritStr != null) {
                            if (!noinheritStr.equals("true") && !noinheritStr.equals("false")) {
                                System.err.println("setinherit: Invalid value");
                                MapRCliCommands.printUsage(cmd);
                                return -1;
                            }
                            int n = noinherit = noinheritStr.equals("true") ? 0 : 1;
                        }
                        if ((preserveModeBitsStr = this.getCliParam(PRESERVEMODEBITS)) != null) {
                            if (!preserveModeBitsStr.equals("true") && !preserveModeBitsStr.equals("false")) {
                                System.err.println("preservemodebits: Invalid value");
                                MapRCliCommands.printUsage(cmd);
                                return -1;
                            }
                            preservemodebits = preserveModeBitsStr.equals("true") ? 1 : 0;
                        }
                        startindex = 0;
                        numArgs = aceArgs.length;
                        if (numArgs < 1) {
                            System.out.println("Invalid Arguments");
                            MapRCliCommands.printUsage(cmd);
                            return -1;
                        }
                        break block105;
                    }
                    catch (ParseException e) {
                        System.err.println("incorrect syntax");
                        MapRCliCommands.printUsage(cmd);
                        return -1;
                    }
                    catch (IOException e) {
                        System.err.println("Got IO exception while processing setace " + e.getMessage().split("\n")[0]);
                        return -1;
                    }
                }
                if ("-addsecuritypolicytag".equals(cmd)) {
                    if (argv[startindex].equals("-R")) {
                        recursive = true;
                        ++startindex;
                    }
                    securityPolicyTags = argv[startindex];
                    ++startindex;
                } else if ("-getsecuritypolicytag".equals(cmd)) {
                    if (argv[startindex].equals("-R")) {
                        recursive = true;
                        ++startindex;
                    }
                } else if ("-removesecuritypolicytag".equals(cmd)) {
                    if (argv[startindex].equals("-R")) {
                        recursive = true;
                        ++startindex;
                    }
                    securityPolicyTags = argv[startindex];
                    ++startindex;
                } else if ("-removeallsecuritypolicytags".equals(cmd)) {
                    if (argv[startindex].equals("-R")) {
                        recursive = true;
                        ++startindex;
                    }
                } else if ("-setsecuritypolicytag".equals(cmd)) {
                    if (argv[startindex].equals("-R")) {
                        recursive = true;
                        ++startindex;
                    }
                    securityPolicyTags = argv[startindex];
                    ++startindex;
                }
            }
        }
        int i = startindex;
        while (true) {
            block106: {
                if (i >= numArgs) {
                    return exitCode;
                }
                try {
                    if ("-ls".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], 0);
                        break block106;
                    }
                    if ("-lsr".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], RecursiveBit);
                        break block106;
                    }
                    if ("-lsrv".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], RecursiveBit | SingleVolumeBit);
                        break block106;
                    }
                    if ("-Lsr".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], RecursiveBit | DereferenceSymlinkBit);
                        break block106;
                    }
                    if ("-lsd".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], DirOnlyBit);
                        break block106;
                    }
                    if ("-lsfid".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], DirOnlyBit | FidBit);
                        break block106;
                    }
                    if ("-lsf".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], LiteLsBit);
                        break block106;
                    }
                    if ("-lss".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], DiskBlockOnlyBit);
                        break block106;
                    }
                    if ("-lssr".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], RecursiveBit | DiskBlockOnlyBit);
                        break block106;
                    }
                    if ("-lso".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], NoFidMap);
                        break block106;
                    }
                    if ("-lsor".equals(cmd)) {
                        exitCode = this.ls(cmd, argv[i], RecursiveBit | NoFidMap);
                        break block106;
                    }
                    if ("-ln".equals(cmd)) {
                        exitCode = this.ln(argv[i], argv[i + 1], false);
                        ++i;
                        break block106;
                    }
                    if ("-lnh".equals(cmd)) {
                        int target = i;
                        int n = i + 1;
                        i = numArgs;
                        exitCode = this.ln(argv[target], argv[n], true);
                        ++i;
                        break block106;
                    }
                    if ("-rmr".equals(cmd)) {
                        exitCode = this.rmr(argv[i]);
                        break block106;
                    }
                    if ("-setcompression".equals(cmd)) {
                        exitCode = this.setcompression(argv[i], compress, compressiontype);
                        break block106;
                    }
                    if ("-setaudit".equals(cmd)) {
                        exitCode = this.modifyAudit(argv[i], audit);
                        break block106;
                    }
                    if ("-setnetworkencryption".equals(cmd)) {
                        exitCode = this.setnetworkencryption(argv[i], wiresecure);
                        break block106;
                    }
                    if ("-setdiskflush".equals(cmd)) {
                        exitCode = this.setdiskflush(argv[i], diskflush);
                        break block106;
                    }
                    if ("-setchunksize".equals(cmd)) {
                        exitCode = this.setchunksize(argv[i], chunksize);
                        break block106;
                    }
                    if ("-setace".equals(cmd)) {
                        exitCode = this.setace(aceArgs[i], aces, noinherit, preservemodebits, recursive);
                        break block106;
                    }
                    if ("-delace".equals(cmd)) {
                        exitCode = this.delace(argv[i], recursive);
                        break block106;
                    }
                    if ("-getace".equals(cmd)) {
                        exitCode = this.getace(argv[i], recursive, serveridx);
                        break block106;
                    }
                    if ("-stat".equals(cmd)) {
                        exitCode = this.stat(argv[i]);
                        break block106;
                    }
                    if ("-count".equals(cmd)) {
                        exitCode = this.count(argv[i]);
                        break block106;
                    }
                    if ("-tierstatus".equals(cmd)) {
                        exitCode = this.tierOp(CLDBProto.FileTierOp.FILE_TIERSTATUS, argv[i], verbose);
                        break block106;
                    }
                    if ("-offload".equals(cmd)) {
                        exitCode = this.tierOp(CLDBProto.FileTierOp.FILE_OFFLOAD, argv[i], verbose);
                        break block106;
                    }
                    if ("-recall".equals(cmd)) {
                        exitCode = this.tierOp(CLDBProto.FileTierOp.FILE_RECALL, argv[i], verbose);
                        break block106;
                    }
                    if ("-addsecuritypolicytag".equals(cmd)) {
                        exitCode = this.setSecurityPolicyTag(securityPolicyTags, argv[i], false, recursive);
                        break block106;
                    }
                    if ("-getsecuritypolicytag".equals(cmd)) {
                        exitCode = this.getSecurityPolicyTag(argv[i], recursive);
                        break block106;
                    }
                    if ("-removesecuritypolicytag".equals(cmd)) {
                        exitCode = this.removeSecurityPolicyTag(securityPolicyTags, argv[i], recursive);
                        break block106;
                    }
                    if ("-removeallsecuritypolicytags".equals(cmd)) {
                        exitCode = this.removeAllSecurityPolicyTags(argv[i], recursive);
                        break block106;
                    }
                    if ("-setsecuritypolicytag".equals(cmd)) {
                        exitCode = this.setSecurityPolicyTag(securityPolicyTags, argv[i], true, recursive);
                    }
                }
                catch (RemoteException e) {
                    exitCode = -1;
                    try {
                        String[] stringArray = e.getLocalizedMessage().split("\n");
                        System.err.println(cmd.substring(1) + ": " + stringArray[0]);
                    }
                    catch (Exception exception) {
                        System.err.println(cmd.substring(1) + ": " + exception.getLocalizedMessage());
                    }
                }
                catch (IOException e) {
                    void var23_35;
                    exitCode = -1;
                    String string = e.getLocalizedMessage();
                    if (string != null) {
                        String string2 = string.split("\n")[0];
                    }
                    System.err.println(cmd.substring(1) + ": " + (String)var23_35);
                }
                catch (Exception e) {
                    System.err.println(e.getLocalizedMessage());
                }
            }
            ++i;
        }
    }

    private static void printUsage(String cmd) {
        String prefix = "Usage: mfs";
        String setAceOptions = "\n\t\t [-R] [-readfile <ace>] [-writefile <ace>] [-executefile <ace>] \n\t\t [-readdir <ace>] [-addchild <ace>] [-deletechild <ace>] [-lookupdir <ace>] \n\t\t [-aces \"[rf:<ace>],[wf:<ace>],[ef:<ace>],[rd:<ace>],[ac:<ace>],[dc:<ace>],[ld:<ace>]\"] \n\t\t [-setinherit <true|false>] [-preservemodebits <true|false>] \n\t    ";
        if ("-ls".equals(cmd) || "-lsr".equals(cmd) || "-lsf".equals(cmd) || "-lsrv".equals(cmd) || "-Lsr".equals(cmd) || "-lsd".equals(cmd) || "-lso".equals(cmd) || "-lsor".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <path>]");
        } else if ("-lsfid".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <cid.cinum.uniq>]");
        } else if ("-ln".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <target> <symlink>]");
        } else if ("-lnh".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <target> <hardlink>]");
        } else if ("-setcompression".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <on|off|lzf|lz4|zlib> <dir|table>]");
        } else if ("-setaudit".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <on|off> <dir|file|table>]");
        } else if ("-setnetworkencryption".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <on|off> <file|dir|table>]");
        } else if ("-setdiskflush".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <on|off> <file>]");
        } else if ("-setchunksize".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <size> <dir>]");
        } else if ("-setace".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + setAceOptions + " <path>]");
        } else if ("-getace".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " [-R] <path>]");
        } else if ("-delace".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " [-R] <path>]");
        } else if ("-lss".equals(cmd) || "-lssr".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <file>]");
        } else if ("-stat".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <path>]");
        } else if ("-count".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <path>]");
        } else if ("-rmr".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <path>]");
        } else if ("-tierstatus".equals(cmd) || "-offload".equals(cmd) || "-recall".equals(cmd)) {
            System.err.println(prefix + " [" + cmd + " <path> [-v]]");
        } else {
            System.err.println(prefix);
            System.err.println("           [-ls <path>]");
            System.err.println("           [-lsr <path>]");
            System.err.println("           [-lsrv <path>]");
            System.err.println("           [-Lsr <path>]");
            System.err.println("           [-lsd <path>]");
            System.err.println("           [-lsf <path>]");
            System.err.println("           [-lsfid <cid.cinum.uniq>]");
            System.err.println("           [-lss <path>]");
            System.err.println("           [-lssr <path>]");
            System.err.println("           [-lso <path>]");
            System.err.println("           [-lsor <path>]");
            System.err.println("           [-ln <target> <symlink>]");
            System.err.println("           [-lnh <target> <hardlink>]");
            System.err.println("           [-setcompression <on|off|lzf|lz4|zlib>] <dir|table>");
            System.err.println("           [-setaudit <on|off> <dir|file|table>]");
            System.err.println("           [-setchunksize <size in bytes (multiple of 65536)> <dir>]");
            System.err.println("           [-setnetworkencryption <on|off> <file|dir|table>]");
            System.err.println("           [-setdiskflush <on|off> <file>]");
            System.err.println("           [-setace " + setAceOptions + " <path>]");
            System.err.println("           [-getace [-R] <path>]");
            System.err.println("           [-delace [-R] <path>]");
            System.err.println("           [-stat <path>]");
            System.err.println("           [-count <path>]");
            System.err.println("           [-rmr <path>]");
            System.err.println("           [-tierstatus <path> [-v]]");
            System.err.println("           [-offload <path> [-v]]");
            System.err.println("           [-recall <path> [-v]]");
            System.err.println("           [-addsecuritypolicytag [-R] <comma-separated list of security policy tags> <path>]");
            System.err.println("           [-getsecuritypolicytag [-R] <path>]");
            System.err.println("           [-removesecuritypolicytag [-R] <comma-separated list of security policy tags> <path>]");
            System.err.println("           [-removeallsecuritypolicytags [-R] <path>]");
            System.err.println("           [-setsecuritypolicytag [-R] <comma-separated list of security policy tags> <path>]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
        }
    }

    private int ParseAceStringArgs(String[] args, int argsStartIndex, int argsCount, String[] aceArgs) {
        String aceStr = args[argsStartIndex];
        Scanner s = new Scanner(aceStr).useDelimiter(",");
        int aceArgCount = 0;
        while (s.hasNext()) {
            String[] pair = s.next().split(":", 2);
            String key = (String)AceHelper.FS_PERM_SHORT_MAP.get(pair[0]);
            if (key == null) {
                MapRCliCommands.printUsage("-setace");
                return -1;
            }
            aceArgs[aceArgCount++] = new String("-" + key);
            aceArgs[aceArgCount++] = new String(pair[1]);
        }
        if (aceArgCount == 0) {
            System.err.println("Invalid ace arguments");
            MapRCliCommands.printUsage("-setace");
            return -1;
        }
        if (argsStartIndex + 1 >= argsCount) {
            System.err.println("setace: <path> is missing");
            MapRCliCommands.printUsage("-setace");
            return -1;
        }
        if (aceArgCount == 0 || argsStartIndex + 1 >= argsCount) {
            return -1;
        }
        for (int i = argsStartIndex + 1; i < argsCount; ++i) {
            aceArgs[aceArgCount++] = args[i];
        }
        return aceArgCount;
    }

    private void parseSetAceOptions(String[] args, int aceArgsStartIndex, int aceArgsCount) throws ParseException {
        Options options = new Options();
        options.addOption("readfile", true, "ace for file read");
        options.addOption("writefile", true, "ace for file write");
        options.addOption("executefile", true, "ace for file execute");
        options.addOption("readdir", true, "ace for read directory");
        options.addOption("addchild", true, "ace for add child in a directory");
        options.addOption("deletechild", true, "ace for delete child in a directory");
        options.addOption("lookupdir", true, "ace for lookup directory");
        options.addOption(SETINHERIT, true, "set inherit aces bit");
        options.addOption(PRESERVEMODEBITS, true, "preserve mode bits");
        this.parser = new BasicParser();
        String[] aceArgs = new String[aceArgsCount];
        System.arraycopy(args, aceArgsStartIndex, aceArgs, 0, aceArgsCount);
        this.cmdLine = this.parser.parse(options, aceArgs);
    }

    int delace(String path, boolean recursive) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        int err = fs.delAces(srcPath, recursive);
        if (err > 0) {
            System.err.println("delace: " + Errno.toString((int)err));
        }
        return err;
    }

    int getace(String path, boolean recursive) throws IOException {
        return this.getace(path, recursive, -1);
    }

    int getace(String path, boolean recursive, int serveridx) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        ArrayList<FileAceEntry> acesList = fs.getAces(srcPath, recursive, 0, serveridx);
        Collections.sort(acesList);
        int error = 0;
        String prevFilePath = "";
        for (FileAceEntry fileAceEntry : acesList) {
            if (fileAceEntry.error != 0) {
                if (error != 0) continue;
                error = fileAceEntry.error;
                continue;
            }
            if (fileAceEntry.aces.size() == 0 || fileAceEntry.filePath.equals(prevFilePath)) continue;
            boolean isDir = false;
            System.out.println("Path: " + fileAceEntry.filePath);
            for (Common.FileACE ace : fileAceEntry.aces) {
                if (!isDir && ace.getAccessType().getNumber() >= Common.FSAccessType.AceDirAccessTypeStart.getNumber() && ace.getAccessType().getNumber() <= Common.FSAccessType.AceDirAccessTypeEnd.getNumber()) {
                    isDir = true;
                }
                System.out.println("  " + fsAccessTypeMap.get(ace.getAccessType()) + ": " + AceHelper.toInfix((String)ace.getBoolExp().toStringUtf8()));
            }
            if (isDir) {
                System.out.println("  inherit: " + fileAceEntry.inherit);
            }
            System.out.println("  mode: " + fileAceEntry.permission);
            prevFilePath = fileAceEntry.filePath;
        }
        return error;
    }

    int setace(String path, ArrayList<Common.FileACE> aces, int noinherit, int preservemodebits, boolean recursive) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        if (LOG.isDebugEnabled()) {
            for (Common.FileACE ace : aces) {
                System.out.println(ace.getAccessType() + " : " + ace.getBoolExp().toStringUtf8());
            }
        }
        if (aces.size() == 0 && preservemodebits != -1) {
            throw new IOException("preservemodebits is set without aces");
        }
        int err = fs.setAces(srcPath, aces, false, noinherit, preservemodebits, recursive, null);
        if (err > 0) {
            System.err.println("setace: " + Errno.toString((int)err));
        }
        return err;
    }

    public int tierOp(CLDBProto.FileTierOp op, String path, boolean verbose) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        if (LOG.isDebugEnabled()) {
            System.out.println("tierOp : " + op.getNumber() + ", path : " + path + ", verbose : " + verbose);
        }
        JNIFileTierStatus fts = fs.tierOp(op.getNumber(), srcPath, verbose, true, 0L, 0L, 0L);
        return fts.fileTierOpStatus;
    }

    List<String> parseSecurityPolicyTags(String securityPolicies) {
        ArrayList<String> securityPolicyTagList = null;
        String[] tokens = securityPolicies.split("[,]");
        for (int i = 0; i < tokens.length; ++i) {
            String next = tokens[i];
            if (next.length() == 0) continue;
            if (securityPolicyTagList == null) {
                securityPolicyTagList = new ArrayList<String>();
            }
            securityPolicyTagList.add(next);
        }
        return securityPolicyTagList;
    }

    public int setSecurityPolicyTag(String securityPolicyTags, String path, boolean isSet, boolean recursive) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        List<String> securityPolicyTagList = this.parseSecurityPolicyTags(securityPolicyTags);
        if (securityPolicyTagList == null) {
            System.out.println("Tags must have at least one character");
            return -1;
        }
        if (isSet) {
            return fs.setSecurityPolicy(srcPath, securityPolicyTagList, recursive);
        }
        return fs.addSecurityPolicy(srcPath, securityPolicyTagList, recursive);
    }

    public int getSecurityPolicyTag(String path, boolean recursive) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        return fs.printSecurityPolicies(srcPath, recursive);
    }

    public int removeSecurityPolicyTag(String securityPolicyTags, String path, boolean recursive) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        List<String> securityPolicyTagList = this.parseSecurityPolicyTags(securityPolicyTags);
        if (securityPolicyTagList == null) {
            System.out.println("Tags must have at least one character");
            return -1;
        }
        return fs.removeSecurityPolicy(srcPath, securityPolicyTagList, recursive);
    }

    public int removeAllSecurityPolicyTags(String path, boolean recursive) throws IOException {
        Path srcPath = new Path(path);
        if (!this.isMapRFsPath(srcPath)) {
            throw new FileNotFoundException("Not a MapRFs uri " + path);
        }
        return fs.removeAllSecurityPolicies(srcPath, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] argv) throws Exception {
        if (argv.length < 1) {
            MapRCliCommands.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        String cmd = argv[i++];
        try {
            this.init();
        }
        catch (RPC.VersionMismatch v) {
            System.err.println("Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            System.err.println("Bad connection to FS. command aborted.");
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-ls".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", 0);
                return this.doall(cmd, argv, i);
            }
            if ("-lsr".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lso".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", NoFidMap);
                return this.doall(cmd, argv, i);
            }
            if ("-lsor".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", NoFidMap | RecursiveBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lsrv".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit | SingleVolumeBit);
                return this.doall(cmd, argv, i);
            }
            if ("-Lsr".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit | DereferenceSymlinkBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lsd".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", DirOnlyBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lsf".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", LiteLsBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lsfid".equals(cmd)) {
                if (i < argv.length) {
                    return this.doall(cmd, argv, i);
                }
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-lss".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", DiskBlockOnlyBit);
                return this.doall(cmd, argv, i);
            }
            if ("-lssr".equals(cmd)) {
                if (i >= argv.length) return this.ls(cmd, ".", RecursiveBit | DiskBlockOnlyBit);
                return this.doall(cmd, argv, i);
            }
            if ("-ln".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-lnh".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-rmr".equals(cmd)) {
                if (argv.length >= 2) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setcompression".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setaudit".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setnetworkencryption".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setdiskflush".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setchunksize".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-delace".equals(cmd)) {
                if (argv.length >= 2) return this.doall(cmd, argv, i);
                System.out.println("argv.length: " + argv.length);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-getace".equals(cmd)) {
                if (argv.length >= 2) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setace".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-stat".equals(cmd)) {
                if (argv.length >= 2) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-count".equals(cmd)) {
                if (argv.length >= 2) return this.doall(cmd, argv, i);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-tierstatus".equals(cmd) || "-offload".equals(cmd) || "-recall".equals(cmd)) {
                if (argv.length >= 2 && argv.length <= 3) {
                    return this.doall(cmd, argv, i);
                }
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-addsecuritypolicytag".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                System.out.println("argv.length: " + argv.length);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-getsecuritypolicytag".equals(cmd)) {
                if (argv.length >= 2) return this.doall(cmd, argv, i);
                System.out.println("argv.length: " + argv.length);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-removesecuritypolicytag".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                System.out.println("argv.length: " + argv.length);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-removeallsecuritypolicytags".equals(cmd)) {
                if (argv.length >= 2) return this.doall(cmd, argv, i);
                System.out.println("argv.length: " + argv.length);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if ("-setsecuritypolicytag".equals(cmd)) {
                if (argv.length >= 3) return this.doall(cmd, argv, i);
                System.out.println("argv.length: " + argv.length);
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if (!"-help".equals(cmd)) {
                exitCode = -1;
                MapRCliCommands.printUsage(cmd);
                return exitCode;
            }
            if (i < argv.length) {
                this.printHelp(argv[i]);
                return exitCode;
            }
            this.printHelp("");
            return exitCode;
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            MapRCliCommands.printUsage(cmd);
            return exitCode;
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
                return exitCode;
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                return exitCode;
            }
        }
        catch (IOException e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
            return exitCode;
        }
        catch (Exception re) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + re.getLocalizedMessage());
            return exitCode;
        }
    }

    public void close() throws IOException {
        if (fs != null) {
            fs.close();
            fs = null;
        }
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        if (this.cmdLine.hasOption(key)) {
            ret = this.cmdLine.getOptionValue(key);
        }
        return ret;
    }

    public static void main(String[] argv) throws Exception {
        int res;
        try (MapRCliCommands shell = new MapRCliCommands();){
            res = ToolRunner.run((Tool)shell, (String[])argv);
        }
        System.exit(res);
    }

    static {
        ui = new UnixUserGroupHelper();
        dateForm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        modifFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        modifFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        fsAccessTypeMap = new ImmutableMap.Builder().put((Object)Common.FSAccessType.AceRead, (Object)new String("readfile")).put((Object)Common.FSAccessType.AceWrite, (Object)new String("writefile")).put((Object)Common.FSAccessType.AceExecute, (Object)new String("executefile")).put((Object)Common.FSAccessType.AceReadDir, (Object)new String("readdir")).put((Object)Common.FSAccessType.AceAddChild, (Object)new String("addchild")).put((Object)Common.FSAccessType.AceDeleteChild, (Object)new String("deletechild")).put((Object)Common.FSAccessType.AceLookupDir, (Object)new String("lookupdir")).build();
        fileStatusComparator = new Comparator<MapRFileStatus>(){

            @Override
            public int compare(MapRFileStatus f1, MapRFileStatus f2) {
                return f1.getPath().toString().compareTo(f2.getPath().toString());
            }
        };
    }

    private static final class ShellListResult {
        private final int lsErrors;
        private final MapRFileStatus[] lsResult;

        private ShellListResult(MapRFileStatus[] lsResult, int lsErrors) {
            this.lsResult = lsResult;
            this.lsErrors = lsErrors;
        }
    }
}

