/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRDbResultScanner;
import com.mapr.fs.MapRDbUtils;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MemMapRDbResultScanner;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemMapRDBUtils
extends MapRDbUtils {
    private HashMap<byte[], Map<String, byte[]>> db = new HashMap();
    private String defaultColumnFamily_;
    private String defaultQualifier_;
    private long rowTimeStamp_;

    public MemMapRDBUtils() {
    }

    public MemMapRDBUtils(MapRFileSystem maprfs) {
    }

    @Override
    public void Init(String tablePath, String defaultColumnFamily, String defaultQualifier) throws IOException {
        if (tablePath == null || tablePath.isEmpty()) {
            throw new IOException("Invalid tablePath");
        }
        if (defaultColumnFamily == null || defaultColumnFamily.isEmpty()) {
            throw new IOException("Invalid defaultColumnFamily");
        }
        if (defaultQualifier == null || defaultQualifier.isEmpty()) {
            throw new IOException("Invalid defaultQualifier");
        }
        this.defaultColumnFamily_ = new String(defaultColumnFamily);
        this.defaultQualifier_ = new String(defaultQualifier);
        this.rowTimeStamp_ = Long.MAX_VALUE;
    }

    public static boolean isDbCreated(String path) {
        return true;
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public void Put(byte[] key, byte[] value) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        if (value == null) {
            throw new IOException("Invalid value");
        }
        HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
        valueMap.put(this.defaultQualifier_, value);
        this.Put(key, valueMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Put(byte[] key, Map<String, byte[]> valueMap) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        if (valueMap == null || valueMap.size() == 0) {
            throw new IOException("Invalid valueMap");
        }
        HashMap<byte[], Map<String, byte[]>> hashMap = this.db;
        synchronized (hashMap) {
            if (this.Exist(key)) {
                key = this.getEquivalKey(key);
                Map<String, byte[]> vMap = this.db.get(key);
                for (String vKey : valueMap.keySet()) {
                    vMap.put(vKey, valueMap.get(vKey));
                }
                return;
            }
            this.db.put(key, valueMap);
        }
    }

    @Override
    public void Put(byte[] key, Map<String, byte[]> insValueMap, List<String> delColumns) throws IOException {
        if (insValueMap != null && insValueMap.size() > 0) {
            this.Put(key, insValueMap);
        }
        if (delColumns != null && delColumns.size() > 0) {
            for (String col : delColumns) {
                this.Delete(key, col);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Delete(byte[] key, String colName) throws IOException {
        if (key == null || colName == null || colName.isEmpty()) {
            throw new IOException("Invalid key");
        }
        HashMap<byte[], Map<String, byte[]>> hashMap = this.db;
        synchronized (hashMap) {
            byte[] oldKey = this.getEquivalKey(key);
            Map<String, byte[]> valueMap = this.db.get(oldKey);
            valueMap.remove(colName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Delete(byte[] key) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        HashMap<byte[], Map<String, byte[]>> hashMap = this.db;
        synchronized (hashMap) {
            byte[] oldKey = this.getEquivalKey(key);
            this.db.remove(oldKey);
        }
    }

    @Override
    public byte[] Get(byte[] key) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, byte[]> MultiColumnGet(byte[] key) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        HashMap<byte[], Map<String, byte[]>> hashMap = this.db;
        synchronized (hashMap) {
            if (this.Exist(key)) {
                byte[] oldKey = this.getEquivalKey(key);
                return this.db.get(oldKey);
            }
        }
        return null;
    }

    @Override
    public boolean Exist(byte[] key) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        byte[] searchKey = key;
        for (byte[] mapKey : this.db.keySet()) {
            if (!Arrays.equals(mapKey, searchKey)) continue;
            return true;
        }
        return false;
    }

    private byte[] getEquivalKey(byte[] key) {
        byte[] searchKey = key;
        for (byte[] mapKey : this.db.keySet()) {
            if (!Arrays.equals(mapKey, searchKey)) continue;
            return mapKey;
        }
        return null;
    }

    private static boolean startsWith(byte[] array, byte[] prefix) {
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private HashMap<byte[], Map<String, byte[]>> getDbWithPrefixKeys(byte[] prefix) {
        HashMap<byte[], Map<String, byte[]>> tempDb = new HashMap<byte[], Map<String, byte[]>>();
        for (byte[] mapKey : this.db.keySet()) {
            if (!MemMapRDBUtils.startsWith(mapKey, prefix)) continue;
            tempDb.put(mapKey, this.db.get(mapKey));
        }
        return tempDb;
    }

    @Override
    public MapRDbResultScanner getKeysScanner(byte[] startKey, byte[] endKey, boolean defaultColumn) throws IOException {
        return this.getScanner(startKey, endKey, defaultColumn, true);
    }

    @Override
    public MapRDbResultScanner getKeysScanner(byte[] startKey, byte[] endKey) throws IOException {
        return this.getScanner(startKey, endKey, true, true);
    }

    @Override
    public MapRDbResultScanner getScanner(byte[] startKey, byte[] endKey) throws IOException {
        return this.getScanner(startKey, endKey, true, false);
    }

    @Override
    public MapRDbResultScanner getScanner(byte[] startKey, byte[] endKey, boolean defaultColumn) throws IOException {
        return this.getScanner(startKey, endKey, defaultColumn, false);
    }

    @Override
    public MapRDbResultScanner getScanner(byte[] startKey, byte[] endKey, boolean defaultColumn, boolean onlyKeys) throws IOException {
        MemMapRDbResultScanner scanner = new MemMapRDbResultScanner(this.db);
        return scanner;
    }

    @Override
    public MapRDbResultScanner getScannerForPrefix(byte[] prefix, boolean defaultColumn) throws IOException {
        HashMap<byte[], Map<String, byte[]>> tempDb = this.getDbWithPrefixKeys(prefix);
        return new MemMapRDbResultScanner(tempDb);
    }
}

