/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.rpcauth;

import com.mapr.security.callback.MaprSaslCallbackHandler;
import com.mapr.security.maprsasl.MaprSaslProvider;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.IpcConnectionContextProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;

public final class MaprAuthMethod
extends RpcAuthMethod {
    public static final Log LOG = LogFactory.getLog(MaprAuthMethod.class);
    static final RpcAuthMethod INSTANCE = new MaprAuthMethod();
    private static final String[] LOGIN_MODULES = new String[]{"com.mapr.security.maprsasl.MaprSecurityLoginModule"};

    private MaprAuthMethod() {
        super((byte)113, "maprsasl", "MAPR-SECURITY", UserGroupInformation.AuthenticationMethod.CUSTOM);
    }

    public String[] loginModules() {
        return LOGIN_MODULES;
    }

    public UserGroupInformation getUser(UserGroupInformation ticket) {
        return ticket.getRealUser() != null ? ticket.getRealUser() : ticket;
    }

    public void writeUGI(UserGroupInformation ugi, IpcConnectionContextProtos.UserInformationProto.Builder ugiProto) {
        ugiProto.setEffectiveUser(ugi.getShortUserName());
    }

    public boolean isSasl() {
        return true;
    }

    public boolean isNegotiable() {
        return true;
    }

    public String getProtocol() throws IOException {
        return "default";
    }

    public String getServerId() throws IOException {
        return "";
    }

    public SaslClient createSaslClient(Map<String, Object> saslProperties) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating SASL " + this.mechanismName + " client to authenticate to SaslServer"));
        }
        UserGroupInformation authUser = UserGroupInformation.getCurrentUser();
        Subject userSubject = authUser.getSubject();
        return Sasl.createSaslClient(new String[]{this.mechanismName}, null, null, "default", saslProperties, (CallbackHandler)new MaprSaslCallbackHandler(userSubject, authUser.getShortUserName()));
    }

    public SaslServer createSaslServer(Server.Connection connection, final Map<String, Object> saslProperties) throws IOException, InterruptedException {
        final UserGroupInformation current = UserGroupInformation.getCurrentUser();
        return (SaslServer)current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslServer>(){

            @Override
            public SaslServer run() throws SaslException {
                AccessControlContext context = AccessController.getContext();
                Subject subject = Subject.getSubject(context);
                return Sasl.createSaslServer(MaprAuthMethod.this.mechanismName, null, "default", saslProperties, (CallbackHandler)new MaprSaslCallbackHandler(subject, current.getShortUserName()));
            }
        });
    }

    public CallbackHandler createCallbackHandler() {
        try {
            AccessControlContext context = AccessController.getContext();
            Subject subject = Subject.getSubject(context);
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            return new MaprSaslCallbackHandler(subject, current.getShortUserName());
        }
        catch (Exception e) {
            LOG.error((Object)"Creating MaprSaslCallbackhandler Error.", (Throwable)e);
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new MaprSaslProvider());
        RpcAuthRegistry.addRpcAuthMethod((RpcAuthMethod)INSTANCE);
    }
}

