/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.io.WritableUtils;

public final class MapRPathId
implements PathId {
    private String fid = "";
    private long[] ips = new long[0];

    public String getFid() {
        return this.fid;
    }

    public long[] getIPs() {
        return this.ips;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public void setIps(long[] ips) {
        this.ips = ips;
    }

    public void setIps(List<Long> listIps) {
        this.ips = new long[listIps.size()];
        for (int i = 0; i < listIps.size(); ++i) {
            this.ips[i] = listIps.get(i);
        }
    }

    public void writeFields(DataOutput out) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)this.fid);
        WritableUtils.writeVInt((DataOutput)out, (int)this.ips.length);
        for (long l : this.ips) {
            WritableUtils.writeVLong((DataOutput)out, (long)l);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.fid = WritableUtils.readString((DataInput)in);
        this.ips = new long[WritableUtils.readVInt((DataInput)in)];
        for (int i = 0; i < this.ips.length; ++i) {
            this.ips[i] = WritableUtils.readVLong((DataInput)in);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof MapRPathId)) {
            return false;
        }
        MapRPathId otherFileId = (MapRPathId)other;
        return otherFileId.getFid().equals(this.fid) && Arrays.equals(otherFileId.getIPs(), this.ips);
    }

    public String toString() {
        return this.getClass() + "[ " + this.fid + " ipaddrs=" + Arrays.toString(this.ips) + " ]";
    }
}

