/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.Installation;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.BackgroundWork;
import com.mapr.fs.ClusterConf;
import com.mapr.fs.ClusterNotFoundException;
import com.mapr.fs.ErrnoException;
import com.mapr.fs.FSCommandHandler;
import com.mapr.fs.FileAceEntry;
import com.mapr.fs.FileAceMoreInfo;
import com.mapr.fs.Inode;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFileAce;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFsDataInputStream;
import com.mapr.fs.MapRFsDataOutputStream;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRPathId;
import com.mapr.fs.MapRPathToSecurityPolicyTags;
import com.mapr.fs.MapRReaddirLite;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.PathNotFoundException;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.beans.QueryServiceParam;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.GatewaySource;
import com.mapr.fs.jni.IOExceptionWithErrorCode;
import com.mapr.fs.jni.IPPort;
import com.mapr.fs.jni.JNIFileTierStatus;
import com.mapr.fs.jni.MapRClientInitParams;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRFileCount;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Error;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.tables.MapRDBMetadataMgr;
import com.mapr.fs.tables.TableBasicAttrs;
import com.mapr.fs.tables.TableCreateOptions;
import com.mapr.fs.tables.TableProperties;
import com.mapr.fs.util.Fids;
import com.mapr.security.UnixUserGroupHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MapRFileSystem
extends AbstractMapRFileSystem
implements MapRConstants {
    public static final URI MAPRFS_BASE_URI;
    private Map<String, MapRDBMetadataMgr> metadataMgrs_ = new HashMap<String, MapRDBMetadataMgr>();
    private Object metadataMgrLock = new Object();
    private static final int MAX_SYMLINK_HEIGHT = 8;
    private static final Log LOG;
    private static final Pattern FID_SPLITTER;
    private static ClusterConf clusterConf;
    private static Map<String, ClusterData> clusterTable;
    private static final Object numInstancesLock;
    private static int numInstances;
    private static Boolean initialized;
    private static boolean disableNameCache_;
    private static MapRClientInitParams clientInitParams;
    protected BiMap<String, Integer> securityPolicyNameToIdMap_ = HashBiMap.create();
    protected BiMap<Integer, String> securityPolicyIdToNameMap_ = this.securityPolicyNameToIdMap_.inverse();
    private URI uri = null;
    private String clusterName = null;
    private Boolean clusterNameUnique;
    private List<ClusterConf.ClusterEntry> localClusterList = new ArrayList<ClusterConf.ClusterEntry>();
    private Map<String, ClusterData> localClusterTable = new HashMap<String, ClusterData>();
    private org.apache.hadoop.fs.Path workingDir;
    private long chunkSize = 0x10000000L;
    private boolean chunkSizePresentInConf_ = false;
    private MapRUserInfo userInfo = null;
    private volatile boolean fileSystemOpen = false;
    private boolean setSeperateAuditPath = false;
    private boolean disableDirentCache = false;
    private static final String tableReplLicenseErrMsg = "Error: Operation not permitted, need an Enterprise license with Database module (for tables), Streams module (for streams)  or Changelog module (for changelogs) enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.";
    public final int MaxNumFileAces = 7;
    public static final String[] emptyStringArray;

    public static MapRUserInfo CurrentUserInfo() throws IOException {
        return MapRFileSystem.CurrentUserInfo(null);
    }

    public static MapRUserInfo CurrentUserInfo(String uname) throws IOException {
        UserGroupInformation loginUser;
        UserGroupInformation currentUser;
        boolean impersonating;
        block5: {
            impersonating = false;
            currentUser = null;
            loginUser = null;
            try {
                loginUser = UserGroupInformation.getLoginUser();
                if (loginUser.getRealUser() != null) {
                    loginUser = loginUser.getRealUser();
                }
                currentUser = uname == null || uname.isEmpty() ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createRemoteUser((String)uname);
                boolean bl = impersonating = !currentUser.getShortUserName().equals(loginUser.getShortUserName());
                if (impersonating) {
                    LOG.info((Object)("User " + loginUser.getShortUserName() + " impersonates user " + currentUser.getShortUserName()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Exception while trying to get currentUser", (Throwable)e);
                if (currentUser != null || loginUser != null) break block5;
                LOG.error((Object)"No current user or login user found");
                throw new IOException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentUser: " + MapRFileSystem.dumpUserGroupInformation(currentUser) + ", loginUser: " + MapRFileSystem.dumpUserGroupInformation(loginUser)));
        }
        MapRUserInfo uInfo = impersonating ? new MapRUserInfo(currentUser.getUserName(), currentUser.getShortUserName()) : new MapRUserInfo(loginUser.getUserName(), loginUser.getShortUserName());
        uInfo.SetImpersonationStatus(impersonating);
        return uInfo;
    }

    static String dumpUserGroupInformation(UserGroupInformation uginfo) {
        return uginfo == null ? "null" : uginfo.getUserName() + ":" + uginfo.getShortUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClientInitParams() {
        if (!initialized.booleanValue()) {
            Boolean bl = initialized;
            synchronized (bl) {
                if (!initialized.booleanValue()) {
                    clientInitParams = new MapRClientInitParams();
                }
            }
        }
    }

    public MapRFileSystem() throws IOException {
        this(null);
    }

    public MapRFileSystem(String uname) throws IOException {
        this.createClientInitParams();
        this.userInfo = MapRFileSystem.CurrentUserInfo(uname);
    }

    public MapRFileSystem(String cName, String[] cldbLocations) throws IOException {
        this(cName, cldbLocations, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRFileSystem(String cName, String[] cldbLocations, String uname) throws IOException {
        Map<String, ClusterData> map = clusterTable;
        synchronized (map) {
            if (!clusterTable.containsKey(cName)) {
                clusterConf.updateClusterEntry(this, cName, cldbLocations);
                this.clusterName = cName;
            }
        }
        this.createClientInitParams();
        this.userInfo = MapRFileSystem.CurrentUserInfo(uname);
        this.setConf(new Configuration());
        try {
            URI uri = new URI("maprfs", cName, "/", null, null);
            this.initConfig(uri);
        }
        catch (URISyntaxException uriException) {
            throw new IOException("Could not build URI for cluster: " + cName);
        }
        this.fileSystemOpen = true;
        this.initClusterSecurityPolicyCache();
    }

    private org.apache.hadoop.fs.Path adjustWorkingDir(String workingDirStr) {
        UserGroupInformation currentUser = null;
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception while trying to get currentUser", (Throwable)e);
        }
        String currentUserName = currentUser != null ? currentUser.getShortUserName() : this.userInfo.getUserName();
        if (workingDirStr != null && !((String)workingDirStr).isEmpty()) {
            workingDirStr = currentUserName != null ? ((String)workingDirStr).replaceAll("\\$USERNAME", currentUserName) : "/";
            if (!((String)workingDirStr).endsWith("/")) {
                workingDirStr = (String)workingDirStr + "/";
            }
            try {
                if (new URI((String)workingDirStr).getScheme() == null) {
                    workingDirStr = "maprfs:///" + (String)workingDirStr;
                }
            }
            catch (URISyntaxException e) {
                LOG.error((Object)("Exception while trying to parse working directory " + (String)workingDirStr), (Throwable)e);
            }
        } else {
            workingDirStr = currentUserName != null ? "/user/" + currentUserName + "/" : "/";
        }
        return new org.apache.hadoop.fs.Path((String)workingDirStr);
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.initialize(name, conf, false);
    }

    public void initialize(URI name, Configuration conf, boolean isExpandAuditTool) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.initConfig(name);
        this.setSeperateAuditPath = isExpandAuditTool;
        this.workingDir = this.adjustWorkingDir(conf.get("fs.mapr.working.dir"));
        this.fileSystemOpen = true;
    }

    private void InitializeClientInitParamsFromConf(Configuration conf) {
        MapRFileSystem.clientInitParams.setSeperateAuditPath = this.setSeperateAuditPath;
        MapRFileSystem.clientInitParams.aggregateWrites = conf.getBoolean("fs.mapr.aggregate.writes", true);
        MapRFileSystem.clientInitParams.numWriters = conf.getInt("fs.mapr.threads", MapRFileSystem.clientInitParams.aggregateWrites ? 8 : 64);
        if (MapRFileSystem.clientInitParams.numWriters <= 0) {
            MapRFileSystem.clientInitParams.numWriters = MapRFileSystem.clientInitParams.aggregateWrites ? 8 : 64;
        }
        MapRFileSystem.clientInitParams.tabletLruLimitKB = conf.getInt("fs.mapr.tabletlru.size.kb", 0);
        MapRFileSystem.clientInitParams.memPoolSize = conf.getInt("fs.mapr.shmpool.size", 2560);
        if (MapRFileSystem.clientInitParams.memPoolSize < 0) {
            MapRFileSystem.clientInitParams.memPoolSize = 2560;
        }
        MapRFileSystem.clientInitParams.allTrace = conf.getTrimmed("fs.mapr.trace");
        if (MapRFileSystem.clientInitParams.allTrace == null) {
            MapRFileSystem.clientInitParams.allTrace = System.getProperty("fs.mapr.trace");
        }
        if (MapRFileSystem.clientInitParams.allTrace != null && MapRFileSystem.clientInitParams.allTrace.equalsIgnoreCase("DEBUG")) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        MapRFileSystem.clientInitParams.slowOpsThreshold = conf.getInt("fs.mapr.slowops.threshold", 0);
        if (MapRFileSystem.clientInitParams.slowOpsThreshold > 0) {
            MapRClientImpl.setSlowOpsThreshold(MapRFileSystem.clientInitParams.slowOpsThreshold);
        }
        MapRFileSystem.clientInitParams.disableLocalIO = conf.getBoolean("fs.mapr.io.remoteonly", false);
        MapRFileSystem.clientInitParams.shuffleCldbBindings = conf.getBoolean("shuffle.cldb.bindings", true);
        MapRFileSystem.clientInitParams.disableRdmaTransport = conf.getBoolean("fs.mapr.disable.rdma.transport", false);
        MapRFileSystem.clientInitParams.rpcServerSelectFuncType = conf.getInt("fs.mapr.rpc.server.select.func", 0);
        MapRFileSystem.clientInitParams.asyncSubscriptionCallbackEnabled = conf.getBoolean("streams.async.subscription.callback.enabled", false);
        MapRFileSystem.clientInitParams.rpcTimeoutSec = conf.getInt("streams.rpc.timeout.ms", 0) / 1000;
        if (MapRFileSystem.clientInitParams.rpcTimeoutSec == 0) {
            MapRFileSystem.clientInitParams.rpcTimeoutSec = conf.getInt("fs.mapr.rpc.timeout", 0);
        }
        MapRFileSystem.clientInitParams.connectTimeout = conf.getInt("fs.mapr.connect.timeout", 0);
        MapRFileSystem.clientInitParams.useSingleMfsPort = conf.getBoolean("fs.mapr.use.single.mfsport", false);
        MapRFileSystem.clientInitParams.spoofedUser = conf.get("hadoop.spoofed.user.username", "root");
        MapRFileSystem.clientInitParams.spoofedUid = conf.getInt("hadoop.spoofed.user.uid", 0);
        if (MapRFileSystem.clientInitParams.spoofedUid < 0) {
            MapRFileSystem.clientInitParams.spoofedUid = 0;
        }
        MapRFileSystem.clientInitParams.spoofedGroup = conf.get("hadoop.spoofed.user.groupname", "root");
        MapRFileSystem.clientInitParams.spoofedGid = conf.getInt("hadoop.spoofed.user.gid", 0);
        if (MapRFileSystem.clientInitParams.spoofedGid < 0) {
            MapRFileSystem.clientInitParams.spoofedGid = 0;
        }
        MapRFileSystem.clientInitParams.dbPutThresholdMB = conf.getInt("db.mapr.putbuffer.threshold.mb", 0);
        MapRFileSystem.clientInitParams.dbPutThresholdSec = conf.getInt("db.mapr.putbuffer.threshold.sec", 0);
        MapRFileSystem.clientInitParams.dbPutBufSize = conf.getInt("db.mapr.putbuffer.size", 0);
        MapRFileSystem.clientInitParams.dbTableSchemaTTLMillis = conf.getInt("db.mapr.tableschema.ttl.millis", 0);
        MapRFileSystem.clientInitParams.dbTabletMapTTLMillis = conf.getInt("db.mapr.tabletmap.ttl.millis", 0);
        MapRFileSystem.clientInitParams.dbTableCacheMaxLruSizeMB = conf.getInt("db.mapr.tablecache.max_lrusize.mb", 0);
        MapRFileSystem.clientInitParams.dbTableCacheMaxSizeMB = conf.getInt("db.mapr.tablecache.max_size.mb", 0);
        MapRFileSystem.clientInitParams.readBuffering = conf.getBoolean("fs.mapr.readbuffering", true);
        MapRFileSystem.clientInitParams.blQueueSizeMB = conf.getInt("db.mapr.bulkload.queuesize.mb", 0);
        MapRFileSystem.clientInitParams.blFlags = conf.getInt("db.mapr.bulkload.flags", 0);
        MapRFileSystem.clientInitParams.numThreadPoolThreads = conf.getInt("fs.mapr.pool.threads", 10);
        MapRFileSystem.clientInitParams.highPriThreadPoolThreads = conf.getInt("fs.mapr.highpri.pool.threads", 2);
        MapRFileSystem.clientInitParams.dbAsyncWorkThreads = conf.getInt("fs.mapr.db.async.work.threads", 2);
        MapRFileSystem.clientInitParams.maxThreadPoolQueueSize = conf.getInt("fs.mapr.pool.queue.max_size", 10000);
        MapRFileSystem.clientInitParams.maxThreadPoolBatchSize = conf.getInt("fs.mapr.pool.batch.size", 128);
        MapRFileSystem.clientInitParams.idleFlusherTimeout = conf.getInt("fs.mapr.write.idleflush.timeout", 3);
        if (MapRFileSystem.clientInitParams.idleFlusherTimeout < 0) {
            MapRFileSystem.clientInitParams.idleFlusherTimeout = 3;
        } else if (MapRFileSystem.clientInitParams.idleFlusherTimeout == 0) {
            MapRFileSystem.clientInitParams.idleFlusherEnabled = false;
        }
        MapRFileSystem.clientInitParams.flushUnaligned = conf.getBoolean("fs.mapr.flush.unaligned", false);
        MapRFileSystem.clientInitParams.hardMount = conf.getBoolean("fs.mapr.hardmount", true);
        MapRFileSystem.clientInitParams.maxRAThreads = conf.getInt("fs.mapr.rathreads", 0);
        MapRFileSystem.clientInitParams.javaRAThreadsPerStream = conf.getInt("fs.mapr.java.ra.threads.per.stream", 2);
        if (MapRFileSystem.clientInitParams.javaRAThreadsPerStream > 8) {
            MapRFileSystem.clientInitParams.javaRAThreadsPerStream = 8;
        } else if (MapRFileSystem.clientInitParams.javaRAThreadsPerStream <= 0) {
            MapRFileSystem.clientInitParams.javaRAThreadsPerStream = 2;
        }
        MapRFileSystem.clientInitParams.resolveUserAtServer = conf.getBoolean("fs.mapr.server.resolve.user", false);
        String fsMaprBailoutOnLibraryMismatchConfig = "fs.mapr.bailout.on.library.mismatch";
        MapRFileSystem.clientInitParams.bailOutOnLibMismatch = conf.getBoolean("fs.mapr.bailout.on.library.mismatch", Boolean.valueOf(System.getProperty("fs.mapr.bailout.on.library.mismatch", "true")).booleanValue());
        if (MapRFileSystem.clientInitParams.maxRAThreads > 256) {
            MapRFileSystem.clientInitParams.maxRAThreads = 256;
        } else if (MapRFileSystem.clientInitParams.maxRAThreads != 0 && MapRFileSystem.clientInitParams.maxRAThreads < 10) {
            MapRFileSystem.clientInitParams.maxRAThreads = 10;
        }
        MapRFileSystem.clientInitParams.bindRetries = conf.getBoolean("fs.mapr.bind.retries", false);
        MapRFileSystem.clientInitParams.uidCacheTimeoutSeconds = conf.getInt("fs.mapr.uid.cache.timeout.seconds", 1800);
        if (MapRFileSystem.clientInitParams.uidCacheTimeoutSeconds < 0) {
            MapRFileSystem.clientInitParams.uidCacheTimeoutSeconds = 1800;
        }
        MapRFileSystem.clientInitParams.flushInline = conf.getBoolean("fs.mapr.write.flush.inline", false);
        MapRFileSystem.clientInitParams.disableDirentCache = conf.getBoolean("fs.mapr.disable.dirent.cache", false);
        MapRFileSystem.clientInitParams.ticketRefreshInterval = conf.getInt("fs.mapr.ticket.refresh.interval", 30);
        if (MapRFileSystem.clientInitParams.ticketRefreshInterval < 0) {
            MapRFileSystem.clientInitParams.ticketRefreshInterval = 30;
        }
        MapRFileSystem.clientInitParams.bindingInactiveThreshold = conf.getInt("fs.mapr.binding.inactive.threshold", 0);
        MapRFileSystem.clientInitParams.highMemoryThresholdPercentageToDie = conf.getInt("fs.mapr.high.memory.threshold.percent.to.die", 0);
        MapRFileSystem.clientInitParams.scanPrefetchBytes = conf.getInt("db.mapr.scan.prefetch.bytes", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getClustersfromConfObject(Configuration conf) {
        String[] clusterList;
        String clusterListKey = "dfs.nameservices";
        String cldbListPrefix = "dfs.ha.namenodes.";
        String cldbAddressPrefix = "dfs.namenode.rpc-address.";
        String clusterIsUnique = "fs.mapr.impl.clustername.unique";
        if (conf == null) {
            return;
        }
        Object object = this.localClusterList;
        synchronized (object) {
            this.localClusterList.clear();
        }
        object = this.localClusterTable;
        synchronized (object) {
            this.localClusterTable.clear();
        }
        this.clusterNameUnique = conf.getBoolean(clusterIsUnique, true);
        for (String cluster : clusterList = conf.getTrimmedStrings(clusterListKey)) {
            Map<String, ClusterData> cTable = this.clusterNameUnique == false ? this.localClusterTable : clusterTable;
            Map<String, ClusterData> map = cTable;
            synchronized (map) {
                if (cTable.containsKey(cluster)) {
                    cTable.remove(cluster);
                }
            }
            String[] cldbList = conf.getTrimmedStrings(cldbListPrefix + cluster);
            ArrayList<String> cldbLocations = new ArrayList<String>();
            for (String cldb : cldbList) {
                String cldbAddress = conf.getTrimmed(cldbAddressPrefix + cluster + "." + cldb);
                if (cldbAddress == null) continue;
                cldbLocations.add(cldbAddress);
            }
            if (cldbLocations.size() <= 0) continue;
            String[] cldbIps = new String[cldbLocations.size()];
            cldbIps = cldbLocations.toArray(cldbIps);
            clusterConf.updateClusterEntry(this, cluster, cldbIps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfig(URI name) throws IOException {
        Object object;
        block24: {
            Configuration conf = this.getConf();
            if (conf != null) {
                this.chunkSize = conf.getLong("fs.mapr.block.size", -1L);
                boolean bl = this.chunkSizePresentInConf_ = this.chunkSize >= 0L;
                if (!this.chunkSizePresentInConf_) {
                    this.chunkSize = conf.getLong("dfs.blocksize", -1L);
                    boolean bl2 = this.chunkSizePresentInConf_ = this.chunkSize >= 0L;
                    if (!this.chunkSizePresentInConf_) {
                        this.chunkSize = 0x10000000L;
                    }
                }
                if (this.chunkSize % 65536L != 0L) {
                    throw new IOException("chunksize should be a multiple of 64K");
                }
                if (!initialized.booleanValue()) {
                    object = initialized;
                    synchronized (object) {
                        if (!initialized.booleanValue()) {
                            if (conf != null) {
                                disableNameCache_ = conf.getBoolean("fs.mapr.disable.namecache", false);
                                this.InitializeClientInitParamsFromConf(conf);
                            }
                            if (MapRClientImpl.initSpoofedUser((String)MapRFileSystem.clientInitParams.spoofedUser, (int)MapRFileSystem.clientInitParams.spoofedUid, (String)MapRFileSystem.clientInitParams.spoofedGroup, (int)MapRFileSystem.clientInitParams.spoofedGid) != 0) {
                                throw new IOException("Failed to initialize spoofed user");
                            }
                            Inode.allocWriteBuffers(MapRFileSystem.clientInitParams.memPoolSize);
                            MapRClientImpl.setReadBuffering(MapRFileSystem.clientInitParams.readBuffering);
                            MapRClientImpl.setJavaRAThreadsPerStream(MapRFileSystem.clientInitParams.javaRAThreadsPerStream);
                            initialized = true;
                        }
                    }
                }
            }
            this.getClustersfromConfObject(conf);
            if (name != null) {
                try {
                    ClusterConf.ClusterEntry centry = clusterConf.getClusterByUri(this, name);
                    this.clusterName = centry.getClusterName();
                    if (name.getHost() != null || name.getAuthority() != null) {
                        this.uri = name;
                        break block24;
                    }
                    try {
                        this.uri = new URI(name.getScheme(), "", name.getPath(), null, null);
                    }
                    catch (URISyntaxException uriException) {
                        throw new IOException("Could not build URI");
                    }
                }
                catch (IOException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)"Could not find any cluster, defaulting to localhost");
                    }
                    ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByAddr(this, "127.0.0.1", 7222);
                    this.clusterName = centry.getClusterName();
                    String authority = "127.0.0.1:7222";
                    try {
                        this.uri = new URI("maprfs", authority, "/", null, null);
                    }
                    catch (URISyntaxException uriException) {
                        throw new IOException("Could not build URI");
                    }
                }
            }
        }
        object = numInstancesLock;
        synchronized (object) {
            if (numInstances == 0) {
                BackgroundWork.init();
            }
            ++numInstances;
        }
    }

    private void initClusterSecurityPolicyCache() throws IOException {
        Map<String, Integer> policyList = this.getClusterSecurityPolicies();
        this.securityPolicyNameToIdMap_.putAll(policyList);
        this.securityPolicyIdToNameMap_ = this.securityPolicyNameToIdMap_.inverse();
    }

    public PathId createPathId() {
        MapRPathId pathId = new MapRPathId();
        return pathId;
    }

    private static void initError(MapRConstants.ErrorValue err) {
        err.error = 0;
        err.trailpath = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterData lookupClient(ClusterConf.ClusterEntry centry) throws IOException {
        this.checkOpen();
        ClusterData retCluster = null;
        String cluster = centry.getClusterName();
        Map<String, ClusterData> cTable = this.clusterNameUnique == false ? this.localClusterTable : clusterTable;
        Map<String, ClusterData> map = cTable;
        synchronized (map) {
            if (cTable.containsKey(cluster)) {
                retCluster = cTable.get(cluster);
            } else {
                try {
                    if (clientInitParams != null && this.setSeperateAuditPath) {
                        MapRFileSystem.clientInitParams.setSeperateAuditPath = this.setSeperateAuditPath;
                    }
                    MapRClientImpl client = new MapRClientImpl(cluster, centry.getIPs(this), centry.getNumIpsPerCldb(), "", disableNameCache_, clientInitParams);
                    retCluster = new ClusterData(client);
                    cTable.put(cluster, retCluster);
                }
                catch (Exception e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }
        }
        if (this.clusterName == null) {
            this.clusterName = cluster;
        }
        if (!this.userInfo.infoIsComplete()) {
            if (0 != retCluster.client.GetUserInfo(this.userInfo)) {
                UnixUserGroupHelper ugh = new UnixUserGroupHelper();
                int uid = ugh.getUserId(this.userInfo.getUserName());
                int[] gid = ugh.getGroups(this.userInfo.getUserName());
                if (uid < 0) {
                    throw new IOException("Error getting user info for current user, " + this.userInfo.getUserName());
                }
                this.userInfo.SetUserID(uid);
                this.userInfo.SetGroupIDList(gid);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User Info object initialized for user " + this.userInfo.getUserName() + " with user ID " + this.userInfo.GetUserID()));
            }
            this.userInfo.idInfoIsPopulated();
        }
        return retCluster;
    }

    private ClusterData lookupClient(org.apache.hadoop.fs.Path p) throws IOException {
        ClusterConf.ClusterEntry centry;
        URI tmpURI = this.uri;
        URI absPathURI = this.makeAbsolute(p).toUri();
        if (tmpURI == null) {
            tmpURI = absPathURI;
        }
        if (this.clusterName == null) {
            LOG.debug((Object)"lookupClient: Cluster name is null");
        }
        if ((centry = clusterConf.getClusterByPath(this, absPathURI, tmpURI, this.clusterName)) == null) {
            throw new IOException("Could not resolve path: " + p.toString());
        }
        return this.lookupClient(centry);
    }

    public void forceLocalResolution(URI name) throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterByUri(this, name);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            throw new IOException("Could not lookup client object");
        }
        clusterData.client.forceLocalResolution();
    }

    public void access(org.apache.hadoop.fs.Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        int error = 0;
        int accessBitsOut = 0;
        LOG.debug((Object)("Enter access: path " + path.toString() + "mode " + mode));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                throw new IOException("Bad URI: no such cluster, path: " + path);
            }
            MapRFileSystem.initError(err);
            if (mode == FsAction.NONE) {
                LOG.debug((Object)"Exit access: failed mode is not set");
                return;
            }
            accessBitsOut = clusterData.client.getUserPermission(this.getName(path), mode, err, this.userInfo);
            error = err.error;
            if (error < 0) {
                error = -error;
            }
            if (error == 2) {
                throw new FileNotFoundException(path.toString());
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (error == 136 && clusterCount < 8);
        if (accessBitsOut == 0) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ") does not have access to " + path);
        }
        LOG.debug((Object)"Exit access:");
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, FsPermission permission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        boolean createIfNonExistant = false;
        boolean append = false;
        boolean overwrite = false;
        for (CreateFlag fl : flag) {
            if (fl == CreateFlag.CREATE) {
                createIfNonExistant = true;
                continue;
            }
            if (fl == CreateFlag.APPEND) {
                append = true;
                continue;
            }
            if (fl != CreateFlag.OVERWRITE) continue;
            overwrite = true;
        }
        return this.create(f, 128, permission, createIfNonExistant, append, overwrite, bufferSize, replication, blockSize, progress, true);
    }

    public FSDataOutputStream createNonRecursive(org.apache.hadoop.fs.Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (!this.exists(f.getParent())) {
            throw new IOException("Parent to path " + f + " does not exist.");
        }
        return this.create(f, 128, permission, true, false, overwrite, bufferSize, replication, blockSize, progress, false);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, int mask, FsPermission permission, boolean createIfNonExistant, boolean append, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, boolean createParent) throws IOException {
        MapRFsOutStream os;
        LOG.debug((Object)("Enter create: path " + f.toString() + "mask " + mask + "permission " + permission + "createIfNonExistant " + createIfNonExistant + "append " + append + "overwrite " + overwrite + "bufferSize " + bufferSize + "replication " + replication + "blockSize " + blockSize + "createParent " + createParent));
        if (append && overwrite) {
            if (createIfNonExistant) {
                throw new HadoopIllegalArgumentException("CREATE, APPEND and OVERWRITE set in CreateFlag");
            }
            throw new HadoopIllegalArgumentException("APPEND and OVERWRITE set in CreateFlag");
        }
        if (this.exists(f)) {
            if (createIfNonExistant && !append && !overwrite) {
                throw new FileAlreadyExistsException("Path " + f + " already exists");
            }
        } else if (!createIfNonExistant) {
            throw new FileNotFoundException("Path " + f + " not found");
        }
        if (blockSize % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int mode = MapRClientImpl.getModeBits(permission, this.getConf());
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                throw new IOException("Bad URI - no such cluster");
            }
            MapRFileSystem.initError(err);
            os = clusterData.client.create(this.getName(f), mask, mode, createIfNonExistant, append, overwrite, replication, blockSize, progress, err, createParent, this.userInfo, this.statistics);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ") does not have access to create " + f);
            }
            if (err.error != 136) continue;
            f = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        MapRFsDataOutputStream dos = null;
        if (os != null) {
            dos = new MapRFsDataOutputStream(os);
            if (append) {
                os.seekToEof();
            }
        }
        LOG.debug((Object)"Exit create: success");
        return dos;
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, 128, FsPermission.getDefault(), true, false, overwrite, bufferSize, replication, blockSize, null, true);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, 128, permission, true, false, overwrite, bufferSize, replication, blockSize, progress, true);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, boolean overwrite) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, overwrite, 0, this.getDefaultReplication(), this.chunkSize, null, true);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, true, 0, this.getDefaultReplication(), this.chunkSize, progress, true);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, short replication) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, true, 0, replication, this.chunkSize, null, true);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, true, 0, replication, this.chunkSize, progress, true);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, overwrite, bufferSize, this.getDefaultReplication(), this.chunkSize, null, true);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, false, overwrite, bufferSize, this.getDefaultReplication(), this.chunkSize, progress, true);
    }

    public boolean truncate(org.apache.hadoop.fs.Path f, long newLength) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        boolean ret = false;
        int clusterCount = 0;
        LOG.debug((Object)("Enter truncate: path " + f.toString() + "newLength: " + newLength));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                throw new IOException("Could not get MapClient object");
            }
            MapRFileSystem.initError(err);
            ret = clusterData.client.truncate(this.getName(f), newLength, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ") does not have access to " + f);
            }
            if (err.error != 136) continue;
            f = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new IOException("Truncate failed for file " + f + " with error " + err.error);
        }
        LOG.debug((Object)("Exit truncate: ret " + ret));
        return ret;
    }

    public FSDataInputStream open(org.apache.hadoop.fs.Path f, int bufferSize) throws IOException, AccessControlException {
        MapRFsInStream is;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        LOG.debug((Object)("Enter open: path " + f.toString() + "bufferSize " + bufferSize));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                LOG.debug((Object)"Exit open: failed lookupClient");
                return null;
            }
            MapRFileSystem.initError(err);
            is = clusterData.client.open(this.getName(f), err, this.userInfo, this.statistics);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ") does not have access to " + f);
            }
            if (err.error != 136) continue;
            f = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (is != null) {
            LOG.debug((Object)"Exit open: success returning MapRFsDataInputStream()");
            return new MapRFsDataInputStream(is);
        }
        LOG.debug((Object)"Exit open: failed");
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return this.getUri().getScheme();
    }

    public FSDataOutputStream append(org.apache.hadoop.fs.Path f, int bufferSize, Progressable progress) throws IOException, AccessControlException {
        MapRFsOutStream os;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        LOG.debug((Object)("Enter append: path " + f.toString() + "bufferSize " + bufferSize));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                LOG.debug((Object)"Exit append: failed lookupClient");
                return null;
            }
            MapRFileSystem.initError(err);
            os = clusterData.client.append(this.getName(f), err, this.userInfo, this.statistics);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
            }
            if (err.error != 136) continue;
            f = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (os != null) {
            LOG.debug((Object)"Exit append: success returning MapRFsDataOutputStream");
            return new MapRFsDataOutputStream(os);
        }
        LOG.debug((Object)"Exit append: failed");
        return null;
    }

    public FileStatus getFileStatus(org.apache.hadoop.fs.Path f) throws IOException {
        LOG.debug((Object)("Enter getFileStatus: path " + f.toString()));
        MapRFileStatus ret = this.getMapRFileStatus(f);
        LOG.debug((Object)("Exit getFileStatus: ret " + ret));
        return ret;
    }

    public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) throws IOException {
        int ret;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        LOG.debug((Object)("Enter rename: src " + src.toString() + "dst " + dst));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(src)) == null) {
                LOG.debug((Object)"Exit rename: failed lookupClient");
                return false;
            }
            MapRFileSystem.initError(err);
            ret = clusterData.client.rename(this.getName(src), this.getName(dst), err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            src = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (ret == 18) {
            org.apache.hadoop.fs.Path tmpDst;
            FileStatus sdst;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Cannot rename across volumes, falling back on copy/delete semantics");
            }
            if (this.exists(dst) && (sdst = this.getFileStatus(dst)).isDir()) {
                dst = new org.apache.hadoop.fs.Path(dst, src.getName());
            }
            if (this.exists(tmpDst = dst.suffix(".tmp~!@"))) {
                this.delete(tmpDst, true);
            }
            if (!FileUtil.copy((FileSystem)this, (org.apache.hadoop.fs.Path)src, (FileSystem)this, (org.apache.hadoop.fs.Path)tmpDst, (boolean)false, (Configuration)this.getConf())) {
                this.delete(tmpDst, true);
                LOG.error((Object)("Exit rename: failed to copy src: " + src + "dst: " + tmpDst));
                return false;
            }
            if (!this.rename(tmpDst, dst)) {
                LOG.error((Object)("Exit rename: failed to rename " + tmpDst + " to " + dst));
                return false;
            }
            this.copyAce(src, dst);
            if (!this.delete(src, true)) {
                LOG.error((Object)("Exit rename: failed to delete " + src));
                return false;
            }
            ret = 0;
        }
        if (ret == 2 || ret == 17) {
            LOG.debug((Object)"Exit rename: failed due to ENOENT or EEXIST");
            return false;
        }
        if (ret == 13) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ") does has been denied access to rename  " + this.getName(src) + " to " + this.getName(dst));
        }
        if (ret != 0) {
            throw new IOException("Error: " + Errno.toString((int)(ret < 0 ? -ret : ret)));
        }
        LOG.debug((Object)"Exit rename: success");
        return true;
    }

    public boolean delete(org.apache.hadoop.fs.Path f, boolean recursive) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter delete: path " + f.toString() + "recursive " + recursive));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                LOG.debug((Object)"Exit delete: failed lookupClient");
                return false;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.delete(this.getName(f), recursive, false, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
            }
            if (error == 136) {
                f = new org.apache.hadoop.fs.Path(err.trailpath);
                continue;
            }
            if (error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
            }
            if (error == 2) {
                LOG.debug((Object)("Cannot delete non existent path " + f));
                continue;
            }
            if (error == 0) continue;
            LOG.error((Object)("Failed to delete path " + f + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")"));
            try {
                MapRFileStatus fStatus = this.getMapRFileStatus(f);
                if (fStatus.isDir() && !recursive) {
                    throw new IOException("Could not delete dir " + f + ", Error: " + Errno.toString((int)err.error) + ", Try with recursive flag set to true");
                }
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Exit delete: failed file " + f.toString() + " not found"));
                return false;
            }
        } while (error == 136);
        boolean ret = error == 0;
        LOG.debug((Object)("Exit delete: ret " + ret));
        return ret;
    }

    public boolean deleteTable(org.apache.hadoop.fs.Path tablePath) throws IOException {
        if (this.delete(tablePath, false)) {
            String tablePathStr = this.makeAbsolute(tablePath).toUri().getPath();
            String clusterName = this.getClusterNameUnchecked(tablePathStr);
            this.metadataMgr(clusterName).deleteEntry(tablePathStr);
            return true;
        }
        return false;
    }

    public boolean delete(org.apache.hadoop.fs.Path f) throws IOException {
        return this.delete(f, true);
    }

    public void setWorkingDirectory(org.apache.hadoop.fs.Path new_dir) {
        this.workingDir = this.adjustWorkingDir(this.makeAbsolute(new_dir).toString());
    }

    public org.apache.hadoop.fs.Path getWorkingDirectory() {
        return this.workingDir;
    }

    public long getDefaultBlockSize() {
        return this.chunkSize;
    }

    int shouldUseDefaultBlockSize() {
        return this.chunkSizePresentInConf_ ? 128 : 0;
    }

    public short getDefaultReplication() {
        return 3;
    }

    public MapRUserInfo getUserInfo() {
        return this.userInfo;
    }

    public void populateUserInfo(org.apache.hadoop.fs.Path p) throws IOException {
        ClusterData clusterData = this.lookupClient(p);
        if (clusterData == null) {
            throw new IOException("Bad URI: no such cluster, path: " + p);
        }
    }

    public MapRUserInfo populateAndGetUserInfo(org.apache.hadoop.fs.Path p) throws IOException {
        this.populateUserInfo(p);
        return this.userInfo;
    }

    String makeDir(org.apache.hadoop.fs.Path p, int mask, int mode, boolean z, long chunkSize, boolean needFid, boolean createParent) throws IOException {
        int error;
        LOG.debug((Object)("Enter makeDir path " + p.toString() + "mask " + mask + "mode " + mode + "z " + z + "needFid " + needFid + "createParent " + createParent));
        if (chunkSize % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(p)) == null) {
                throw new IOException("Bad URI: no such cluster, path: " + p);
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.mkdirs(this.getName(p), mask, mode, z, chunkSize, err, needFid, createParent, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (error != 136) continue;
            p = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            if (error < 0) {
                error = -error;
            }
            if (error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  has been denied access to create " + p.getName());
            }
            throw new IOException("Error: " + Errno.toString((int)error) + "(" + error + "), file: " + p.getName() + ", user name: " + this.userInfo.getUserName() + ", ID: " + this.userInfo.GetUserID());
        }
        String ret = needFid ? err.fid : null;
        LOG.debug((Object)("Exit makeDir: ret " + ret));
        return ret;
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path p, FsPermission permission) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(permission, this.getConf()), true, this.chunkSize, false, true);
        return true;
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path p, boolean createParent, FsPermission permission) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(permission, this.getConf()), true, this.chunkSize, false, createParent);
        return true;
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path p, FsPermission permission, boolean compress) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize() | 0x40, MapRClientImpl.getModeBits(permission, this.getConf()), compress, this.chunkSize, false, true);
        return true;
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path f, FsPermission permission, long chunkSize) throws IOException {
        this.makeDir(f, 128, MapRClientImpl.getModeBits(permission, this.getConf()), true, chunkSize, false, true);
        return true;
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path f, FsPermission permission, boolean compress, long chunkSize) throws IOException {
        this.makeDir(f, 192, MapRClientImpl.getModeBits(permission, this.getConf()), compress, chunkSize, false, true);
        return true;
    }

    private static MapRFileStatus adjustFileStatus(MapRFileStatus fstatus, boolean needAuthority, String authority) {
        if (needAuthority) {
            org.apache.hadoop.fs.Path p = new org.apache.hadoop.fs.Path("maprfs", authority, fstatus.getPath().toString());
            fstatus.setPath(p);
        }
        return fstatus;
    }

    public MapRFileStatus getMapRFileStatus(org.apache.hadoop.fs.Path f) throws IOException {
        MapRFileStatus fstatus;
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        LOG.debug((Object)("Enter getMapRFileStatus path " + f.toString()));
        boolean needAuthority = authority != null && !authority.isEmpty();
        String rawPath = u.getPath();
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            LOG.debug((Object)"Exit getMapRFileStatus: with adjustFileStatus");
            return MapRFileSystem.adjustFileStatus(new MapRFileStatus("/mapr", System.currentTimeMillis()), needAuthority, authority);
        }
        boolean needSlashMapr = rawPath.startsWith("/mapr/");
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                LOG.debug((Object)"Exit getMapRFileStatus: failed lookupClient");
                return null;
            }
            MapRFileSystem.initError(err);
            fstatus = clusterData.client.getFileStatus(this.getNameStr(rawPath), needSlashMapr, this.getScheme(), authority, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
            }
            if (err.error != 136) continue;
            f = new org.apache.hadoop.fs.Path(err.trailpath);
            u = this.makeAbsolute(f).toUri();
            authority = u.getAuthority();
            rawPath = u.getPath();
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (fstatus == null) {
            throw new FileNotFoundException("Requested file " + f + " does not exist" + (String)(f.isAbsolute() ? "." : " (Absolute path: " + rawPath + ")."));
        }
        LOG.debug((Object)("Exit getMapRFileStatus: ret " + fstatus));
        return fstatus;
    }

    public int fetchGNSConf() throws IOException {
        LOG.debug((Object)"Enter fetchGNSConf");
        int ret = 0;
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            LOG.debug((Object)"Exit fetchGNSConf: failed lookupClient");
            return 2;
        }
        byte[] respByteArray = clusterData.client.fetchGNSClusters();
        if (respByteArray == null) {
            return 22;
        }
        CLDBProto.ClusterGroupListResponse resp = CLDBProto.ClusterGroupListResponse.parseFrom((byte[])respByteArray);
        if (resp.getStatus() != 0) {
            LOG.debug((Object)("failed to generate the merged trust store, err " + resp.getStatus()));
            return resp.getStatus();
        }
        List respConfs = resp.getCcConfsList();
        ret = this.generateMergedTrustStore(respConfs);
        LOG.debug((Object)("Exit fetchGNSConf: ret " + ret));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRFileStatus[] slashReaddir(String authority) throws IOException {
        boolean needAuthority = authority != null && !authority.isEmpty();
        LOG.debug((Object)("Enter slashReaddir: authority " + authority));
        int err = this.fetchGNSConf();
        if (err == 0) {
            clusterConf.refreshClusterList();
        } else {
            LOG.debug((Object)("Failed to fetch GNS info " + err));
        }
        List<ClusterConf.ClusterEntry> clusterList = clusterConf.getClusterList();
        if (clusterList.isEmpty()) {
            LOG.debug((Object)"Exit slashReaddir: failed clusterConf.getClusterList");
            return null;
        }
        MapRFileStatus[] result = new MapRFileStatus[clusterList.size()];
        List<ClusterConf.ClusterEntry> list = clusterList;
        synchronized (list) {
            int i = 0;
            long time = System.currentTimeMillis();
            for (ClusterConf.ClusterEntry centry : clusterList) {
                result[i] = MapRFileSystem.adjustFileStatus(new MapRFileStatus("/mapr/" + centry.getClusterName(), time), needAuthority, authority);
                ++i;
            }
        }
        LOG.debug((Object)("Exit slashReaddir: ret " + result));
        return result;
    }

    public MapRFileStatus[] listMapRStatus(org.apache.hadoop.fs.Path f, boolean showVols, boolean showHidden) throws IOException {
        MapRFileStatus status;
        String name;
        ClusterData clusterData;
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        String rawPath = u.getPath();
        LOG.debug((Object)("Enter listMapRStatus: path " + f.toString() + "showVols " + showVols + "showHidden " + showHidden));
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            LOG.debug((Object)"Exit listMapRStatus: with slashReaddir()");
            return this.slashReaddir(authority);
        }
        boolean needSlashMapr = rawPath.startsWith("/mapr/");
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            if ((clusterData = this.lookupClient(f)) == null) {
                LOG.debug((Object)"Exit listMapRStatus: failed lookupClient");
                throw new IOException("Could not lookup mapr client for path " + f);
            }
            MapRFileSystem.initError(err);
            name = this.getNameStr(rawPath);
            status = clusterData.client.getFileStatus(name, needSlashMapr, this.getScheme(), authority, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            f = new org.apache.hadoop.fs.Path(err.trailpath);
            u = this.makeAbsolute(f).toUri();
            authority = u.getAuthority();
            rawPath = u.getPath();
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error == 13) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
        }
        if (status == null) {
            throw new FileNotFoundException(f.toString());
        }
        if (status.isDir()) {
            MapRFileStatus[] result = clusterData.client.listStatus(name, showVols, needSlashMapr, showHidden, this.getScheme(), authority, err, this.userInfo);
            if (result == null) {
                if (err.error < 0) {
                    err.error = -err.error;
                }
                if (err.error == 13) {
                    throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
                }
                if (err.error == 1) {
                    throw new IOException("Failed to list contents of dir " + f + ", err: " + Errno.toString((int)err.error) + "(" + err.error + ")");
                }
                if (err.error == 36) {
                    throw new IOException("File Path too long of dir " + f + ", err: " + Errno.toString((int)err.error) + "(" + err.error + ")");
                }
                if (err.error != 0) {
                    throw new IOException("Failed to list contents of dir " + f + ", err: " + Errno.toString((int)err.error) + "(" + err.error + ")");
                }
                LOG.debug((Object)"Exit listMapRStatus: return empty result");
                return new MapRFileStatus[0];
            }
            LOG.debug((Object)("Exit listMapRStatus: ret " + result));
            return result;
        }
        LOG.debug((Object)("Exit listMapRStatus: status " + status));
        return new MapRFileStatus[]{status};
    }

    public MapRReaddirLite listStatusLite(org.apache.hadoop.fs.Path f, int cid, int cinum, int uniq, int count, long cookie, boolean showHidden) throws IOException {
        MapRFileStatus[] statuses;
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        String rawPath = u.getPath();
        int entriesCount = 0;
        long respCookie = 0L;
        LOG.debug((Object)("Enter listStatusLite: path " + f + "cid " + cid + "cinum " + cinum + "uniq count " + count + "cookie " + cookie + "showHidden " + showHidden));
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            statuses = this.slashReaddir(authority);
        } else {
            ClusterData clusterData = this.lookupClient(f);
            if (clusterData == null) {
                LOG.debug((Object)"Exit listStatusLite: failed lookupClient");
                return null;
            }
            String name = this.getNameStr(rawPath);
            MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
            MapRFileSystem.initError(err);
            statuses = clusterData.client.listStatusLite(name, cid, cinum, uniq, count, cookie, showHidden, this.getScheme(), authority, err, this.userInfo);
            if (statuses == null) {
                if (err.error < 0) {
                    err.error = -err.error;
                }
                if (err.error == 13) {
                    throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
                }
                if (err.error == 1) {
                    throw new IOException("Failed to list contents of dir " + f + ", err: " + Errno.toString((int)err.error) + "(" + err.error + ")");
                }
            }
        }
        if (statuses != null && statuses.length > 0) {
            entriesCount = statuses.length;
            respCookie = statuses[entriesCount - 1].getOffset();
        }
        MapRReaddirLite result = new MapRReaddirLite(entriesCount, respCookie, statuses);
        LOG.debug((Object)"Exit listStatusLite:");
        return result;
    }

    public int listDirLite(org.apache.hadoop.fs.Path f) throws IOException {
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        String rawPath = u.getPath();
        int error = 0;
        LOG.debug((Object)("Entering listDirLite() Path: " + f));
        ClusterData clusterData = this.lookupClient(f);
        if (clusterData == null) {
            LOG.debug((Object)"Exit listDirLite: failed lookupClient");
            return 0;
        }
        String name = this.getNameStr(rawPath);
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        error = clusterData.client.listDirLite(name, this.getScheme(), authority, err, this.userInfo);
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (err.error == 13) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
        }
        if (err.error == 1) {
            throw new IOException("Failed to list contents of dir " + f + ", err: " + Errno.toString((int)err.error) + "(" + err.error + ")");
        }
        LOG.debug((Object)("Exit listDirLite: ret " + err.error));
        return err.error;
    }

    public MapRFileStatus[] listStatus(org.apache.hadoop.fs.Path f) throws IOException {
        return this.listMapRStatus(f, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        LOG.debug((Object)"Enter close:");
        if (!this.fileSystemOpen) {
            LOG.debug((Object)"Exit close: fileSystemOpen flag is not set");
            return;
        }
        super.close();
        this.localClusterList.clear();
        this.localClusterTable.clear();
        Object object = numInstancesLock;
        synchronized (object) {
            if (--numInstances == 0) {
                BackgroundWork.close();
            }
        }
        this.fileSystemOpen = false;
        LOG.debug((Object)"Exit close:");
    }

    void checkOpen() throws IOException {
        if (!this.fileSystemOpen) {
            throw new IOException("Filesystem closed");
        }
    }

    public long getUsed() throws IOException {
        FsStatus fsStatus = this.getStatus();
        return fsStatus.getUsed();
    }

    public boolean supportsSymlinks() {
        return true;
    }

    public void createSymlink(org.apache.hadoop.fs.Path target, org.apache.hadoop.fs.Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        int err = this.createSymlink(target.toString(), link, createParent);
        if (err == -1) {
            throw new IOException("Cannot create symlink");
        }
        if (err == 17) {
            throw new FileAlreadyExistsException("Cannot create symlink");
        }
        if (err == 13) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to create symlink");
        }
        if (err == 2) {
            throw new FileNotFoundException(link + " not found to create symlink");
        }
        if (err == 20) {
            throw new ParentNotDirectoryException("Parent directory not found to create symlink");
        }
    }

    public int createSymlink(String target, org.apache.hadoop.fs.Path link, boolean createParent) throws IOException {
        String scheme;
        LOG.debug((Object)("Enter createSymlink: target " + target + "link " + link.toString() + "createParent " + createParent));
        URI u = this.makeAbsolute(new org.apache.hadoop.fs.Path(target)).toUri();
        if (u != null && (scheme = u.getScheme()) != null && !scheme.equalsIgnoreCase("maprfs")) {
            throw new IOException("Cannot create symlinks to non-maprfs filesystems");
        }
        MapRConstants.ErrorValue linkErr = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(link)) == null) {
                LOG.debug((Object)"Exit createSymlink: failed lookupClient");
                return -1;
            }
            int mask = this.shouldUseDefaultBlockSize();
            int mode = MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf());
            clusterData.client.createSymlink(target, this.getName(link).toString(), createParent, mask, mode, this.chunkSize, linkErr, this.userInfo);
            if (linkErr.error < 0) {
                linkErr.error = -linkErr.error;
            }
            if (linkErr.error != 136) continue;
            link = new org.apache.hadoop.fs.Path(linkErr.trailpath);
        } while (linkErr.error == 136);
        LOG.debug((Object)("Exit createSymlink: ret " + linkErr.error));
        return linkErr.error;
    }

    public int removeRecursive(org.apache.hadoop.fs.Path f) throws AccessControlException, FileNotFoundException, IOException {
        int error;
        String scheme;
        LOG.debug((Object)("Enter removeRecursive: path " + f.toString()));
        URI u = this.makeAbsolute(f).toUri();
        if (u != null && (scheme = u.getScheme()) != null && !scheme.equalsIgnoreCase("maprfs")) {
            throw new IOException("Cannot do delete recursive to non-maprfs filesystems");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        boolean recursive = true;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(f)) == null) {
                LOG.debug((Object)"Exit removeRecursive: failed lookupClient");
                return -1;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.delete(this.getName(f), recursive, true, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
            }
            if (error == 136) {
                f = new org.apache.hadoop.fs.Path(err.trailpath);
                continue;
            }
            if (error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
            }
            if (error == 2) {
                LOG.debug((Object)("Cannot delete non existent path " + f));
                continue;
            }
            if (error == 0) continue;
            LOG.error((Object)("Failed to delete path " + f + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")"));
            try {
                MapRFileStatus fStatus = this.getMapRFileStatus(f);
                if (fStatus.isDir() && !recursive) {
                    throw new IOException("Could not delete dir " + f + ", Error: " + Errno.toString((int)err.error) + ", Try with recursive flag set to true");
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug((Object)"Exception in removeRecursive()", (Throwable)e);
                return error;
            }
        } while (error == 136);
        LOG.debug((Object)("Exit removeRecursive: error " + error));
        return error;
    }

    public MapRClientImpl getMapRClient() throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        return clusterData.client;
    }

    public int createHardlink(org.apache.hadoop.fs.Path oldpath, org.apache.hadoop.fs.Path newpath) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        String scheme;
        LOG.debug((Object)("Enter createHardlink: oldpath " + oldpath.toString() + "newpath " + newpath.toString()));
        URI u = this.makeAbsolute(oldpath).toUri();
        if (u != null && (scheme = u.getScheme()) != null && !scheme.equalsIgnoreCase("maprfs")) {
            throw new IOException("Cannot create hardlinks to non-maprfs filesystems");
        }
        MapRConstants.ErrorValue linkErr = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(oldpath)) == null) {
                linkErr.error = -1;
                break;
            }
            clusterData.client.createHardlink(this.getName(oldpath).toString(), this.getName(newpath).toString(), linkErr, this.userInfo);
            if (linkErr.error < 0) {
                linkErr.error = -linkErr.error;
            }
            if (linkErr.error != 136) continue;
            newpath = new org.apache.hadoop.fs.Path(linkErr.trailpath);
        } while (linkErr.error == 136);
        if (linkErr.error == 21) {
            throw new IOException(oldpath + " hard link not allowed for directory");
        }
        if (linkErr.error == 17) {
            throw new FileAlreadyExistsException(newpath + " " + Errno.toString((int)17));
        }
        if (linkErr.error == 13) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to create hardlink");
        }
        if (linkErr.error == 2) {
            throw new FileNotFoundException("failed to create hard link: " + newpath + " -> " + oldpath + " " + Errno.toString((int)2));
        }
        if (linkErr.error == 20) {
            throw new ParentNotDirectoryException(newpath + " " + Errno.toString((int)20));
        }
        if (linkErr.error == 18) {
            throw new IOException("failed to create hard link: " + newpath + " -> " + oldpath + " " + Errno.toString((int)18));
        }
        if (linkErr.error != 0) {
            LOG.error((Object)("failed to create hard link: " + newpath + " -> " + oldpath + " " + Errno.toString((int)linkErr.error)));
            return linkErr.error;
        }
        LOG.debug((Object)"Exit createHardlink: success");
        return 0;
    }

    public MapRFileStatus[] scanDir(String cluster, String fidstr) throws IOException {
        LOG.debug((Object)("Enter scanDir: cluster " + cluster + "fidstr " + fidstr));
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            LOG.debug((Object)"Exit scanDir: failed lookupClient");
            return null;
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileStatus[] ret = clusterData.client.listStatus(fidstr, true, false, true, this.getScheme(), null, err, this.userInfo);
        LOG.debug((Object)("Exit scanDir: ret " + ret));
        return ret;
    }

    public byte[] scanKV(String cluster, String fidstr, byte[] start, byte[] end, int maxkeys) throws IOException {
        return this.scanKV(cluster, fidstr, start, end, maxkeys, false);
    }

    public byte[] scanKV(String cluster, String fidstr, byte[] start, byte[] end, int maxkeys, boolean fromGfsck) throws IOException {
        LOG.debug((Object)("Enter scanKV: cluster " + cluster + "fidstr " + fidstr + "start " + start + "end " + end + "maxkeys " + maxkeys + "fromGfsck " + fromGfsck));
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            LOG.debug((Object)"Exit scanKV: failed lookupClient");
            return null;
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        byte[] ret = clusterData.client.scanKV(fidstr, start, end, maxkeys, fromGfsck, err);
        LOG.debug((Object)("Exit scanKV: ret " + ret));
        return ret;
    }

    public Fileserver.KvstoreScanResponse scanKVGivenFid(org.apache.hadoop.fs.Path URI2, Common.FidMsg kvFid, Fileserver.KvStoreKey start, Fileserver.KvStoreKey end) throws IOException {
        Fileserver.KvstoreScanResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        LOG.debug((Object)("Enter scanKVGivenFid: URI " + URI2 + "kvFid " + kvFid + "start " + start + "end " + end));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(URI2)) == null) {
                throw new IOException("Failed to create maprclient for " + URI2);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.scanKVGivenFid(kvFid, start, end, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            URI2 = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to scan table");
            }
            throw new IOException("Failed to scan table, Error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        LOG.debug((Object)"Exit scanKVGivenFid:");
        return resp;
    }

    public Fileserver.KvstoreLookupResponse lookupKV(org.apache.hadoop.fs.Path tableURI, Fileserver.KvStoreKey key) throws IOException {
        Fileserver.KvstoreLookupResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter lookupKV: tableURI " + tableURI.toString() + "key " + key));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.lookupKV(tableName, key, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to scan table");
            }
            throw new IOException("Failed to lookup key on table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        LOG.debug((Object)"Exit lookupKV:");
        return resp;
    }

    public int createVolLink(String cluster, String volName, org.apache.hadoop.fs.Path volLink, boolean writeable, boolean isHidden) throws IOException {
        LOG.debug((Object)("Enter createVolLink: cluster " + cluster + "volName " + volName + "volLink " + volLink + "writeable " + writeable + "isHidden " + isHidden));
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            LOG.debug((Object)"Exit createVolLink: failed lookupClient");
            return -1;
        }
        int ret = clusterData.client.createVolLink(volName, this.getName(volLink).toString(), writeable, isHidden, this.userInfo);
        LOG.debug((Object)("Exit  createVolLink: ret " + ret));
        return ret;
    }

    public int deleteVolLink(String cluster, String volLink) throws IOException {
        LOG.debug((Object)("Enter deleteVolLink: cluster " + cluster + "volLink " + volLink));
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            LOG.debug((Object)"Exit deleteVolLink: failed deleteVolLink");
            return -1;
        }
        int ret = clusterData.client.deleteVolLink(volLink, this.userInfo);
        LOG.debug((Object)("Exiting deleteVolLink() ret: " + ret));
        return ret;
    }

    public org.apache.hadoop.fs.Path getHomeDirectory() {
        return this.workingDir;
    }

    public org.apache.hadoop.fs.Path makeAbsolute(org.apache.hadoop.fs.Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new org.apache.hadoop.fs.Path(this.workingDir, path);
    }

    public String getClusterNameUnchecked(String str) {
        if (str.startsWith("/mapr/")) {
            String[] strArr = str.split("/", 4);
            if (strArr.length <= 3) {
                throw new IllegalArgumentException("Could not parse clustername from " + str);
            }
            return strArr[2];
        }
        return this.clusterName;
    }

    public String getNameStr(String str) {
        if (str.startsWith("/mapr/")) {
            String[] strArr = str.split("/", 4);
            if (strArr.length <= 3) {
                return "/";
            }
            return "/" + strArr[3];
        }
        return str;
    }

    public String getName(org.apache.hadoop.fs.Path p) {
        return this.getNameStr(this.makeAbsolute(p).toUri().getPath());
    }

    public MapRBlockLocation[] getMapRFileBlockLocations(FileStatus file, long start, long len, boolean usePrimaryFid, boolean needDiskBlocks, boolean fullBlockInfo) throws IOException {
        MapRBlockLocation[] result;
        LOG.debug((Object)("Enter getMapRFileBlockLocations: file " + file + "start " + start + "len " + len + "usePrimaryFid " + usePrimaryFid + "needDiskBlocks " + needDiskBlocks + "fullBlockInfo " + fullBlockInfo));
        if (file == null) {
            LOG.debug((Object)"Exit getMapRFileBlockLocations: failed file is null");
            return null;
        }
        String path = this.getName(file.getPath());
        if (path == null) {
            LOG.debug((Object)"Exit getMapRFileBlockLocations: failed path is NULL");
            return new MapRBlockLocation[0];
        }
        if (start < 0L) {
            throw new IOException("Negative offset is not supported.");
        }
        if (len < 0L) {
            throw new IOException("Negative length is not supported.");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        org.apache.hadoop.fs.Path p = file.getPath();
        int clusterCount = 0;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(p)) == null) {
                LOG.debug((Object)"Exit getMapRFileBlockLocations: failed lookupClient");
                return new MapRBlockLocation[0];
            }
            MapRFileSystem.initError(err);
            result = clusterData.client.getBlockLocations(path, start, len, usePrimaryFid, needDiskBlocks, fullBlockInfo, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + path);
            }
            if (err.error != 136) continue;
            path = err.trailpath;
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        MapRBlockLocation[] ret = result == null ? new MapRBlockLocation[]{} : result;
        LOG.debug((Object)("Exit getMapRFileBlockLocations: ret " + ret));
        return ret;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.getMapRFileBlockLocations(file, start, len, false, false, false);
    }

    public void setOwner(org.apache.hadoop.fs.Path p, String user, String group) throws IOException {
        int error;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Enter setOwner: Path = " + p + " User = " + user + " Group = " + group));
        }
        if (user == null && group == null) {
            throw new HadoopIllegalArgumentException("Invalid user/group arguments " + user + "/" + group + " for path " + p);
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(p)) == null) {
                LOG.debug((Object)"Exit setOwner: failed lookupClient");
                return;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.setOwner(this.getName(p), user, group, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            p = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        if (error == 2) {
            throw new FileNotFoundException(p.toString());
        }
        if (error == 13) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to set owner/group for path " + p);
        }
        if (error != 0) {
            throw new IOException("Could not set owner/group " + user + "/" + group + " for path " + p + " error is " + error);
        }
        LOG.debug((Object)"Exit setOwner:");
    }

    public void setOwnerFid(String pfid, String user, String group) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Enter setOwnerFid: pfid = " + pfid + " User = " + user + " Group = " + group));
        }
        if (user == null && group == null) {
            throw new IOException("Invalid user/group arguments " + user + "/" + group + " for path " + pfid);
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            throw new IOException("Unable to connect to MapR cluster!");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        int error = clusterData.client.setOwnerFid(pfid, user, group, err, this.userInfo);
        if (error < 0) {
            error = -error;
        }
        if (error == 2) {
            throw new FileNotFoundException(pfid.toString());
        }
        if (error == 13) {
            throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to set owner/group for fid " + pfid);
        }
        if (error != 0) {
            throw new IOException("Could not set owner/group " + user + "/" + group + " for fid " + pfid + " error is " + error);
        }
        LOG.debug((Object)"Exit setOwnerFid:");
    }

    public void setTimes(org.apache.hadoop.fs.Path p, long mtime, long atime) throws IOException {
        LOG.debug((Object)("Enter setTimes: mtime " + mtime + "atime " + atime));
        if (mtime != -1L || atime != -1L) {
            int error;
            MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
            do {
                ClusterData clusterData;
                if ((clusterData = this.lookupClient(p)) == null) {
                    LOG.debug((Object)"Exit setTimes: failed lookupClient");
                    return;
                }
                MapRFileSystem.initError(err);
                error = clusterData.client.setTimes(this.getName(p), mtime, atime, err, this.userInfo);
                if (error < 0) {
                    error = -error;
                }
                if (error != 136) continue;
                p = new org.apache.hadoop.fs.Path(err.trailpath);
            } while (error == 136);
            if (error != 0) {
                throw new IOException("Could not set mtime/atime for " + p);
            }
        }
        LOG.debug((Object)"Exit setTimes:");
    }

    public void setPermission(org.apache.hadoop.fs.Path p, FsPermission permission) throws IOException {
        LOG.debug((Object)("Enter setPermission: path " + p.toString() + "permission " + permission));
        if (permission != null) {
            int error;
            MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
            do {
                ClusterData clusterData;
                if ((clusterData = this.lookupClient(p)) == null) {
                    LOG.debug((Object)"Exit setPermission: failed lookupClient");
                    return;
                }
                MapRFileSystem.initError(err);
                error = clusterData.client.setPermission(this.getName(p), permission.toShort(), err, this.userInfo);
                if (error < 0) {
                    error = -error;
                }
                if (error != 136) continue;
                p = new org.apache.hadoop.fs.Path(err.trailpath);
            } while (error == 136);
            if (error != 0) {
                throw new IOException("Could not set permission for " + p);
            }
        }
        LOG.debug((Object)"Exit setPermission:");
    }

    public FileStatus getFileLinkStatus(org.apache.hadoop.fs.Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.getMapRFileStatus(f);
    }

    public org.apache.hadoop.fs.Path getLinkTarget(org.apache.hadoop.fs.Path f) throws IOException {
        LOG.debug((Object)("Enter getLinkTarget: path " + f.toString()));
        MapRFileStatus status = this.getMapRFileStatus(f);
        if (!status.isSymlink()) {
            throw new IOException("Path " + f + " is not a symbolic link");
        }
        org.apache.hadoop.fs.Path newPath = null;
        while ((status = this.getMapRFileStatus(newPath = status.getSymlink())).isSymlink()) {
        }
        LOG.debug((Object)("Exit getLinkTarget: ret " + newPath.toString()));
        return newPath;
    }

    protected org.apache.hadoop.fs.Path resolveLink(org.apache.hadoop.fs.Path f) throws IOException {
        MapRFileStatus status = this.getMapRFileStatus(f);
        if (!status.isSymlink()) {
            throw new IOException("Path " + f + " is not a symbolic link");
        }
        return status.getSymlink();
    }

    public FsStatus getStatus() throws IOException {
        return this.getStatus(null);
    }

    public FsStatus getStatus(org.apache.hadoop.fs.Path p) throws IOException {
        LOG.debug((Object)("Enter getStatus: path " + p.toString()));
        ClusterData clusterData = p == null ? this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName)) : this.lookupClient(p);
        if (clusterData == null) {
            LOG.debug((Object)"Exit getStatus: failed lookupClient");
            return null;
        }
        FsStatus ret = clusterData.client.getStatus();
        LOG.debug((Object)("Exit getStatus: ret " + ret));
        return ret;
    }

    public void setXAttr(org.apache.hadoop.fs.Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        boolean xAttrExists = false;
        try {
            byte[] xval = this.getXAttr(path, name);
            xAttrExists = xval != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        XAttrSetFlag.validate((String)name, (boolean)xAttrExists, flag);
        this.setXAttr(path, name, value);
    }

    public void setXAttr(org.apache.hadoop.fs.Path path, String name, byte[] value) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter setXAttr: path " + path + "name " + name + "value " + value));
        if (name == null || name.length() == 0 || value == null || value.length == 0) {
            throw new IOException("Invalid Argument");
        }
        MapRFileStatus fstatus = this.getMapRFileStatus(path);
        if (fstatus.isSymlink()) {
            path = this.getLinkTarget(path);
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                throw new IOException("no cluster");
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.setXAttr(this.getName(path).toString(), name, value, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            throw new IOException(Errno.toString((int)error));
        }
        LOG.debug((Object)"Exit setXAttr");
    }

    public byte[] getXAttr(org.apache.hadoop.fs.Path path, String name) throws IOException {
        byte[] xval;
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter getXAttr: path " + path + "name " + name));
        MapRFileStatus fstatus = this.getMapRFileStatus(path);
        if (fstatus.isSymlink()) {
            path = this.getLinkTarget(path);
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                LOG.debug((Object)"Exit getXAttr: failed lookupClient");
                return null;
            }
            MapRFileSystem.initError(err);
            xval = clusterData.client.getXAttr(this.getName(path).toString(), name, err, this.userInfo);
            error = err.error;
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        LOG.debug((Object)("Exit getXAttr: ret " + xval));
        return xval;
    }

    public Map<String, byte[]> getXAttrs(org.apache.hadoop.fs.Path path) throws IOException {
        List<String> names = this.listXAttrs(path);
        return this.getXAttrs(path, names);
    }

    public Map<String, byte[]> getXAttrs(org.apache.hadoop.fs.Path path, List<String> names) throws IOException {
        HashMap<String, byte[]> xmap = new HashMap<String, byte[]>();
        for (String name : names) {
            byte[] xval = this.getXAttr(path, name);
            xmap.put(name, xval);
        }
        return xmap;
    }

    public List<String> listXAttrs(org.apache.hadoop.fs.Path path) throws IOException {
        List<String> xnames;
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter listXAttrs: path " + path));
        MapRFileStatus fstatus = this.getMapRFileStatus(path);
        if (fstatus.isSymlink()) {
            path = this.getLinkTarget(path);
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                LOG.debug((Object)"Exit listXAttrs: failed lookupClient");
                return null;
            }
            MapRFileSystem.initError(err);
            xnames = clusterData.client.listXAttrs(this.getName(path).toString(), err, this.userInfo);
            error = err.error;
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        LOG.debug((Object)("Exit listXAttrs ret " + xnames));
        return xnames;
    }

    public void removeXAttr(org.apache.hadoop.fs.Path path, String name) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter removeXAttr: path " + path + "name " + name));
        MapRFileStatus fstatus = this.getMapRFileStatus(path);
        if (fstatus.isSymlink()) {
            path = this.getLinkTarget(path);
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                throw new IOException("no cluster");
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.removeXAttr(this.getName(path).toString(), name, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            throw new IOException(Errno.toString((int)err.error));
        }
        LOG.debug((Object)"Exit removeXAttr:");
    }

    private void handleError(org.apache.hadoop.fs.Path path, MapRConstants.ErrorValue errorValue) throws IOException {
        int err = errorValue.error;
        if (err != 0) {
            if (err < 0) {
                err = -err;
            }
            String pathString = path.toString();
            StackTraceElement[] stackFrames = Thread.currentThread().getStackTrace();
            String op = "<unknown>";
            for (int frameIdx = 1; frameIdx < stackFrames.length; ++frameIdx) {
                String method = stackFrames[frameIdx].getMethodName();
                if (method.equals("handleError")) continue;
                op = method;
                break;
            }
            IOException ioex = null;
            String msg = String.format("%s() on '%s' failed with error: %s (%d).", op, pathString, Errno.toString((int)err), err);
            switch (err) {
                case 2: {
                    ioex = new PathNotFoundException(msg).initFilePath(pathString);
                    break;
                }
                case 13: {
                    msg = String.format("User '%s' (user id %d) does not have permission for %s() on '%s'.", this.userInfo.getUserName(), this.userInfo.GetUserID(), op, pathString);
                    ioex = new AccessControlException(msg);
                    break;
                }
                default: {
                    ioex = new ErrnoException(msg, err);
                }
            }
            throw ioex;
        }
    }

    public <ReturnType> ReturnType executeCommand(FSCommandHandler handler, FSCommandHandler.ICommandExecutor<ReturnType> executor) throws IOException {
        handler.setErrorValue(new MapRConstants.ErrorValue());
        ReturnType retValue = null;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(handler.getPath())) == null) {
                return null;
            }
            MapRFileSystem.initError(handler.getErrorValue());
            retValue = executor.execute(clusterData.client);
            if (handler.getErrorValue().error != 136) continue;
            handler.setPath(new org.apache.hadoop.fs.Path(handler.getErrorValue().trailpath));
        } while (handler.getErrorValue().error == 136);
        return retValue;
    }

    public int setCompression(org.apache.hadoop.fs.Path path, boolean val, String compName) throws IOException {
        LOG.debug((Object)("Enter setCompression: path " + path + "val " + val + "compName " + compName));
        final FSCommandHandler handler = new FSCommandHandler(this, path, new boolean[]{val}, null, null, new String[]{compName});
        int error = this.executeCommand(handler, new FSCommandHandler.ICommandExecutor<Integer>(){

            @Override
            public Integer execute(MapRClientImpl client) {
                int ret = client.setCompression(MapRFileSystem.this.getName(handler.getPath()).toString(), handler.getBooleanInput(0), handler.getStringInput(0), handler.getErrorValue(), MapRFileSystem.this.userInfo);
                LOG.debug((Object)("Exit setCompression: ret " + ret));
                return ret;
            }
        });
        if (error != 0) {
            this.handleError(path, handler.getErrorValue());
        }
        LOG.debug((Object)("Exit setCompression: error " + error));
        return error;
    }

    public JNIFileTierStatus tierOp(int op, org.apache.hadoop.fs.Path path, boolean verbose, boolean blocking, long shaHigh, long shaLow, long uniq) throws IOException {
        LOG.debug((Object)("Enter tierOp: op " + op + "path " + path + "verbose " + verbose + "blocking " + blocking + "shaHigh " + shaHigh + "shaLow " + shaLow + "uniq " + uniq));
        final FSCommandHandler handler = new FSCommandHandler(this, path, new boolean[]{verbose, blocking}, new int[]{op}, new long[]{shaHigh, shaLow, uniq}, null);
        JNIFileTierStatus tStatus = this.executeCommand(handler, new FSCommandHandler.ICommandExecutor<JNIFileTierStatus>(){

            @Override
            public JNIFileTierStatus execute(MapRClientImpl client) {
                JNIFileTierStatus rc = client.tierOp(handler.getIntInput(0), MapRFileSystem.this.getName(handler.getPath()).toString(), handler.getBooleanInput(0), handler.getBooleanInput(1), handler.getLongInput(0), handler.getLongInput(1), handler.getLongInput(2), handler.getErrorValue(), MapRFileSystem.this.userInfo);
                LOG.debug((Object)("Exit tierOp: rc " + rc));
                return rc;
            }
        });
        LOG.debug((Object)("Exit tierOp: tStatus " + tStatus));
        return tStatus;
    }

    public MapRFileStatus getStat(org.apache.hadoop.fs.Path path) throws IOException {
        LOG.debug((Object)("Enter getStat: path " + path));
        final FSCommandHandler handler = new FSCommandHandler(this, path, null, null, null, null);
        MapRFileStatus status = this.executeCommand(handler, new FSCommandHandler.ICommandExecutor<MapRFileStatus>(){

            @Override
            public MapRFileStatus execute(MapRClientImpl client) {
                MapRFileStatus ret = client.getStat(MapRFileSystem.this.getName(handler.getPath()).toString(), handler.getErrorValue(), MapRFileSystem.this.userInfo);
                LOG.debug((Object)("Exit getStat: ret " + ret));
                return ret;
            }
        });
        if (status == null) {
            this.handleError(path, handler.getErrorValue());
        }
        LOG.debug((Object)("Exit getStat: status " + status));
        return status;
    }

    public MapRFileCount getFileCount(org.apache.hadoop.fs.Path f) throws IOException {
        URI u = this.makeAbsolute(f).toUri();
        String rawPath = u.getPath();
        MapRFileCount fileCount = null;
        LOG.debug((Object)("Enter getFileCount: path " + f));
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            throw new IOException("Count does not work on mapr cluster directory");
        }
        ClusterData clusterData = this.lookupClient(f);
        if (clusterData == null) {
            LOG.debug((Object)"Exit getFileCount: failed lookupClient");
            return null;
        }
        String name = this.getNameStr(rawPath);
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        fileCount = clusterData.client.getFileCount(name, err, this.userInfo);
        if (fileCount == null) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + this.userInfo.getUserName() + "(user id " + this.userInfo.GetUserID() + ")  does not have access to " + f);
            }
            String msg = "Failed to get file count for " + f + ", err: " + Errno.toString((int)err.error) + "(" + err.error + ")";
            switch (err.error) {
                case 2: {
                    throw new FileNotFoundException(msg);
                }
            }
            throw new IOException(msg);
        }
        LOG.debug((Object)("Exit getFileCount: fileCount " + fileCount));
        return fileCount;
    }

    public int modifyAudit(org.apache.hadoop.fs.Path path, boolean val) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter modifyAudit: path " + path + "val " + val));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                LOG.debug((Object)"Exit modifyAudit: failed lookupClient");
                return -1;
            }
            MapRFileSystem.initError(err);
            error = clusterData.client.modifyAudit(this.getName(path).toString(), val, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        LOG.debug((Object)("Exit modifyAudit: error " + error));
        return error;
    }

    public int setWireSecurity(org.apache.hadoop.fs.Path path, boolean val) throws IOException {
        LOG.debug((Object)("Enter setWireSecurity: path " + path + "val " + val));
        final FSCommandHandler handler = new FSCommandHandler(this, path, new boolean[]{val}, null, null, null);
        int error = this.executeCommand(handler, new FSCommandHandler.ICommandExecutor<Integer>(){

            @Override
            public Integer execute(MapRClientImpl client) {
                int ret = client.setWireSecurity(MapRFileSystem.this.getName(handler.getPath()).toString(), handler.getBooleanInput(0), handler.getErrorValue(), MapRFileSystem.this.userInfo);
                LOG.debug((Object)("Exit setWireSecurity ret " + ret));
                return ret;
            }
        });
        if (error != 0) {
            this.handleError(path, handler.getErrorValue());
        }
        LOG.debug((Object)("Exit setWireSecurity error " + error));
        return error;
    }

    public int setDiskFlush(org.apache.hadoop.fs.Path path, boolean val) throws IOException {
        LOG.debug((Object)("Enter setDiskFlush: path " + path + "val " + val));
        final FSCommandHandler handler = new FSCommandHandler(this, path, new boolean[]{val}, null, null, null);
        int error = this.executeCommand(handler, new FSCommandHandler.ICommandExecutor<Integer>(){

            @Override
            public Integer execute(MapRClientImpl client) {
                int ret = client.setDiskFlush(MapRFileSystem.this.getName(handler.getPath()).toString(), handler.getBooleanInput(0), handler.getErrorValue(), MapRFileSystem.this.userInfo);
                LOG.debug((Object)("Exit setDiskFlush() ret " + ret));
                return ret;
            }
        });
        if (error != 0) {
            this.handleError(path, handler.getErrorValue());
        }
        LOG.debug((Object)("Exit setDiskFlush: error " + error));
        return error;
    }

    private MapRFileAce.AccessType toAccessType(Common.FSAccessType fsAccessType) {
        if (fsAccessType == Common.FSAccessType.AceRead) {
            return MapRFileAce.AccessType.READFILE;
        }
        if (fsAccessType == Common.FSAccessType.AceWrite) {
            return MapRFileAce.AccessType.WRITEFILE;
        }
        if (fsAccessType == Common.FSAccessType.AceExecute) {
            return MapRFileAce.AccessType.EXECUTEFILE;
        }
        if (fsAccessType == Common.FSAccessType.AceReadDir) {
            return MapRFileAce.AccessType.READDIR;
        }
        if (fsAccessType == Common.FSAccessType.AceAddChild) {
            return MapRFileAce.AccessType.ADDCHILD;
        }
        if (fsAccessType == Common.FSAccessType.AceDeleteChild) {
            return MapRFileAce.AccessType.DELETECHILD;
        }
        if (fsAccessType == Common.FSAccessType.AceLookupDir) {
            return MapRFileAce.AccessType.LOOKUPDIR;
        }
        assert (false);
        return MapRFileAce.AccessType.READFILE;
    }

    private void addAces(org.apache.hadoop.fs.Path path, List<MapRFileAce> aces, boolean isSet) throws IOException {
        this.addAces(path, aces, isSet, false);
    }

    private void addAces(org.apache.hadoop.fs.Path path, List<MapRFileAce> aces, boolean isSet, boolean recursive) throws IOException {
        LOG.debug((Object)("Enter addAces: path " + path + "isSet " + isSet + "recursive " + recursive));
        if (aces.size() == 0) {
            throw new IOException("Empty aces list");
        }
        ArrayList<Common.FileACE> fileAces = new ArrayList<Common.FileACE>();
        for (int i = 0; i < aces.size(); ++i) {
            String postFixStr = AceHelper.toPostfix((String)aces.get(i).getBooleanExpression());
            fileAces.add(Common.FileACE.newBuilder().setAccessType(aces.get(i).getAccessType().getValue()).setBoolExp(ByteString.copyFromUtf8((String)postFixStr)).build());
        }
        this.setAces(path, fileAces, isSet, -1, -1, recursive, null);
        LOG.debug((Object)"Exit addAces:");
    }

    public void setAces(org.apache.hadoop.fs.Path path, List<MapRFileAce> aces) throws IOException {
        this.addAces(path, aces, true);
    }

    public void setAces(org.apache.hadoop.fs.Path path, List<MapRFileAce> aces, boolean recursive) throws IOException {
        this.addAces(path, aces, true, recursive);
    }

    public void modifyAces(org.apache.hadoop.fs.Path path, List<MapRFileAce> aces) throws IOException {
        this.addAces(path, aces, false);
    }

    public void deleteAces(org.apache.hadoop.fs.Path path) throws IOException {
        this.delAces(path, false);
    }

    public void deleteAces(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        this.delAces(path, recursive);
    }

    public List<MapRFileAce> getAces(org.apache.hadoop.fs.Path path) throws IOException {
        LOG.debug((Object)("Enter getAces: path " + path));
        ArrayList<FileAceEntry> fileAceEntryList = this.getAces(path, false);
        if (fileAceEntryList.size() == 0) {
            LOG.debug((Object)"Exit getAces: failed fileAceEntryList.size() is zero");
            return null;
        }
        if (fileAceEntryList.get((int)0).error != 0) {
            LOG.debug((Object)("Exit getAces: err: " + fileAceEntryList.get((int)0).error));
            throw new IOException("getAces failed with err: " + fileAceEntryList.get((int)0).error);
        }
        ArrayList<Common.FileACE> fileAces = fileAceEntryList.get((int)0).aces;
        if (fileAces.size() == 0) {
            LOG.debug((Object)"Exit getAces: failed fileAces.size() is zero");
            return null;
        }
        ArrayList<MapRFileAce> aces = new ArrayList<MapRFileAce>();
        for (int i = 0; i < fileAces.size(); ++i) {
            MapRFileAce ace = new MapRFileAce(this.toAccessType(fileAces.get(i).getAccessType()));
            String inFixStr = AceHelper.toInfix((String)fileAces.get(i).getBoolExp().toStringUtf8());
            ace.setBooleanExpression(inFixStr);
            aces.add(ace);
        }
        LOG.debug((Object)"Exit getAces:");
        return aces;
    }

    public void addAceEntryError(ArrayList<FileAceEntry> acesList, org.apache.hadoop.fs.Path path, int err) {
        acesList.add(new FileAceEntry(this.getName(path).toString(), null, err, null, null));
    }

    public ArrayList<FileAceEntry> getAces(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        return this.getAces(path, recursive, 0);
    }

    public ArrayList<FileAceEntry> getAces(org.apache.hadoop.fs.Path path, boolean recursive, int symLinkHeight) throws IOException {
        return this.getAces(path, recursive, symLinkHeight, -1);
    }

    public ArrayList<FileAceEntry> getAces(org.apache.hadoop.fs.Path path, boolean recursive, int symLinkHeight, int serveridx) throws IOException {
        int error;
        ArrayList<Common.FileACE> aces = new ArrayList<Common.FileACE>();
        ArrayList<FileAceEntry> acesList = new ArrayList<FileAceEntry>();
        FileAceMoreInfo aceMoreInfo = new FileAceMoreInfo();
        FsPermission permission = null;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Entering getAces() path: " + path + "recursive: " + recursive + "symLinkHeight: " + symLinkHeight + "serveridx: " + serveridx));
        if (symLinkHeight > 8) {
            LOG.debug((Object)("Too many levels of symbolic links for path: " + this.getName(path).toString()));
            this.addAceEntryError(acesList, path, 22);
            return acesList;
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                throw new IOException("no cluster");
            }
            MapRFileSystem.initError(err);
            try {
                MapRFileStatus stat = this.getMapRFileStatus(path);
                permission = stat.getPermission();
                if (stat.isSymlink()) {
                    path = stat.getSymlink();
                    LOG.debug((Object)"Exiting getAces() ret(1)");
                    return this.getAces(path, recursive, ++symLinkHeight);
                }
                if (!stat.isFile() && !stat.isDirectory()) {
                    LOG.debug((Object)("Path " + this.getName(path).toString() + " is neither file/dir"));
                    this.addAceEntryError(acesList, path, 22);
                    return acesList;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
                this.addAceEntryError(acesList, path, -1);
                return acesList;
            }
            error = clusterData.client.getAces(this.getName(path).toString(), aces, aceMoreInfo, err, this.userInfo, serveridx);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        acesList.add(new FileAceEntry(this.getName(path).toString(), aces, error, aceMoreInfo, permission));
        MapRFileStatus[] childStatus = null;
        try {
            MapRFileStatus status = this.getMapRFileStatus(path);
            if (!status.isDirectory() || !recursive) {
                LOG.debug((Object)("Exit getAces: status.isDirectory " + status.isDirectory() + "recursive " + recursive + " error: " + error));
                return acesList;
            }
            childStatus = this.listStatus(path);
            if (childStatus == null && err.error != 0) {
                if (err.error < 0) {
                    err.error = -err.error;
                }
                LOG.debug((Object)("Error in getting child status for path " + this.getName(path).toString() + ", error: " + err.error));
                this.addAceEntryError(acesList, path, err.error);
                return acesList;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in getting child status for path " + this.getName(path).toString() + ", error: " + e.getMessage()));
            this.addAceEntryError(acesList, path, -1);
            return acesList;
        }
        for (int i = 0; i < childStatus.length; ++i) {
            ArrayList<FileAceEntry> acesOneDir = this.getAces(childStatus[i].getPath(), recursive);
            acesList.addAll(acesOneDir);
        }
        LOG.debug((Object)"Exit getAces:");
        return acesList;
    }

    public int copyAce(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) throws IOException {
        if (src == null || dst == null) {
            throw new IOException("One of src/dst is null");
        }
        ArrayList<FileAceEntry> srcAces = this.getAces(src, false);
        if (srcAces.size() == 0 || srcAces.get((int)0).error != 0) {
            return 0;
        }
        int noinherit = srcAces.get((int)0).inherit ? 0 : 1;
        int err = this.setAces(dst, srcAces.get((int)0).aces, true, noinherit, 1, false, null);
        if (err != 0) {
            throw new IOException("Hit error " + err + " while copying aces from " + src.toString() + " to " + dst.toString());
        }
        this.setPermission(dst, this.getMapRFileStatus(src).getPermission());
        return srcAces.get((int)0).aces.size();
    }

    public int delAces(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        return this.delAces(path, recursive, 0);
    }

    public int delAces(org.apache.hadoop.fs.Path path, boolean recursive, int symLinkHeight) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter delAces: path " + path + "recursive " + recursive + "symLinkHeight " + symLinkHeight));
        if (symLinkHeight > 8) {
            LOG.debug((Object)("Too many levels of symbolic links for path: " + this.getName(path).toString()));
            return -1;
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                throw new IOException("no cluster");
            }
            MapRFileSystem.initError(err);
            try {
                MapRFileStatus stat = this.getMapRFileStatus(path);
                if (stat.isSymlink()) {
                    path = stat.getSymlink();
                    int ret = this.delAces(path, recursive, ++symLinkHeight);
                    LOG.debug((Object)("Exit delAces: ret " + ret));
                    return ret;
                }
                if (!stat.isFile() && !stat.isDirectory()) {
                    LOG.debug((Object)("Path " + this.getName(path).toString() + " is neither file/dir"));
                    return -1;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
                return -1;
            }
            error = clusterData.client.delAces(this.getName(path).toString(), err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            LOG.debug((Object)("Exit delAces: error " + error));
            return error;
        }
        MapRFileStatus status = this.getMapRFileStatus(path);
        if (!status.isDirectory() || !recursive) {
            LOG.debug((Object)("Exit delAces() status.isDirectory() " + status.isDirectory() + "recursive " + recursive + "error " + error));
            return error;
        }
        MapRFileStatus[] childStatus = this.listStatus(path);
        if (childStatus == null && err.error != 0) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            LOG.debug((Object)("Exit delAces: failed error in getting child status for path " + this.getName(path).toString() + ", error: " + err.error));
            return err.error;
        }
        for (int i = 0; i < childStatus.length; ++i) {
            int childErr = this.delAces(childStatus[i].getPath(), recursive);
            if (childErr == 0 || error != 0) continue;
            error = childErr;
        }
        LOG.debug((Object)("Exit delAces: returning error " + error));
        return error;
    }

    public void setAces(org.apache.hadoop.fs.Path path, String strAces, boolean isSet, int noinherit, int preservemodebits, boolean recursive) throws IOException {
        ArrayList aces = AceHelper.getFilePermissionWithShort((String)strAces);
        this.setAces(path, aces, isSet, noinherit, preservemodebits, recursive, null);
    }

    public int setAces(org.apache.hadoop.fs.Path path, ArrayList<Common.FileACE> aces, boolean isSet, int noinherit, int preservemodebits, boolean recursive, org.apache.hadoop.fs.Path hintAcePath) throws IOException {
        return this.setAces(path, aces, isSet, noinherit, preservemodebits, recursive, hintAcePath, 0);
    }

    public int setAces(org.apache.hadoop.fs.Path path, ArrayList<Common.FileACE> aces, boolean isSet, int noinherit, int preservemodebits, boolean recursive, org.apache.hadoop.fs.Path hintAcePath, int symLinkHeight) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        LOG.debug((Object)("Enter setAces: path " + path + "isSet " + isSet + "noinherit " + noinherit + "preservemodebits " + preservemodebits + "recursive " + recursive + "hintAcePath " + hintAcePath + "symLinkHeight " + symLinkHeight));
        if (symLinkHeight > 8) {
            LOG.debug((Object)("Exit setAces: too many levels of symbolic links for path: " + this.getName(path).toString()));
            return -1;
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(path)) == null) {
                throw new IOException("no cluster");
            }
            MapRFileSystem.initError(err);
            try {
                MapRFileStatus stat = this.getMapRFileStatus(path);
                if (stat.isSymlink()) {
                    path = stat.getSymlink();
                    int ret = this.setAces(path, aces, isSet, noinherit, preservemodebits, recursive, hintAcePath, ++symLinkHeight);
                    LOG.debug((Object)("Exit setAces: symlink ret " + ret));
                    return ret;
                }
                if (!stat.isFile() && !stat.isDirectory()) {
                    LOG.debug((Object)("Exit setAces: path " + this.getName(path).toString() + " is neither file/dir"));
                    return -1;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
                return -1;
            }
            String hintAceName = hintAcePath != null ? this.getName(hintAcePath).toString() : null;
            error = clusterData.client.setAces(this.getName(path).toString(), aces, isSet, noinherit, preservemodebits, hintAceName, err, this.userInfo);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new org.apache.hadoop.fs.Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            LOG.debug((Object)("Exit setAces: error " + error));
            return error;
        }
        MapRFileStatus status = this.getMapRFileStatus(path);
        if (!status.isDirectory() || !recursive) {
            LOG.debug((Object)("Exit setAces: path " + this.getName(path).toString() + " is neither directory nor recursive error " + error));
            return error;
        }
        MapRFileStatus[] childStatus = this.listStatus(path);
        if (childStatus == null && err.error != 0) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            LOG.debug((Object)("Exit setAces: error in getting child status for path " + this.getName(path).toString() + ", error: " + err.error));
            return err.error;
        }
        for (int i = 0; i < childStatus.length; ++i) {
            int childErr = this.setAces(childStatus[i].getPath(), aces, isSet, noinherit, preservemodebits, recursive, path);
            if (childErr == 0 || error != 0) continue;
            error = childErr;
        }
        LOG.debug((Object)("Exit setAces: returning error " + error));
        return error;
    }

    public int setChunkSize(org.apache.hadoop.fs.Path path, long val) throws IOException {
        final FSCommandHandler handler = new FSCommandHandler(this, path, null, null, new long[]{val}, null);
        LOG.debug((Object)("Enter setChunkSize: path " + path + "val " + val));
        int error = this.executeCommand(handler, new FSCommandHandler.ICommandExecutor<Integer>(){

            @Override
            public Integer execute(MapRClientImpl client) {
                int ret = client.setChunkSize(MapRFileSystem.this.getName(handler.getPath()).toString(), handler.getLongInput(0), handler.getErrorValue(), MapRFileSystem.this.userInfo);
                LOG.debug((Object)("Exit setChunkSize: ret " + ret));
                return ret;
            }
        });
        if (error != 0) {
            this.handleError(path, handler.getErrorValue());
        }
        LOG.debug((Object)("Exit setChunkSize: error " + error));
        return error;
    }

    public int getCidFromPath(org.apache.hadoop.fs.Path path) {
        int cid = 0;
        LOG.debug((Object)("Enter getCidFromPath: path " + path.toString()));
        try {
            MapRFileStatus fsStatus = this.getMapRFileStatus(path);
            if (fsStatus == null) {
                LOG.error((Object)"Exit getCidFromPath: getMapRFileStatus returned null.");
                return 0;
            }
            cid = fsStatus.getCid();
        }
        catch (IOException e) {
            LOG.error((Object)("Exit getCidFromPath: getMapRFileStatus threw exception. msg: " + e.getLocalizedMessage()));
        }
        LOG.info((Object)("Exit getCidFromPath: name space cid: " + cid));
        return cid;
    }

    public int mountVolume(String cluster, String volName, String mountPath, String username) {
        LOG.debug((Object)("Enter mountVolume: cluster " + cluster + " volName " + volName + " mountPath " + mountPath + " username " + username));
        if (mountPath.charAt(0) != '/') {
            LOG.error((Object)("Exit mountVolume: mount path " + mountPath + " is not absolute"));
            return -1;
        }
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            int mode = MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf());
            ClusterData clusterData = this.lookupClient(centry);
            int ret = clusterData.client.mountVolume(volName, mountPath, username, this.userInfo, mode);
            LOG.debug((Object)("Exit mountVolume: ret " + ret));
            return ret;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in mountVolume() ", (Throwable)e);
            return -1;
        }
    }

    public int unmountVolume(String cluster, String volName, String mountPath, String username, int pCid, int pCinum, int pUniq) {
        LOG.debug((Object)("Enter unmountVolume: cluster " + cluster + "volName " + volName + "mountPath " + mountPath + "username " + username + "pCid " + pCid + "pCinum " + pCinum + "pUniq " + pUniq));
        if (mountPath.charAt(0) != '/') {
            LOG.error((Object)("Exit unmountVolume: mount path " + mountPath + " is not absolute"));
            return -1;
        }
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            int ret = clusterData.client.unmountVolume(volName, mountPath, username, pCid, pCinum, pUniq, this.userInfo);
            LOG.debug((Object)("Exit unmountVolume: ret " + ret));
            return ret;
        }
        catch (Exception e) {
            LOG.error((Object)"Exit unmountVolume: exception in unmountVolume ", (Throwable)e);
            return -1;
        }
    }

    public String getVolumeName(int volId) throws IOException {
        String volumeName = null;
        LOG.debug((Object)("Enter getVolumeName: volId " + volId));
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData == null) {
                throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
            }
            volumeName = clusterData.client.getVolumeName(volId, this.userInfo);
            if (volumeName == null) {
                throw new IOException("Failed to get VolumeName for volid: " + volId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exit getVolumeName: exception in getVolumeName ", (Throwable)e);
            return null;
        }
        LOG.debug((Object)("Exit getVolumeName: volumeName: " + volumeName));
        return volumeName;
    }

    public String getVolumeNameCached(int volId) throws IOException {
        String volumeName = null;
        LOG.debug((Object)("Enter getVolumeNameCached: volId " + volId));
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData == null) {
                throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
            }
            volumeName = clusterData.client.getVolumeNameCached(volId, this.userInfo);
            if (volumeName == null) {
                throw new IOException("Failed to get VolumeName for volid: " + volId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exit getVolumeNameCached: exception in getVolumeName ", (Throwable)e);
            return null;
        }
        LOG.debug((Object)("Exit getVolumeNameCached: volumeName " + volumeName));
        return volumeName;
    }

    public String getMountPathFid(String fidStr) throws IOException {
        LOG.debug((Object)("Enter getMountPathFid: fidStr " + fidStr));
        String[] fidTriple = FID_SPLITTER.split(fidStr);
        if (fidTriple.length != 3) {
            throw new IOException(fidStr + ": Invalid fid format");
        }
        try {
            int[] fidInts = new int[]{Integer.valueOf(fidTriple[0]), Integer.valueOf(fidTriple[1]), Integer.valueOf(fidTriple[2])};
            String ret = this.getMountPath(null, this.userInfo.getUserName(), fidInts[0], fidInts[1], fidInts[2], false);
            LOG.debug((Object)("Exit getMountPathFid: ret " + ret));
            return ret;
        }
        catch (NumberFormatException e) {
            throw new IOException(fidStr + ": Invalid fid format", e);
        }
    }

    public int addFidMountPathToCache(String fidStr, String path, boolean forceUpdate) {
        String[] fidTriple = FID_SPLITTER.split(fidStr);
        LOG.debug((Object)("Enter addFidMountPathToCache: fidStr " + fidStr + ", forceUpdate: " + forceUpdate + ", path: " + path));
        if (fidTriple.length != 3) {
            return 22;
        }
        try {
            int[] fidInts = new int[]{Integer.valueOf(fidTriple[0]), Integer.valueOf(fidTriple[1]), Integer.valueOf(fidTriple[2])};
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            int ret = clusterData.client.NewFidPath(null, fidInts[0], fidInts[1], fidInts[2], null, path, forceUpdate);
            LOG.debug((Object)("Exit addFidMountPathToCache getMountPath: ret " + ret));
            return ret;
        }
        catch (NumberFormatException e) {
            LOG.error((Object)(fidStr + ": Invalid fid format"));
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in addFidMountPathToCache", (Throwable)e);
        }
        return 0;
    }

    public String getMountPathFidCached(String fidStr) throws IOException {
        return this.getMountPathFidCached(fidStr, false);
    }

    public String getMountPathFidCached(String fidStr, boolean skipFSCall) throws IOException {
        String[] fidTriple = FID_SPLITTER.split(fidStr);
        LOG.debug((Object)("Enter getMountPathFidCached: fidStr " + fidStr));
        if (fidTriple.length != 3) {
            throw new IOException(fidStr + ": Invalid fid format");
        }
        try {
            int[] fidInts = new int[]{Integer.valueOf(fidTriple[0]), Integer.valueOf(fidTriple[1]), Integer.valueOf(fidTriple[2])};
            String ret = this.getMountPath(null, this.userInfo.getUserName(), fidInts[0], fidInts[1], fidInts[2], true, skipFSCall);
            LOG.debug((Object)("Exit getMountPathFidCached ret " + ret));
            return ret;
        }
        catch (NumberFormatException e) {
            throw new IOException(fidStr + ": Invalid fid format", e);
        }
    }

    public String getMountPath(String cluster, String username, int pCid, int pCinum, int pUniq, boolean useCache) {
        return this.getMountPath(cluster, username, pCid, pCinum, pUniq, useCache, false);
    }

    public String getMountPath(String cluster, String username, int pCid, int pCinum, int pUniq, boolean useCache, boolean skipFSCall) {
        LOG.debug((Object)("Enter getMountPath: cluster " + cluster + "username " + username + "pCid " + pCid + "pCinum " + pCinum + "pUniq " + pUniq + "useCache " + useCache + "skipFSCall " + skipFSCall));
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            String ret = clusterData.client.getMountPath(username, pCid, pCinum, pUniq, this.userInfo, useCache, skipFSCall);
            LOG.debug((Object)("Exit getMountPath: ret " + ret));
            return ret;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in getNewMountPath", (Throwable)e);
            return null;
        }
    }

    public String getMountPath(String cluster, String username, int pCid, int pCinum, int pUniq) {
        LOG.debug((Object)("Enter getMountPath: cluster " + cluster + "username " + username + "pCid " + pCid + "pCinum " + pCinum + "pUniq " + pUniq));
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            String ret = clusterData.client.getMountPath(username, pCid, pCinum, pUniq, this.userInfo, false, false);
            LOG.debug((Object)("Exit getMountPath: ret " + ret));
            return ret;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in getNewMountPath", (Throwable)e);
            return null;
        }
    }

    public int createSnapshot(String cluster, String volumeName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, long expirationTime, String username) {
        return this.createSnapshot(cluster, volumeName, volId, rootCid, snapshotName, mirrorSnapshot, expirationTime, username, 0L);
    }

    public int createSnapshot(String cluster, String volumeName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, long expirationTime, String username, long clusterOps) {
        LOG.debug((Object)("Enter createSnapshot: cluster " + cluster + "volumeName " + volumeName + "volId " + volId + "rootCid " + rootCid + "snapshotName " + snapshotName + "mirrorSnapshot " + mirrorSnapshot + "expirationTime " + expirationTime + "username " + username + "clusterOps " + clusterOps));
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(this, cluster) : clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData == null) {
                LOG.debug((Object)"Exit createSnapshot: failed lookupClient");
                return -1;
            }
            int ret = clusterData.client.createSnapshotLite(volumeName, volId, rootCid, snapshotName, mirrorSnapshot, expirationTime, username, this.userInfo, clusterOps);
            LOG.debug((Object)("Exit createSnapshot: ret " + ret));
            return ret;
        }
        catch (Exception e) {
            LOG.debug((Object)"Exiting createSnapshot with exception");
            return -1;
        }
    }

    public QueryServiceParam getQueryServiceParam() throws IOException, InterruptedException {
        return this.getQueryServiceParam(this.clusterName);
    }

    public QueryServiceParam getQueryServiceParam(String clusterName) throws IOException, InterruptedException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, clusterName);
        if (centry == null) {
            throw new ClusterNotFoundException(clusterName);
        }
        ClusterData clusterData = this.lookupClient(centry);
        return clusterData.client.getQueryServiceParam();
    }

    public void setQueryServiceParam(QueryServiceParam qsp) throws IOException, InterruptedException {
        this.setQueryServiceParam(this.clusterName, qsp);
    }

    public void setQueryServiceParam(String clusterName, QueryServiceParam qsp) throws IOException, InterruptedException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, clusterName);
        if (centry == null) {
            throw new ClusterNotFoundException(clusterName);
        }
        ClusterData clusterData = this.lookupClient(centry);
        clusterData.client.setQueryServiceParam(qsp);
    }

    public void clearQueryServiceParam() throws IOException, InterruptedException {
        this.clearQueryServiceParam(this.clusterName);
    }

    public void clearQueryServiceParam(String clusterName) throws IOException, InterruptedException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, clusterName);
        if (centry == null) {
            throw new ClusterNotFoundException(clusterName);
        }
        ClusterData clusterData = this.lookupClient(centry);
        clusterData.client.clearQueryServiceParam();
    }

    private String getZkConnectStringInternal(String cName) {
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, cName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData == null) {
                return null;
            }
            return clusterData.client.getZkConnectString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getZkConnectString() throws IOException {
        return this.getZkConnectStringInternal(this.clusterName);
    }

    public Object getMapRClient(String uri) throws IOException {
        String cName;
        LOG.debug((Object)("Enter getMapRClient: uri: " + uri));
        if (!uri.startsWith("maprfs:///")) {
            throw new IOException("Invalid prefix in " + uri + " expecting maprfs:///");
        }
        if ((uri = uri.replaceFirst("maprfs:///", "")).isEmpty()) {
            cName = this.clusterName;
        } else {
            if (uri.matches("mapr/+")) {
                throw new IOException("Invalid cluster path in " + uri + " expecting maprfs:///");
            }
            uri = uri.replaceFirst("mapr/", "");
            cName = uri = uri.replaceAll("/+$", "");
        }
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, cName);
            LOG.debug((Object)"Exit getMapRClient: with lookupClient");
            return this.lookupClient((ClusterConf.ClusterEntry)centry).client;
        }
        catch (Exception e) {
            LOG.debug((Object)"Exit getMapRClient: with return value NULL");
            return null;
        }
    }

    public InetSocketAddress[] getJobTrackerAddrs(Configuration conf) throws IOException {
        URI jobTrackerUri;
        if (conf == null) {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
            ClusterData clusterData = this.lookupClient(centry);
            if (clusterData != null) {
                return clusterData.client.getJobTrackerAddrs();
            }
            throw new IOException("Invalid Configuration");
        }
        String jobTrackerStr = conf.get("mapred.job.tracker", "maprdummy").trim();
        try {
            jobTrackerUri = new URI(jobTrackerStr);
        }
        catch (Exception e) {
            return this.getAddrsFromConf(conf);
        }
        if ("maprfs".equals(jobTrackerUri.getScheme())) {
            MapRClientImpl client = (MapRClientImpl)((Object)this.getMapRClient(jobTrackerStr));
            if (client != null) {
                return client.getJobTrackerAddrs();
            }
            throw new IOException("Failed to get cluster information for " + jobTrackerStr);
        }
        return this.getAddrsFromConf(conf);
    }

    private InetSocketAddress[] getAddrsFromConf(Configuration conf) {
        String[] jobTrackerStrs = MapRFileSystem.getTrimmedStrings(conf.get("mapred.job.tracker", "maprdummy"));
        InetSocketAddress[] jobTrackerAddrs = new InetSocketAddress[jobTrackerStrs.length];
        for (int i = 0; i < jobTrackerStrs.length; ++i) {
            jobTrackerAddrs[i] = NetUtils.createSocketAddr((String)jobTrackerStrs[i]);
        }
        return jobTrackerAddrs;
    }

    public static ClusterConf getClusterConf() {
        return clusterConf;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || "".equals(str.trim())) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }

    @Deprecated
    public static String fidToString(Common.FidMsg fid) {
        return Fids.fidToString(fid);
    }

    @Deprecated
    public static boolean isFidString(String fid) {
        return Fids.isFidString(fid);
    }

    @Deprecated
    public static void validateFid(String fid) throws IOException {
        Fids.validateFid(fid);
    }

    public void createSymbolicLink(org.apache.hadoop.fs.Path target, org.apache.hadoop.fs.Path link) throws IOException {
        int err = this.createSymlink(target.toString(), link, false);
        if (err != 0) {
            throw new IOException("Failed to create symbolic link: " + link + " -> " + target + ".Error: " + Errno.toString((int)err));
        }
    }

    public Inode openTable(org.apache.hadoop.fs.Path tableURI, MapRHTable htable) throws IOException {
        Inode table;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter openTable: tableURI " + tableURI.toString()));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create mapr client for " + tableURI);
            }
            MapRFileSystem.initError(err);
            table = clusterData.client.openTable(tableName, err, htable, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        LOG.debug((Object)("Exit openTable: table " + table.toString()));
        return table;
    }

    public Inode openTableWithFid(org.apache.hadoop.fs.Path priTableURI, String indexFid, MapRHTable htable) throws IOException {
        Inode table;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        LOG.debug((Object)("Enter openTableWithFid: priTableURI " + priTableURI.toString() + "indexFid " + indexFid));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(priTableURI)) == null) {
                throw new IOException("Failed to create mapr client for " + priTableURI);
            }
            MapRFileSystem.initError(err);
            table = clusterData.client.openTableWithFid(indexFid, err, htable, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            priTableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        LOG.debug((Object)("Exit openTableWithFid: table " + table.toString()));
        return table;
    }

    private List<String> getSecurityPolicyNames(List<Integer> spIds) throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
        }
        return clusterData.client.getSecurityPolicyNames(spIds, err, this.userInfo);
    }

    public String getSecurityPolicyNameOrId(int spId) throws IOException {
        Object spName;
        try {
            spName = this.getSecurityPolicyName(spId);
            if (spName == null) {
                spName = "__UNKNOWN__" + spId;
            }
        }
        catch (Exception e) {
            spName = "__UNKNOWN__" + spId;
        }
        return spName;
    }

    public String getSecurityPolicyName(int policyID) throws IOException {
        String policyName = (String)this.securityPolicyIdToNameMap_.get((Object)policyID);
        if (policyName == null) {
            ArrayList<Integer> inList = new ArrayList<Integer>();
            inList.add(policyID);
            List<String> outList = this.getSecurityPolicyNames(inList);
            if (outList.isEmpty()) {
                throw new IOException("Failed to get policy name for security policy ID \"" + policyName + "\"");
            }
            policyName = outList.get(0);
            this.securityPolicyNameToIdMap_.put((Object)policyName, (Object)policyID);
        }
        return policyName;
    }

    public List<Integer> getSecurityPolicyIds(List<String> securityPolicyTagList) throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
        }
        return clusterData.client.getSecurityPolicyIds(securityPolicyTagList, err, this.userInfo);
    }

    public int getSecurityPolicyId(String policyName) throws IOException {
        Integer policyId = (Integer)this.securityPolicyNameToIdMap_.get((Object)policyName);
        if (policyId == null) {
            ArrayList<String> inList = new ArrayList<String>();
            inList.add(policyName);
            List<Integer> outList = this.getSecurityPolicyIds(inList);
            if (outList.isEmpty()) {
                throw new IOException("Failed to get policy ID for security policy \"" + policyName + "\"");
            }
            policyId = outList.get(0);
            this.securityPolicyNameToIdMap_.put((Object)policyName, (Object)policyId);
        }
        return policyId;
    }

    public Map<String, Integer> getClusterSecurityPolicies() throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
        }
        return clusterData.client.getClusterSecurityPolicies(this.userInfo);
    }

    public String createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, Dbserver.TableAces aces, byte[][] splitKeys, boolean needServerInfo, int auditValue) throws IOException {
        return this.createTable(tableURI, user, attr, aces, splitKeys, needServerInfo, auditValue, null);
    }

    public String createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, Dbserver.TableAces aces, byte[][] splitKeys, boolean needServerInfo, int auditValue, List<String> securityPolicyTagList) throws IOException {
        return this.createTable(tableURI, user, attr, aces, splitKeys, needServerInfo, auditValue, securityPolicyTagList, TableCreateOptions.defaults());
    }

    public String createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, Dbserver.TableAces aces, byte[][] splitKeys, boolean needServerInfo, int auditValue, List<String> securityPolicyTagList, TableCreateOptions options) throws IOException {
        boolean updateMetadata;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tablePath = this.getName(tableURI);
        String server = null;
        String tablePathStr = this.makeAbsolute(tableURI).toUri().getPath();
        String clusterName = this.getClusterNameUnchecked(tablePathStr);
        LOG.debug((Object)("Enter createTable: tableURI " + tableURI.toString() + "user " + user + "needServerInfo " + needServerInfo));
        int mode = MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf());
        boolean bl = updateMetadata = !attr.getJson() && !options.isSystem();
        do {
            List<Integer> securityPolicyIdTagList;
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tablePath);
            }
            MapRFileSystem.initError(err);
            if (securityPolicyTagList != null && !securityPolicyTagList.isEmpty() && (securityPolicyIdTagList = this.getSecurityPolicyIds(securityPolicyTagList)).size() > 0) {
                Dbserver.SecurityPolicyIds spIds = Dbserver.SecurityPolicyIds.newBuilder().addAllIds(securityPolicyIdTagList).build();
                attr = attr.toBuilder().setSecurityPolicyIdTags(spIds).build();
            }
            if (updateMetadata) {
                this.metadataMgr(clusterName).prepareCreate(tablePathStr);
            }
            server = clusterData.client.createTable(tablePath, user, attr, aces, mode, splitKeys, needServerInfo, auditValue, err, this.userInfo);
            if (updateMetadata && err.error == 0) {
                this.metadataMgr(clusterName).commitCreate(tablePathStr);
            }
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tablePath = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38 || attr == null) continue;
            if (attr.getIsMarlinTable()) {
                throw new IOExceptionWithErrorCode("Failed to create stream: " + tablePath + " , Error: Operation not permitted, verify that the cluster has an M3 license or an Enterprise license with Streams module enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.", err.error);
            }
            throw new IOExceptionWithErrorCode("Failed to create table: " + tablePath + " , Error: Operation not permitted, verify that the cluster has an M3 license or an Enterprise license with Database module enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.", err.error);
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error > 0 && err.error <= 138) {
                throw new IOExceptionWithErrorCode("Failed to create table: " + tablePath + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
            Error.ErrorCode extendedTaggingErrorCode = Error.ErrorCode.ErrSecurityPolicyTaggingNotAllowed;
            if (err.error == extendedTaggingErrorCode.getNumber()) {
                if (err.securityPolicyId > 0) {
                    String spName = this.getSecurityPolicyNameOrId(err.securityPolicyId);
                    throw new IOExceptionWithErrorCode("Failed to create table: " + tablePath + ". Tagging not allowed for security policy " + spName, err.error);
                }
            } else {
                throw new IOExceptionWithErrorCode("Failed to create table: " + tablePath + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
        }
        LOG.debug((Object)("Exit createTable: server " + server));
        return server;
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, AceHelper.DBPermission dbperm, int auditValue) throws IOException {
        this.createTable(tableURI, user, attr, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), null, false, auditValue, null);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, AceHelper.DBPermission dbperm, int auditValue, List<String> securityPolicyTagList) throws IOException {
        this.createTable(tableURI, user, attr, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), null, false, auditValue, securityPolicyTagList);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, AceHelper.DBPermission dbperm, byte[][] splitKeys, int auditValue, List<String> securityPolicyTagList) throws IOException {
        this.createTable(tableURI, user, attr, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), splitKeys, false, auditValue, securityPolicyTagList, TableCreateOptions.defaults());
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, AceHelper.DBPermission dbperm, byte[][] splitKeys, int auditValue, List<String> securityPolicyTagList, TableCreateOptions options) throws IOException {
        this.createTable(tableURI, user, attr, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), splitKeys, false, auditValue, securityPolicyTagList, options);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, String user, Dbserver.TableAttr attr, AceHelper.DBPermission dbperm, byte[][] splitKeys, int auditValue) throws IOException {
        this.createTable(tableURI, user, attr, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), splitKeys, false, auditValue);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, String user) throws IOException {
        this.createTable(tableURI, user, Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), null, false, -1);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI) throws IOException {
        this.createTable(tableURI, null, Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), null, false, -1);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, String user, byte[][] splitKeys) throws IOException {
        this.createTable(tableURI, user, Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), splitKeys, false, -1);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, byte[][] splitKeys, boolean isBulkLoad, boolean isJson) throws IOException {
        Dbserver.TableAttr ta = Dbserver.TableAttr.getDefaultInstance();
        ta = ta.toBuilder().setBulkLoad(isBulkLoad).build();
        ta = ta.toBuilder().setJson(isJson).build();
        this.createTable(tableURI, null, ta, Dbserver.TableAces.getDefaultInstance(), splitKeys, false, -1);
    }

    public void createTable(org.apache.hadoop.fs.Path tableURI, byte[][] splitKeys, boolean isBulkLoad, boolean isJson, boolean insertOrder) throws IOException {
        if (!isJson && insertOrder) {
            throw new IOException("Insertion Order on a BINARY table is an invalid operation.");
        }
        Dbserver.TableAttr ta = Dbserver.TableAttr.getDefaultInstance();
        ta = ta.toBuilder().setBulkLoad(isBulkLoad).build();
        ta = ta.toBuilder().setJson(isJson).build();
        ta = ta.toBuilder().setInsertionOrder(insertOrder).build();
        this.createTable(tableURI, null, ta, Dbserver.TableAces.getDefaultInstance(), splitKeys, false, -1, null);
    }

    public Dbserver.TabletLookupResponse getTablets(org.apache.hadoop.fs.Path tableURI, String indexFid, byte[] stKey, byte[] endKey, boolean needSpaceUsage) throws IOException {
        return this.getTablets(tableURI, indexFid, stKey, endKey, needSpaceUsage, false);
    }

    public Dbserver.TabletLookupResponse getTablets(org.apache.hadoop.fs.Path tableURI, String indexFid, byte[] stKey, byte[] endKey, boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        Dbserver.TabletLookupResponse lookupResp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter getTablets: tableURI " + tableURI.toString() + "indexFid " + indexFid + "stKey " + stKey + "endKey: " + endKey + "needSpaceUsage: " + needSpaceUsage + "prefetchTabletMap: " + prefetchTabletMap));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            lookupResp = indexFid == null ? clusterData.client.getTablets(tableName, stKey, endKey, needSpaceUsage, prefetchTabletMap, err, this.userInfo) : clusterData.client.getTabletsWithFid(indexFid, stKey, endKey, needSpaceUsage, prefetchTabletMap, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            String stKeyStr = new String(stKey, "UTF-8");
            throw new IOException("Failed to get tablets on table: " + tableName + " with startkey " + stKeyStr + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        LOG.debug((Object)"Exit getTablets:");
        return lookupResp;
    }

    public void createColumnFamily(org.apache.hadoop.fs.Path tableURI, String name, Dbserver.ColumnFamilyAttr cfAttr) throws IOException {
        this.createColumnFamily(tableURI, name, cfAttr, null);
    }

    public void createColumnFamily(org.apache.hadoop.fs.Path tableURI, String name, Dbserver.ColumnFamilyAttr cfAttr, AceHelper.DBPermission dbperm, List<String> securityPolicyTagList) throws IOException {
        this.createColumnFamily(tableURI, name, cfAttr.toBuilder().addAllAces((Iterable)AceHelper.getCfPermission((AceHelper.DBPermission)dbperm)).build(), securityPolicyTagList);
    }

    public void createColumnFamily(org.apache.hadoop.fs.Path tableURI, String name, Dbserver.ColumnFamilyAttr cfAttr, List<String> securityPolicyTagList) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter createColumnFamily: tableURI " + tableURI.toString() + "name " + name));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            ArrayList<Integer> securityPolicyIdTagList = new ArrayList<Integer>();
            if (securityPolicyTagList != null) {
                for (String spName : securityPolicyTagList) {
                    int policyID = this.getSecurityPolicyId(spName);
                    securityPolicyIdTagList.add(policyID);
                }
            }
            MapRFileSystem.initError(err);
            if (securityPolicyIdTagList.size() > 0) {
                Dbserver.SecurityPolicyIds spIds = Dbserver.SecurityPolicyIds.newBuilder().addAllIds(securityPolicyIdTagList).build();
                cfAttr = cfAttr.toBuilder().setSchFamily(cfAttr.getSchFamily().toBuilder().setSecurityPolicyIdTags(spIds).build()).build();
            }
            clusterData.client.createColumnFamily(tableName, name, cfAttr, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to create column family on table: " + tableName + " with name " + name + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error == 126) {
            throw new IOException("Failed to create column family on table: " + tableName + " with name " + name + ", Error: first column family name must be \"default\" for table of type JSON");
        }
        if (err.error != 0) {
            if (err.error > 0 && err.error <= 138) {
                throw new ErrnoException("Failed to create column family on table: " + tableName + " with name " + name + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
            Error.ErrorCode extendedTaggingErrorCode = Error.ErrorCode.ErrSecurityPolicyTaggingNotAllowed;
            if (err.error == extendedTaggingErrorCode.getNumber()) {
                if (err.securityPolicyId > 0) {
                    String spName = this.getSecurityPolicyNameOrId(err.securityPolicyId);
                    throw new ErrnoException("Failed to create column family on table: " + tableName + " with name " + name + ". Tagging not allowed for security policy " + spName, err.error);
                }
            } else {
                throw new ErrnoException("Failed to create column family on table: " + tableName + " with name " + name + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
        }
        LOG.debug((Object)"Exit createColumnFamily:");
    }

    public void modifyColumnFamily(org.apache.hadoop.fs.Path tableURI, String name, Dbserver.ColumnFamilyAttr cfAttr, AceHelper.DBPermission dbperm) throws IOException {
        this.modifyColumnFamily(tableURI, name, Dbserver.SecurityPolicyOperation.SPOP_NONE, cfAttr.toBuilder().addAllAces((Iterable)AceHelper.getCfPermission((AceHelper.DBPermission)dbperm)).build());
    }

    public void modifyColumnFamily(org.apache.hadoop.fs.Path tableURI, String name, Dbserver.ColumnFamilyAttr cfAttr, Dbserver.SecurityPolicyOperation securityPolicyOp, AceHelper.DBPermission dbperm) throws IOException {
        this.modifyColumnFamily(tableURI, name, securityPolicyOp, cfAttr.toBuilder().addAllAces((Iterable)AceHelper.getCfPermission((AceHelper.DBPermission)dbperm)).build());
    }

    public void modifyColumnFamily(org.apache.hadoop.fs.Path tableURI, String name, Dbserver.ColumnFamilyAttr cfAttr) throws IOException {
        this.modifyColumnFamily(tableURI, name, Dbserver.SecurityPolicyOperation.SPOP_NONE, cfAttr);
    }

    public void modifyColumnFamily(org.apache.hadoop.fs.Path tableURI, String name, Dbserver.SecurityPolicyOperation securityPolicyOp, Dbserver.ColumnFamilyAttr cfAttr) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter modifyColumnFamily: tableURI " + tableURI.toString() + "name " + name));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.modifyColumnFamily(tableName, name, cfAttr, securityPolicyOp, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to modify column family on table: " + tableName + " with name " + name + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error > 0 && err.error <= 138) {
                throw new ErrnoException("Failed to modify column family on table: " + tableName + " with name " + name + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
            Error.ErrorCode extendedTaggingErrorCode = Error.ErrorCode.ErrSecurityPolicyTaggingNotAllowed;
            if (err.error == extendedTaggingErrorCode.getNumber()) {
                if (err.securityPolicyId > 0) {
                    String spName = this.getSecurityPolicyNameOrId(err.securityPolicyId);
                    throw new ErrnoException("Failed to modify column family on table: " + tableName + " with name " + name + ". Tagging not allowed for security policy " + spName, err.error);
                }
            } else {
                throw new ErrnoException("Failed to modify column family on table: " + tableName + " with name " + name + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
        }
        LOG.debug((Object)"Exit modifyColumnFamily:");
    }

    public void deleteColumnFamily(org.apache.hadoop.fs.Path tableURI, String name) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter deleteColumnFamily: tableURI " + tableURI.toString() + "name: " + name));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.deleteColumnFamily(tableName, name, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to delete column family on table: " + tableName + " with name " + name + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to delete column family on table: " + tableName + " with name " + name + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit deleteColumnFamily:");
    }

    public List<Dbserver.ColumnFamilyAttr> listColumnFamily(org.apache.hadoop.fs.Path tableURI, boolean wantAces) throws IOException {
        return this.listColumnFamily(tableURI, wantAces, false);
    }

    public List<Dbserver.ColumnFamilyAttr> listColumnFamily(org.apache.hadoop.fs.Path tableURI, boolean wantAces, boolean useCached) throws IOException {
        List<Dbserver.ColumnFamilyAttr> colFamilyList;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter listColumnFamily: tableURI " + tableURI.toString() + "wantAces " + wantAces + "useCached " + useCached));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            colFamilyList = clusterData.client.listColumnFamily(tableName, wantAces, useCached, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        this.handleError(tableURI, err);
        LOG.debug((Object)"Exit listColumnFamily:");
        return colFamilyList;
    }

    public void modifyDbSecurityPolicy(org.apache.hadoop.fs.Path tableURI, AceHelper.DBPermission dbperm, List<String> securityPolicyTagList, Dbserver.SecurityPolicyOperation op) throws IOException {
        List<Object> securityPolicyIdTagListToModify;
        List<Object> list = securityPolicyIdTagListToModify = securityPolicyTagList.isEmpty() ? new ArrayList() : this.getSecurityPolicyIds(securityPolicyTagList);
        if (op != Dbserver.SecurityPolicyOperation.SPOP_NONE) {
            Dbserver.SecurityPolicyIds spIds = Dbserver.SecurityPolicyIds.newBuilder().addAllIds(securityPolicyIdTagListToModify).build();
            Dbserver.TableAttr attr = Dbserver.TableAttr.newBuilder().setSecurityPolicyIdTags(spIds).build();
            this.modifyTableAttr(tableURI, attr, dbperm, false, op);
        }
    }

    public void modifyDbCfSecurityPolicy(org.apache.hadoop.fs.Path tableURI, AceHelper.DBPermission dbperm, List<String> securityPolicyTagList, Dbserver.SecurityPolicyOperation op, String cfname) throws IOException {
        Dbserver.ColumnFamilyAttr existingCf = null;
        for (Dbserver.ColumnFamilyAttr cf : this.listColumnFamily(tableURI, true)) {
            if (!cf.getSchFamily().getName().equals(cfname)) continue;
            existingCf = cf;
            break;
        }
        List<Object> securityPolicyIdTagListToModify = securityPolicyTagList.isEmpty() ? new ArrayList() : this.getSecurityPolicyIds(securityPolicyTagList);
        Dbserver.ColumnFamilyAttr cfAttr = null;
        if (op != Dbserver.SecurityPolicyOperation.SPOP_NONE) {
            Dbserver.SecurityPolicyIds spIds = Dbserver.SecurityPolicyIds.newBuilder().addAllIds(securityPolicyIdTagListToModify).build();
            cfAttr = Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(Dbserver.SchemaFamily.newBuilder().setSecurityPolicyIdTags(spIds).build()).build();
        }
        this.modifyColumnFamily(tableURI, cfname, cfAttr, op, dbperm);
    }

    public void modifyTableAttr(org.apache.hadoop.fs.Path tableURI, Dbserver.TableAttr am, AceHelper.DBPermission dbperm) throws IOException {
        this.modifyTableAttr(tableURI, am, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), false, Dbserver.SecurityPolicyOperation.SPOP_NONE);
    }

    public void modifyTableAttr(org.apache.hadoop.fs.Path tableURI, Dbserver.TableAttr am, AceHelper.DBPermission dbperm, boolean genUuid) throws IOException {
        this.modifyTableAttr(tableURI, am, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), genUuid, Dbserver.SecurityPolicyOperation.SPOP_NONE);
    }

    public void modifyTableAttr(org.apache.hadoop.fs.Path tableURI, Dbserver.TableAttr am, AceHelper.DBPermission dbperm, boolean genUuid, Dbserver.SecurityPolicyOperation securityPolicyOp) throws IOException {
        this.modifyTableAttr(tableURI, am, AceHelper.getTablePermission((AceHelper.DBPermission)dbperm), genUuid, securityPolicyOp);
    }

    public void modifyTableAttr(org.apache.hadoop.fs.Path tableURI, Dbserver.TableAttr am, Dbserver.TableAces aces) throws IOException {
        this.modifyTableAttr(tableURI, am, aces, false, Dbserver.SecurityPolicyOperation.SPOP_NONE);
    }

    public void modifyTableAttr(org.apache.hadoop.fs.Path tableURI, Dbserver.TableAttr am, Dbserver.TableAces aces, boolean genUuid, Dbserver.SecurityPolicyOperation securityPolicyOp) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter modifyTableAttr: tableURI " + tableURI.toString() + "genUuid " + genUuid));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.modifyTableAttr(tableName, am, aces, genUuid, securityPolicyOp, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOExceptionWithErrorCode("Failed to modify attribute on table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB/streams support enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.", err.error);
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error > 0 && err.error <= 138) {
                throw new IOExceptionWithErrorCode("Failed to modify attribute on table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
            Error.ErrorCode extendedTaggingErrorCode = Error.ErrorCode.ErrSecurityPolicyTaggingNotAllowed;
            if (err.error == extendedTaggingErrorCode.getNumber()) {
                if (err.securityPolicyId > 0) {
                    String spName = this.getSecurityPolicyNameOrId(err.securityPolicyId);
                    throw new IOExceptionWithErrorCode("Failed to modify attribute on table: " + tableName + ". Tagging not allowed for security policy " + spName, err.error);
                }
            } else {
                throw new IOExceptionWithErrorCode("Failed to create table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
            }
        }
        LOG.debug((Object)"Exit modifyTableAttr:");
    }

    public TableBasicAttrs getTableBasicAttrs(org.apache.hadoop.fs.Path tableURI) throws IOException {
        Dbserver.OpenBasicAttrs tableBasicAttrs;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter getTableBasicAttrs: tableURI " + tableURI.toString()));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            tableBasicAttrs = clusterData.client.getTableBasicAttrs(tableName, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            String msg = "Failed to get basic attributes on table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")";
            switch (err.error) {
                case 2: 
                case 22: 
                case 116: {
                    throw new FileNotFoundException(msg);
                }
            }
            throw new IOException(msg);
        }
        LOG.debug((Object)"Exit getTableBasicAttrs:");
        return new TableBasicAttrs(tableBasicAttrs);
    }

    public TableProperties getTableProperties(org.apache.hadoop.fs.Path tableURI) throws IOException {
        TableProperties tableProp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter getTableProperties: tableURI " + tableURI.toString()));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            tableProp = clusterData.client.getTableProperties(tableName, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            String msg = "Failed to list attributes on table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")";
            switch (err.error) {
                case 2: 
                case 22: 
                case 116: {
                    throw new FileNotFoundException(msg);
                }
            }
            throw new IOException(msg);
        }
        LOG.debug((Object)"Exit getTableProperties:");
        return tableProp;
    }

    public void splitTableRegion(org.apache.hadoop.fs.Path tableURI, String fidstr, boolean ignoreRegionTooSmallError) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter splitTableRegion: tableURI " + tableURI.toString() + "fidstr " + fidstr + "ignoreRegionTooSmallError " + ignoreRegionTooSmallError));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.splitTableRegion(fidstr, ignoreRegionTooSmallError, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to split region of table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to split region of table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit splitTableRegion:");
    }

    public void packTableRegion(org.apache.hadoop.fs.Path tableURI, String fidstr, int ctype) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter packTableRegion: tableURI " + tableURI.toString() + "fidstr " + fidstr + "ctype: " + ctype));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.packTableRegion(fidstr, ctype, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to pack region of table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to pack region of table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit packTableRegion:");
    }

    public void mergeTableRegion(org.apache.hadoop.fs.Path tableURI, String fidstr) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter mergeTableRegion: tableURI " + tableURI.toString() + "fidstr " + fidstr));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.mergeTableRegion(fidstr, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to merge region of table: " + tableName + ", Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to merge region of table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit mergeTableRegion:");
    }

    public MapRTabletScanner getTabletScanner(org.apache.hadoop.fs.Path tableURI, String indexFid) throws IOException {
        return this.getTabletScanner(tableURI, indexFid, false, false);
    }

    public MapRTabletScanner getTabletScanner(org.apache.hadoop.fs.Path tableURI, String indexFid, boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        LOG.debug((Object)("In getTabletScanner: tableURI " + tableURI.toString() + "indexFid " + indexFid));
        MapRTabletScanner scanner = new MapRTabletScanner(this, tableURI, indexFid, needSpaceUsage, prefetchTabletMap);
        return scanner;
    }

    public byte[] getContainerInfo(org.apache.hadoop.fs.Path path, List<Integer> cidList) throws IOException {
        ClusterData clusterData = this.lookupClient(path);
        LOG.debug((Object)("Enter getContainerInfo: path " + path.toString() + "cidList " + cidList));
        if (clusterData == null) {
            LOG.error((Object)"Exit getContainerInfo: failed lookupClient");
            return null;
        }
        int[] cids = new int[cidList.size()];
        for (int i = 0; i < cidList.size(); ++i) {
            cids[i] = cidList.get(i);
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        byte[] resp = clusterData.client.getContainerInfo(cids, err, this.userInfo);
        if (err.error != 0 || resp == null) {
            LOG.error((Object)("Failed to get containerinfo for path " + path.toString() + "error " + err.error));
        }
        LOG.debug((Object)("Exit getContainerInfo: resp " + resp));
        return resp;
    }

    public MapRTabletScanner getTabletScanner(org.apache.hadoop.fs.Path tableURI, String indexFid, byte[] startKey) throws IOException {
        LOG.debug((Object)("In getTabletScanner: tableURI " + tableURI.toString() + "indexFid " + indexFid + "startKey " + startKey));
        MapRTabletScanner scanner = new MapRTabletScanner(this, tableURI, indexFid, startKey);
        return scanner;
    }

    public MapRTabletScanner getTabletScanner(org.apache.hadoop.fs.Path tableURI, String indexFid, byte[] startKey, byte[] endKey, boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        LOG.debug((Object)("In getTabletScanner: tableURI " + tableURI.toString() + "indexFid " + indexFid + "startKey " + startKey + "endKey needSpaceUsage: " + needSpaceUsage + "prefetchTabletMap: " + prefetchTabletMap));
        MapRTabletScanner scanner = new MapRTabletScanner(this, tableURI, indexFid, startKey, endKey, needSpaceUsage, prefetchTabletMap);
        return scanner;
    }

    public Dbserver.TabletStatResponse getTabletStat(org.apache.hadoop.fs.Path tablePath, Common.FidMsg tabletFid) throws IOException {
        ClusterData clusterData = this.lookupClient(tablePath);
        LOG.debug((Object)("Enter getTabletStat: path " + tablePath.toString()));
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for path: " + tablePath.toString());
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        Dbserver.TabletStatResponse resp = clusterData.client.getTabletStat(tabletFid, err);
        if (err.error != 0 || resp == null) {
            String fid = tabletFid.getCid() + "." + tabletFid.getCinum() + "." + tabletFid.getUniq();
            throw new IOException("Failed to get tablet stat for fid: " + fid);
        }
        LOG.debug((Object)"Exit getTabletStat:");
        return resp;
    }

    public void addTableReplica(org.apache.hadoop.fs.Path tableURI, Dbserver.TableReplicaDesc desc, Dbserver.TableReplAutoSetupInfo ainfo) throws IOException, UnsupportedOperationException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        boolean isChangelog = false;
        boolean isIndex = false;
        LOG.debug((Object)("Enter addTableReplica: path " + tableURI.toString()));
        if (desc.hasReplicaClassName() && desc.getReplicaClassName().equals(Dbserver.DBInternalDefaults.getDefaultInstance().getReplicaClassNameForChangeLog())) {
            isChangelog = true;
        } else if (desc.hasSiInfo()) {
            isIndex = true;
        }
        String errStr = "Failed to add " + (isChangelog ? "changelog" : (isIndex ? "index" : "replica")) + " for table: " + tableName;
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            int ret = clusterData.client.addTableReplica(tableName, desc, ainfo, err, this.userInfo);
            if (err.error != 0) {
                if (isChangelog) {
                    Dbserver.ChangelogInfo cloginfo = Dbserver.ChangelogInfo.values()[ret];
                    if (cloginfo != Dbserver.ChangelogInfo.CLOG_ENABLED && cloginfo != Dbserver.ChangelogInfo.CLOG_NOT_DETERMINED) {
                        throw new UnsupportedOperationException(errStr + " ChangelogInfo " + cloginfo.toString());
                    }
                } else if (isIndex) {
                    Dbserver.SIInfo siInfo = Dbserver.SIInfo.values()[ret];
                    if (siInfo != Dbserver.SIInfo.SI_ENABLED && siInfo != Dbserver.SIInfo.SI_NOT_DETERMINED) {
                        throw new UnsupportedOperationException(errStr + " : " + this.SIInfoCodeToString(siInfo));
                    }
                } else {
                    Dbserver.DirectCopyInfo dcinfo = Dbserver.DirectCopyInfo.values()[ret];
                    if (dcinfo != Dbserver.DirectCopyInfo.DC_ENABLED && dcinfo != Dbserver.DirectCopyInfo.DC_NOT_DETERMINED) {
                        throw new UnsupportedOperationException(errStr + " DirectCopyInfo " + dcinfo.toString());
                    }
                }
            }
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException(errStr + ", Error: Operation not permitted, need an Enterprise license with Database module (for tables), Streams module (for streams)  or Changelog module (for changelogs) enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            if (err.error == 17) {
                throw new ErrnoException(errStr + ", Error: " + (isChangelog ? "changelog" : (isIndex ? "index" : "replica")) + " already exists");
            }
            throw new ErrnoException(errStr + ", Error *** : " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit addTableReplica:");
    }

    public void editTableReplica(org.apache.hadoop.fs.Path tableURI, String clusterName, String replicaPath, boolean allowAllCfs, Dbserver.TableReplicaDesc desc) throws IOException {
        this.editTableReplica(tableURI, clusterName, replicaPath, null, allowAllCfs, desc);
    }

    public void editTableReplica(org.apache.hadoop.fs.Path tableURI, String clusterName, String replicaPath, String topicName, boolean allowAllCfs, Dbserver.TableReplicaDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        boolean isChangelog = false;
        if (topicName != null && !topicName.equals("")) {
            isChangelog = true;
        }
        LOG.debug((Object)("Enter editTableReplica: path " + tableURI.toString() + "clusterName " + clusterName + "replicaPath " + replicaPath + "topicName " + topicName + "allowAllCfs " + allowAllCfs));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.editTableReplica(tableName, clusterName, replicaPath, topicName, allowAllCfs, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to edit " + (isChangelog ? "changelog" : "replica") + " for table: " + tableName + ", Error: Operation not permitted, need an Enterprise license with Database module (for tables), Streams module (for streams)  or Changelog module (for changelogs) enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to edit " + (isChangelog ? "changelog" : "replica") + " for table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit editTableReplica:");
    }

    public Dbserver.TableBasicStats getTableStats(org.apache.hadoop.fs.Path tableURI, String indexFid) throws IOException {
        Dbserver.TableBasicStats basicStats = null;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter getTableStats: path " + tableURI.toString() + "indexFid " + indexFid));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            basicStats = clusterData.client.getTableStats(tableName, indexFid, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0 || basicStats == null) {
            throw new ErrnoException("Failed to fetch stats for table " + tableName + ", " + (String)(indexFid != null ? indexFid + ", " : "") + "Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit getTableStats:");
        return basicStats;
    }

    public Dbserver.TableBasicStats getScanRangeStats(org.apache.hadoop.fs.Path tableURI, String indexFid, byte[] stKey, byte[] endKey) throws IOException {
        Dbserver.TableBasicStats scrStats = null;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter getScanRangeStats: path " + tableURI.toString() + "indexFid " + indexFid + "stKey " + stKey + "endKey " + endKey));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            scrStats = clusterData.client.getScanRangeStats(tableName, indexFid, stKey, endKey, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0 || scrStats == null) {
            String stKeyStr = new String(stKey, "UTF-8");
            String endKeyStr = new String(endKey, "UTF-8");
            throw new ErrnoException("Failed to fetch scan range stats for table " + tableName + ", " + (String)(indexFid != null ? indexFid + ", " : "") + " with startkey " + stKeyStr + " and endKey " + endKeyStr + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit getScanRangeStats:");
        return scrStats;
    }

    public Dbserver.TableReplicaListResponse listTableIndexes(org.apache.hadoop.fs.Path tableURI, boolean wantStats, boolean skipFieldsReadPermCheck, boolean refreshNow) throws IOException {
        LOG.debug((Object)"In listTableIndexes: executing listTableDownstreams:");
        return this.listTableDownstreams(tableURI, wantStats, skipFieldsReadPermCheck, refreshNow, MapRClientImpl.TableDownstreamType.Indexes, false);
    }

    public Dbserver.TableReplicaListResponse listTableReplicas(org.apache.hadoop.fs.Path tableURI, boolean wantStats, boolean refreshNow, boolean getCompactInfo) throws IOException {
        LOG.debug((Object)"In listTableReplicas: executing listTableDownstreams:");
        return this.listTableDownstreams(tableURI, wantStats, false, refreshNow, MapRClientImpl.TableDownstreamType.Replica, getCompactInfo);
    }

    private Dbserver.TableReplicaListResponse listTableDownstreams(org.apache.hadoop.fs.Path tableURI, boolean wantStats, boolean skipFieldsReadPermCheck, boolean refreshNow, MapRClientImpl.TableDownstreamType type, boolean getCompactInfo) throws IOException {
        Dbserver.TableReplicaListResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter listTableDownstreams: path " + tableURI + "wantStats " + wantStats + "skipFieldsReadPermCheck " + skipFieldsReadPermCheck + "refreshNow " + refreshNow + "type " + type + "getCompactInfo " + getCompactInfo));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.listTableDownstreams(tableName, wantStats, skipFieldsReadPermCheck, refreshNow, type, getCompactInfo, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to list " + (type == MapRClientImpl.TableDownstreamType.Indexes ? "index" : "replicas or changelogs") + " for table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit listTableDownstreams:");
        return resp;
    }

    public void removeTableReplica(org.apache.hadoop.fs.Path tableURI, Dbserver.TableReplicaDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter removeTableReplica: path " + tableURI));
        boolean isChangelog = false;
        boolean isIndex = false;
        if (desc.hasTopicName() && !desc.getTopicName().equals("")) {
            isChangelog = true;
        } else if (desc.hasSiInfo()) {
            isIndex = true;
        }
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.removeTableReplica(tableName, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to remove " + (isChangelog ? "changelog" : (isIndex ? "index" : "replica")) + " for table: " + tableName + ", Error: Operation not permitted, need an Enterprise license with Database module (for tables), Streams module (for streams)  or Changelog module (for changelogs) enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to remove " + (isChangelog ? "changelog" : (isIndex ? "index" : "replica")) + " for table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit removeTableReplica:");
    }

    public void addTableUpstream(org.apache.hadoop.fs.Path tableURI, Dbserver.TableUpstreamDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter addTableUpstream: path " + tableURI));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.addTableUpstream(tableName, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to add upstream for table: " + tableName + ", Error: Operation not permitted, need an Enterprise license with Database module (for tables), Streams module (for streams)  or Changelog module (for changelogs) enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to add upstream for table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit addTableUpstream:");
    }

    public Dbserver.TableUpstreamListResponse listTableUpstreams(org.apache.hadoop.fs.Path tableURI) throws IOException {
        Dbserver.TableUpstreamListResponse resp;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter listTableUpstreams: path " + tableURI));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            resp = clusterData.client.listTableUpstreams(tableName, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
            tableName = this.getName(tableURI);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to list upstreams for table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Exit listTableUpstreams:");
        return resp;
    }

    public void removeTableUpstream(org.apache.hadoop.fs.Path tableURI, Dbserver.TableUpstreamDesc desc) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        String tableName = this.getName(tableURI);
        LOG.debug((Object)("Enter removeTableUpstream: path " + tableURI));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(tableURI)) == null) {
                throw new IOException("Failed to create maprclient for " + tableName);
            }
            MapRFileSystem.initError(err);
            clusterData.client.removeTableUpstream(tableName, desc, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                tableURI = new org.apache.hadoop.fs.Path(err.trailpath);
                tableName = this.getName(tableURI);
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to remove upstream for table: " + tableName + ", Error: Operation not permitted, need an Enterprise license with Database module (for tables), Streams module (for streams)  or Changelog module (for changelogs) enabled. If the cluster was upgraded, enable new features using 'maprcli cluster feature enable -all'.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error != 0) {
            throw new ErrnoException("Failed to remove upstream for table: " + tableName + ", Error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        LOG.debug((Object)"Eixt removeTableUpstream:");
    }

    public String getServerForCid(int cid, String cluster) throws IOException {
        ClusterConf.ClusterEntry centry;
        ClusterData clusterData;
        LOG.debug((Object)("Enter getServerForCid: cid " + cid + "cluster " + cluster));
        if (cid < 0) {
            throw new IOException("Invalid cid: " + cid);
        }
        if (cluster == null || cluster.isEmpty()) {
            cluster = this.clusterName;
        }
        if ((clusterData = this.lookupClient(centry = clusterConf.getClusterEntryByName(this, cluster))) == null) {
            throw new IOException("Failed to create maprclient for cluster " + cluster);
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRFileSystem.initError(err);
        String server = clusterData.client.getServerForCid(cid, err);
        if (err.error != 0 || server == null) {
            throw new IOException("Failed to get Server for cid: " + cid + ", cluster: " + cluster + " Error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        LOG.debug((Object)("Exit getServerForCid: server " + server));
        return server;
    }

    public String getDefaultClusterName() {
        return this.clusterName;
    }

    public String getClusterName(URI p) throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterByPath(this, p, this.uri, this.clusterName);
        if (centry != null) {
            return centry.getClusterName();
        }
        throw new IOException("Could not get cluster for " + this.uri + "Please check if $MAPR_HOME/conf/mapr-clusters.conf has valid entries.");
    }

    public String getServerForCid(int cid) throws IOException {
        return this.getServerForCid(cid, this.clusterName);
    }

    public FSDataInputStream openFid2(PathId pfid, String file, int readAheadBytesHint) throws IOException {
        ClusterData clusterData;
        if (readAheadBytesHint < 0) {
            throw new IOException("readAheadBytesHint cannot be negative");
        }
        if (readAheadBytesHint == 0) {
            int numIps = pfid.getIPs().length;
            byte[][] ips = new byte[numIps][];
            int[] ports = new int[numIps];
            int i = 0;
            for (long l : pfid.getIPs()) {
                ips[i] = ByteBuffer.allocate(64).putLong(l >> 32).array();
                ports[i] = (int)(l & 0xFFFFL);
                ++i;
            }
            return this.openFid(pfid.getFid(), file, ips, ports);
        }
        Fids.validateFid(pfid.getFid());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Enter openFid2: " + pfid.toString() + (String)(file != null ? "/" + file : "")));
        }
        if ((clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName))) == null) {
            throw new IOException("Failed to lookup cluster " + this.clusterName);
        }
        MapRFsInStream is = clusterData.client.openFid2(this.createPathId(), file, readAheadBytesHint, this.userInfo, this.statistics);
        LOG.debug((Object)"Exit openFid2:");
        return new MapRFsDataInputStream(is);
    }

    public FSDataInputStream openFid(String fid, byte[][] ips, int[] ports, long chunkSize, long fileSize) throws IOException {
        LOG.debug((Object)("Enter openFid: fid " + fid + "ips " + ips + "chunkSize " + chunkSize + "fileSize: " + fileSize));
        Fids.validateFid(fid);
        if (chunkSize < 0L) {
            throw new IOException("Incorrect chunkSize");
        }
        if (fileSize < 0L) {
            throw new IOException("Incorrect file size");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            LOG.debug((Object)"Exit openFid: failed lookupClient");
            return null;
        }
        MapRFsInStream is = clusterData.client.openFid(fid, ips, ports, chunkSize, fileSize, this.userInfo, this.statistics);
        LOG.debug((Object)"Exit openFid:");
        return new MapRFsDataInputStream(is);
    }

    public FSDataInputStream openFid(String pfid, String file, byte[][] ips, int[] ports) throws IOException {
        LOG.debug((Object)("Enter openFid: pfid " + pfid + "file " + file + "ips " + ips));
        Fids.validateFid(pfid);
        if (file == null || file.isEmpty()) {
            throw new IOException("Invalid file");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            LOG.debug((Object)"Exit openFid: failed lookupClient");
            return null;
        }
        MapRFsInStream is = clusterData.client.openFid(pfid, file, ips, ports, this.userInfo, this.statistics);
        LOG.debug((Object)"Exit openFid:");
        return new MapRFsDataInputStream(is);
    }

    public FSDataOutputStream createFid(String pfid, String file) throws IOException {
        LOG.debug((Object)("Enter createFid: pfid " + pfid + "file " + file));
        Fids.validateFid(pfid);
        if (file == null || file.isEmpty()) {
            throw new IOException("Invalid file");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            LOG.debug((Object)"Exit createFid: failed lookupClient");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: " + pfid + " / " + file));
        }
        MapRFsOutStream os = clusterData.client.createFid(pfid, file, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), this.chunkSize, this.userInfo, this.statistics);
        LOG.debug((Object)"Exit createFid:");
        return new MapRFsDataOutputStream(os);
    }

    public FSDataOutputStream createFid(String pfid, String file, boolean overwrite) throws IOException {
        LOG.debug((Object)("Enter createFid: pfid " + pfid + "file " + file + "overwrite " + overwrite));
        Fids.validateFid(pfid);
        if (file == null || file.isEmpty()) {
            throw new IOException("Invalid file");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            LOG.debug((Object)"Exit createFid: failed lookupClient");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: " + pfid + " / " + file));
        }
        MapRFsOutStream os = clusterData.client.createFid(pfid, file, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), this.chunkSize, overwrite, this.userInfo, this.statistics);
        LOG.debug((Object)"Exit createFid:");
        return new MapRFsDataOutputStream(os);
    }

    public boolean deleteFid(String pfid, String dir) throws IOException {
        LOG.debug((Object)("Enter deleteFid: pfid " + pfid + "dir " + dir));
        Fids.validateFid(pfid);
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            LOG.debug((Object)"Exit deleteFid: failed lookupClient");
            return false;
        }
        int error = clusterData.client.deleteFid(pfid, dir, this.userInfo);
        boolean ret = error == 0;
        LOG.debug((Object)("Exit deleteFid: ret " + ret));
        return ret;
    }

    public String mkdirsFid(String pfid, String dir) throws IOException {
        Fids.validateFid(pfid);
        LOG.debug((Object)("Enter mkdirsFid: pfid " + pfid + "dir " + dir));
        if (dir == null || dir.isEmpty()) {
            throw new IOException("Invalid directory");
        }
        ClusterData clusterData = this.lookupClient(clusterConf.getClusterEntryByName(this, this.clusterName));
        if (clusterData == null) {
            throw new IOException("Unable to connect to MapR cluster!");
        }
        String ret = clusterData.client.mkdirsFid(pfid, dir, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), true, this.chunkSize, this.userInfo);
        LOG.debug((Object)("Exit mkdirsFid: ret " + ret));
        return ret;
    }

    public String mkdirsFid(org.apache.hadoop.fs.Path p) throws IOException {
        return this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), true, this.chunkSize, true, true);
    }

    public org.apache.hadoop.fs.Path resolveTablePath(org.apache.hadoop.fs.Path path) throws IOException {
        if (!this.exists(path)) {
            return null;
        }
        MapRFileStatus status = this.getMapRFileStatus(path);
        while (status.isSymlink()) {
            org.apache.hadoop.fs.Path target = status.getSymlink();
            if (!target.isAbsolute()) {
                target = new org.apache.hadoop.fs.Path(status.getPath().getParent(), target);
            }
            if (!this.exists(target)) {
                return null;
            }
            status = this.getMapRFileStatus(target);
        }
        return status.isTable() ? status.getPath() : null;
    }

    public boolean isTable(org.apache.hadoop.fs.Path path) throws IOException {
        boolean ret = this.resolveTablePath(path) != null;
        return ret;
    }

    public boolean isJsonTable(org.apache.hadoop.fs.Path path) throws IOException {
        if (!this.isTable(path)) {
            return false;
        }
        Dbserver.TableAttr attr = this.getTableProperties(path).getAttr();
        boolean ret = attr.hasJson() && attr.getJson();
        return ret;
    }

    public boolean isStream(org.apache.hadoop.fs.Path path) throws IOException {
        if (!this.isTable(path)) {
            return false;
        }
        Dbserver.TableAttr attr = this.getTableProperties(path).getAttr();
        boolean ret = attr.hasIsMarlinTable() && attr.getIsMarlinTable();
        return ret;
    }

    public boolean isChangelog(org.apache.hadoop.fs.Path path) throws IOException {
        if (!this.isTable(path)) {
            return false;
        }
        Dbserver.TableAttr attr = this.getTableProperties(path).getAttr();
        if (!(attr.hasIsMarlinTable() && attr.getIsMarlinTable() && attr.hasMarlinAttr())) {
            return false;
        }
        Marlincommon.MarlinTableAttr mattr = attr.getMarlinAttr();
        return mattr.hasIsChangelog() && mattr.getIsChangelog();
    }

    private String SIInfoCodeToString(Dbserver.SIInfo code) {
        switch (code) {
            case SI_NOT_SUPPORTED: {
                return "Secondary Indexes not supported";
            }
            case SI_GATEWAYS_NOT_CONFIGURED: {
                return "Cluster Gateways are not configured or are unreachable";
            }
            case SI_INCL_FIELD_SPANS_MULTI_CF: {
                return "Data for Secondary Index included field may not span more than one column family";
            }
            case SI_ARRAY_FIELD_CARTESIAN_PRODUCT: {
                return "Array Index resulting in cartesian product is not supported";
            }
            case SI_ARRAY_FIELD_TYPE_CONFLICTING: {
                return "Adding both array and non-array index on the same field is not supported";
            }
        }
        return null;
    }

    public String GatewaySourceToString(int source) {
        if (source == Dbserver.GatewayLookupSource.GW_SOURCE_DNS.getNumber()) {
            return "DNS";
        }
        if (source == Dbserver.GatewayLookupSource.GW_SOURCE_CLDB.getNumber()) {
            return "CLDB";
        }
        if (source == Dbserver.GatewayLookupSource.GW_SOURCE_CONF.getNumber()) {
            return "mapr-clusters.conf";
        }
        return "None";
    }

    public IPPort[] getGatewayIps(String file, String dstCluster, boolean skipCache, GatewaySource source) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        IPPort[] ipPorts = null;
        String fileName = this.getName(new org.apache.hadoop.fs.Path(file));
        LOG.debug((Object)("Enter getGatewayIps: file " + file + "dstCluster " + dstCluster + "skipCache " + skipCache));
        do {
            ClusterData clusterData;
            if ((clusterData = this.lookupClient(new org.apache.hadoop.fs.Path(file))) == null) {
                LOG.error((Object)("Failed to get cluster info for file: " + file));
                throw new IOException("Invalid cluster provided");
            }
            MapRFileSystem.initError(err);
            ipPorts = clusterData.client.getGatewayIps(fileName, dstCluster, skipCache, source, err, this.userInfo);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                file = err.trailpath;
                fileName = this.getName(new org.apache.hadoop.fs.Path(file));
                ++clusterCount;
                continue;
            }
            if (err.error != 38) continue;
            throw new IOException("Failed to get gateway Ips. Error: Operation not permitted, need license with MapR-DB support enabled.");
        } while (err.error == 136 && clusterCount < 8);
        if (err.error == 104) {
            throw new IOException("No valid gateways found. Source tried: " + this.GatewaySourceToString(source.source));
        }
        if (err.error != 0) {
            throw new IOException("Failed to get gateway Ips, Error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        LOG.debug((Object)"Exit getGatewayIps:");
        return ipPorts;
    }

    public IPPort[] getGatewayIps(String file) throws IOException {
        return this.getGatewayIps(file, null, false, null);
    }

    void setStatistics(FileSystem.Statistics stats) {
        this.statistics = stats;
    }

    public boolean getClusterNameUnique() {
        return this.clusterNameUnique;
    }

    public List<ClusterConf.ClusterEntry> getClusterList() {
        return this.localClusterList;
    }

    public void enablePrivilegedProcessAccess(boolean enable) throws IOException {
    }

    public static int getRAThreads() {
        return MapRFileSystem.clientInitParams.maxRAThreads;
    }

    public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) {
        return null;
    }

    public int addSecurityPolicy(org.apache.hadoop.fs.Path path, String securityPolicyTag, boolean recursive) throws IOException {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(securityPolicyTag);
        return this.addSecurityPolicy(path, tags, recursive);
    }

    public int addSecurityPolicy(org.apache.hadoop.fs.Path path, List<String> securityPolicyTags, boolean recursive) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterData clusterData = this.lookupClient(path);
        if (clusterData == null) {
            throw new IOException("no cluster");
        }
        MapRFileSystem.initError(err);
        MapRFileStatus stat = this.getMapRFileStatus(path);
        if (!stat.isFile() && !stat.isDirectory()) {
            throw new IOException("Path " + this.getName(path).toString() + " is neither file/dir");
        }
        if (!stat.isDirectory() && recursive) {
            recursive = false;
        }
        return clusterData.client.addsecuritypolicies(this.getName(path).toString(), securityPolicyTags, recursive, err, this.userInfo);
    }

    public int setSecurityPolicy(org.apache.hadoop.fs.Path path, String securityPolicyTag, boolean recursive) throws IOException {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(securityPolicyTag);
        return this.setSecurityPolicy(path, tags, recursive);
    }

    public int setSecurityPolicy(org.apache.hadoop.fs.Path path, List<String> securityPolicyTags, boolean recursive) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterData clusterData = this.lookupClient(path);
        if (clusterData == null) {
            throw new IOException("no cluster");
        }
        MapRFileSystem.initError(err);
        MapRFileStatus stat = this.getMapRFileStatus(path);
        if (!stat.isFile() && !stat.isDirectory()) {
            throw new IOException("Path " + this.getName(path).toString() + " is neither file/dir");
        }
        if (!stat.isDirectory() && recursive) {
            recursive = false;
        }
        return clusterData.client.setsecuritypolicies(this.getName(path).toString(), securityPolicyTags, recursive, err, this.userInfo);
    }

    public int removeSecurityPolicy(org.apache.hadoop.fs.Path path, String securityPolicyTag, boolean recursive) throws IOException {
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(securityPolicyTag);
        return this.removeSecurityPolicy(path, tags, recursive);
    }

    public int removeSecurityPolicy(org.apache.hadoop.fs.Path path, List<String> securityPolicyTags, boolean recursive) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterData clusterData = this.lookupClient(path);
        if (clusterData == null) {
            throw new IOException("no cluster");
        }
        MapRFileSystem.initError(err);
        MapRFileStatus stat = this.getMapRFileStatus(path);
        if (!stat.isFile() && !stat.isDirectory()) {
            throw new IOException("Path " + this.getName(path).toString() + " is neither file/dir");
        }
        if (!stat.isDirectory() && recursive) {
            recursive = false;
        }
        return clusterData.client.removesecuritypolicies(this.getName(path).toString(), securityPolicyTags, recursive, err, this.userInfo);
    }

    public int removeAllSecurityPolicies(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        ArrayList<String> securityPolicyTags = new ArrayList<String>();
        return this.setSecurityPolicy(path, securityPolicyTags, recursive);
    }

    private int getSecurityPolicy(org.apache.hadoop.fs.Path path, StringBuilder securityPolicyTagsValue, int numSymLinks) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterData clusterData = this.lookupClient(path);
        if (clusterData == null) {
            throw new IOException("no cluster");
        }
        if (numSymLinks > 8) {
            throw new IOException("too many symlinks");
        }
        MapRFileSystem.initError(err);
        try {
            MapRFileStatus stat = this.getMapRFileStatus(path);
            if (stat.isSymlink()) {
                path = stat.getSymlink();
                return this.getSecurityPolicy(path, securityPolicyTagsValue, numSymLinks + 1);
            }
            if (!stat.isFile() && !stat.isDirectory()) {
                LOG.debug((Object)("Path " + this.getName(path).toString() + " is neither file nor directory"));
                return -1;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            return -1;
        }
        byte[] reply = this.getXAttr(path, Fileserver.FSDefaults.getDefaultInstance().getSecurityPolicyXattrName());
        securityPolicyTagsValue.setLength(0);
        securityPolicyTagsValue.append(new String(reply, "UTF-8"));
        return 0;
    }

    public int getSecurityPolicy(org.apache.hadoop.fs.Path path, List<String> securityPolicyTags) throws IOException {
        StringBuilder securityPolicyTagList = new StringBuilder();
        int status = this.getSecurityPolicy(path, securityPolicyTagList, 0);
        if (status < 0) {
            return status;
        }
        if (securityPolicyTagList.length() == 0) {
            return 22;
        }
        securityPolicyTags.addAll(Arrays.asList(securityPolicyTagList.toString().split(", ")));
        return 0;
    }

    public int getSecurityPolicy(List<org.apache.hadoop.fs.Path> paths, List<MapRPathToSecurityPolicyTags> securityPolicyTags) throws IOException {
        for (org.apache.hadoop.fs.Path path : paths) {
            ArrayList<String> tagList;
            int status = this.getSecurityPolicy(path, tagList = new ArrayList<String>());
            if (status != 0) {
                return status;
            }
            MapRPathToSecurityPolicyTags tag = new MapRPathToSecurityPolicyTags(path, tagList);
            securityPolicyTags.add(tag);
        }
        return 0;
    }

    public int printSecurityPolicies(org.apache.hadoop.fs.Path path, boolean recursive) throws IOException {
        ClusterData clusterData = this.lookupClient(path);
        if (clusterData == null) {
            throw new IOException("no cluster");
        }
        MapRFileStatus stat = this.getMapRFileStatus(path);
        if (!stat.isFile() && !stat.isDirectory()) {
            throw new IOException("Path " + this.getName(path).toString() + " is neither file/dir");
        }
        if (!stat.isDirectory() && recursive) {
            recursive = false;
        }
        return clusterData.client.printsecuritypolicies(this.getName(path).toString(), recursive, this.userInfo);
    }

    public List<Dbserver.DataMask> getAllDataMasks() throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
        }
        return clusterData.client.getAllDataMasks(err, this.userInfo);
    }

    public Dbserver.DataMask getDataMask(String dmName) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
        }
        return clusterData.client.getDataMask(dmName, err, this.userInfo);
    }

    public String getDataMaskNameFromId(int id) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
        }
        return clusterData.client.getDataMaskNameFromId(id, err, this.userInfo);
    }

    public byte[] s3BucketCreate(String path, String bktName, String domain, int aId, boolean worm, long ownwerUid) throws IOException {
        if (bktName == null || bktName.isEmpty()) {
            throw new IOException("Invalid bktName");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(centry);
        if (clusterData == null) {
            throw new IOException("Failed to create maprclient for cluster " + this.clusterName);
        }
        return clusterData.client.creates3bucket(path, bktName, err, this.userInfo, domain, aId, worm, ownwerUid);
    }

    public byte[] removeS3Bucket(String bucketName, String domainName) throws IOException {
        if (bucketName == null || bucketName.isEmpty()) {
            LOG.error((Object)"bucket remove operation failed, empty bucket name");
            return null;
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        ClusterConf.ClusterEntry cEntry = clusterConf.getClusterEntryByName(this, this.clusterName);
        ClusterData clusterData = this.lookupClient(cEntry);
        if (clusterData == null) {
            LOG.error((Object)("bucket remove operation failed, unable to get mapr client, cluster:" + this.clusterName));
            return null;
        }
        return clusterData.client.removeS3bucket(bucketName, err, this.userInfo, domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapRDBMetadataMgr metadataMgr(String clusterName) {
        MapRDBMetadataMgr metadataMgr = this.metadataMgrs_.get(clusterName);
        if (metadataMgr == null) {
            Object object = this.metadataMgrLock;
            synchronized (object) {
                metadataMgr = this.metadataMgrs_.get(clusterName);
                if (metadataMgr == null) {
                    metadataMgr = new MapRDBMetadataMgr(this, clusterName);
                    this.metadataMgrs_.put(clusterName, metadataMgr);
                }
            }
        }
        return metadataMgr;
    }

    public boolean addTableEntryToMetadata(String tablePath) {
        return this.addTableEntryToMetadata(tablePath, 0);
    }

    public boolean addTableEntryToMetadata(String tablePath, int retryCount) {
        long sleepMS = 50L;
        String clusterName = this.getClusterNameUnchecked(tablePath);
        MapRDBMetadataMgr metadataMgr = this.metadataMgr(clusterName);
        while (true) {
            if (metadataMgr.commitCreate(tablePath)) {
                return true;
            }
            if (retryCount <= 0) break;
            LOG.debug((Object)("Metadata update failed for table '" + tablePath + "'. Retrying..."));
            try {
                Thread.sleep(sleepMS *= 2L);
                --retryCount;
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    private int generateMergedTrustStore(List<CLDBProto.ClusterGroupConf> clusterGroupConfs) {
        Path tmpSSLTrustStorePath = null;
        try {
            String mapRHome = Installation.getMapRHome();
            String SSLTrustStorePath = mapRHome + "/conf/ssl_truststore";
            tmpSSLTrustStorePath = Files.createTempFile(Paths.get(mapRHome, new String[0]), null, null, new FileAttribute[0]);
            if (tmpSSLTrustStorePath == null) {
                LOG.debug((Object)"GenerateMergedTrustStore : failed to merge truststores.");
                return 5;
            }
            boolean alreadyExist = Util.moveTrustStore((String)SSLTrustStorePath, (String)tmpSSLTrustStorePath.toString());
            boolean needsRename = false;
            HashMap<String, String> clusterCert = new HashMap<String, String>();
            for (CLDBProto.ClusterGroupConf rcvCgConf : clusterGroupConfs) {
                clusterCert.put(rcvCgConf.getClusterName(), rcvCgConf.getRootCaContent());
            }
            needsRename = Util.AddToTruststore(clusterCert, (String)tmpSSLTrustStorePath.toString(), (boolean)alreadyExist);
            if (!needsRename) {
                LOG.debug((Object)"GenerateMergedTrustStore : No new certificates received from GNS");
                try {
                    Files.deleteIfExists(tmpSSLTrustStorePath);
                }
                catch (IOException ioe) {
                    LOG.debug((Object)("Exception while removing tmp file" + ioe.toString()));
                }
                return 0;
            }
            Path source = Paths.get(tmpSSLTrustStorePath.toString(), new String[0]);
            Path target = Paths.get(SSLTrustStorePath, new String[0]);
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            LOG.debug((Object)("Exception while merging the trust store " + e.toString()));
            if (tmpSSLTrustStorePath != null) {
                try {
                    Files.deleteIfExists(tmpSSLTrustStorePath);
                }
                catch (IOException ioe) {
                    LOG.debug((Object)("Exception while removing tmp file" + ioe.toString()));
                }
            }
            return 5;
        }
        return 0;
    }

    static {
        ShimLoader.load();
        URI maprfsURI = null;
        try {
            maprfsURI = new URI("maprfs:///");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        MAPRFS_BASE_URI = maprfsURI;
        FileSystem.enableSymlinks();
        LOG = LogFactory.getLog(MapRFileSystem.class);
        FID_SPLITTER = Pattern.compile("\\.");
        clusterConf = new ClusterConf();
        clusterTable = new HashMap<String, ClusterData>();
        numInstancesLock = new Object();
        numInstances = 0;
        initialized = false;
        disableNameCache_ = false;
        emptyStringArray = new String[0];
    }

    private class ClusterData {
        public MapRClientImpl client;

        public ClusterData(MapRClientImpl client) {
            this.client = client;
        }
    }
}

