/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;

public class MapRTabletScanner {
    private static final byte[] EMPTY_KEY = new byte[0];
    private Path tablePath;
    private Dbserver.TabletLookupResponse lookupResp;
    private MapRFileSystem fs_;
    private int size;
    private int idx;
    private byte[] endKey_;
    private boolean needSpaceUsage_;
    private int numTotalTablets;
    private String indexFid;

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI, String indexFid) throws IOException {
        this(fs, tableURI, indexFid, false, false);
    }

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI, String indexFid, boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        this(fs, tableURI, indexFid, EMPTY_KEY, EMPTY_KEY, needSpaceUsage, prefetchTabletMap);
    }

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI, byte[] startKey) throws IOException {
        this.tablePath = tableURI;
        this.fs_ = fs;
        this.idx = 0;
        this.lookupResp = this.fs_.getTablets(this.tablePath, null, startKey, EMPTY_KEY, false);
        this.size = this.lookupResp.getDescCount();
        if (this.lookupResp.hasNumTotalTablets()) {
            this.numTotalTablets = this.lookupResp.getNumTotalTablets();
        }
    }

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI, String indexFid, byte[] startKey) throws IOException {
        this(fs, tableURI, indexFid, startKey, EMPTY_KEY, false);
    }

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI, String indexFid, byte[] startKey, byte[] endKey, boolean needSpaceUsage) throws IOException {
        this(fs, tableURI, indexFid, startKey, endKey, needSpaceUsage, false);
    }

    public MapRTabletScanner(MapRFileSystem fs, Path tableURI, String indexFid, byte[] startKey, byte[] endKey, boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        this.tablePath = tableURI;
        this.fs_ = fs;
        this.idx = 0;
        this.endKey_ = endKey;
        this.indexFid = indexFid;
        this.needSpaceUsage_ = needSpaceUsage;
        this.lookupResp = this.fs_.getTablets(this.tablePath, indexFid, startKey, endKey, needSpaceUsage, prefetchTabletMap);
        this.size = this.lookupResp.getDescCount();
        if (this.lookupResp.hasNumTotalTablets()) {
            this.numTotalTablets = this.lookupResp.getNumTotalTablets();
        }
    }

    private boolean isAtOrAfterEndKey(byte[] key) {
        return key == null || key.length == 0 || this.endKey_.length != 0 && Bytes.compareTo((byte[])key, (byte[])this.endKey_) >= 0;
    }

    public Dbserver.TabletDesc next() throws IOException {
        if (this.idx >= this.size) {
            if (this.size == 0) {
                return null;
            }
            byte[] lastKey = this.lookupResp.getDesc(this.size - 1).getEndKey().toByteArray();
            if (this.isAtOrAfterEndKey(lastKey)) {
                return null;
            }
            this.idx = 0;
            this.lookupResp = this.fs_.getTablets(this.tablePath, this.indexFid, lastKey, EMPTY_KEY, this.needSpaceUsage_);
            this.size = this.lookupResp.getDescCount();
            return this.next();
        }
        return this.lookupResp.getDesc(this.idx++);
    }

    public List<Dbserver.TabletDesc> nextSet() throws IOException {
        if (this.idx >= this.size) {
            if (this.size == 0) {
                return null;
            }
            byte[] lastKey = this.lookupResp.getDesc(this.size - 1).getEndKey().toByteArray();
            if (this.isAtOrAfterEndKey(lastKey)) {
                return null;
            }
            this.idx = 0;
            this.lookupResp = this.fs_.getTablets(this.tablePath, this.indexFid, lastKey, EMPTY_KEY, this.needSpaceUsage_);
            this.size = this.lookupResp.getDescCount();
            return this.nextSet();
        }
        this.idx += this.size;
        return this.lookupResp.getDescList();
    }

    public int getTotal() {
        return this.numTotalTablets;
    }

    public boolean hasTotal() {
        return this.lookupResp.hasNumTotalTablets();
    }
}

