/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRDbKeyValue;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRScan;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDbResultScanner {
    private MapRHTable maprHTable_;
    private MapRScan mapScan_;
    private long scannerId_;
    private static final Logger LOG = LoggerFactory.getLogger(MapRDbResultScanner.class);

    public MapRDbResultScanner() {
    }

    public MapRDbResultScanner(MapRScan mapScan, MapRHTable maprHTable, long scannerId) {
        this.mapScan_ = mapScan;
        this.maprHTable_ = maprHTable;
        this.scannerId_ = scannerId;
    }

    public MapRDbKeyValue next() throws IOException {
        return this.next(true);
    }

    public MapRDbKeyValue next(boolean defaultColumn) throws IOException {
        MapRResult[] res = new MapRResult[1];
        this.maprHTable_.scanNext(this.scannerId_, 1, res);
        if (res[0] == null || res[0].isEmpty()) {
            return null;
        }
        MapRDbKeyValue keyValue = new MapRDbKeyValue(!defaultColumn);
        MapRResult mresult = res[0];
        byte[] row = mresult.bufBytes;
        int keyLength = mresult.keyLength;
        byte[] key = Arrays.copyOfRange(row, 0, keyLength);
        keyValue.key = key;
        if (defaultColumn) {
            int valOffset = mresult.valueOffsets[0];
            int valLength = mresult.valueLengths[0];
            byte[] value = Arrays.copyOfRange(row, valOffset, valOffset + valLength);
            keyValue.value = value;
        } else {
            HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
            int[] columnOffsets = mresult.getColumnOffsets();
            int[] columnLengths = mresult.getColumnLengths();
            int[] valueOffsets = mresult.getValueOffsets();
            int[] valueLengths = mresult.getValueLengths();
            for (int i = 0; i < columnOffsets.length; ++i) {
                byte[] column = Arrays.copyOfRange(row, columnOffsets[i], columnOffsets[i] + columnLengths[i]);
                byte[] value = Arrays.copyOfRange(row, valueOffsets[i], valueOffsets[i] + valueLengths[i]);
                valueMap.put(new String(column), value);
                String string = new String(column);
            }
            keyValue.valueMap = valueMap;
        }
        return keyValue;
    }

    public void close() throws IOException {
        if (this.scannerId_ == 0L) {
            return;
        }
        this.maprHTable_.getInode().closeScanner(this.scannerId_);
        this.scannerId_ = 0L;
    }
}

