/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.org.apache.hadoop.metrics.util;

import com.mapr.org.apache.hadoop.classification.InterfaceAudience;
import com.mapr.org.apache.hadoop.metrics.MetricsRecord;
import com.mapr.org.apache.hadoop.metrics.util.MetricsBase;
import com.mapr.org.apache.hadoop.metrics.util.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class MetricsIntValue
extends MetricsBase {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsIntValue.class);
    private int value = 0;
    private boolean changed = false;

    public MetricsIntValue(String nam, MetricsRegistry registry, String description) {
        super(nam, description);
        registry.add(nam, this);
    }

    public MetricsIntValue(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription");
    }

    public synchronized void set(int newValue) {
        this.value = newValue;
        this.changed = true;
    }

    public synchronized int get() {
        return this.value;
    }

    @Override
    public synchronized void pushMetric(MetricsRecord mr) {
        if (this.changed) {
            try {
                mr.setMetric(this.getName(), this.value);
            }
            catch (Exception e) {
                LOG.info("pushMetric failed for " + this.getName() + "\n", (Throwable)e);
            }
        }
        this.changed = false;
    }
}

