/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.jni.Page;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

class PageList {
    int num = 0;
    Page head = null;
    Page tail = null;
    Condition cv;

    public PageList(Lock l) {
        this.cv = l.newCondition();
    }

    public Page pop(Page t) {
        if (t.inlru) {
            t.inlru = false;
            Page p = t.prev;
            Page n = t.next;
            if (n != null) {
                n.prev = p;
            } else {
                this.tail = p;
            }
            if (p != null) {
                p.next = n;
            } else {
                this.head = n;
            }
            --this.num;
        }
        return t;
    }

    public Page popOldest() {
        return this.pop(this.head);
    }

    public boolean empty() {
        return this.head == null;
    }

    public void waitTillNotEmpty() {
        while (this.head == null) {
            this.cv.awaitUninterruptibly();
        }
    }

    public void pushOldest(Page p) {
        if (!p.inlru) {
            p.inlru = true;
            p.next = this.head;
            p.prev = null;
            if (this.head == null) {
                this.tail = p;
                this.cv.signalAll();
            } else {
                this.head.prev = p;
            }
            this.head = p;
            ++this.num;
        }
    }

    public void push(Page p) {
        if (!p.inlru) {
            p.inlru = true;
            p.next = null;
            p.prev = this.tail;
            if (this.head == null) {
                this.head = p;
                this.cv.signalAll();
            } else {
                this.tail.next = p;
            }
            this.tail = p;
            ++this.num;
        }
    }

    public Page getEldest() {
        return this.head;
    }
}

